/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.IDBType;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.ConnectionInterface;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Model;
import org.apache.commons.lang3.StringUtils;

public class DbTypeManager
implements IDBType {
    public static final int JDBC_Sequence = 1;
    public static final int JDBC_Table = 2;

    public static String getType(Environment environment) {
        return DbTypeManager.getType(AppSchemaUtil.getDatabase(environment));
    }

    public static String getType(Database database) {
        if (database == null) {
            return "hsqldb";
        }
        return database.getType();
    }

    public static boolean isHSQLDB(Environment environment) {
        if (environment == null) {
            return false;
        }
        Database database = AppSchemaUtil.getDatabase(environment);
        if (database == null) {
            return false;
        }
        return DbTypeManager.isHSQLDB(database);
    }

    public static boolean isHSQLDB(Database database) {
        String driver = database.getDriver();
        return driver.indexOf("hsqldb") >= 0;
    }

    public static boolean isDatabaseType(Environment environment, String type_prefix) {
        return DbTypeManager.isDatabaseType(DbTypeManager.getType(environment), type_prefix);
    }

    public static boolean isDatabaseType(String type, String type_prefix) {
        return type.startsWith(type_prefix);
    }

    public static boolean hasSequence(Environment environment) {
        Database database = AppSchemaUtil.getDatabase(environment);
        return database != null ? StringUtils.isNotBlank((CharSequence)database.getSequenceDML()) : false;
    }

    public static boolean isConnectionInterface(Environment environment) {
        if (environment == null) {
            return false;
        }
        ConnectionInterface conintcfg = AppSchemaUtil.getConnectionInterface(environment);
        return conintcfg != null;
    }

    public static String getHibernateDialect(Environment environment) {
        return DbTypeManager.getHibernateDialect(AppSchemaUtil.getDatabase(environment));
    }

    public static String getHibernateDialect(Database database) {
        if (database == null) {
            return "org.hibernate.dialect.HSQLDialect";
        }
        return database.getHibernateDialect();
    }

    public static int getMaxTableNameLength(Environment environment) {
        Database database = AppSchemaUtil.getDatabase(environment);
        return database != null ? database.getMaxTablenameLength() : Integer.MAX_VALUE;
    }

    public static int getMaxIndexNameLength(Environment environment) {
        Database database = AppSchemaUtil.getDatabase(environment);
        return database != null ? database.getMaxIndexnameLength() : Integer.MAX_VALUE;
    }

    public static int getMaxColumnNameLength(Environment environment) {
        Database database = AppSchemaUtil.getDatabase(environment);
        return database != null ? database.getMaxColumnnameLength() : Integer.MAX_VALUE;
    }

    public static String getMaxLengthStringDataType(Environment environment) {
        Database database = AppSchemaUtil.getDatabase(environment);
        return database != null ? database.getMaxLengthStringDataType() : "VARCHAR(4000)";
    }

    public static String getCharacterLargeObjectDataType(Environment environment) {
        Database database = AppSchemaUtil.getDatabase(environment);
        return database != null ? database.getCharacterLargeObjectDataType() : "CLOB";
    }

    public static String getDatabaseCharEncoding(Environment environment) {
        Database database;
        String default_encoding = "Shift_JIS";
        if (DbTypeManager.isHSQLDB(environment)) {
            default_encoding = "UTF-8";
        }
        if ((database = AppSchemaUtil.getDatabase(environment)) == null) {
            return default_encoding;
        }
        String encoding = database.getCharencoding();
        if (encoding != null && encoding.length() > 0) {
            return encoding;
        }
        return default_encoding;
    }

    public static String getSimpleDateFormatString(Environment environment, String type) {
        if (environment == null || type == null) {
            return "yyyy-MM-dd";
        }
        String format_str = null;
        if ("date".equals(type)) {
            format_str = environment.getDateformat();
            if (StringUtils.isBlank((CharSequence)format_str)) {
                format_str = "yyyy-MM-dd";
            }
        } else if ("time".equals(type)) {
            format_str = environment.getTimeformat();
            if (StringUtils.isBlank((CharSequence)format_str)) {
                format_str = "HH:mm:ss";
            }
        } else if ("dateTime".equals(type) && StringUtils.isBlank((CharSequence)(format_str = environment.getDatetimeformat()))) {
            format_str = "yyyy-MM-dd HH:mm:ss";
        }
        return format_str;
    }

    public static int getSequenceStorageType(Environment environment, Model model) {
        String seqtypestr = model.getSeqStorage();
        int seqtype = seqtypestr.equals("jdbc_sequence") ? 1 : (seqtypestr.equals("jdbc_table") ? 2 : 1);
        if (DbTypeManager.hasSequence(environment) && seqtype == 1) {
            return 1;
        }
        return 2;
    }

    public static boolean isSupportTimeDataType(Environment environment) {
        Database database = AppSchemaUtil.getDatabase(environment);
        return database != null ? database.getSupportTimeDataType() : true;
    }

    public static String getSimpleDateFormatForNoneSupportTimeDataType(Environment environment) {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public static String getSearchStringEscapeInLike(Model model, Environment environment) {
        Database[] databases;
        String subdatabasename = model.getSubdatabase();
        if (StringUtils.isBlank((CharSequence)subdatabasename)) {
            Database database = AppSchemaUtil.getDatabase(environment);
            return database != null ? database.getSearchStringEscapeInLike() : "\\\\";
        }
        for (Database database : databases = AppSchemaUtil.getSubdatabases(environment)) {
            if (!database.getName().equals(subdatabasename)) continue;
            return database.getSearchStringEscapeInLike();
        }
        return "\\\\";
    }

    public static SubqueryHeaderType getSubqueryHeaderType(Environment environment) {
        SubqueryHeaderType shtype = SubqueryHeaderType.EXISTS;
        return shtype;
    }

    public static enum SubqueryHeaderType {
        IN,
        EXISTS;

    }
}

