/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AbstractDBExpressionGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Sortkey;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpressionGenerator_JDBC
extends AbstractDBExpressionGenerator {
    private static Logger logger = LogManager.getLogger(ExpressionGenerator_JDBC.class);

    @Override
    public String getProperColumnName(String name) {
        return this.getProperColumnName(name, 0);
    }

    @Override
    public String getProperColumnName(String name, int indexOfCompositeKey) {
        Model smodel = this.getStoreModel();
        if (smodel != null) {
            return ExpressionGenerator_JDBC.getProperColumnName(name, this.getStoreModel(), indexOfCompositeKey);
        }
        return ExpressionGenerator_JDBC.getProperColumnName(this.project, this.conditionlist, name, indexOfCompositeKey);
    }

    public static String getProperColumnName(String name, Model smodel, int indexOfCompositeKey) {
        Modelitem mitem;
        if (AppSchemaUtil.hasChildPart(name)) {
            name = AppSchemaUtil.getParentPart(name);
        }
        if ((mitem = AppSchemaUtil.getModelitem(name, smodel)) != null) {
            return ExpressionGenerator_JDBC.getProperColumnName(mitem, smodel, indexOfCompositeKey);
        }
        return SourceGenerator.convertRdbColumnname(name);
    }

    public static String getProperColumnName(Modelitem mitem, Model smodel, int indexOfCompositeKey) {
        return ExpressionGenerator_JDBC.getProperColumnName(null, mitem, smodel, indexOfCompositeKey);
    }

    public static String getProperColumnName(Project project, Modelitem mitem, Model smodel, int indexOfCompositeKey) {
        Object cname = mitem.getRdbcolumnname();
        if (cname != null && ((String)cname).length() > 0) {
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
            if (relation == null) {
                relation = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(project, smodel, mitem);
            }
            if (relation != null) {
                String[] tokens;
                Model rmodel = (Model)relation.getIdrefAsIRNode();
                if (rmodel == null) {
                    rmodel = AppSchemaUtil.getModel(project, relation.getIdref());
                }
                PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, project);
                if (((String)cname).indexOf(",") > 0 && (tokens = ((String)cname).split(",")) != null && indexOfCompositeKey < tokens.length) {
                    cname = tokens[indexOfCompositeKey];
                    if (cname != null) {
                        cname = ((String)cname).trim();
                    }
                    return cname;
                }
                if (pkeys != null && pkeys.length > 1 && indexOfCompositeKey < pkeys.length) {
                    cname = "check".equals(relation.getType()) ? pkeys[indexOfCompositeKey].getName() : (String)cname + "_" + pkeys[indexOfCompositeKey].getName();
                }
            }
            return cname;
        }
        return SourceGenerator.convertRdbColumnname(mitem.getName());
    }

    public static String getProperColumnName(Project project, Conditionlist conditionlist, String name, int indexOfCompositeKey) {
        String cmodelname;
        Model cmodel = null;
        if (conditionlist != null) {
            IRNode node = conditionlist.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                cmodel = (Model)node;
            }
            if (cmodel == null) {
                return SourceGenerator.convertRdbColumnname(name);
            }
        }
        Model smodel = null;
        IRNode node = cmodel.getIdrefAsIRNode();
        if (node != null && node instanceof Model) {
            smodel = (Model)node;
        }
        if (smodel == null && (cmodelname = cmodel.getId()).endsWith("_c")) {
            String smodelname = cmodelname.substring(0, cmodelname.length() - 2);
            smodel = AppSchemaUtil.getModel(project, smodelname);
        }
        if (smodel == null) {
            smodel = cmodel;
        }
        return ExpressionGenerator_JDBC.getProperColumnName(name, smodel, indexOfCompositeKey);
    }

    @Override
    public void gCreateExpressionMethod_init(StringBuilder sb) {
        String expressionMethodname = "createExpression";
        String[] param = new String[]{this.rman.getValue("pbean.comment.createexpression.param"), "table"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.sql"), param, this.rman.getValue("pbean.comment.createexpression.sql.ret")));
        sb.append("    ");
        sb.append("protected String ");
        sb.append(expressionMethodname);
        sb.append("(Map map, ");
        sb.append(this.tableclassname);
        sb.append(" table)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        if (this.isEnableQuote()) {
            sb.append("        ");
            sb.append("String quoteId = table.getQuoteId();");
            sb.append(CR);
            sb.append("        ");
            sb.append("String quoteWhere = table.getQuoteWhere();");
            sb.append(CR);
            sb.append("        ");
            sb.append("String quoteIdInWhere = table.getQuoteIdInWhere();");
            sb.append(CR);
        }
        sb.append(CR);
        sb.append("        ");
        sb.append("StringBuilder sb = new StringBuilder();");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("// " + this.rman.getValue("pbean.comment.createexpression.sql.begin"));
        sb.append(CR);
        sb.append(CR);
    }

    @Override
    public void gOutputConditionMethod_init(StringBuilder sb) {
        String expressionMethodname = "outputCondition";
        String[] param = new String[]{this.rman.getValue("pbean.comment.createexpression.param")};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.sql"), param, this.rman.getValue("pbean.comment.createexpression.sql.ret")));
        sb.append("    ");
        sb.append("protected void ");
        sb.append(expressionMethodname);
        sb.append("(");
        sb.append(CR);
        sb.append("        ");
        sb.append("StringBuilder sb, Map map, ");
        sb.append(this.tableclassname);
        sb.append(" table)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        if (this.isEnableQuote()) {
            sb.append("        ");
            sb.append("String quoteId = table.getQuoteId();");
            sb.append(CR);
            sb.append("        ");
            sb.append("String quoteWhere = table.getQuoteWhere();");
            sb.append(CR);
            sb.append("        ");
            sb.append("String quoteIdInWhere = table.getQuoteIdInWhere();");
            sb.append(CR);
        }
        sb.append(CR);
        sb.append("        ");
        sb.append("// " + this.rman.getValue("pbean.comment.createexpression.sql.begin"));
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean isfirstexpression = true;");
        sb.append(CR);
        sb.append(CR);
    }

    @Override
    public void gOutputWhereMainMethod_init(StringBuilder sb, String expressionMethodname) {
        String[] param = new String[]{this.rman.getValue("pbean.comment.createexpression.param"), "table"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.sql"), param, this.rman.getValue("pbean.comment.createexpression.sql.ret")));
        sb.append("    ");
        sb.append("protected boolean ");
        sb.append(expressionMethodname);
        sb.append("(");
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean isfirstexpression, StringBuilder sb, Map map, ");
        sb.append(this.tableclassname);
        sb.append(" table)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        if (this.isEnableQuote()) {
            sb.append("        ");
            sb.append("String quoteId = table.getQuoteId();");
            sb.append(CR);
            sb.append("        ");
            sb.append("String quoteWhere = table.getQuoteWhere();");
            sb.append(CR);
            sb.append("        ");
            sb.append("String quoteIdInWhere = table.getQuoteIdInWhere();");
            sb.append(CR);
        }
        sb.append(CR);
        sb.append("        ");
        sb.append("// " + this.rman.getValue("pbean.comment.createexpression.sql.begin"));
        sb.append(CR);
        sb.append(CR);
        sb.append(this.gPrepareNoselectionSet("        "));
        sb.append(CR);
    }

    @Override
    protected String gAddCondition_child(Condition condition, String basetab, String name, String keyname, String prefix, String type, String cond, boolean isMultipleFlag, boolean isStoreref, int conditiongroup_nestlevel, int indexOfCompositeKey) {
        String actionid;
        if (prefix == null) {
            prefix = "";
        }
        String type0 = JavaSourceGenerator.isBasicType(type) ? JavaSourceGenerator.b2wc(type) : JavaSourceGenerator.getProperType(type);
        String cname = AppSchemaUtil.hasChildPart(name) ? AppSchemaUtil.getChildPart(name) : name;
        String columnname = this.getProperColumnName(name, indexOfCompositeKey);
        StringBuilder sb = new StringBuilder();
        sb.append(this.outputQuoteIdInWhere("            " + basetab));
        sb.append("            " + basetab);
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("            " + basetab));
        Environment env = this.project.getEnvironment();
        String dbType = DbTypeManager.getType(env);
        if (!"=".equals(cond) && dbType.startsWith("postgresql")) {
            if (cond != null && !"LIKE".equals(cond)) {
                String actionid2 = this.getAction().getId();
                Object[] oa = new Object[]{actionid2, cname};
                logger.warn(this.rman.getValue("pbean.errmsg.operator", oa));
            }
            sb.append("            " + basetab);
            sb.append("sb.append(\" ~ '<");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">[^<]*\");");
            sb.append(CR);
            sb.append("            " + basetab);
            if ("String".equals(type0)) {
                sb.append("sb.append(SQLUtilities.replacePOSIXRegexpChar(");
                sb.append("_" + cname + prefix);
                sb.append("));");
            } else {
                sb.append("sb.append(");
                sb.append("_" + cname + prefix);
                sb.append(");");
            }
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("sb.append(\"[^<]*</");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">' \");");
            sb.append(CR);
            return sb.toString();
        }
        if (!"=".equals(cond) && dbType.startsWith("sqlserver")) {
            if (cond != null && !"LIKE".equals(cond)) {
                String actionid3 = this.getAction().getId();
                Object[] oa = new Object[]{actionid3, cname};
                logger.warn(this.rman.getValue("pbean.errmsg.operator", oa));
            }
            sb.append("            " + basetab);
            sb.append("sb.append(\" LIKE '<");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">[^<]%\");");
            sb.append(CR);
            sb.append("            " + basetab);
            if ("String".equals(type0)) {
                sb.append("sb.append(SQLUtilities.replaceSQLServer2000RegexpChar(");
                sb.append("_" + cname + prefix);
                sb.append("));");
            } else {
                sb.append("sb.append(");
                sb.append("_" + cname + prefix);
                sb.append(");");
            }
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("sb.append(\"[^<]%</");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">' \");");
            sb.append(CR);
            return sb.toString();
        }
        if ("LIKE".equals(cond)) {
            actionid = this.getAction().getId();
            Object[] oa = new Object[]{dbType, actionid, cname};
            logger.warn(this.rman.getValue("pbean.errmsg.dbtype", oa));
        } else if (cond != null && !"=".equals(cond)) {
            actionid = this.getAction().getId();
            Object[] oa = new Object[]{actionid, cname};
            logger.warn(this.rman.getValue("pbean.errmsg.operator", oa));
        }
        String escapestr = DbTypeManager.getSearchStringEscapeInLike(this.smodel, env);
        sb.append("            " + basetab);
        sb.append("sb.append(\" LIKE '%<");
        sb.append(StringUtil.convertJavaString((String)cname));
        sb.append(">\");");
        sb.append(CR);
        sb.append("            " + basetab);
        if ("String".equals(type0)) {
            sb.append("sb.append(SQLUtilities.replaceLikeSpecialChar(");
            sb.append("_" + cname + prefix);
            sb.append(", \"");
            sb.append(escapestr);
            sb.append("\"));");
        } else {
            sb.append("sb.append(");
            sb.append("_" + cname + prefix);
            sb.append(");");
        }
        sb.append(CR);
        sb.append("            " + basetab);
        sb.append("sb.append(\"</");
        sb.append(StringUtil.convertJavaString((String)cname));
        sb.append(">%' ESCAPE '" + escapestr + "' \");");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_master(Condition condition, String name, String cond, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel) {
        String cname;
        boolean isChildFlag;
        StringBuilder sb = new StringBuilder();
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String columnname = this.getProperColumnName(name);
        sb.append("        ");
        sb.append("// ");
        sb.append(this.rman.getValue("pbean.comment.addcondition.master", cname));
        sb.append(CR);
        String basetab = "";
        sb.append(basetab + "        ");
        sb.append("Integer _" + cname + " = ");
        if (isChildFlag) {
            sb.append(CR);
            sb.append(basetab + "            ");
        }
        sb.append("(Integer)map.get(\"");
        sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, cname)));
        sb.append("\");");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (_" + cname + " != null) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression(basetab + "            ", condition.getOperator(), conditiongroup_nestlevel));
        sb.append(this.outputQuoteIdInWhere(basetab + "            "));
        sb.append(basetab + "            ");
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere(basetab + "            "));
        if (!isChildFlag && !isCheckboxFlag) {
            sb.append(basetab + "            ");
            sb.append("sb.append(\" ");
            sb.append(StringUtil.convertJavaString((String)cond));
            sb.append(" \");");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("sb.append(_" + cname + ".intValue());");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("sb.append(\" \");");
            sb.append(CR);
        } else {
            sb.append(basetab + "            ");
            sb.append("sb.append(\" LIKE '%<");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">\");");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("sb.append(_" + cname + ".intValue());");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("sb.append(\"</");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">%' \");");
            sb.append(CR);
        }
        if (!isChildFlag && !isCheckboxFlag && item.getNoselection() != null) {
            sb.append("        " + basetab);
            sb.append("} else if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression(basetab + "            ", condition.getOperator(), conditiongroup_nestlevel));
            sb.append(this.outputQuoteIdInWhere(basetab + "            "));
            sb.append(basetab + "            ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere(basetab + "            "));
            sb.append(basetab + "            ");
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
        }
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_master_check(Condition condition, String name, boolean isEmptycaseZero, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel) {
        String cname;
        boolean isChildFlag;
        StringBuilder sb = new StringBuilder();
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String columnname = this.getProperColumnName(name);
        sb.append("        ");
        sb.append("// ");
        sb.append(this.rman.getValue("pbean.comment.addcondition.master", cname));
        sb.append(CR);
        sb.append("        ");
        sb.append("int[] _" + cname + " = ");
        if (isChildFlag) {
            sb.append(CR);
            sb.append("            ");
        }
        sb.append("(int[])map.get(\"");
        sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, cname)));
        sb.append("\");");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_" + cname + " != null && ");
        sb.append("_" + cname + ".length > 0) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("int count = 0;");
        sb.append(CR);
        sb.append("            ");
        sb.append("for (int i=0; i< ");
        sb.append("_" + cname + ".length; i++) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("int __" + cname + " = ");
        if (isChildFlag) {
            sb.append(CR);
            sb.append("                    ");
        }
        sb.append("_" + cname + "[i];");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (count == 0) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "AND", conditiongroup_nestlevel));
        sb.append("                    ");
        sb.append("sb.append(\"( \");");
        sb.append(CR);
        sb.append("                ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "OR", conditiongroup_nestlevel));
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("                "));
        sb.append("                ");
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("                "));
        if (isCheckboxFlag || isChildFlag) {
            sb.append("                ");
            sb.append("sb.append(\" LIKE '%<");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">\");");
            sb.append(CR);
            sb.append("                ");
            sb.append("sb.append(__" + cname + ");");
            sb.append(CR);
            sb.append("                ");
            sb.append("sb.append(\"</");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">%' \");");
            sb.append(CR);
        } else {
            sb.append("                ");
            sb.append("sb.append(\" = \" + __" + cname + " + \" \");");
            sb.append(CR);
        }
        sb.append("                ");
        sb.append("count++;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (count > 0) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("sb.append(\") \");");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        if (isEmptycaseZero) {
            sb.append("        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            ", condition.getOperator(), conditiongroup_nestlevel));
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\" LIKE '%<");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">\");");
            sb.append(CR);
            sb.append("            ");
            sb.append("sb.append(\"-1\"); ");
            sb.append("// " + this.rman.getValue("pbean.comment.createexpression.sql.invalidvalue"));
            sb.append(CR);
            sb.append("            ");
            sb.append("sb.append(\"</");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">%' \");");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_storeref_check(Condition condition, String name, String type, boolean isEmptycaseZero, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel, int indexOfCompositeKey) {
        String cname;
        boolean isChildFlag;
        StringBuilder sb = new StringBuilder();
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String columnname = this.getProperColumnName(name, indexOfCompositeKey);
        boolean isQuote = true;
        type = JavaSourceGenerator.getProperType(type);
        if (JavaSourceGenerator.isBasicType(type)) {
            isQuote = false;
        }
        sb.append("        ");
        sb.append("// ");
        sb.append(this.rman.getValue("pbean.comment.addcondition.master", cname));
        sb.append(CR);
        sb.append("        ");
        sb.append(type);
        sb.append("[] _" + cname + " = (");
        sb.append(type);
        sb.append("[])map.get(\"");
        sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, cname)));
        sb.append("\");");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_" + cname + " != null && ");
        sb.append("_" + cname + ".length > 0) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("int count = 0;");
        sb.append(CR);
        sb.append("            ");
        sb.append("for (int i=0; i< ");
        sb.append("_" + cname + ".length; i++) {");
        sb.append(CR);
        sb.append("                ");
        sb.append(type + " __" + cname + " = _" + cname + "[i];");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (count == 0) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "AND", conditiongroup_nestlevel));
        sb.append("                    ");
        sb.append("sb.append(\"( \");");
        sb.append(CR);
        sb.append("                ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "OR", conditiongroup_nestlevel));
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("                "));
        sb.append("                ");
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("                "));
        if (isCheckboxFlag || isChildFlag) {
            Environment env = this.project.getEnvironment();
            String escapestr = DbTypeManager.getSearchStringEscapeInLike(this.smodel, env);
            sb.append("                ");
            sb.append("sb.append(\" LIKE '%<");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">\");");
            sb.append(CR);
            sb.append("                ");
            if (type.equals("String")) {
                sb.append("sb.append(SQLUtilities.replaceLikeSpecialChar(");
                sb.append("__" + cname);
                sb.append(", \"");
                sb.append(escapestr);
                sb.append("\"));");
            } else {
                sb.append("sb.append(");
                sb.append("__" + cname);
                sb.append(");");
            }
            sb.append(CR);
            sb.append("                ");
            sb.append("sb.append(\"</");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">%' ESCAPE '" + escapestr + "' \");");
            sb.append(CR);
        } else {
            sb.append("                ");
            sb.append("sb.append(\" = \");");
            sb.append(CR);
            if (isQuote) {
                sb.append("                ");
                sb.append("sb.append(\"'\");");
                sb.append(CR);
            }
            sb.append("                ");
            if (type.equals("String")) {
                sb.append("sb.append(SQLUtilities.replaceSpecialChar(");
                sb.append("__" + cname);
                sb.append("));");
            } else {
                sb.append("sb.append(");
                sb.append("__" + cname);
                sb.append(");");
            }
            sb.append(CR);
            if (isQuote) {
                sb.append("                ");
                sb.append("sb.append(\"'\");");
                sb.append(CR);
            }
            sb.append("                ");
            sb.append("sb.append(\" \");");
            sb.append(CR);
        }
        sb.append("                ");
        sb.append("count++;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (count > 0) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("sb.append(\") \");");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        if (isEmptycaseZero) {
            sb.append("        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            ", condition.getOperator(), conditiongroup_nestlevel));
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\" LIKE '%<");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">\");");
            sb.append(CR);
            sb.append("            ");
            sb.append("sb.append(\"-1\"); ");
            sb.append("// " + this.rman.getValue("pbean.comment.createexpression.sql.invalidvalue"));
            sb.append(CR);
            sb.append("            ");
            sb.append("sb.append(\"</");
            sb.append(StringUtil.convertJavaString((String)cname));
            sb.append(">%' \");");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_storeref_check_single(Condition condition, String name, String type, boolean isEmptycaseZero, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel, int indexOfCompositeKey) {
        return "        // ignore case." + CR;
    }

    @Override
    protected String gAddCondition_storeref_check_compositeKey(Condition condition, String name, PrimaryKey[] pkeys, String[] types, boolean isEmptycaseZero, boolean isCheckboxStore, Modelitem item, int conditiongroup_nestlevel) {
        return "";
    }

    @Override
    protected String gSubQueryBegin(Condition condition, String basetab, String name, String prefix, String type, String cond, boolean isMultipleFlag, int indexOfCompositeKey) {
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        if (smitem == null) {
            logger.error("[Internal Error] smitem is null. model.id=" + smodel.getId() + " modelitem.name=" + name);
        }
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            logger.error("[Internal Error] relation[@type=ref and @refstoretype=thismodel] in storage=jdbc modelitem. model.id=" + smodel.getId() + " modelitem.name=" + name);
        } else {
            logger.error(this.rman.getValue("pbean.errmsg.implicit.multi", condition.getName()));
        }
        return "";
    }

    @Override
    protected String gSubQueryEnd(Condition condition, String basetab, String name, String prefix, String type, String cond, boolean isMultipleFlag) {
        return "";
    }

    @Override
    protected boolean isOutputSortColumn(Sortkey key) {
        String cnt = key.getContent();
        return !AppSchemaUtil.hasChildPart(cnt);
    }

    @Override
    protected String callOutputConditionMethod() {
        String expressionMethodname = "outputCondition";
        StringBuilder sb = new StringBuilder();
        sb.append(expressionMethodname);
        sb.append("(sb, map, table);");
        return sb.toString();
    }

    @Override
    protected String callOutputWhereMainMethod(String expressionMethodname, String expressionVariablename, boolean isMainMethod) {
        StringBuilder sb = new StringBuilder();
        if (isMainMethod) {
            sb.append("isfirstexpression = ");
            sb.append(expressionMethodname);
            sb.append("(isfirstexpression, ");
            sb.append(expressionVariablename);
            sb.append(", map, table);");
        } else {
            sb.append(expressionMethodname);
            sb.append("(true, ");
            sb.append(expressionVariablename);
            sb.append(", map, table);");
        }
        return sb.toString();
    }
}

