/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorSubTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGeneratorSubTask_fkey
extends HelperGeneratorSubTask {
    ForeignKey fk;
    Map<String, String> filterMap;
    protected Logger logger = LogManager.getLogger((String)HelperGeneratorSubTask_fkey.class.getName());

    public HelperGeneratorSubTask_fkey(Project project, Model model, ForeignKey fk, Map<String, String> filterMap) {
        super(project, model);
        this.fk = fk;
        this.filterMap = filterMap;
    }

    public boolean isProcess(String name, String ref_name) {
        Model rmodel = null;
        IRNode node = this.fk.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            this.logger.error(this.rman.getValue("helper.comment.foreignkey.idref", name));
            return false;
        }
        rmodel = (Model)node;
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
        boolean isPrimaryKey = false;
        for (int i = 0; i < pkeys.length; ++i) {
            PrimaryKey pkey = pkeys[i];
            if (!ref_name.equals(pkey.getName())) continue;
            isPrimaryKey = true;
            break;
        }
        return isPrimaryKey;
    }

    @Override
    public void process0() {
        String name = this.fk.getName();
        String ref_name = AppSchemaUtil.getForeignKeyTargetItemName(this.fk);
        Modelitem mitem = AppSchemaUtil.getModelitem(name, this.model);
        String id = this.model.getId();
        String type = AppSchemaUtil.getModelitemType(this.project, id, mitem, "roleid");
        if (!this.isProcess(name, ref_name)) {
            return;
        }
        String v_name = JavaSourceGenerator.VARNAME(name);
        this.sb.append("        ");
        this.sb.append("// " + this.rman.getValue("helper.comment.init.fkey"));
        this.sb.append(CR);
        this.sb.append("        ");
        this.sb.append("if (").append(v_name).append(" != null && ").append(v_name).append(".length() > 0) {");
        this.sb.append(CR);
        this.sb.append("            ");
        this.sb.append(id);
        this.sb.append(".");
        this.sb.append(JavaSourceGenerator.setterMethod(name));
        this.sb.append("(");
        if (JavaSourceGenerator.isBasicType(type)) {
            this.sb.append("StringUtil");
            this.sb.append(JavaSourceGenerator.getWc2b_method(type));
            this.sb.append("(");
            this.sb.append(v_name);
            this.sb.append(")");
        } else if (JavaSourceGenerator.isDateOrTimeType(type)) {
            String ptype = JavaSourceGenerator.getProperType(type);
            this.sb.append(ptype + ".valueOf(");
            this.sb.append(v_name);
            this.sb.append(")");
        } else {
            this.sb.append(v_name);
        }
        this.sb.append(");");
        this.sb.append(CR);
        this.sb.append("        ");
        this.sb.append("}");
        this.sb.append(CR);
    }
}

