/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGenerator;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeUpdate;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.DefaultValue;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_addNode
extends HelperGenerator_beforeUpdate {
    protected Modelitem mitem;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_addNode.class.getName());

    public HelperGenerator_addNode(Project project, Model model, Modelitem mitem, HelperGenerator hgen) {
        super(project, model, hgen);
        this.mitem = mitem;
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        if (this.model.getIdref() != null && this.model.getIdref().length() > 0) {
            return sb.toString();
        }
        String id = this.model.getId();
        String classname = AppSchemaUtil.getClassname(this.model);
        String node_id = this.mitem.getName();
        String node_type = this.mitem.getType();
        String node_classname = JavaSourceGenerator.getProperType(node_type);
        int node_maxOccurs = this.mitem.getMaxOccurs();
        boolean isCopy = this.mitem.getCopy();
        String dvcontent = null;
        IModelChoice[] imc = this.model.getContent();
        for (int i = 0; i < imc.length; ++i) {
            DefaultValue _dv;
            if (!(imc[i] instanceof DefaultValue) || !node_id.equals((_dv = (DefaultValue)imc[i]).getName()) || !"init".equals(_dv.getAction()) || "operation".equals(_dv.getType())) continue;
            dvcontent = _dv.getContent();
            break;
        }
        Modelitem pmitem = null;
        Model pmodel = AppSchemaUtil.getModel(this.project, this.model.getId(), "presentation");
        if (pmodel != null) {
            pmitem = AppSchemaUtil.getModelitem(node_id, pmodel);
        }
        String[] msg_param = new String[]{id + " " + classname, "p ActionParameter", "manager JFCErrorManager"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.addnode", node_id), msg_param, null));
        sb.append("    ");
        sb.append("public static void add");
        sb.append(SourceGenerator.capFirst(node_id));
        sb.append("(");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(", ActionParameter p,");
        sb.append(CR);
        sb.append("        ");
        sb.append("JFCErrorManager manager)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        if (node_maxOccurs > 0) {
            sb.append("        ");
            sb.append("int MAX_OCCURS = ");
            sb.append(node_maxOccurs);
            sb.append(";");
            sb.append(CR);
        }
        if (node_maxOccurs > 0 || isCopy) {
            sb.append("        ");
            sb.append(node_classname);
            sb.append("[] ");
            sb.append(node_id + "_ary");
            sb.append(" = ");
            sb.append(id);
            sb.append(JavaSourceGenerator.getterFullMethod(node_id));
            sb.append(";");
            sb.append(CR);
        }
        if (node_maxOccurs > 0) {
            Model smodel = AppSchemaUtil.getStoreModel(this.model);
            String rkey = null;
            if (smodel != null && pmitem != null) {
                String label_i18n = AppSchemaUtil.getLabeli18n(pmitem, smodel.getId(), this.model, this.project);
                rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), pmitem.getName(), label_i18n);
                JFCAppResourceGenerator.put(rkey, label_i18n);
            }
            sb.append("        ");
            sb.append("if (");
            sb.append(node_id + "_ary != null && ");
            sb.append(node_id + "_ary.length >= MAX_OCCURS && manager != null) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("Object[] o = { ");
            sb.append("JFCUtils.getRValue(\"" + rkey + "\", p.locale)");
            sb.append(", Integer.toString(MAX_OCCURS) };");
            sb.append(CR);
            sb.append("            ");
            sb.append("p.errors.addJfcerror");
            sb.append(CR);
            sb.append("                ");
            sb.append("(manager.getJfcerror(\"error.input.maxoccurs\", o, p.locale));");
            sb.append(CR);
            sb.append("            ");
            sb.append("return;");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
        if (isCopy) {
            sb.append("        ");
            sb.append("if (");
            sb.append(node_id + "_ary");
            sb.append(" != null && ");
            sb.append(node_id + "_ary");
            sb.append(".length > 0) {");
            sb.append(CR);
            sb.append("            ");
            sb.append(id);
            sb.append(".add");
            sb.append(SourceGenerator.capFirst(node_id));
            sb.append("(");
            sb.append(node_id + "_ary[");
            sb.append(node_id + "_ary.length-1");
            sb.append("]");
            sb.append(");");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            return sb.toString();
        }
        if (JavaSourceGenerator.isBasicType(node_type) && StringUtils.isNotBlank((CharSequence)dvcontent) && dvcontent.indexOf(",") > 0) {
            String[] tokens;
            for (String token : tokens = dvcontent.split(",")) {
                this.gCreateContent(id, node_id, node_type, token, sb);
                sb.append(CR);
            }
        } else {
            this.gCreateContent(id, node_id, node_type, dvcontent, sb);
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected void gCreateContent(String id, String node_id, String node_type, String dvcontent, StringBuilder sb) {
        if (node_type != null && JavaSourceGenerator.isBasicType(node_type)) {
            sb.append("        ");
            sb.append(id);
            sb.append(".add");
            sb.append(SourceGenerator.capFirst(node_id));
            sb.append("(");
            if ("byte".equals(node_type) || "short".equals(node_type)) {
                sb.append("(" + node_type + ")");
            }
            if (dvcontent != null) {
                sb.append(dvcontent);
                if ("float".equals(node_type)) {
                    sb.append("F");
                } else if ("long".equals(node_type)) {
                    sb.append("L");
                }
            } else {
                sb.append(JavaSourceGenerator.getValidValue(node_type));
            }
            sb.append(");");
        } else if (node_type != null && JavaSourceGenerator.isDateOrTimeType(node_type)) {
            String _classtype = JavaSourceGenerator.getProperType(node_type);
            if (dvcontent == null || dvcontent.length() == 0 || "null".equals(dvcontent)) {
                sb.append("        ");
                sb.append(id);
                sb.append(".add");
                sb.append(SourceGenerator.capFirst(node_id));
                sb.append("(");
                sb.append("new " + _classtype + "(0L)");
                sb.append(");");
            } else if ("now".equals(dvcontent)) {
                sb.append("        ");
                sb.append(id);
                sb.append(".add");
                sb.append(SourceGenerator.capFirst(node_id));
                sb.append("(");
                sb.append("new ");
                sb.append(_classtype);
                sb.append("(System.currentTimeMillis())");
                sb.append(");");
            } else if (dvcontent.startsWith("now")) {
                String rest = dvcontent.substring("now".length(), dvcontent.length());
                if (rest.startsWith("+")) {
                    rest = rest.substring(1, rest.length());
                }
                int amount = StringUtil.intValue((String)rest);
                String nid = "d_" + node_id;
                sb.append("        ");
                sb.append("java.util.Calendar ");
                sb.append(nid);
                sb.append(" = java.util.Calendar.getInstance();");
                sb.append(CR);
                sb.append("        ");
                sb.append(nid);
                sb.append(".add(java.util.Calendar.");
                if ("time".equals(node_type)) {
                    sb.append("SECOND");
                } else {
                    sb.append("DATE");
                }
                sb.append(", ");
                sb.append(amount);
                sb.append(");");
                sb.append(CR);
                sb.append("        ");
                sb.append(id);
                sb.append(".add");
                sb.append(SourceGenerator.capFirst(node_id));
                sb.append("(");
                sb.append("new ");
                sb.append(_classtype);
                sb.append("(");
                sb.append(nid + ".getTime().getTime())");
                sb.append(");");
            } else {
                sb.append("        ");
                sb.append(id);
                sb.append(".add");
                sb.append(SourceGenerator.capFirst(node_id));
                sb.append("(");
                sb.append(JavaSourceGenerator.getSQLObjectMethodname(node_type));
                sb.append("(");
                sb.append(JavaSourceGenerator.getProperStr2DateTimeConvMethodname(node_type));
                sb.append("(");
                String rkey = null;
                rkey = JFCAppResourceGenerator.createHelperResourceKey("defaultValue", this.model.getId(), this.mitem.getName(), dvcontent);
                JFCAppResourceGenerator.put(rkey, dvcontent);
                sb.append("JFCUtils.getRValue(\"" + rkey + "\", p.locale)");
                sb.append("))");
                sb.append(");");
            }
        } else if (node_type != null && "masterref".equals(node_type)) {
            sb.append("        ");
            sb.append("// masterref type is not supported.");
            sb.append(CR);
            Object[] o = new Object[]{node_id};
            this.logger.error(this.rman.getValue("helper.addnode.masterref.notsupported", o));
        } else if (node_type != null && "storeref".equals(node_type)) {
            sb.append("        ");
            sb.append("// storeref type is not supported.");
            sb.append(CR);
            Object[] o = new Object[]{node_id};
            this.logger.error(this.rman.getValue("helper.addnode.storeref.notsupported", o));
        } else {
            sb.append("        ");
            sb.append(id);
            sb.append(".add");
            sb.append(SourceGenerator.capFirst(node_id));
            sb.append("(");
            sb.append("new String(");
            if (dvcontent != null) {
                String rkey = null;
                rkey = JFCAppResourceGenerator.createHelperResourceKey("defaultValue", this.model.getId(), this.mitem.getName(), dvcontent);
                JFCAppResourceGenerator.put(rkey, dvcontent);
                sb.append("JFCUtils.getRValue(\"" + rkey + "\", p.locale)");
            }
            sb.append("));");
        }
    }
}

