/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import jp.jasminesoft.jfc.appgen.component.AbstractPrimarykey;
import jp.jasminesoft.jfc.appgen.component.CompositePrimarykey;
import jp.jasminesoft.jfc.appgen.component.SimplePrimarykey;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Cascade;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_beforeDelete_checkOtherModelRef
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_beforeDelete_checkOtherModelRef.class.getName());
    String id;
    String classname;
    boolean setBeforeShowMethodFlag = false;
    String methodNamePrefix;
    private static final String[] workflowSystemModelIds = new String[]{"jfcparticipant_setting", "jfcproxy_setting", "jfcworkflow_setting", "jfcworkstate", "jfcstartworkstate", "jfcsuspendworkstate"};

    public HelperGenerator_beforeDelete_checkOtherModelRef(Project project, Model model) {
        this(project, model, null, "beforeDelete_checkOtherModelRef");
    }

    public HelperGenerator_beforeDelete_checkOtherModelRef(Project project, Model model, HelperGenerator hgen) {
        this(project, model, hgen, "beforeDelete_checkOtherModelRef");
    }

    public HelperGenerator_beforeDelete_checkOtherModelRef(Project project, Model model, HelperGenerator hgen, String methodNamePrefix) {
        this.project = project != null ? project : AppSchemaUtil.getProject();
        this.model = model;
        this.hgen = hgen;
        this.methodNamePrefix = methodNamePrefix;
        this.id = model != null ? model.getId() : "";
        this.classname = model != null ? AppSchemaUtil.getClassname(model) : "";
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        Cascade[] cascades;
        if (!this.project.getEnvironment().getBeforeDeleteCheckOtherModelRef()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] msg_param = new String[]{"entity entity", "p ActionParameter"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.beforeDelete_checkOtherModelRef"), msg_param, null));
        sb.append("    ");
        sb.append("public void beforeDelete_checkOtherModelRef");
        sb.append("(");
        sb.append(this.classname);
        sb.append(" entity, ActionParameter p)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("beforeDelete_checkOtherModelRef(getPrimarykey(entity), p);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        StoreModel storeModel = new StoreModel(this.model);
        AbstractPrimarykey pkey = storeModel.getPrimarykey();
        msg_param = new String[]{"pkey primary key", "p ActionParameter"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.beforeDelete_checkOtherModelRef"), msg_param, null));
        sb.append("    ");
        sb.append("public void beforeDelete_checkOtherModelRef");
        sb.append("(");
        sb.append(pkey.getClassName());
        sb.append(" pkey, ActionParameter p)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        ArrayList<Object> code = new ArrayList<Object>();
        code.add("int cnt;");
        HashSet<String> cascadeModelIds = new HashSet<String>();
        Action action = AppSchemaUtil.getActionByModelIdAndType(this.project, this.model.getId(), "delete");
        if (action != null && (cascades = AppSchemaUtil.getCascade(action)) != null) {
            for (Cascade cascade : cascades) {
                cascadeModelIds.add(cascade.getContent());
            }
        }
        List<Relation> refrels = this.getRefModelitem();
        for (Relation relation : refrels) {
            Modelitem refmitem = (Modelitem)relation.rGetParentRNode();
            Model refmodel = (Model)refmitem.rGetParentRNode();
            if (relation.getIgnoreBeforeDeleteCheckOtherModelRef()) {
                this.logger.debug("1 modelid " + this.model.getId() + " refmodel=" + refmodel.getId() + " refmitem=" + refmitem.getName());
                continue;
            }
            if (this.isIgnoreCheck(refmitem, refmodel, cascadeModelIds)) continue;
            ArrayList<String> metaInstanceNames = new ArrayList<String>();
            ArrayList<String> pkeyGetCodes = new ArrayList<String>();
            this.addCriteriaEqValue(refmodel, refmitem, pkey, metaInstanceNames, pkeyGetCodes);
            if (metaInstanceNames.size() == 0) {
                this.logger.debug("4 modelid " + this.model.getId() + " refmodel=" + refmodel.getId() + " refmitem=" + refmitem.getName());
                continue;
            }
            String clsname = AppSchemaUtil.getClassname(refmodel);
            String pkgname = AppSchemaUtil.getPackagename_app(refmodel, this.project);
            code.add("cnt = p.appctx.getBean(\"" + clsname + "EntityService\", " + pkgname + clsname + "EntityService.class).count((criteria, meta) -> {");
            for (int i = 0; i < metaInstanceNames.size(); ++i) {
                String metaInstanceName = (String)metaInstanceNames.get(i);
                String pkeyGetCode = (String)pkeyGetCodes.get(i);
                code.add("    criteria.eq(meta." + metaInstanceName + ", " + pkeyGetCode + ");");
            }
            String rkey = this.getRKey(refmitem, refmodel);
            String[] codes = new String[]{"});", "if (cnt > 0) {", "    throw new " + BusinessLogicException.class.getCanonicalName() + "(", "        JFCUtils.getRValue(\"" + rkey + "\", p.locale));", "}"};
            code.addAll(Arrays.asList(codes));
            this.logger.debug("5 modelid " + this.model.getId() + " refmodel=" + refmodel.getId() + " refmitem=" + refmitem.getName());
        }
        for (String string : code) {
            sb.append("        ");
            sb.append(string);
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private boolean isIgnoreCheck(Modelitem refmitem, Model refmodel, HashSet<String> cascadeModelIds) {
        String type = refmodel.getBeforeDeleteCheckOtherModelRef();
        if (type != null) {
            if (type.equals("force")) {
                this.logger.debug("refmodel.BeforeDeleteCheckOtherModelRef is force. modelid=" + this.model.getId() + " refmodel=" + refmodel.getId() + " refmitem=" + refmitem.getName());
                return false;
            }
            if (type.equals("ignore")) {
                this.logger.debug("refmodel.BeforeDeleteCheckOtherModelRef is ignore. modelid=" + this.model.getId() + " refmodel=" + refmodel.getId() + " refmitem=" + refmitem.getName());
                return true;
            }
            if (!type.equals("standard")) {
                this.logger.warn("refmodel.BeforeDeleteCheckOtherModelRef is illegal value " + type + ". use standard setting. modelid=" + this.model.getId() + " refmodel=" + refmodel.getId() + " refmitem=" + refmitem.getName());
            }
        }
        if (refmodel.getMainmodelidref() != null) {
            this.logger.debug("refmodel is submodel. modelid=" + this.model.getId() + " refmodel=" + refmodel.getId() + " refmitem=" + refmitem.getName());
            return true;
        }
        if (cascadeModelIds.contains(refmodel.getId())) {
            this.logger.debug("refmodel is cascadeDelete. modelid=" + this.model.getId() + " refmodel=" + refmodel.getId() + " refmitem=" + refmitem.getName());
            return true;
        }
        return false;
    }

    private void addCriteriaEqValue(Model refmodel, Modelitem refmitem, AbstractPrimarykey pkey, List<String> metaInstanceNames, List<String> pkeyGetCodes) {
        String realfieldstr = refmitem.getRealfield();
        if (StringUtils.isBlank((CharSequence)realfieldstr)) {
            if (refmitem.getTransient() && refmitem.getFormula() == null) {
                this.logger.debug("1 refmodelid " + refmodel.getId() + " refmitem=" + refmitem);
                return;
            }
        } else {
            String[] realfields;
            for (String realfield : realfields = realfieldstr.split(",")) {
                Modelitem mitem2 = AppSchemaUtil.getModelitem(realfield, refmodel);
                if (mitem2 == null) {
                    this.logger.warn("Unknown modelitem " + realfield + " in model " + refmodel.getId());
                    return;
                }
                if (!mitem2.getTransient() || mitem2.getFormula() != null) continue;
                this.logger.debug("2 refmodelid " + refmodel.getId() + " refmitem=" + refmitem + " mitem2=" + mitem2);
                return;
            }
        }
        String metaInstanceName = refmitem.getName();
        if (AppSchemaUtil.hasChildPart(refmitem.getName())) {
            metaInstanceName = AppSchemaUtil.getChildPart(refmitem.getName());
        }
        if (!(pkey instanceof CompositePrimarykey)) {
            metaInstanceNames.add(metaInstanceName);
            pkeyGetCodes.add("pkey");
        } else {
            CompositePrimarykey cpkey = (CompositePrimarykey)pkey;
            for (SimplePrimarykey spkey : cpkey.getElements()) {
                metaInstanceNames.add(metaInstanceName + "_" + spkey.getName());
                pkeyGetCodes.add("pkey" + JavaSourceGenerator.getterFullMethod(spkey.getName()));
            }
        }
    }

    private String getRKey(Modelitem refmitem, Model refmodel) {
        String modeldesc = refmodel.getDescription();
        if (StringUtils.isBlank((CharSequence)modeldesc)) {
            modeldesc = refmodel.getId();
        }
        Model prefmodel = AppSchemaUtil.getModel(this.project, refmodel.getId(), "presentation");
        Modelitem prefmitem = AppSchemaUtil.getModelitem(refmitem.getName(), prefmodel);
        String mitemdesc = AppSchemaUtil.getLabeli18n(prefmitem, refmodel.getId(), prefmodel, this.project);
        if (StringUtils.isBlank((CharSequence)mitemdesc)) {
            mitemdesc = prefmitem.getName();
        }
        Object[] oa = new Object[]{modeldesc, mitemdesc};
        String label = this.rman.getValue("helper.beforeDelete_checkOtherModelRef.BusinessLogicExceptionContent", oa);
        String rkey = JFCAppResourceGenerator.createHelperResourceKey("beforeDelete_checkOtherModelRef", refmodel.getId(), refmitem.getName(), label);
        JFCAppResourceGenerator.put(rkey, label);
        return rkey;
    }

    private List<Relation> getRefModelitem() {
        IProjectChoice[] ipcs;
        boolean hasWorkflowInProject = AppSchemaUtil.hasWorkflowModel(this.project);
        ArrayList<Relation> refrels = new ArrayList<Relation>();
        for (IProjectChoice ipc : ipcs = this.project.getContent()) {
            Modelitem[] mitems;
            if (!(ipc instanceof Model)) continue;
            Model model = (Model)ipc;
            if (model.getId().startsWith("jfc") && !hasWorkflowInProject) {
                boolean bingo = false;
                String mid = model.getId();
                String[] stringArray = workflowSystemModelIds;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String wid = stringArray[i];
                    if (!wid.equals(mid)) continue;
                    bingo = true;
                    break;
                }
                if (bingo) continue;
            }
            if (model.getIdref() != null) continue;
            for (Modelitem mitem : mitems = AppSchemaUtil.getModelitem(model)) {
                Relation rel;
                if (!mitem.getType().equals("storeref") || (rel = AppSchemaUtil.getRelationTypeExceptRef(mitem)) == null || !rel.getIdref().equals(this.id)) continue;
                refrels.add(rel);
            }
        }
        return refrels;
    }
}

