/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.appschema.CsvoutputParameterModelitem;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getCsvTargetItemSet
extends HelperGeneratorBaseTask {
    private static final String TARGETITEM_PKEY_VARNAME = "TARGETITEM_PKEY";
    private static final String TARGETITEM_MULTIPLE_WO_CONT_VARNAME = "TARGETITEM_MULTIPLE_WO_CONT";
    private static final String TARGETITEM_MULTIPLE_WITH_CONT_VARNAME = "TARGETITEM_MULTIPLE";
    private static final String TARGETITEM_MAIN_VARNAME = "TARGETITEM_MAIN";
    private static final String TARGETITEM_ALL_VARNAME = "TARGETITEM_ALL";
    private static final String TARGETITEM_CONT_VARNAME_HEADER = "TARGETITEM_CONT_";
    private static final String TARGETITEM_ORDERMAP_VARNAME = "TARGETITEM_ORDERMAP";
    private static final String TARGETITEM_MAIN_ORDERMAP_VARNAME = "TARGETITEM_MAIN_ORDERMAP";
    private static final String TARGETITEM_MULTIPLE_MAP_VARNAME = "TARGETITEM_MULTIPLE_MAP";
    protected Project project;
    protected Logger logger = LogManager.getLogger(HelperGenerator_getCsvTargetItemSet.class);

    public HelperGenerator_getCsvTargetItemSet(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model smodel = (Model)node;
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            return sb.toString();
        }
        Map<String, Object> itemMap = AppSchemaUtil.devideMapByContainerName(smodel);
        List<Modelitem> pkeyMitems = this.getPrimaryKeyModelitem(smodel);
        this.gCsvTargetItem(sb, TARGETITEM_PKEY_VARNAME, smodel, this.model, pkeyMitems);
        List<Modelitem> mutipleMitems = this.getMultipleModelitem(smodel);
        this.gCsvTargetItem(sb, TARGETITEM_MULTIPLE_WO_CONT_VARNAME, smodel, this.model, mutipleMitems);
        sb.append("    ");
        sb.append("private final static Map<String, Integer[]> TARGETITEM_ORDERMAP;");
        sb.append(CR);
        sb.append("    ");
        sb.append("private final static Map<String, Integer[]> TARGETITEM_MAIN_ORDERMAP;");
        sb.append(CR);
        sb.append("    ");
        sb.append("private final static List<String> TARGETITEM_ALL;");
        sb.append(CR);
        sb.append("    ");
        sb.append("private final static List<String> TARGETITEM_MAIN;");
        sb.append(CR);
        sb.append("    ");
        sb.append("static {");
        sb.append(CR);
        ArrayList<String> code = new ArrayList<String>();
        List<Modelitem> allMitems = HelperGenerator_getCsvTargetItemSet.getAllModelitem(smodel);
        code.add("LinkedHashMap<String, Integer[]> map = new LinkedHashMap<>();");
        code.addAll(this.gCsvTargetItemMapCode("map", smodel, this.model, allMitems));
        code.add("TARGETITEM_ORDERMAP = Collections.unmodifiableMap(map);");
        code.add("TARGETITEM_ALL = Collections.unmodifiableList(new ArrayList<>(map.keySet()));");
        code.add("");
        HashSet<String> mitemnameSet = new HashSet<String>();
        this.addModelitemName(mitemnameSet, mutipleMitems);
        List<Modelitem> mainMitems = this.getMainModelitem(smodel, itemMap, mitemnameSet);
        code.add("map = new LinkedHashMap<>();");
        code.addAll(this.gCsvTargetItemMapCode("map", smodel, this.model, mainMitems));
        code.add("TARGETITEM_MAIN_ORDERMAP = Collections.unmodifiableMap(map);");
        code.add("TARGETITEM_MAIN = Collections.unmodifiableList(new ArrayList<>(map.keySet()));");
        for (String c : code) {
            if (c.length() != 0) {
                sb.append("        ");
                sb.append(c);
            }
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        this.gCsvTargetItemContainer(sb, smodel, this.model, itemMap);
        List<String> contmitemnames = this.getContainerModelitemNames(itemMap);
        this.gVarInitStaticCode(sb, contmitemnames);
        this.gContainsMethod(sb);
        this.gGetCsvTargetItemSetMethod(sb);
        return sb.toString();
    }

    private void addModelitemName(Collection<String> set, List<Modelitem> mitems) {
        for (Modelitem mitem : mitems) {
            set.add(mitem.getName());
        }
    }

    private List<String> getContainerModelitemNames(Map<String, Object> itemMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : itemMap.keySet()) {
            Object o = itemMap.get(name);
            if (!(o instanceof Set)) continue;
            list.add(name);
        }
        return list;
    }

    private void gVarInitStaticCode(StringBuilder sb, List<String> contmitemnames) {
        String[] code = new String[]{"private final static Map<String, String[]> TARGETITEM_MULTIPLE_MAP;", "private final static String[] TARGETITEM_MULTIPLE;", "static {"};
        this.append(sb, "    ", code);
        ArrayList<String> codes = new ArrayList<String>(Arrays.asList("HashMap<String, String[]> map = new HashMap<>();", "for (String itemname : TARGETITEM_MULTIPLE_WO_CONT) {", "    map.put(itemname, new String[] { itemname });", "}", "List<String> list = new ArrayList<String>(Arrays.asList(TARGETITEM_MULTIPLE_WO_CONT));"));
        for (String name : contmitemnames) {
            codes.addAll(Arrays.asList("map.put(\"" + name + "\", TARGETITEM_CONT_" + name + ");", "list.addAll(Arrays.asList(TARGETITEM_CONT_" + name + "));"));
        }
        codes.addAll(Arrays.asList("TARGETITEM_MULTIPLE_MAP = map;", "TARGETITEM_MULTIPLE = list.toArray(new String[list.size()]);"));
        this.append(sb, "        ", codes);
        code = new String[]{"}", ""};
        this.append(sb, "    ", code);
    }

    private void gContainsMethod(StringBuilder sb) {
        String[] code = new String[]{"public static boolean containsMultipleItem(Set<String> itemSet) {", "    return containsOne(itemSet, TARGETITEM_MULTIPLE);", "}", "", "public static boolean containsMultipleItem(", "        Set<String> itemSet, String itemname) {"};
        this.append(sb, "    ", code);
        code = new String[]{"if (itemSet == null) {", "    return true;", "}", "if (TARGETITEM_MULTIPLE_MAP.containsKey(itemname)) {", "    return containsOne(itemSet, TARGETITEM_MULTIPLE_MAP.get(itemname));", "}", "return false;"};
        this.append(sb, "        ", code);
        code = new String[]{"}"};
        this.append(sb, "    ", code);
    }

    private void gGetCsvTargetItemSetMethod(StringBuilder sb) {
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.getCsvTargetItemSet"), null, null));
        String[] code = new String[]{"public static Map<String, Integer[]> getCsvTargetItemOrderMap() {", "    return TARGETITEM_ORDERMAP;", "}", "", "public static Map<String, Integer[]> getMainCsvTargetItemOrderMap() {", "    return TARGETITEM_MAIN_ORDERMAP;", "}", "", "public static List<String> getCsvTargetItem() {", "    return TARGETITEM_ALL;", "}", "", "public static List<String> getMainCsvTargetItem() {", "    return TARGETITEM_MAIN;", "}", "", "public static Set<String> getCsvTargetItemSet() {", "    return TARGETITEM_ORDERMAP.keySet();", "}", "", "public static Set<String> getMainCsvTargetItemSet() {", "    return TARGETITEM_MAIN_ORDERMAP.keySet();", "}", "", "public static Set<String> getModelitemCsvTargetItemSet(String itemname) {"};
        this.append(sb, "    ", code);
        code = new String[]{"HashSet<String> set = new HashSet<String>(Arrays.asList(TARGETITEM_PKEY));", "if (TARGETITEM_MULTIPLE_MAP.containsKey(itemname)) {", "    set.addAll(Arrays.asList(TARGETITEM_MULTIPLE_MAP.get(itemname)));", "}", "return Collections.unmodifiableSet(set);"};
        this.append(sb, "        ", code);
        code = new String[]{"}", ""};
        this.append(sb, "    ", code);
    }

    private void append(StringBuilder sb, String tab, List<String> codes) {
        for (String code : codes) {
            if (code == null) continue;
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sb.append(tab);
                sb.append(code);
            }
            sb.append(CR);
        }
    }

    private void append(StringBuilder sb, String tab, String[] codes) {
        this.append(sb, tab, Arrays.asList(codes));
    }

    private static List<Modelitem> getAllModelitem(Model smodel) {
        return Arrays.stream(AppSchemaUtil.getModelitem(smodel)).filter(mitem -> !mitem.getHasChild()).collect(Collectors.toList());
    }

    private List<Modelitem> getMainModelitem(Model smodel, Map<String, Object> itemMap, Set<String> ignoreMitemnameSet) {
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        for (String name : itemMap.keySet()) {
            Object o;
            if (ignoreMitemnameSet.contains(name) || !((o = itemMap.get(name)) instanceof Modelitem)) continue;
            list.add((Modelitem)o);
        }
        return list;
    }

    private void gCsvTargetItemContainer(StringBuilder sb, Model smodel, Model pmodel, Map<String, Object> itemMap) {
        ArrayList list = new ArrayList();
        for (String name : itemMap.keySet()) {
            Object o = itemMap.get(name);
            if (!(o instanceof Set)) continue;
            list.clear();
            Set set = (Set)o;
            this.gCsvTargetItem(sb, TARGETITEM_CONT_VARNAME_HEADER + name, smodel, pmodel, set);
        }
    }

    private List<Modelitem> getPrimaryKeyModelitem(Model smodel) {
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(smodel);
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        for (PrimaryKey pkey : pkeys) {
            Modelitem mitem = AppSchemaUtil.getModelitem(pkey.getName(), smodel);
            list.add(mitem);
        }
        return list;
    }

    private List<Modelitem> getMultipleModelitem(Model smodel) {
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            return list;
        }
        for (int i = 0; i < simc.length; ++i) {
            Modelitem mitem;
            if (!(simc[i] instanceof Modelitem) || !(mitem = (Modelitem)simc[i]).getMultiple() || mitem.getHasChild() || AppSchemaUtil.hasChildPart(mitem.getName())) continue;
            list.add(mitem);
        }
        return list;
    }

    private void gCsvTargetItem(StringBuilder sb, String varname, Model smodel, Model pmodel, Collection<Modelitem> list) {
        sb.append("    ");
        sb.append("private final static String[] " + varname + " = {");
        sb.append(CR);
        List<CsvTargetItemColumnOrder> list2 = this.getCsvTargetItemColumnOrder(smodel, pmodel, list);
        Iterator<CsvTargetItemColumnOrder> it = list2.iterator();
        while (it.hasNext()) {
            CsvTargetItemColumnOrder mitems = it.next();
            String itemname = mitems.itemname;
            sb.append("        ");
            sb.append("\"" + itemname + "\"");
            if (it.hasNext()) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
    }

    private List<String> gCsvTargetItemMapCode(String varname, Model smodel, Model pmodel, Collection<Modelitem> list) {
        ArrayList<String> code = new ArrayList<String>();
        List<CsvTargetItemColumnOrder> list2 = this.getCsvTargetItemColumnOrder(smodel, pmodel, list);
        for (CsvTargetItemColumnOrder mitems : list2) {
            String itemname = mitems.itemname;
            StringBuilder sb = new StringBuilder();
            sb.append(varname);
            sb.append(".put(\"" + itemname + "\", ");
            if (mitems.columnOrder.length == 0) {
                sb.append("new Integer[0]);");
            } else {
                sb.append("new Integer[] { ");
                boolean isfirst = true;
                for (Integer i : mitems.columnOrder) {
                    if (isfirst) {
                        isfirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(i);
                }
                sb.append(" });");
            }
            code.add(sb.toString());
        }
        return code;
    }

    public static boolean isHaveColumnOrder(Model smodel, Model pmodel) {
        List<Modelitem> list = HelperGenerator_getCsvTargetItemSet.getAllModelitem(smodel);
        for (Modelitem mitem : list) {
            CsvoutputParameterModelitem cpm;
            Modelitem pitem;
            String itemname = mitem.getName();
            if (AppSchemaUtil.isGenerationModelitem(itemname, smodel) || !AppSchemaUtil.getCsvOutputable(smodel, itemname) || (pitem = AppSchemaUtil.getModelitem(mitem.getName(), pmodel)) == null || !pitem.getCsvOutput() || (cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pitem)) == null || cpm.sizeColumnOrder() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<CsvTargetItemColumnOrder> getCsvTargetItemColumnOrder(Model smodel, Model pmodel, Collection<Modelitem> list) {
        ArrayList<CsvTargetItemColumnOrder> mitemlist;
        TreeMap<Integer, ArrayList<CsvTargetItemColumnOrder>> columnordermitem = new TreeMap<Integer, ArrayList<CsvTargetItemColumnOrder>>();
        ArrayList<CsvTargetItemColumnOrder> othermitem = new ArrayList<CsvTargetItemColumnOrder>();
        block0: for (Modelitem mitem : list) {
            CsvoutputParameterModelitem cpm;
            Modelitem pitem;
            String itemname = mitem.getName();
            if (AppSchemaUtil.isGenerationModelitem(itemname, smodel) || !AppSchemaUtil.getCsvOutputable(smodel, itemname) || (pitem = AppSchemaUtil.getModelitem(mitem.getName(), pmodel)) == null || !pitem.getCsvOutput()) continue;
            if (AppSchemaUtil.hasChildPart(itemname)) {
                itemname = AppSchemaUtil.getChildPart(itemname);
            }
            if ((cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pitem)) == null || cpm.sizeColumnOrder() == 0) {
                othermitem.add(new CsvTargetItemColumnOrder(mitem, itemname, new Integer[0]));
                continue;
            }
            for (Integer columnOrder : cpm.getColumnOrderAsInteger()) {
                if (columnOrder < 0) continue;
                ArrayList<CsvTargetItemColumnOrder> mitemlist2 = (ArrayList<CsvTargetItemColumnOrder>)columnordermitem.get(columnOrder);
                if (mitemlist2 == null) {
                    mitemlist2 = new ArrayList<CsvTargetItemColumnOrder>();
                    columnordermitem.put(columnOrder, mitemlist2);
                }
                mitemlist2.add(new CsvTargetItemColumnOrder(mitem, itemname, cpm.getColumnOrderAsInteger()));
                continue block0;
            }
        }
        if (columnordermitem.size() == 0) {
            mitemlist = othermitem;
        } else {
            mitemlist = new ArrayList();
            for (List mitemlist1 : columnordermitem.values()) {
                mitemlist.addAll(mitemlist1);
            }
            mitemlist.addAll(othermitem);
        }
        return mitemlist;
    }

    private static class CsvTargetItemColumnOrder {
        private String itemname;
        private Integer[] columnOrder;

        public CsvTargetItemColumnOrder(Modelitem mitem, String itemname, Integer[] columnOrder) {
            this.itemname = itemname;
            this.columnOrder = columnOrder;
        }
    }
}

