/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getPrimaryKeyForCsvData
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_getPrimaryKeyForCsvData.class.getName());

    public HelperGenerator_getPrimaryKeyForCsvData(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IModelChoice[] imc = this.model.getContent();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model rmodel = (Model)node;
        IModelChoice[] rimc = rmodel.getContent();
        if (rimc == null || rimc.length == 0) {
            return sb.toString();
        }
        ArrayList<Modelitem> pkey_mitems = new ArrayList<Modelitem>();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
        Map<String, String> labels = AppSchemaUtil.createCsvHeaderMap(rmodel, this.model);
        for (int i = 0; i < rimc.length; ++i) {
            String label;
            Modelitem mitem;
            if (!(rimc[i] instanceof Modelitem) || (mitem = (Modelitem)rimc[i]).getMultiple() || mitem.getHasChild() || mitem.getName().indexOf("/") >= 0) continue;
            Modelitem pitem = null;
            if (imc != null) {
                for (int j = 0; !(j >= imc.length || imc[j] instanceof Modelitem && (pitem = (Modelitem)imc[j]).getName().equals(mitem.getName())); ++j) {
                }
            }
            if ((label = labels.get(mitem.getName())) == null) continue;
            boolean isPrimaryKey = false;
            for (int j = 0; j < pkeys.length; ++j) {
                PrimaryKey pkey = pkeys[j];
                if (!pkey.getName().equals(mitem.getName())) continue;
                isPrimaryKey = true;
                break;
            }
            if (pitem != null && !pitem.getCsvOutput() && !isPrimaryKey || !isPrimaryKey) continue;
            pkey_mitems.add(mitem);
        }
        StringBuilder sb_mitemnames = new StringBuilder();
        sb_mitemnames.append("    ");
        sb_mitemnames.append("public final static String[] GetPrimaryKeyForCsvData_ModelitemNames = {");
        sb_mitemnames.append(CR);
        for (int i = 0; i < pkey_mitems.size(); ++i) {
            Modelitem mitem = (Modelitem)pkey_mitems.get(i);
            sb_mitemnames.append("        ");
            sb_mitemnames.append("\"" + mitem.getName() + "\"");
            if (i + 1 < pkey_mitems.size()) {
                sb_mitemnames.append(",");
            }
            sb_mitemnames.append(CR);
        }
        sb_mitemnames.append("    ");
        sb_mitemnames.append("};");
        sb_mitemnames.append(CR);
        sb_mitemnames.append(CR);
        sb.append((CharSequence)sb_mitemnames);
        sb.append(this.gGetPrimaryKeyModelitems());
        return sb.toString();
    }

    private String gGetPrimaryKeyModelitems() {
        StringBuilder sb = new StringBuilder();
        Model smodel = AppSchemaUtil.getStoreModel(this.model);
        String[] msgParam = new String[]{};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.getPrimaryKeyLabelResourceKeys"), msgParam, this.rman.getValue("helper.comment.getPrimaryKeyLabelResourceKeys.return")));
        sb.append("    ");
        sb.append("@Override");
        sb.append(CR);
        sb.append("    ");
        sb.append("public String[] getPrimaryKeyModelitems() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return GetPrimaryKeyForCsvData_ModelitemNames;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("@Override");
        sb.append(CR);
        sb.append("    ");
        sb.append("public String getModelId() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return \"" + smodel.getId() + "\";");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }
}

