/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_control;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Control;
import jp.jasminesoft.jfc.gen.appschema.CsvoutputParameterModelitem;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getValidCsvHeader
extends HelperGeneratorBaseTask {
    protected Project project;
    private Map<String, String> labels;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_getValidCsvHeader.class.getName());

    public HelperGenerator_getValidCsvHeader(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    public String getMethodname() {
        return "getValidCsvHeader";
    }

    public boolean isProcessSingleModelitem(Model smodel, Modelitem smitem) {
        return true;
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model smodel = (Model)node;
        this.labels = AppSchemaUtil.createCsvHeaderMap(smodel, this.model);
        sb.append(this.generateParseCsvData(basetab, smodel, null));
        IModelChoice[] smitems = smodel.getContent();
        if (smitems == null || smitems.length == 0) {
            return sb.toString();
        }
        for (int i = 0; i < smitems.length; ++i) {
            Modelitem smitem;
            if (!(smitems[i] instanceof Modelitem) || !(smitem = (Modelitem)smitems[i]).getHasChild()) continue;
            sb.append(this.generateParseCsvData(basetab, smodel, smitem));
        }
        return sb.toString();
    }

    public String generateParseCsvData(String basetab, Model smodel, Modelitem containermitem) {
        Object smodel_classname;
        String smodel_id;
        Object pmodel_classname;
        Object pmodel_id;
        StringBuilder sb = new StringBuilder();
        String _pmodel_id = this.model.getId();
        String _pmodel_classname = AppSchemaUtil.getClassname(this.model);
        String pmodel_packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        String _smodel_id = smodel.getId();
        String _smodel_classname = AppSchemaUtil.getClassname(smodel);
        if (containermitem == null) {
            pmodel_id = _pmodel_id;
            pmodel_classname = _pmodel_classname;
            smodel_id = _smodel_id;
            smodel_classname = _smodel_classname;
            this.generateParseCsvData_header(sb, (String)pmodel_id, (String)pmodel_classname, smodel_id, (String)smodel_classname);
        } else {
            Object containername = containermitem.getName();
            smodel_id = containername;
            smodel_classname = AppSchemaUtil.getPackagename(smodel, this.project) + AppSchemaUtil.getModelitemClassname(containermitem);
            pmodel_id = "p_" + (String)containername;
            pmodel_classname = pmodel_packagename + AppSchemaUtil.getModelitemClassname(containermitem);
            this.generateParseCsvData_containerheader(sb, _pmodel_id, _pmodel_classname, _smodel_id, _smodel_classname, (String)pmodel_id, (String)pmodel_classname, smodel_id, (String)smodel_classname, (String)containername);
            containername = (String)containername + "/";
        }
        IModelChoice[] smitems = smodel.getContent();
        if (smitems == null || smitems.length == 0) {
            sb.append("        ");
            sb.append("return false;");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            return sb.toString();
        }
        sb.append("        ");
        sb.append("{");
        sb.append(CR);
        sb.append("$$$simplelist$$$").append(CR);
        IModelChoice[] pmitems = this.model.getContent();
        StringBuilder sb2 = new StringBuilder();
        StringBuilder sb3 = new StringBuilder();
        String containerModelitemnameHeader = null;
        if (containermitem != null) {
            containerModelitemnameHeader = containermitem.getName() + "/";
        }
        ArrayList<String> simpleList = new ArrayList<String>();
        for (int i = 0; i < smitems.length; ++i) {
            String label;
            Modelitem pmitem;
            if (!(smitems[i] instanceof Modelitem)) continue;
            Modelitem smitem = (Modelitem)smitems[i];
            if (containermitem == null) {
                String label2;
                if (smitem.getHasChild()) {
                    label2 = this.labels.get(smitem.getName());
                    if (label2 == null) continue;
                    this.process1_container(sb, smodel, smitem, label2);
                    continue;
                }
                if (smitem.getName().indexOf("/") >= 0) continue;
                if (smitem.getMultiple()) {
                    label2 = this.labels.get(smitem.getName());
                    if (label2 == null) continue;
                    this.process1_multiple(sb, smodel, smitem, label2);
                    continue;
                }
            } else if (smitem.getHasChild() || !smitem.getName().startsWith(containerModelitemnameHeader) || smitem.getMultiple()) continue;
            if (containermitem == null && !this.isProcessSingleModelitem(smodel, smitem) || smitem.getTransient() || (pmitem = this.getPresentationModelitem(pmitems, smitem.getName())) == null || !AppSchemaUtil.isCsvUploadUpdate(pmitem) || (label = this.labels.get(smitem.getName())) == null) continue;
            StringBuilder tmpsb = new StringBuilder();
            this.process1(tmpsb, sb2, sb3, smodel, smitem, pmitem, label, pmodel_packagename, smodel_id, (String)pmodel_id, (String)smodel_classname, (String)pmodel_classname, containermitem);
            String tmp = tmpsb.toString();
            if (this.isSimplePattern(tmp)) {
                int ptr = tmp.indexOf("getRValue(\"");
                tmp = tmp.substring(ptr + "getRValue(\"".length());
                tmp = tmp.substring(0, tmp.indexOf("\""));
                simpleList.add(tmp);
                continue;
            }
            sb.append((CharSequence)tmpsb);
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("return false;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(sb2.toString());
        String ret = sb.toString();
        int ssize = simpleList.size();
        if (ssize > 0) {
            StringBuilder slb = new StringBuilder();
            slb.append("            ");
            slb.append("final String[] _validHeaders = {").append(CR);
            for (int i = 0; i < ssize; ++i) {
                slb.append("                ").append("JFCUtils.getRValue(\"").append((String)simpleList.get(i)).append("\", p.locale)");
                if (i < ssize - 1) {
                    slb.append(",");
                }
                slb.append(CR);
            }
            slb.append("            ").append("};").append(CR);
            slb.append("            ").append("final Set<String> _validHeaderSet = new HashSet<String>(Arrays.asList(_validHeaders));").append(CR);
            slb.append("            ").append("if (_validHeaderSet.contains(_key)) {").append(CR);
            slb.append("                ").append("return true;").append(CR);
            slb.append("            ").append("}").append(CR);
            ret = ret.replace("$$$simplelist$$$", slb.toString());
        } else {
            ret = ret.replace("$$$simplelist$$$", "");
        }
        return ret;
    }

    private boolean isSimplePattern(String src) {
        String[] lines = StringUtil.split((String)src, (String)CR);
        if (lines != null && lines.length == 3) {
            lines[0] = StringUtil.removePreAndPostWhitespaceWithoutInside((String)lines[0]);
            lines[1] = StringUtil.removePreAndPostWhitespaceWithoutInside((String)lines[1]);
            if (lines[0].startsWith("if (_key.equals(JFCUtils.getRValue") && lines[0].endsWith(", p.locale))) {") && lines[1].equals("return true;")) {
                return true;
            }
        }
        return false;
    }

    protected void generateParseCsvData_header(StringBuilder sb, String pmodel_id, String pmodel_classname, String smodel_id, String smodel_classname) {
        String[] msg_param = new String[]{"_header", "p ActionParameter"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.getValidCsvHeader"), msg_param, this.rman.getValue("helper.comment.getValidCsvHeader.return")));
        sb.append("    ");
        sb.append("@Override").append(CR).append("    ");
        sb.append("public boolean " + this.getMethodname() + "(String _key, ActionParameter p, Set<String> _headerSet) {");
        sb.append(CR);
    }

    private void generateParseCsvData_containerheader(StringBuilder sb, String _pmodel_id, String _pmodel_classname, String _smodel_id, String _smodel_classname, String pmodel_id, String pmodel_classname, String smodel_id, String smodel_classname, String containername) {
        sb.append("    ");
        sb.append("public boolean " + this.getMethodname() + "_");
        sb.append(containername);
        sb.append("(String _key, ActionParameter p, Set<String> _headerSet) {");
        sb.append(CR);
    }

    private Modelitem getPresentationModelitem(IModelChoice[] pmitems, String smitemname) {
        if (pmitems == null) {
            return null;
        }
        for (int j = 0; j < pmitems.length; ++j) {
            Modelitem mitem;
            if (!(pmitems[j] instanceof Modelitem) || !(mitem = (Modelitem)pmitems[j]).getName().equals(smitemname)) continue;
            return mitem;
        }
        return null;
    }

    protected void process1_container(StringBuilder sb, Model smodel, Modelitem smitem, String label) {
        String rkey = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", smodel.getId(), smitem.getName(), label);
        JFCAppResourceGenerator.put(rkey, label);
        sb.append("            ");
        sb.append("if (");
        sb.append("_key.startsWith(JFCUtils.getRValue(\"");
        sb.append(rkey);
        sb.append("\", p.locale)+\"[\")) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("String s = _key.substring(JFCUtils.getRValue(\"");
        sb.append(rkey);
        sb.append("\", p.locale).length());");
        sb.append(CR);
        String methodname = this.getMethodname() + "_" + smitem.getName();
        sb.append("                ");
        sb.append("return checkCsvHeaderContainer(_key, s, \"").append(methodname).append("\", _headerSet, p, logger);").append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    protected void process1_multiple(StringBuilder sb, Model smodel, Modelitem smitem, String label) {
        String rkey = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", smodel.getId(), smitem.getName(), label);
        JFCAppResourceGenerator.put(rkey, label);
        sb.append("            ");
        sb.append("if (");
        sb.append("_key.startsWith(JFCUtils.getRValue(\"");
        sb.append(rkey);
        sb.append("\", p.locale)+\"[\")) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("String s = _key.substring(JFCUtils.getRValue(\"");
        sb.append(rkey);
        sb.append("\", p.locale).length());");
        sb.append(CR);
        sb.append("                ");
        sb.append("return checkCsvHeaderMultiple(_key, s, logger);").append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private void process1(StringBuilder sb, StringBuilder sb2, StringBuilder sb3, Model smodel, Modelitem smitem, Modelitem pmitem, String label, String pmodel_packagename, String smodel_id, String pmodel_id, String smodel_classname, String pmodel_classname, Modelitem containermitem) {
        Modelitem refsitem;
        String rkey = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", smodel.getId(), smitem.getName(), label);
        JFCAppResourceGenerator.put(rkey, label);
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), smitem);
        Control control = AppSchemaUtil.getControlTypeIsHidden(pmitem);
        boolean isAnormFlag = AppSchemaUtil.isAnormOption(pmitem);
        boolean isHiddenFlag = control != null;
        boolean isFilenameModelitem = false;
        String mitemFooter = smodel.getRealFilenameRefModelitemFooter();
        if (mitemFooter != null && mitemFooter.length() > 0 && (refsitem = AppSchemaUtil.getModelitem(smitem.getName() + mitemFooter, smodel)) != null) {
            isFilenameModelitem = true;
        }
        HelperGenerator_s2p_control hcon = HelperGenerator_s2p_control.getInstance(this.model.getId(), HelperGenerator_s2p_control.Mode.StoreModel, this.project, this);
        if (isAnormFlag) {
            sb.append("            ");
            sb.append("if (_key.equals(JFCUtils.getRValue(\"");
            sb.append(rkey);
            sb.append("\", p.locale))) {");
            sb.append(CR);
            if (isHiddenFlag) {
                sb.append(hcon.gPrepare(control, "        "));
                sb.append("                ");
                sb.append("if (ret) {");
                sb.append(CR);
                sb.append("                    ");
                sb.append("return true;");
                sb.append(CR);
                sb.append("                ");
                sb.append("}");
                sb.append(CR);
                sb.append("                ");
                sb.append("return false;");
                sb.append(CR);
            } else {
                sb.append("                ");
                sb.append("return true;");
                sb.append(CR);
            }
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        } else if ("combo".equals(smitem.getDualinputmethod()) && "store".equals(smodel.getType()) || "masterref".equals(smitem2.getType()) || "storeref".equals(smitem2.getType())) {
            this.process1_ref(sb, sb2, sb3, smodel, smitem, pmitem, smodel_id, pmodel_id, smodel_classname, pmodel_classname, rkey, smitem2, control, "            ", containermitem, hcon);
        } else {
            sb.append("            ");
            sb.append("if (_key.equals(JFCUtils.getRValue(\"");
            sb.append(rkey);
            sb.append("\", p.locale))) {");
            sb.append(CR);
            if (isHiddenFlag) {
                sb.append(hcon.gPrepare(control, "        "));
                sb.append("                ");
                sb.append("if (ret) {");
                sb.append(CR);
                sb.append("                    ");
                sb.append("return true;");
                sb.append(CR);
                sb.append("                ");
                sb.append("}");
                sb.append(CR);
                sb.append("                ");
                sb.append("return false;");
                sb.append(CR);
            } else {
                sb.append("                ");
                sb.append("return true;");
                sb.append(CR);
            }
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            if (isFilenameModelitem) {
                String label_jfcattachment = label + "_jfcattachment";
                String rkey_jfcattachment = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", smodel.getId(), smitem.getName() + "_jfcattachment", label_jfcattachment);
                JFCAppResourceGenerator.put(rkey_jfcattachment, label_jfcattachment);
                sb.append("            ");
                sb.append("if (_key.equals(JFCUtils.getRValue(\"");
                sb.append(rkey_jfcattachment);
                sb.append("\", p.locale))) {");
                sb.append(CR);
                if (isHiddenFlag) {
                    sb.append(hcon.gPrepare(control, "        "));
                    sb.append("                ");
                    sb.append("if (ret) {");
                    sb.append(CR);
                    sb.append("                    ");
                    sb.append("return true;");
                    sb.append(CR);
                    sb.append("                ");
                    sb.append("}");
                    sb.append(CR);
                    sb.append("                ");
                    sb.append("return false;");
                    sb.append(CR);
                } else {
                    sb.append("                ");
                    sb.append("return true;");
                    sb.append(CR);
                }
                sb.append("            ");
                sb.append("}");
                sb.append(CR);
                sb.append(CR);
            }
        }
    }

    private void process1_ref(StringBuilder sb, StringBuilder sb2, StringBuilder sb3, Model smodel, Modelitem smitem, Modelitem pmitem, String smodel_id, String pmodel_id, String smodel_classname, String pmodel_classname, String rkey, Modelitem smitem2, Control control, String basetab, Modelitem containermitem, HelperGenerator_s2p_control hcon) {
        boolean outputOneColumnForCheckbox;
        CsvoutputParameterModelitem cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pmitem);
        boolean bl = outputOneColumnForCheckbox = cpm != null && cpm.getOutputOneColumnForCheckbox();
        if (AppSchemaUtil.isCheckRelation(smitem2) && !outputOneColumnForCheckbox) {
            this.process1_ref_roleContent(sb, sb2, smodel, smitem, pmitem, smodel_id, pmodel_id, smodel_classname, pmodel_classname, rkey, null, smitem2, control, basetab, containermitem, "rolecontent", hcon, true);
            sb.append(CR);
        } else if ("combo".equals(smitem.getDualinputmethod()) && "store".equals(smodel.getType())) {
            this.process1_ref_roleContent(sb, sb2, smodel, smitem, pmitem, smodel_id, pmodel_id, smodel_classname, pmodel_classname, rkey, null, smitem2, control, basetab, containermitem, "rolecontent", hcon, false);
            sb.append(CR);
        } else {
            Object label = this.labels.get(smitem.getName());
            label = (String)label + "#id";
            String rkey_id = JFCAppResourceGenerator.createHelperResourceKey("csvHeader_id", smodel.getId(), smitem.getName(), (String)label);
            JFCAppResourceGenerator.put(rkey_id, (String)label);
            String parseStorerefType = null;
            if (cpm != null) {
                parseStorerefType = cpm.getParseStorerefType();
            }
            if (parseStorerefType == null) {
                parseStorerefType = "rolecontent_id";
            }
            this.process1_ref_roleContent(sb, sb2, smodel, smitem, pmitem, smodel_id, pmodel_id, smodel_classname, pmodel_classname, rkey, rkey_id, smitem2, control, basetab, containermitem, parseStorerefType, hcon, false);
            sb.append(CR);
            this.process1_ref_roleId(sb, sb2, smodel, smitem, pmitem, smodel_id, pmodel_id, smodel_classname, pmodel_classname, rkey, rkey_id, smitem2, control, basetab, containermitem, parseStorerefType, hcon);
            sb.append(CR);
        }
    }

    private void process1_ref_callParseCsvData(StringBuilder sb, Model smodel, Modelitem smitem, String smodel_id, String pmodel_id, String basetab, String methodnameHeader, Modelitem containermitem) {
        sb.append(basetab);
        sb.append("return ");
        sb.append(methodnameHeader + AppSchemaUtil.getChildPart(smitem.getName()));
        sb.append("(_key, p);");
        sb.append(CR);
    }

    private void process1_ref_roleContent(StringBuilder sb, StringBuilder sb2, Model smodel, Modelitem smitem, Modelitem pmitem, String smodel_id, String pmodel_id, String smodel_classname, String pmodel_classname, String rkey_content, String rkey_id, Modelitem smitem2, Control control, String basetab, Modelitem containermitem, String parseStorerefType, HelperGenerator_s2p_control hcon, boolean isOutputMultiColumnForCheckbox) {
        boolean outputOneColumnForCheckbox;
        boolean isHiddenFlag = control != null;
        CsvoutputParameterModelitem cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pmitem);
        boolean bl = outputOneColumnForCheckbox = cpm != null && cpm.getOutputOneColumnForCheckbox();
        if (AppSchemaUtil.isCheckRelation(smitem2) && !outputOneColumnForCheckbox) {
            sb.append(basetab);
            sb.append("if (_key.startsWith(JFCUtils.getRValue(\"");
            sb.append(rkey_content);
            sb.append("\", p.locale))) {");
            sb.append(CR);
        } else if (parseStorerefType.equals("roleid_content")) {
            sb.append(basetab);
            sb.append("if (");
            sb.append("!_headerSet.contains(JFCUtils.getRValue(\"");
            sb.append(rkey_id);
            sb.append("\", p.locale)) &&");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("_key.equals(JFCUtils.getRValue(\"");
            sb.append(rkey_content);
            sb.append("\", p.locale)))");
            sb.append(CR);
            sb.append(basetab);
            sb.append("{");
            sb.append(CR);
        } else {
            sb.append(basetab);
            sb.append("if (");
            sb.append("_key.equals(JFCUtils.getRValue(\"");
            sb.append(rkey_content);
            sb.append("\", p.locale))) {");
            sb.append(CR);
        }
        String ltab = "";
        if (isHiddenFlag) {
            String tab = basetab.length() > 4 ? basetab.substring(4) : "";
            sb.append(hcon.gPrepare(control, tab));
            sb.append(basetab + "    ");
            sb.append("if (ret) {");
            sb.append(CR);
            ltab = "    ";
        }
        if (parseStorerefType.equals("roleid")) {
            sb.append(basetab + "    " + ltab);
            sb.append("// " + smitem.getName() + " is not supported.");
            sb.append(CR);
            sb.append(basetab + "    " + ltab);
            sb.append("return false;");
            sb.append(CR);
        } else if (isOutputMultiColumnForCheckbox) {
            String methodnameHeader = this.getMethodname() + "_";
            this.process1_ref_callParseCsvData(sb, smodel, smitem, smodel_id, pmodel_id, basetab + "    " + ltab, methodnameHeader, containermitem);
            this.gParseCsvData(sb2, rkey_content, smodel, smitem, smitem2, pmitem, methodnameHeader, "rolecontent", smodel_id, pmodel_id, smodel_classname, pmodel_classname, containermitem);
        } else {
            sb.append(basetab + "    " + ltab);
            sb.append("return true;");
            sb.append(CR);
        }
        if (isHiddenFlag) {
            sb.append(basetab + "    ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("return false;");
            sb.append(CR);
        }
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
    }

    private void process1_ref_roleId(StringBuilder sb, StringBuilder sb2, Model smodel, Modelitem smitem, Modelitem pmitem, String smodel_id, String pmodel_id, String smodel_classname, String pmodel_classname, String rkey_content, String rkey_id, Modelitem smitem2, Control control, String basetab, Modelitem containermitem, String parseStorerefType, HelperGenerator_s2p_control hcon) {
        boolean isHiddenFlag = control != null;
        if (parseStorerefType.equals("rolecontent_id")) {
            sb.append(basetab);
            sb.append("if (");
            sb.append("!_headerSet.contains(JFCUtils.getRValue(\"");
            sb.append(rkey_content);
            sb.append("\", p.locale)) &&");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("_key.equals(JFCUtils.getRValue(\"");
            sb.append(rkey_id);
            sb.append("\", p.locale)))");
            sb.append(CR);
            sb.append(basetab);
            sb.append("{");
            sb.append(CR);
        } else {
            sb.append(basetab);
            sb.append("if (");
            sb.append("_key.equals(JFCUtils.getRValue(\"");
            sb.append(rkey_id);
            sb.append("\", p.locale))) {");
            sb.append(CR);
        }
        String ltab = "";
        if (isHiddenFlag) {
            String tab = basetab.length() > 4 ? basetab.substring(4) : "";
            sb.append(hcon.gPrepare(control, tab));
            sb.append(basetab + "    ");
            sb.append("if (ret) {");
            sb.append(CR);
            ltab = "    ";
        }
        if (parseStorerefType.equals("rolecontent")) {
            sb.append(basetab + "    " + ltab);
            sb.append("// the id part of " + smitem.getName() + " is not supported.");
            sb.append(CR);
            sb.append(basetab + "    " + ltab);
            sb.append("return false;");
            sb.append(CR);
        } else {
            sb.append(basetab + "    " + ltab);
            sb.append("return true;");
            sb.append(CR);
        }
        if (isHiddenFlag) {
            sb.append(basetab + "    ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("return false;");
            sb.append(CR);
        }
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
    }

    public void gParseCsvData(StringBuilder sb, String rkey, Model smodel, Modelitem smitem, Modelitem smitem2, Modelitem pmitem, String methodnameheader, String parseStorerefType, String smodel_id, String pmodel_id, String smodel_classname, String pmodel_classname, Modelitem containermitem) {
        assert (parseStorerefType.equals("roleid") || parseStorerefType.equals("rolecontent"));
        sb.append("    ");
        sb.append("public boolean " + methodnameheader + AppSchemaUtil.getChildPart(smitem.getName()) + "(");
        sb.append(CR);
        sb.append("        ");
        sb.append("String _key, ActionParameter p)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        this.gParseCsvData_check_multicolumn(sb, rkey, smodel, smitem, smitem2, pmitem, pmodel_id);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private void gParseCsvData_callGetUpdateMethod(StringBuilder sb, Model smodel, Modelitem smitem, Modelitem pmitem) {
        sb.append("        ");
        sb.append("_items = ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project)).append(".");
        sb.append("get").append(AppSchemaUtil.getModelitemClassname(smitem)).append("_all(p);");
        sb.append(CR);
    }

    public void gParseCsvData_check_multicolumn(StringBuilder sb, String rkey, Model smodel, Modelitem smitem, Modelitem smitem2, Modelitem pmitem, String pmodel_id) {
        String pmodel_packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        String pmitem_classname = AppSchemaUtil.getModelitemClassname(pmitem);
        sb.append("        ");
        sb.append("final String _header = JFCUtils.getRValue(\"");
        sb.append(rkey);
        sb.append("\", p.locale);");
        sb.append(CR);
        sb.append("        ");
        sb.append("String _value = _key.substring(_header.length());");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append(pmodel_packagename);
        sb.append(pmitem_classname);
        sb.append(" _item = null;");
        sb.append(CR);
        sb.append("        ");
        sb.append(pmodel_packagename);
        sb.append(pmitem_classname);
        sb.append("[] _items;");
        sb.append(CR);
        this.gParseCsvData_callGetUpdateMethod(sb, smodel, smitem, pmitem);
        sb.append(CR);
        sb.append("        ");
        sb.append("for (int j=0; j<_items.length; j++) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("    if (_value.equals(_items[j].getContentAsString())) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("        if (_item != null) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("            // ").append(this.rman.getValue("helper.comment.HelperGenerator_getValidCsvHeader.twice"));
        sb.append(CR);
        sb.append("        ");
        sb.append("            return false;");
        sb.append(CR);
        sb.append("        ");
        sb.append("        } else {");
        sb.append(CR);
        sb.append("        ");
        sb.append("            // ").append(this.rman.getValue("helper.comment.HelperGenerator_getValidCsvHeader.once"));
        sb.append(CR);
        sb.append("        ");
        sb.append("            _item = _items[j];");
        sb.append(CR);
        sb.append("        ");
        sb.append("        }");
        sb.append(CR);
        sb.append("        ");
        sb.append("    }");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_item == null) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("    return false;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("return true;");
        sb.append(CR);
    }
}

