/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang3.StringUtils;

public class HelperGenerator_incdecNode
implements ISourceVariable {
    private Model model;
    private Project project;
    private String tab;

    public HelperGenerator_incdecNode(Model model, Project project) {
        this(model, project, "        ");
    }

    public HelperGenerator_incdecNode(Model model, Project project, String tab) {
        this.model = model;
        this.project = project;
        this.tab = tab;
    }

    public String process(String timing) {
        return this.process(timing, null, null);
    }

    public String process(String timing, String excludeModelitemName, String excludeExpr) {
        StringBuilder sb = new StringBuilder();
        if (!((String)timing).endsWith(":")) {
            timing = (String)timing + ":";
        }
        for (IModelChoice imc : this.model.getContent()) {
            String _action;
            Modelitem mitem;
            if (!(imc instanceof Modelitem) || !(mitem = (Modelitem)imc).getMultiple() || !StringUtils.isNotBlank((CharSequence)(_action = mitem.getAction()))) continue;
            if (_action.startsWith((String)timing)) {
                _action = _action.substring(((String)timing).length());
            }
            if (mitem.getHasChild()) {
                String condition = null;
                if (excludeModelitemName != null && mitem.getName().equals(excludeModelitemName)) {
                    condition = excludeExpr;
                }
                if ("addFirst".equals(_action)) {
                    this.process_addContainerFirst(mitem, condition, sb);
                    continue;
                }
                if ("addLast".equals(_action)) {
                    this.process_addContainerLast(mitem, condition, sb);
                    continue;
                }
                if ("removeFirst".equals(_action)) {
                    this.process_removeContainerFirst(mitem, condition, sb);
                    continue;
                }
                if (!"removeLast".equals(_action)) continue;
                this.process_removeContainerLast(mitem, condition, sb);
                continue;
            }
            if ("addFirst".equals(_action)) {
                this.process_addItemFirst(mitem, sb);
                continue;
            }
            if ("addLast".equals(_action)) {
                this.process_addItemLast(mitem, sb);
                continue;
            }
            if ("removeFirst".equals(_action)) {
                this.process_removeItemFirst(mitem, sb);
                continue;
            }
            if (!"removeLast".equals(_action)) continue;
            this.process_removeItemLast(mitem, sb);
        }
        return sb.toString();
    }

    protected void process_addItemFirst(Modelitem mitem, StringBuilder sb) {
        this.process_Item(mitem, sb, "add", new IndexExpression(){

            @Override
            public String process(String mid, String getterf) {
                return "0";
            }
        });
    }

    protected void process_addItemLast(Modelitem mitem, StringBuilder sb) {
        this.process_Item(mitem, sb, "add", new IndexExpression(){

            @Override
            public String process(String mid, String getterf) {
                return "";
            }
        });
    }

    protected void process_removeItemFirst(Modelitem mitem, StringBuilder sb) {
        this.process_Item(mitem, sb, "remove", new IndexExpression(){

            @Override
            public String process(String mid, String getterf) {
                return "0";
            }
        });
    }

    protected void process_removeItemLast(Modelitem mitem, StringBuilder sb) {
        this.process_Item(mitem, sb, "remove", new IndexExpression(){

            @Override
            public String process(String mid, String getterf) {
                return "Math.max(ArrayUtils.getLength(" + mid + getterf + ")-1, 0)";
            }
        });
    }

    private void process_Item(Modelitem mitem, StringBuilder sb, String op, IndexExpression expr) {
        String mid = this.model.getId();
        String name = mitem.getName();
        String method = null;
        if ("add".equals(op)) {
            method = JavaSourceGenerator.adderMethod(name);
        } else if ("remove".equals(op)) {
            method = JavaSourceGenerator.removeMethod(name);
        }
        String getterf = JavaSourceGenerator.getterFullMethod(name);
        String type = mitem.getType();
        sb.append(this.tab);
        sb.append(mid).append(".").append(method).append("(");
        String idx = expr.process(mid, getterf);
        sb.append(idx);
        if ("add".equals(op) && !JavaSourceGenerator.isBasicType(type)) {
            if (StringUtils.isNotBlank((CharSequence)idx)) {
                sb.append(", ");
            }
            if (JavaSourceGenerator.isStringType(type)) {
                sb.append("\"\"");
            } else if (JavaSourceGenerator.isDateOrTimeType(type)) {
                sb.append("new ").append(JavaSourceGenerator.getProperType(type));
            }
        }
        sb.append(");").append(CR);
    }

    protected void process_addContainerFirst(Modelitem mitem, String condition, StringBuilder sb) {
        this.process_Container(mitem, sb, "add", condition, new IndexExpression(){

            @Override
            public String process(String mid, String getterf) {
                return "0";
            }
        });
    }

    protected void process_addContainerLast(Modelitem mitem, String condition, StringBuilder sb) {
        this.process_Container(mitem, sb, "add", condition, new IndexExpression(){

            @Override
            public String process(String mid, String getterf) {
                return "ArrayUtils.getLength(" + mid + getterf + ")";
            }
        });
    }

    protected void process_removeContainerFirst(Modelitem mitem, String condition, StringBuilder sb) {
        this.process_Container(mitem, sb, "remove", condition, new IndexExpression(){

            @Override
            public String process(String mid, String getterf) {
                return "0";
            }
        });
    }

    protected void process_removeContainerLast(Modelitem mitem, String condition, StringBuilder sb) {
        this.process_Container(mitem, sb, "remove", condition, new IndexExpression(){

            @Override
            public String process(String mid, String getterf) {
                return "Math.max(ArrayUtils.getLength(" + mid + getterf + ")-1, 0)";
            }
        });
    }

    private void process_Container(Modelitem mitem, StringBuilder sb, String method, String condition, IndexExpression expr) {
        String name = mitem.getName();
        String mid = this.model.getId();
        String mpackagename = AppSchemaUtil.getPackagename(this.model, this.project);
        String mclassname = AppSchemaUtil.getModelitemClassname(mitem);
        String classname = mpackagename + mclassname;
        String setter = JavaSourceGenerator.setterMethod(name);
        String getterf = JavaSourceGenerator.getterFullMethod(name);
        sb.append(this.tab);
        if (condition != null) {
            sb.append(condition).append(CR);
            sb.append(this.tab + "    ");
        }
        sb.append(mid).append(".").append(setter).append("(");
        sb.append("(").append(classname).append("[])");
        sb.append("ArrayUtils.").append(method).append("(");
        sb.append(mid).append(getterf);
        sb.append(", ");
        sb.append(expr.process(mid, getterf));
        if ("add".equals(method)) {
            sb.append(", new ");
            sb.append(classname).append("()");
        }
        sb.append(")");
        sb.append(")");
        sb.append(";");
        sb.append(CR);
        if (condition != null) {
            sb.append(this.tab + "    ").append("p.request.setAttribute(\"__jfc_ignore_setDefaultValue\", \"").append(name).append("\");").append(CR);
            sb.append(this.tab).append("}").append(CR);
        }
    }

    private abstract class IndexExpression {
        private IndexExpression() {
        }

        abstract String process(String var1, String var2);
    }
}

