/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_input_check;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Inhibit;
import jp.jasminesoft.jfc.gen.appschema.Inhibitlist;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_inhibit
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Inhibit content;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_inhibit.class.getName());
    public static final String INHIBIT_PREFIX = "inhibit_";

    public HelperGenerator_inhibit(Project project, Model model, Modelitem item, Inhibit content) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.content = content;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        sb.append(basetab + "        ");
        sb.append("// " + this.rman.getValue("helper.comment.inhibit"));
        sb.append(CR);
        IRNode[] nodes = this.content.getIdrefsAsIRNodes();
        for (int i = 0; i < nodes.length; ++i) {
            IRNode node = nodes[i];
            if (!(node instanceof Inhibitlist)) continue;
            sb.append(this.process0((Inhibitlist)node, basetab));
        }
        return sb.toString();
    }

    public String process0(Inhibitlist pt, String basetab) {
        StringBuilder sb = new StringBuilder();
        String elementname = INHIBIT_PREFIX + pt.getId();
        String name = HelperGenerator_input_check.getName4ErrorManager(this.item.getName(), this.model);
        String label = this.item.getLabel();
        if (label == null || label.length() == 0) {
            label = this.item.getName();
        }
        Relation relation = AppSchemaUtil.getRelationFromPModel(this.model, this.item);
        Model smodel = AppSchemaUtil.getStoreModel(this.model);
        String rkey = null;
        if (smodel != null) {
            String label_i18n = AppSchemaUtil.getLabeli18n(this.item, smodel.getId(), this.model, this.project);
            rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName(), label_i18n);
            JFCAppResourceGenerator.put(rkey, label_i18n);
        }
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ");
            sb.append("if (_isContainsId) {").append(CR);
        }
        sb.append(basetab + "        ");
        sb.append("if (s != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("for (int i=0; i<" + elementname + ".length; i++) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("if (s.indexOf(" + elementname + "[i]) >= 0) {");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append("Object[] o = { ");
        sb.append("getRValue(\"" + rkey + "\", p)");
        sb.append(" , ");
        sb.append(CR);
        sb.append(basetab + "                        ");
        sb.append(elementname + "[i] };");
        sb.append(CR);
        sb.append(basetab + "                    ");
        if (this.content.getWarning()) {
            sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =");
            sb.append(CR);
            sb.append(basetab + "                        ");
            sb.append("manager.getJfcwarn(\"");
            sb.append(name).append("\", \"");
            sb.append(this.createErrorCode("error.input.inhibit_string"));
            sb.append("\", o, p.locale);");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, \"");
            sb.append(rkey);
            sb.append("\", \"" + this.createErrorCode("error.input.inhibit_string") + "\");");
            sb.append(CR);
            HelperGenerator_input_check.generateWarnCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                    ");
        } else {
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
            sb.append(CR);
            sb.append(basetab + "                        ");
            sb.append("manager.getJfcerror(\"");
            sb.append(name).append("\", \"");
            sb.append(this.createErrorCode("error.input.inhibit_string"));
            sb.append("\", o, p.locale);");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("p.errors.addJfcerror(_error);");
            sb.append(CR);
            HelperGenerator_input_check.generateErrorCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                    ");
        }
        sb.append(basetab + "                ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ").append("}").append(CR);
        }
        return sb.toString();
    }
}

