/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_input_check;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Regexp;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_regexp
extends HelperGeneratorBaseTask {
    protected Regexp regexp;
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_regexp.class.getName());

    public HelperGenerator_regexp(Project project, Model model, Modelitem item, Regexp regexp) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.regexp = regexp;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        String name = HelperGenerator_input_check.getName4ErrorManager(this.item.getName(), this.model);
        String label = this.item.getLabel();
        if (label == null || label.length() == 0) {
            label = this.item.getName();
        }
        Relation relation = AppSchemaUtil.getRelationFromPModel(this.model, this.item);
        boolean isZipCodeFlag = false;
        Model smodel = AppSchemaUtil.getStoreModel(this.model);
        Modelitem sitem = null;
        String rkey = null;
        if (smodel != null) {
            String label_i18n = AppSchemaUtil.getLabeli18n(this.item, smodel.getId(), this.model, this.project);
            rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName(), label_i18n);
            JFCAppResourceGenerator.put(rkey, label_i18n);
            sitem = AppSchemaUtil.getModelitem(this.item.getName(), smodel);
            if (sitem != null) {
                isZipCodeFlag = AppSchemaUtil.isZipCode(this.project, sitem, smodel);
            }
        }
        sb.append(basetab + "        ");
        sb.append("// " + this.rman.getValue("helper.comment.regexp"));
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ");
            sb.append("if (_isContainsId) {").append(CR);
        }
        sb.append(basetab + "        ");
        sb.append("if (StringUtils.isNotEmpty(s)) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("Object[] o = { ");
        sb.append("getRValue(\"" + StringUtil.convertJavaString((String)rkey) + "\", p)");
        sb.append(" };");
        sb.append(CR);
        if (isZipCodeFlag) {
            sb.append(basetab + "            ");
            sb.append("if (s.length() > 0 && s.charAt(0) == '$')");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("s = s.substring(1);");
            sb.append(CR);
        }
        sb.append(basetab + "            ");
        sb.append("try {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("if (!s.matches(\"");
        sb.append(StringUtil.convertJavaString((String)this.regexp.getContent()));
        sb.append("\")) {");
        sb.append(CR);
        if (this.regexp.getWarning()) {
            sb.append(basetab + "                    ");
            sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =");
            sb.append(CR);
            sb.append(basetab + "                        ");
            sb.append("manager.getJfcwarn(\"");
            sb.append(name).append("\", \"");
            sb.append(this.createErrorCode("error.input.regexp"));
            sb.append("\", o, p.locale);");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, \"");
            sb.append(StringUtil.convertJavaString((String)rkey));
            sb.append("\", \"" + this.createErrorCode("error.input.regexp") + "\");");
            sb.append(CR);
            HelperGenerator_input_check.generateWarnCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                    ");
        } else {
            String rtype;
            sb.append(basetab + "                    ");
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
            sb.append(CR);
            sb.append(basetab + "                        ");
            sb.append("manager.getJfcerror(\"");
            sb.append(name).append("\", \"");
            sb.append(this.createErrorCode("error.input.regexp"));
            sb.append("\", o, p.locale);");
            sb.append(CR);
            if (relation != null && "search".equals(rtype = relation.getType())) {
                sb.append(basetab + "                    ");
                sb.append("_error.setName(\"").append(name).append("\");").append(CR);
            }
            sb.append(basetab + "                    ");
            sb.append("p.errors.addJfcerror(_error);");
            sb.append(CR);
            HelperGenerator_input_check.generateErrorCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                    ");
        }
        sb.append(basetab + "                ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("} catch (java.util.regex.PatternSyntaxException e) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("logger.warn(\"illegal syntax pattern, \"+e.getMessage());");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ").append("}").append(CR);
        }
        return sb.toString();
    }
}

