/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Checkitem;
import jp.jasminesoft.jfc.gen.appschema.Checklist;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Validation;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_validate
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_validate.class.getName());

    public HelperGenerator_validate(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        Validation validation = null;
        IModelChoice[] imc = this.model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                if (!(imc[i] instanceof Validation)) continue;
                validation = (Validation)imc[i];
                break;
            }
        }
        if (validation == null) {
            return sb.toString();
        }
        Checklist checklist = validation.getChecklist();
        if (checklist == null) {
            this.logger.error(this.rman.getValue("value.null.checklist", this.model.getId()));
            return sb.toString();
        }
        Checkitem[] checkitems = checklist.getCheckitem();
        if (checkitems == null || checkitems.length == 0) {
            this.logger.error(this.rman.getValue("value.null.checkitems", this.model.getId()));
            return sb.toString();
        }
        String id = this.model.getId();
        String classname = AppSchemaUtil.getClassname(this.model);
        String[] msg_param = new String[]{id + " " + classname};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.validation"), msg_param, "true or false"));
        sb.append("    ");
        sb.append("public boolean validate(");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(")");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean ret = true;");
        sb.append(CR);
        sb.append(CR);
        for (int i = 0; i < checkitems.length; ++i) {
            Checkitem checkitem = checkitems[i];
            String cname = checkitem.getName();
            String ccond = JavaSourceGenerator.gProperCondition(checkitem.getCond());
            String cvalue = checkitem.getValue();
            sb.append("        ");
            sb.append("if (");
            sb.append(id);
            sb.append(".");
            sb.append(JavaSourceGenerator.getterMethod(cname));
            sb.append("() ");
            sb.append(ccond);
            sb.append(" ");
            sb.append(cvalue);
            sb.append(")");
            sb.append(CR);
            sb.append("            ");
            sb.append("ret = false;");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("return ret;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }
}

