/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AnormManagerGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Zipcodeinfo;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_zipCodeSync
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Modelitem zipitem;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_zipCodeSync.class.getName());

    public HelperGenerator_zipCodeSync(Project project, Model model, Modelitem zipitem) {
        this.project = project;
        this.model = model;
        this.zipitem = zipitem;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        Modelitem zip_mitem;
        StringBuilder sb = new StringBuilder();
        String id = this.model.getId();
        String classname = AppSchemaUtil.getClassname(this.model);
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model rmodel = (Model)node;
        String zipname = this.zipitem.getName();
        String addrname = "";
        IModelitemChoice[] imic = this.zipitem.getContent();
        Zipcodeinfo zinfo = null;
        if (imic != null) {
            for (int i = 0; i < imic.length; ++i) {
                if (!(imic[i] instanceof Zipcodeinfo)) continue;
                zinfo = (Zipcodeinfo)imic[i];
                break;
            }
        }
        if (zinfo != null) {
            addrname = zinfo.getAddressfield();
        }
        boolean isAnormFlag = false;
        Modelitem addr_mitem = AppSchemaUtil.getModelitem(addrname, this.model);
        if (addr_mitem != null) {
            isAnormFlag = AppSchemaUtil.isAnormOption(addr_mitem);
        }
        if ((zip_mitem = AppSchemaUtil.getModelitem(zipname, this.model)) == null) {
            return "";
        }
        Modelitem zip_sitem = AppSchemaUtil.getModelitem(zipname, rmodel);
        Relation _rrelation = AppSchemaUtil.getRelationTypeIsRef(zip_sitem);
        if (_rrelation != null) {
            isAnormFlag = true;
        }
        boolean hasChildFlag = false;
        String zipname_p = null;
        String zipname_c = null;
        if (zipname.indexOf("/") > 0) {
            hasChildFlag = true;
            if ("condition".equals(rmodel.getType())) {
                hasChildFlag = false;
            }
            zipname_p = zipname.substring(0, zipname.indexOf("/"));
            zipname = zipname_c = zipname.substring(zipname.indexOf("/") + 1);
        }
        String _name = hasChildFlag ? zipname_p + "_" + zipname_c : zipname;
        String addrname_p = null;
        String addrname_c = null;
        if (addrname.indexOf("/") > 0) {
            addrname_p = addrname.substring(0, addrname.indexOf("/"));
            addrname = addrname_c = addrname.substring(addrname.indexOf("/") + 1);
        }
        String cls_zipname = AppSchemaUtil.getModelitemClassname(zip_mitem);
        String cls_zipname0 = cls_zipname + SourceGenerator.convClassname4Relax("_jshzipcode");
        String getterf_zipname = ".get" + SourceGenerator.capFirst(zipname) + "()";
        String setter_zipname = ".set" + SourceGenerator.capFirst(zipname) + "(";
        String setter_zipname0 = ".set" + SourceGenerator.capFirst(zipname) + SourceGenerator.convClassname4Relax("_jshzipcode") + "(";
        String getterf_addrname = ".get" + SourceGenerator.capFirst(addrname) + "()";
        String setter_addrname = ".set" + SourceGenerator.capFirst(addrname) + "(";
        String addr_classname = AppSchemaUtil.getModelitemClassname(addr_mitem);
        String addr_instancename = "_" + addrname;
        boolean useAnormManager = AnormManagerGenerator.getAnormType(this.project) != null;
        String proxyClassname = AnormManagerGenerator.getAnormServerProxyClassnameWithPackage(this.project);
        String[] msg_param = new String[hasChildFlag ? 3 : 2];
        msg_param[0] = id + " " + classname;
        if (hasChildFlag) {
            msg_param[1] = "index";
            msg_param[2] = "p ActionParameter";
        } else {
            msg_param[1] = "p ActionParameter";
        }
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.zipcode"), msg_param, null));
        sb.append("    ");
        sb.append("public void");
        sb.append(" zipCodeSync_");
        sb.append(_name);
        sb.append("(");
        sb.append(CR);
        sb.append("        ");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(", ");
        if (hasChildFlag) {
            sb.append("int index, ");
        }
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        if (CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.HelperGenerator_zipCodeSync.useframework." + this.model.getId()) && !useAnormManager && StringUtils.isNotBlank((CharSequence)addrname)) {
            sb.append(basetab + "        ");
            sb.append("zipCodeSync(");
            sb.append(id).append(", ");
            sb.append("\"").append(zipname).append("\", ");
            sb.append(cls_zipname).append(".class, ");
            sb.append("\"").append(zipname).append("_jshzipcode\", ");
            sb.append(cls_zipname).append(SourceGenerator.convClassname4Relax("_jshzipcode") + ".class, ");
            sb.append("\"").append(addrname).append("\", ");
            sb.append(addr_classname).append(".class, ");
            if (hasChildFlag) {
                sb.append("\"").append(addrname_p).append("\", ");
                sb.append("index, ");
            }
            sb.append("\"").append(_name).append("\", ");
            sb.append("p);").append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            return sb.toString();
        }
        if (addrname == null || addrname.length() == 0) {
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            return sb.toString();
        }
        sb.append("        ");
        sb.append(cls_zipname);
        sb.append(" _zipcode = ");
        sb.append(id);
        if (hasChildFlag) {
            sb.append(JavaSourceGenerator.getterFullMethod(zipname_p));
            sb.append("[index]");
        }
        sb.append(getterf_zipname);
        sb.append(";");
        sb.append(CR);
        sb.append("        ");
        sb.append("String zipcode = _zipcode.getContent();");
        sb.append(CR);
        if (isAnormFlag) {
            sb.append("        ");
            sb.append(addr_classname);
            sb.append(" ");
            sb.append(addr_instancename);
            sb.append(" = ");
            sb.append(id);
            if (hasChildFlag) {
                sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
                sb.append("[index]");
            }
            sb.append(getterf_addrname);
            sb.append(";");
            sb.append(CR);
            sb.append("        ");
            sb.append("if (" + addr_instancename + " == null) {");
            sb.append(CR);
            sb.append("            ");
            sb.append(addr_instancename);
            sb.append(" = new " + addr_classname + "();");
            sb.append(CR);
            sb.append("            ");
            sb.append(addr_instancename);
            sb.append(".setContent(\"\");");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
            sb.append("        ");
            sb.append("String adrs = ");
            sb.append(addr_instancename);
            sb.append(".getContent();");
            sb.append(CR);
        } else {
            sb.append("        ");
            sb.append("String adrs = ");
            sb.append(id);
            sb.append(getterf_addrname);
            sb.append(";");
            sb.append(CR);
        }
        if (useAnormManager) {
            sb.append("        ");
            sb.append(proxyClassname);
            sb.append(" __jfc_proxy = ");
            sb.append(CR);
            sb.append("            ");
            sb.append("NormalizeServerManager.getInstance(p);");
            sb.append(CR);
            sb.append("        ");
            sb.append("if (__jfc_proxy == null) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("p.logger.warn(\"NormalizeServer is not found.\");");
            sb.append(CR);
            sb.append("            ");
            sb.append("return;");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        } else {
            sb.append("        ");
            sb.append("jp.jasminesoft.util.address.AddressResolver _resolver =").append(CR);
            sb.append("            ");
            sb.append("jp.jasminesoft.util.address.AddressResolver.getInstance();");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("if (zipcode != null && zipcode.length() > 0) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("zipcode = StringUtil.removePreAndPostWhitespace(zipcode);");
        sb.append(CR);
        sb.append("            ");
        sb.append("// " + this.rman.getValue("helper.comment.zipcode.z2a"));
        sb.append(CR);
        sb.append("            ");
        sb.append("if (zipcode.startsWith(\"$\")) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("// " + this.rman.getValue("helper.comment.zipcode.determine"));
        sb.append(CR);
        sb.append("                ");
        sb.append(cls_zipname0);
        sb.append("[] zlist = (");
        sb.append(cls_zipname0);
        sb.append("[])p.appMap.get(\"" + _name + "list\");");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (zlist != null) {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("int id = StringUtil.intValue(zipcode.substring(1));");
        sb.append(CR);
        sb.append("                    ");
        sb.append("for (int i=0; i<zlist.length; i++) {");
        sb.append(CR);
        sb.append("                        ");
        sb.append("if (id == zlist[i].getId()) {");
        sb.append(CR);
        sb.append("                            ");
        sb.append("String s = zlist[i].getContent();");
        sb.append(CR);
        sb.append("                            ");
        sb.append("int ptr = s.indexOf(\" \");");
        sb.append(CR);
        sb.append("                            ");
        sb.append("if (ptr > 0 && ptr < s.length()) {");
        sb.append(CR);
        sb.append("                                ");
        sb.append("String pcode = s.substring(0, ptr);");
        sb.append(CR);
        sb.append("                                ");
        sb.append("String adrs0 = s.substring(ptr+1);");
        sb.append(CR);
        sb.append("                                ");
        sb.append("_zipcode.setContent(pcode);");
        sb.append(CR);
        sb.append("                                ");
        sb.append(id);
        if (hasChildFlag) {
            sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
            sb.append("[index]");
        }
        sb.append(setter_zipname);
        sb.append("_zipcode");
        sb.append(");");
        sb.append(CR);
        sb.append("                                ");
        sb.append("// " + this.rman.getValue("helper.comment.zipcode.setifchange"));
        sb.append(CR);
        sb.append("                                ");
        sb.append("if (adrs == null || !adrs.startsWith(adrs0)) {");
        sb.append(CR);
        if (isAnormFlag) {
            sb.append("                                    ");
            sb.append(addr_instancename);
            sb.append(".setContent(adrs0);");
            sb.append(CR);
            sb.append("                                    ");
            sb.append(id);
            if (hasChildFlag) {
                sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
                sb.append("[index]");
            }
            sb.append(setter_addrname);
            sb.append(addr_instancename);
            sb.append(");");
            sb.append(CR);
        } else {
            sb.append("                                    ");
            sb.append(id);
            if (hasChildFlag) {
                sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
                sb.append("[index]");
            }
            sb.append(setter_addrname);
            sb.append("adrs0);");
            sb.append(CR);
        }
        sb.append("                                ");
        sb.append("}");
        sb.append(CR);
        sb.append("                            ");
        sb.append("}");
        sb.append(CR);
        sb.append("                            ");
        sb.append("break;");
        sb.append(CR);
        sb.append("                        ");
        sb.append("}");
        sb.append(CR);
        sb.append("                    ");
        sb.append("}");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("                ");
        sb.append("// " + this.rman.getValue("helper.comment.zipcode.z2a"));
        sb.append(CR);
        sb.append("                ");
        sb.append("String[] _adrs = null;");
        sb.append(CR);
        if (useAnormManager) {
            sb.append("                ");
            sb.append("try {");
            sb.append(CR);
            sb.append("                    ");
            sb.append("if (zipcode.length() == 7) {");
            sb.append(CR);
            sb.append("                        ");
            sb.append("_adrs = __jfc_proxy.getAddress(zipcode);");
            sb.append(CR);
            sb.append("                        ");
            sb.append("if (_adrs != null && _adrs.length == 4) {");
            sb.append(CR);
            sb.append("                            ");
            sb.append("String tmp = _adrs[0] + _adrs[1] + _adrs[2] + _adrs[3];");
            sb.append(CR);
            sb.append("                            ");
            sb.append("_adrs = new String[1];");
            sb.append(CR);
            sb.append("                            ");
            sb.append("_adrs[0] = tmp;");
            sb.append(CR);
            sb.append("                        ");
            sb.append("}");
            sb.append(CR);
            sb.append("                    ");
            sb.append("} else {");
            sb.append(CR);
            sb.append("                        ");
            sb.append("_adrs = __jfc_proxy.getAddress4ZipSync(zipcode);");
            sb.append(CR);
            sb.append("                    ");
            sb.append("}");
            sb.append(CR);
            sb.append("                ");
            sb.append("} catch (Exception e) {");
            sb.append(CR);
            sb.append("                    ");
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _jfcerror = new Jfcerror();");
            sb.append(CR);
            sb.append("                    ");
            sb.append("_jfcerror.setContent(e.getMessage());");
            sb.append(CR);
            sb.append("                    ");
            sb.append("_jfcerror.setCode(\"error.anorm\");");
            sb.append(CR);
            sb.append("                    ");
            sb.append("p.errors.addJfcerror(_jfcerror);");
            sb.append(CR);
            sb.append("                ");
            sb.append("}");
            sb.append(CR);
        } else {
            sb.append("                ");
            sb.append("if (zipcode.length() == 7) {").append(CR);
            sb.append("                    ");
            sb.append("String[] _ss = _resolver.findAddressByZipcode(zipcode);").append(CR);
            sb.append("                    ");
            sb.append("if (_ss != null && _ss.length > 0) {").append(CR);
            sb.append("                        ");
            sb.append("_adrs = new String[1];").append(CR);
            sb.append("                        ");
            sb.append("_adrs[0] = _ss[0];").append(CR);
            sb.append("                    ");
            sb.append("}").append(CR);
            sb.append("                ");
            sb.append("} else {").append(CR);
            sb.append("                    ");
            sb.append("_adrs = _resolver.findAddressByZipcode(zipcode);").append(CR);
            sb.append("                ");
            sb.append("}").append(CR);
        }
        sb.append("                ");
        sb.append("if (_adrs != null && _adrs.length > 0) {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("if (_adrs.length == 1) {");
        sb.append(CR);
        sb.append("                        ");
        sb.append("if (adrs == null || !adrs.startsWith(_adrs[0])) {");
        sb.append(CR);
        if (isAnormFlag) {
            sb.append("                            ");
            sb.append(addr_instancename);
            sb.append(".setContent(_adrs[0]);");
            sb.append(CR);
            sb.append("                            ");
            sb.append(id);
            if (hasChildFlag) {
                sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
                sb.append("[index]");
            }
            sb.append(setter_addrname);
            sb.append(addr_instancename);
            sb.append(");");
            sb.append(CR);
        } else {
            sb.append("                            ");
            sb.append(id);
            if (hasChildFlag) {
                sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
                sb.append("[index]");
            }
            sb.append(setter_addrname);
            sb.append("_adrs[0]);");
            sb.append(CR);
        }
        sb.append("                        ");
        sb.append("}");
        sb.append(CR);
        sb.append("                    ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("                        ");
        sb.append(cls_zipname0);
        sb.append("[] z0 = new ");
        sb.append(cls_zipname0);
        sb.append("[_adrs.length];");
        sb.append(CR);
        sb.append("                        ");
        sb.append("for (int i=0; i<z0.length; i++) {");
        sb.append(CR);
        sb.append("                            ");
        sb.append("z0[i] = new ");
        sb.append(cls_zipname0);
        sb.append("();");
        sb.append(CR);
        sb.append("                            ");
        sb.append("z0[i].setId(i);");
        sb.append(CR);
        sb.append("                            ");
        sb.append("z0[i].setContent(_adrs[i]);");
        sb.append(CR);
        sb.append("                        ");
        sb.append("}");
        sb.append(CR);
        sb.append("                        ");
        sb.append(id);
        if (hasChildFlag) {
            sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
            sb.append("[index]");
        }
        sb.append(setter_zipname0);
        sb.append("z0);");
        sb.append(CR);
        sb.append("                        ");
        sb.append("// " + this.rman.getValue("helper.comment.zipcode.tmpstore"));
        sb.append(CR);
        sb.append("                        ");
        sb.append("p.appMap.put(\"");
        sb.append(_name + "list");
        sb.append("\", z0);");
        sb.append(CR);
        sb.append("                    ");
        sb.append("}");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else if (adrs != null && adrs.length() > 0) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("// " + this.rman.getValue("helper.comment.zipcode.a2z"));
        sb.append(CR);
        sb.append("            ");
        sb.append("String[] _zip = null;");
        sb.append(CR);
        if (useAnormManager) {
            sb.append("            ");
            sb.append("try {");
            sb.append(CR);
            sb.append("                ");
            sb.append("String[] ss = __jfc_proxy.getResultByString(adrs);");
            sb.append(CR);
            sb.append("                ");
            sb.append("if (ss != null) {");
            sb.append(CR);
            sb.append("                    ");
            sb.append("_zip = new String[1];");
            sb.append(CR);
            sb.append("                    ");
            sb.append("_zip[0] = ss[2] + ss[3] + ss[4] + \" \" + ss[1];");
            sb.append(CR);
            sb.append("                ");
            sb.append("}");
            sb.append(CR);
            sb.append("            ");
            sb.append("} catch (Exception e) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _jfcerror = new Jfcerror();");
            sb.append(CR);
            sb.append("                ");
            sb.append("_jfcerror.setContent(e.getMessage());");
            sb.append(CR);
            sb.append("                ");
            sb.append("_jfcerror.setCode(\"error.anorm\");");
            sb.append(CR);
            sb.append("                ");
            sb.append("p.errors.addJfcerror(_jfcerror);");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        } else {
            sb.append("            ");
            sb.append("String[] _ss = null;//_resolver.findZipcodeByAddress(adrs);");
            sb.append(CR);
            sb.append("            ");
            sb.append("if (_ss != null) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("_zip = new String[1];");
            sb.append(CR);
            sb.append("                ");
            sb.append("_zip[0] = _ss[0];");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("if (_zip != null && _zip.length > 0) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("int ptr = 0;");
        sb.append(CR);
        sb.append("                ");
        sb.append("String s = null;");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (_zip.length == 1) {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("s = _zip[0];");
        sb.append(CR);
        sb.append("                    ");
        sb.append("ptr = s.indexOf(\" \");");
        sb.append(CR);
        sb.append("                    ");
        sb.append("if (ptr > 0 && ptr < s.length()) {");
        sb.append(CR);
        sb.append("                        ");
        sb.append("String adrs0 = s.substring(0, ptr);");
        sb.append(CR);
        sb.append("                        ");
        sb.append("String pcode = s.substring(ptr+1);");
        sb.append(CR);
        sb.append("                        ");
        sb.append("_zipcode.setContent(pcode);");
        sb.append(CR);
        sb.append("                        ");
        sb.append(id);
        if (hasChildFlag) {
            sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
            sb.append("[index]");
        }
        sb.append(setter_zipname);
        sb.append("_zipcode");
        sb.append(");");
        sb.append(CR);
        sb.append("                    ");
        sb.append("}");
        sb.append(CR);
        sb.append("                ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("                    ");
        sb.append(cls_zipname0);
        sb.append("[] z0 = new ");
        sb.append(cls_zipname0);
        sb.append("[_zip.length];");
        sb.append(CR);
        sb.append("                    ");
        sb.append("for (int i=0; i<z0.length; i++) {");
        sb.append(CR);
        sb.append("                        ");
        sb.append("z0[i] = new ");
        sb.append(cls_zipname0);
        sb.append("();");
        sb.append(CR);
        sb.append("                        ");
        sb.append("z0[i].setId(i);");
        sb.append(CR);
        sb.append("                        ");
        sb.append("s = _zip[i];");
        sb.append(CR);
        sb.append("                        ");
        sb.append("ptr = s.indexOf(\" \");");
        sb.append(CR);
        sb.append("                        ");
        sb.append("if (ptr > 0 && ptr < s.length()) {");
        sb.append(CR);
        sb.append("                            ");
        sb.append("String adrs0 = s.substring(0, ptr);");
        sb.append(CR);
        sb.append("                            ");
        sb.append("String pcode = s.substring(ptr+1);");
        sb.append(CR);
        sb.append("                            ");
        sb.append("z0[i].setContent(pcode + \" \" + adrs0);");
        sb.append(CR);
        sb.append("                        ");
        sb.append("}");
        sb.append(CR);
        sb.append("                    ");
        sb.append("}");
        sb.append(CR);
        sb.append("                    ");
        sb.append(id);
        if (hasChildFlag) {
            sb.append(JavaSourceGenerator.getterFullMethod(addrname_p));
            sb.append("[index]");
        }
        sb.append(setter_zipname0);
        sb.append("z0);");
        sb.append(CR);
        sb.append("                    ");
        sb.append("// " + this.rman.getValue("helper.comment.zipcode.tmpstore"));
        sb.append(CR);
        sb.append("                    ");
        sb.append("p.appMap.put(\"");
        sb.append(_name + "list");
        sb.append("\", z0);");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }
}

