/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.app.IListPHelper;
import jp.jasminesoft.jfc.appgen.generator.DataOwnerMethodGenerator;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_getControlTypeMap;
import jp.jasminesoft.jfc.gen.HelperGenerator_getGridColumns;
import jp.jasminesoft.jfc.gen.HelperGenerator_getParameterMap;
import jp.jasminesoft.jfc.gen.HelperGenerator_p2p;
import jp.jasminesoft.jfc.gen.HelperGenerator_p2s;
import jp.jasminesoft.jfc.gen.HelperGenerator_removeUnchooseValue;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_control;
import jp.jasminesoft.jfc.gen.HelperGenerator_setRelationToParent;
import jp.jasminesoft.jfc.gen.HelperGenerator_setValue;
import jp.jasminesoft.jfc.gen.HelperGenerator_toMailMessage;
import jp.jasminesoft.jfc.gen.HelperGenerator_zipCodeSync;
import jp.jasminesoft.jfc.gen.HelperListPGenerator_l2lp;
import jp.jasminesoft.jfc.gen.HelperTotalPGenerator_t2tp;
import jp.jasminesoft.jfc.gen.HelperUpdateListPGenerator_isChanged;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.model.JFCButtonfield;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class HelperPresentationGenerator
extends HelperGenerator {
    protected Logger logger = LogManager.getLogger((String)HelperPresentationGenerator.class.getName());
    private Model rmodel = null;
    private boolean isStoreModel = false;
    private boolean isListModel = false;
    private boolean isTotalModel = false;
    private boolean isUpdateList = false;

    public HelperPresentationGenerator(Project project, Model model) {
        super(project, model);
        IRNode node = model.getIdrefAsIRNode();
        if (node != null && node instanceof Model) {
            this.rmodel = (Model)node;
            if (this.rmodel.getType().equals("list")) {
                this.isListModel = true;
            } else if (this.rmodel.getType().equals("total")) {
                this.isTotalModel = true;
            } else {
                this.isStoreModel = true;
            }
        }
        this.isUpdateList = false;
        if (this.isListModel && model.getUpdatelist()) {
            this.isUpdateList = true;
        }
    }

    @Override
    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        if (HelperPresentationGenerator.usePresentationHelperInterface(this.model)) {
            sb.append("public class ");
            sb.append(this.getClassname());
            sb.append(" implements IPresentationHelper");
        } else {
            String extends_classname = null;
            Model smodel = AppSchemaUtil.getStoreModel(this.model);
            Model rmodel = (Model)this.model.getIdrefAsIRNode();
            boolean phelper = false;
            if (this.isListModel && !this.isUpdateList || this.isTotalModel) {
                extends_classname = "jp.jasminesoft.jfc.app.PresentationHelper";
            } else if (this.isUpdateList) {
                extends_classname = "jp.jasminesoft.jfc.app.PresentationUlpHelper";
                phelper = true;
            } else {
                extends_classname = "jp.jasminesoft.jfc.app.PresentationPHelper";
                phelper = true;
            }
            sb.append("public class ");
            sb.append(this.getClassname());
            sb.append(" extends ").append(extends_classname);
            String s_classname = null;
            Object p_classname = null;
            if (this.isUpdateList) {
                s_classname = AppSchemaUtil.getClassname(smodel);
                p_classname = AppSchemaUtil.getPackagename(this.model, this.project) + "Item";
            } else {
                s_classname = AppSchemaUtil.getClassname(rmodel);
                p_classname = AppSchemaUtil.getClassname(this.model);
            }
            if (phelper) {
                sb.append("<").append(s_classname);
                sb.append(", ").append((String)p_classname);
                sb.append(">");
            }
            if (this.isListModel && !this.isUpdateList) {
                String entity_classname = AppSchemaUtil.getClassname(smodel);
                sb.append(" implements IListPHelper<");
                sb.append(s_classname);
                sb.append(", ");
                sb.append((String)p_classname);
                sb.append(", ");
                sb.append(entity_classname);
                sb.append(">");
            }
        }
        sb.append(CR);
        return sb.toString();
    }

    @Override
    public String[] getDefaultImport() {
        String[] contents = super.getDefaultImport();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(contents));
        if (this.isListModel) {
            String[] classnames = new String[]{BaseController.class.getName(), JFCButtonfield.class.getName(), HttpServletRequest.class.getName(), CollectionUtils.class.getName()};
            list.addAll(Arrays.asList(classnames));
        }
        if (this.isListModel && !this.isUpdateList) {
            list.add(IListPHelper.class.getName());
        }
        if (this.isListModel && !this.isUpdateList || this.isTotalModel) {
            list.add("jp.jasminesoft.jfc.controller.DbShowListController");
        }
        if (this.isStoreModel || this.isUpdateList) {
            list.add(Autowired.class.getName());
        }
        if (list.size() != contents.length) {
            return list.toArray(new String[list.size()]);
        }
        return contents;
    }

    public static boolean usePresentationHelperInterface(Model model) {
        return false;
    }

    @Override
    protected String gHelperMethod0() {
        Model smodel;
        ForeignKey[] fkeys;
        IModelChoice[] imc;
        StringBuilder sb = new StringBuilder();
        HelperGenerator_s2p_control control = HelperGenerator_s2p_control.getInstance(this.model.getId(), this.project, this);
        LinkedHashSet<Modelitem> zipConvSet = new LinkedHashSet<Modelitem>();
        if ((this.isStoreModel || this.isUpdateList) && (imc = this.rmodel.getContent()) != null) {
            for (int i = 0; i < imc.length; ++i) {
                Modelitem mitem;
                boolean isZipcodeFlag;
                if (!(imc[i] instanceof Modelitem) || !(isZipcodeFlag = AppSchemaUtil.isZipCode(this.project, mitem = (Modelitem)imc[i], this.rmodel)) || !StringUtils.isNotBlank((CharSequence)mitem.getName())) continue;
                zipConvSet.add(mitem);
            }
        }
        HelperGeneratorBaseTask hgt = null;
        if (this.isStoreModel || this.isUpdateList) {
            hgt = new HelperGenerator_p2s(this.project, this.model);
            sb.append(hgt.process());
            hgt = new HelperGenerator_s2p(this.project, this.model);
            sb.append(hgt.process());
            hgt = new HelperGenerator_p2p(this.project, this.model);
            sb.append(hgt.process());
        }
        if (this.isStoreModel || this.isUpdateList) {
            for (Modelitem zipitem : zipConvSet) {
                hgt = new HelperGenerator_zipCodeSync(this.project, this.model, zipitem);
                sb.append(hgt.process());
            }
        } else if (this.isListModel) {
            hgt = new HelperListPGenerator_l2lp(this.project, this.model);
            sb.append(hgt.process());
        } else if (this.isTotalModel) {
            hgt = new HelperTotalPGenerator_t2tp(this.project, this.model);
            sb.append(hgt.process());
        }
        if (this.model.getMailMessage() && this.isStoreModel) {
            hgt = new HelperGenerator_toMailMessage(this.project, this.model);
            sb.append(hgt.process());
        }
        if (this.isUpdateList) {
            hgt = new HelperGenerator_setValue(this.project, this.model);
            sb.append(hgt.process());
            hgt = new HelperUpdateListPGenerator_isChanged(this.project, this.model);
            sb.append(hgt.process());
        }
        if (this.isStoreModel || this.isUpdateList) {
            hgt = new HelperGenerator_removeUnchooseValue(this.project, this.model);
            sb.append(hgt.process());
        }
        if (this.isUpdateList && (fkeys = AppSchemaUtil.getForeignKey(smodel = AppSchemaUtil.getStoreModel(this.model))) != null && fkeys.length > 0) {
            boolean isOutputSetRelationToParent = false;
            for (ForeignKey fkey : fkeys) {
                Model fmodel = (Model)fkey.getIdrefAsIRNode();
                if (isOutputSetRelationToParent) continue;
                hgt = new HelperGenerator_setRelationToParent(this.project, this.model, fmodel);
                sb.append(hgt.process());
                isOutputSetRelationToParent = true;
            }
        }
        hgt = new HelperGenerator_getControlTypeMap(this.project, this.model);
        sb.append(hgt.process("    "));
        sb.append(control.getMethodDeclaration());
        sb.append(new DataOwnerMethodGenerator(this.rmodel).generateContent());
        if (this.isListModel) {
            hgt = new HelperGenerator_getGridColumns(this.project, this.model);
            sb.append(hgt.process());
        }
        if (this.isStoreModel || this.isUpdateList) {
            hgt = new HelperGenerator_getParameterMap(this.project, this.model);
            sb.append(hgt.process());
        }
        return sb.toString();
    }
}

