/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HtmlTemplateManager
implements ISourceVariable {
    protected Logger logger = LogManager.getLogger((String)HtmlTemplateManager.class.getName());
    private Map contentsMap;
    private String template;
    private String DEFAULT_TEMPLATE = "<tr>" + CR + "$block{}" + CR + "</tr>" + CR;

    public HtmlTemplateManager() {
        this(null, null);
    }

    public HtmlTemplateManager(String name) {
        this(name, null);
    }

    public HtmlTemplateManager(String name, String enc) {
        this.init(name, enc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String tplfilename, String enc) {
        this.contentsMap = new HashMap();
        if (tplfilename == null) {
            this.template = this.DEFAULT_TEMPLATE;
            return;
        }
        if (enc == null) {
            enc = System.getProperty("file.encoding");
        }
        BufferedReader in = null;
        StringBuilder buf = new StringBuilder();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tplfilename), enc));
            String line = null;
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append(CR);
            }
        }
        catch (IOException e) {
            this.logger.warn("IOException has occured while reading file,", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.template = buf.toString();
        if (this.template.length() == 0) {
            this.template = this.DEFAULT_TEMPLATE;
        }
    }

    protected void setTemplate(String s) {
        this.template = s;
    }

    public void addContent(String s) {
        this.addContent("", s);
    }

    public void addContent(String blockname, String s) {
        StringBuilder sb = (StringBuilder)this.contentsMap.get(blockname);
        if (sb == null) {
            sb = new StringBuilder();
            this.contentsMap.put(blockname, sb);
        }
        sb.append(s);
    }

    public String getResult() {
        StringBuilder tplbuf = new StringBuilder(this.template);
        for (String _blockname : this.contentsMap.keySet()) {
            int start;
            StringBuilder sb = (StringBuilder)this.contentsMap.get(_blockname);
            String cnt = sb != null ? sb.toString() : "";
            String repkey = "$block{" + _blockname + "}";
            String base = tplbuf.toString();
            while ((start = base.indexOf(repkey)) >= 0) {
                tplbuf.replace(start, start + repkey.length(), cnt);
                base = tplbuf.toString();
            }
        }
        return tplbuf.toString();
    }

    public static void main(String[] args) {
        HtmlTemplateManager tplman = new HtmlTemplateManager();
        tplman.addContent("Hello, Template!");
        String s = tplman.getResult();
        System.out.println(s);
    }
}

