/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JAASPolicyGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGeneratorMap;
import jp.jasminesoft.jfc.gen.appschema.Acl;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Datalist;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Permission;
import jp.jasminesoft.jfc.gen.appschema.Principal;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JAASPolicyGenerator_Tomcat4
extends JAASPolicyGenerator {
    private static final Logger logger = LogManager.getLogger(JAASPolicyGenerator_Tomcat4.class);
    private ProcessBeanGeneratorMap pgenMap = null;

    public JAASPolicyGenerator_Tomcat4(Project project, Acl acl, ProcessBeanGeneratorMap pgenMap) {
        super(project, acl);
        this.pgenMap = pgenMap;
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "subjectpolicy";
    }

    @Override
    public String getCommentStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!--");
        sb.append(" Subject-Based Access Control Policy for the JFC Application");
        sb.append(" -->");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        String enc = JavaSourceGenerator.getEncoding(this.project);
        sb.append("<?xml version=\"1.0\" encoding=\"");
        sb.append(enc);
        sb.append("\" ?>");
        sb.append(CR);
        sb.append(this.getCommentStr());
        Principal[] principals = this.acl.getPrincipal();
        Map action_perm_map = this.createActionPermissionMap();
        principals = this.addAllUsersPrincipal(principals, action_perm_map);
        Arrays.sort(principals, new PrincipalComparator());
        sb.append("<subjectpolicy>");
        sb.append(CR);
        for (int i = 0; i < principals.length; ++i) {
            Principal principal = principals[i];
            String id = principal.getPrincipalId();
            Permission[] permissions = principal.getPermission();
            if (permissions == null || permissions.length <= 0) continue;
            sb.append("  ");
            sb.append("<grant>");
            sb.append(CR);
            sb.append("    ");
            sb.append("<principalinfo>");
            sb.append(CR);
            sb.append("      ");
            sb.append("<classname>");
            sb.append("jp.jasminesoft.jfc.JFCAppPrincipal");
            sb.append("</classname>");
            sb.append(CR);
            sb.append("      ");
            sb.append("<name>");
            sb.append(id);
            sb.append("</name>");
            sb.append(CR);
            sb.append("    ");
            sb.append("</principalinfo>");
            sb.append(CR);
            sb.append(CR);
            this.outputPermissioninfo(sb, permissions, action_perm_map);
            sb.append("  ");
            sb.append("</grant>");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append("</subjectpolicy>");
        sb.append(CR);
        return sb.toString();
    }

    protected Principal[] addAllUsersPrincipal(Principal[] principals, Map action_perm_map) {
        if (principals == null) {
            principals = new Principal[]{};
        }
        Principal target = null;
        for (Principal principal : principals) {
            if (!"jshparam_all_users".equals(principal.getId())) continue;
            target = principal;
            break;
        }
        if (target == null) {
            target = new Principal();
            target.setPrincipalId("jshparam_all_users");
            target.setNo(-1);
            Principal[] tmp_principals = new Principal[principals.length + 1];
            tmp_principals[0] = target;
            System.arraycopy(principals, 0, tmp_principals, 1, principals.length);
            principals = tmp_principals;
        }
        ArrayList<PermissionWrapper> col = new ArrayList<PermissionWrapper>();
        Permission pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, "juser", "show");
        if (pbean_perm != null) {
            col.add(new PermissionWrapper(pbean_perm));
        }
        this.addModelPermission(col, AppSchemaUtil.getModel(this.project, "juser"));
        TreeSet<PermissionWrapper> set = new TreeSet<PermissionWrapper>(col);
        for (Permission permission : target.getPermission()) {
            set.add(new PermissionWrapper(permission));
        }
        target.clearPermission();
        for (PermissionWrapper wrapper : set) {
            target.addPermission(wrapper.getPermission());
        }
        return principals;
    }

    private void outputPermissioninfo(StringBuilder sb, Permission[] permissions, Map action_perm_map) {
        ArrayList<PermissionWrapper> sep_permwrapper = new ArrayList<PermissionWrapper>();
        LinkedHashSet permwrappers = new LinkedHashSet();
        Arrays.sort(permissions, new PermissionComparator());
        for (int j = 0; j < permissions.length; ++j) {
            Permission permission = permissions[j];
            this.outputPermissioninfo(sb, permission);
            Permission[] sep_perms = this.separatePermission(permission);
            for (int i = 0; i < sep_perms.length; ++i) {
                Permission sep_perm = sep_perms[i];
                PermissionWrapper permwrapper = new PermissionWrapper(sep_perm);
                sep_permwrapper.add(permwrapper);
                Collection col = (Collection)action_perm_map.get(permwrapper);
                if (col == null) continue;
                permwrappers.addAll(col);
            }
        }
        permwrappers.removeAll(sep_permwrapper);
        if (permwrappers.size() == 0) {
            return;
        }
        sb.append(CR);
        for (PermissionWrapper permwrapper : permwrappers) {
            Permission permission = permwrapper.getPermission();
            this.outputPermissioninfo(sb, permission);
        }
    }

    private void outputPermissioninfo(StringBuilder sb, Permission permission) {
        String name = permission.getName();
        String action = permission.getAction();
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)action)) {
            return;
        }
        sb.append("    ");
        sb.append("<permissioninfo>");
        sb.append(CR);
        sb.append("      ");
        sb.append("<classname>");
        sb.append("jp.jasminesoft.jfc.JFCAppPermission");
        sb.append("</classname>");
        sb.append(CR);
        sb.append("      ");
        sb.append("<name>");
        sb.append(name);
        sb.append("</name>");
        sb.append(CR);
        sb.append("      ");
        sb.append("<actions>");
        sb.append(action);
        sb.append("</actions>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</permissioninfo>");
        sb.append(CR);
    }

    private Permission[] separatePermission(Permission perm) {
        String name = perm.getName();
        String actions = perm.getAction();
        ArrayList<Permission> list = new ArrayList<Permission>();
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            String action = st.nextToken();
            if (action.length() == 0) continue;
            Permission newperm = new Permission();
            newperm.setName(name);
            newperm.setAction(action);
            list.add(newperm);
        }
        return list.toArray(new Permission[list.size()]);
    }

    private Map createActionPermissionMap() {
        LinkedHashMap map = new LinkedHashMap();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return map;
        }
        HashSet<String> processedIdSet = new HashSet<String>();
        for (int i = 0; i < ipc.length; ++i) {
            if (!(ipc[i] instanceof Action)) continue;
            Action _action = (Action)ipc[i];
            this.addActionPermissionMap(map, (Action)ipc[i]);
            String sid = _action.getIdref();
            if (sid == null || JFCUtils.isSystemModel((String)sid) || processedIdSet.contains(sid)) continue;
            List<ProcessBeanGenerator> pgenList = this.pgenMap.getProcessBeanList(sid);
            for (ProcessBeanGenerator pgen : pgenList) {
                Action __action = pgen.getAction();
                Permission __permission = AppSchemaUtil.getProcessBeanPermission(__action, this.project, sid, pgen.getActionType());
                if (__permission == null) continue;
                for (Object key : map.keySet()) {
                    PermissionWrapper p_wp;
                    Collection col;
                    PermissionWrapper perm_wp;
                    if (!(key instanceof PermissionWrapper) || !(perm_wp = (PermissionWrapper)key).getPermission().getName().equals(__permission.getName()) || (col = (Collection)map.get(perm_wp)).contains(p_wp = new PermissionWrapper(__permission))) continue;
                    col.add(p_wp);
                }
            }
            processedIdSet.add(sid);
        }
        return map;
    }

    private void addActionPermissionMap(Map map, Action action) {
        Model smodel;
        String action_type;
        Collection<PermissionWrapper> col;
        Permission action_perm = AppSchemaUtil.getActionPermission(action);
        if (action_perm == null || StringUtils.isBlank((CharSequence)action_perm.getName()) && StringUtils.isBlank((CharSequence)action_perm.getAction())) {
            return;
        }
        PermissionWrapper action_perm_wp = new PermissionWrapper(action_perm);
        if (map.containsKey(action_perm_wp)) {
            col = (Collection)map.get(action_perm_wp);
        } else {
            col = new ArrayList();
            map.put(action_perm_wp, col);
        }
        Permission pbean_perm = AppSchemaUtil.getProcessBeanPermission(action);
        if (pbean_perm != null) {
            col.add(new PermissionWrapper(pbean_perm));
        }
        if ("update".equals(action_type = action.getType())) {
            pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, action.getIdref(), "show");
            if (pbean_perm != null) {
                col.add(new PermissionWrapper(pbean_perm));
            }
        } else if ("showList".equals(action_type)) {
            pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, action.getIdref(), "getCount");
            if (pbean_perm != null) {
                col.add(new PermissionWrapper(pbean_perm));
            }
            if ("jholiday".equals(action.getIdref()) && (pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, action.getIdref(), "showArray")) != null) {
                col.add(new PermissionWrapper(pbean_perm));
            }
        } else if ("uploadUpdate".equals(action_type)) {
            pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, action.getIdref(), "show");
            if (pbean_perm != null) {
                col.add(new PermissionWrapper(pbean_perm));
            }
            if ((pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, action.getIdref(), "insert")) != null) {
                col.add(new PermissionWrapper(pbean_perm));
            }
            if ((pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, action.getIdref(), "update")) != null) {
                col.add(new PermissionWrapper(pbean_perm));
            }
        }
        this.addModelPermission(col, action);
        this.addForeignKeyPermission(col, action);
        IRNode node = action.getIdrefAsIRNode();
        if (node != null && node instanceof Model && (smodel = (Model)node).getWorkflow()) {
            this.addWorkflowSettingPermission(col, action);
        }
    }

    private void addModelPermission(Collection col, Action action) {
        Conditionlist conditionlist;
        IRNode node = action.getIdrefAsIRNode();
        if (node != null && node instanceof Model) {
            Model smodel = (Model)node;
            this.addModelPermission(col, smodel);
        }
        if ((conditionlist = AppSchemaUtil.getConditionlist(action)) != null && (node = conditionlist.getIdrefAsIRNode()) != null && node instanceof Model) {
            Model cmodel = (Model)node;
            this.addModelPermission(col, cmodel);
        }
    }

    private void addModelPermission(Collection col, Model smodel) {
        IModelChoice[] imc = smodel.getContent();
        if (imc == null) {
            return;
        }
        for (int i = 0; i < imc.length; ++i) {
            Modelitem mitem;
            if (!(imc[i] instanceof Modelitem) || "model".equals((mitem = (Modelitem)imc[i]).getSrcgen())) continue;
            this.addStorerefPermission(col, mitem);
            this.addDualinputPermission(col, smodel, mitem);
        }
    }

    private void addStorerefPermission(Collection col, Modelitem mitem) {
        if (!mitem.getType().equals("storeref") || !mitem.getUseRelax()) {
            return;
        }
        if (mitem.getGeneration()) {
            return;
        }
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
        if (relation != null) {
            this.addStorerefPermission(col, relation.getIdref());
        } else {
            relation = AppSchemaUtil.getRelationTypeIsRef(mitem);
            this.addStorerefPermission(col, relation.getIdref());
            Modelitem ref_mitem = AppSchemaUtil.getModelitem(relation.getName(), (Model)relation.getIdrefAsIRNode());
            this.addStorerefPermission(col, ref_mitem);
        }
    }

    private void addStorerefPermission(Collection col, String refsmodelid) {
        Permission pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, refsmodelid, "show");
        if (pbean_perm != null) {
            col.add(new PermissionWrapper(pbean_perm));
        }
        if ((pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, refsmodelid, "showList")) != null) {
            col.add(new PermissionWrapper(pbean_perm));
        }
    }

    private void addDualinputPermission(Collection col, Model smodel, Modelitem mitem) {
        if (!"combo".equals(mitem.getDualinputmethod())) {
            return;
        }
        Permission pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, smodel.getId(), "showList");
        if (pbean_perm != null) {
            col.add(new PermissionWrapper(pbean_perm));
        }
    }

    private void addForeignKeyPermission(Collection col, Action action) {
        Datalist datalist = AppSchemaUtil.getDatalist(action);
        if (datalist == null) {
            return;
        }
        Dataitem[] dataitems = datalist.getDataitem();
        if (dataitems == null) {
            return;
        }
        for (int i = 0; i < dataitems.length; ++i) {
            Dataitem dataitem = dataitems[i];
            this.addForeignKeyPermission(col, action, dataitem);
            this.addReversePermission(col, action, dataitem);
        }
    }

    private void addForeignKeyPermission(Collection col, Action action, Dataitem dataitem) {
        String dataitem_type = dataitem.getType();
        if (!"array2list".equals(dataitem_type)) {
            return;
        }
        IRNode node = action.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            return;
        }
        Model smodel = (Model)node;
        node = dataitem.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{action.getId(), dataitem.getIdref()};
            logger.error(this.rman.getValue("value.null.relateddata", o));
            return;
        }
        Model ref_lpmodel = (Model)node;
        if ((node = ref_lpmodel.getIdrefAsIRNode()) == null || !(node instanceof Model)) {
            Object[] o = new Object[]{ref_lpmodel.getId(), ref_lpmodel.getIdref()};
            logger.error(this.rman.getValue("value.null.rmodel", o));
            return;
        }
        Model ref_lmodel = (Model)node;
        if ((node = ref_lmodel.getIdrefAsIRNode()) == null || !(node instanceof Model)) {
            Object[] o = new Object[]{ref_lmodel.getId(), ref_lmodel.getIdref()};
            logger.error(this.rman.getValue("value.null.rmodel", o));
            return;
        }
        Model ref_smodel = (Model)node;
        Permission pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, ref_smodel.getId(), "showArray");
        if (pbean_perm != null) {
            col.add(new PermissionWrapper(pbean_perm));
        }
    }

    private void addReversePermission(Collection col, Action action, Dataitem dataitem) {
        Permission pbean_perm;
        String dataitem_type = dataitem.getType();
        if (!"reverse".equals(dataitem_type)) {
            return;
        }
        String idref = dataitem.getIdref();
        if (idref.endsWith("_lp")) {
            idref = idref.substring(0, idref.length() - "_lp".length());
        }
        if ((pbean_perm = AppSchemaUtil.getProcessBeanPermission(null, this.project, idref, "showArray")) != null) {
            col.add(new PermissionWrapper(pbean_perm));
        }
    }

    private void addWorkflowSettingPermission(Collection col, Action action) {
        String action_type = action.getType();
        if ("insert".equals(action_type) || "show".equals(action_type)) {
            Permission permission = new Permission();
            permission.setName("jfcworkstate");
            permission.setAction("pbean_insert");
            col.add(new PermissionWrapper(permission));
            permission = new Permission();
            permission.setName("jfcworkstate");
            permission.setAction("insert");
            col.add(new PermissionWrapper(permission));
            this.addModelPermission(col, AppSchemaUtil.getModel(this.project, "jfcworkstate"));
            permission = new Permission();
            permission.setName("jfcworkflow_setting");
            permission.setAction("pbean_showArray");
            col.add(new PermissionWrapper(permission));
            this.addModelPermission(col, AppSchemaUtil.getModel(this.project, "jfcworkflow_setting"));
            permission = new Permission();
            permission.setName("jfcmailtemplate");
            permission.setAction("pbean_show");
            col.add(new PermissionWrapper(permission));
            this.addModelPermission(col, AppSchemaUtil.getModel(this.project, "jfcmailtemplate"));
        }
    }

    private static class PrincipalComparator
    implements Comparator<Principal> {
        private PrincipalComparator() {
        }

        @Override
        public int compare(Principal o1, Principal o2) {
            return o1.getId() - o2.getId();
        }
    }

    private static class PermissionWrapper
    implements Comparable {
        private Permission perm;

        PermissionWrapper(Permission perm) {
            this.perm = perm;
            if (perm.getName() == null || perm.getAction() == null) {
                logger.warn("illegal permission " + perm);
            }
        }

        public Permission getPermission() {
            return this.perm;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PermissionWrapper)) {
                return false;
            }
            Permission dst = ((PermissionWrapper)obj).getPermission();
            if (this.getPermission().getName() == null ? dst.getName() != null : !this.getPermission().getName().equals(dst.getName())) {
                return false;
            }
            return !(this.getPermission().getAction() == null ? dst.getAction() != null : !this.getPermission().getAction().equals(dst.getAction()));
        }

        public int hashCode() {
            int code = 0;
            if (this.getPermission().getName() != null) {
                code += this.getPermission().getName().hashCode();
            }
            if (this.getPermission().getAction() != null) {
                code += this.getPermission().getAction().hashCode();
            }
            return code;
        }

        public int compareTo(Object obj) {
            int i;
            if (obj == null || !(obj instanceof PermissionWrapper)) {
                return -1;
            }
            Permission dst = ((PermissionWrapper)obj).getPermission();
            if (this.getPermission() == null) {
                logger.info("getPermission() == null");
            }
            if (this.getPermission().getName() == null) {
                logger.info("getPermission().getName() == null");
            }
            if ((i = this.getPermission().getName().compareTo(dst.getName())) != 0) {
                return i;
            }
            return this.getPermission().getAction().compareTo(dst.getAction());
        }
    }

    private static class PermissionComparator
    implements Comparator<Permission> {
        private PermissionComparator() {
        }

        @Override
        public int compare(Permission o1, Permission o2) {
            int i = o1.getName().compareTo(o2.getName());
            if (i != 0) {
                return i;
            }
            return o1.getAction().compareTo(o2.getAction());
        }
    }
}

