/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.RelaxerWrapperBaseGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;

public class JFCDataAccessManagerGenerator
extends RelaxerWrapperBaseGenerator {
    public static final String Classname = "JFCDataAccessManagerImpl";
    private static LinkedHashSet<String> modelnamelist;
    private static LinkedHashSet<String> idlist;

    public static void addDataAccessManagerId(Model model, String appctxid) {
        if (model.getStatic()) {
            return;
        }
        if ("jfcmodel".equals(model.getId()) || "jfcmodel4dm".equals(model.getId())) {
            return;
        }
        if ("jprincipal".equals(model.getId())) {
            return;
        }
        ApplicationContextBean bean = new ApplicationContextBean(appctxid, "jp.jasminesoft.jfc.app.ModelDataAccessManager", null, true);
        bean.setModelId(model.getId());
        bean.addProperty("modelId", model.getId());
        bean.addProperty("entityHelper", new ApplicationContextBean.ReferenceElement(StoreModelUtils.entityHelperName((String)model.getId())));
        bean.addProperty("entityService", new ApplicationContextBean.ReferenceElement(StoreModelUtils.entityServiceName((String)model.getId())));
        String beanId = SpringApplicationContextContainer.addApplicationContextBean(bean);
        modelnamelist.add(model.getId());
        idlist.add(beanId);
    }

    public JFCDataAccessManagerGenerator(Project project) {
        super(project, null);
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir("app", null);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName("app", null);
    }

    @Override
    public String getClassname() {
        return Classname;
    }

    @Override
    public String getClassDeclarationSuffix() {
        return " extends JFCDataAccessManager";
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        importList.add("org.apache.logging.log4j.Logger");
        importList.add("org.apache.logging.log4j.LogManager");
        importList.add("jp.jasminesoft.jfc.*");
        importList.add("jp.jasminesoft.jfc.model.master.*");
        importList.add("java.util.*");
        return importList.toArray(new String[0]);
    }

    @Override
    protected String gVariableDefinition() {
        return "";
    }

    @Override
    protected String gConstructor() {
        return "";
    }

    @Override
    protected String gBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("private final static Logger logger = LogManager.getLogger(");
        sb.append(this.getClassname());
        sb.append(".class);");
        sb.append(CR);
        sb.append(CR);
        sb.append(this.gInstance());
        sb.append(this.gCreateAccessor());
        return sb.toString();
    }

    private String gCreateAccessor() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append("@Override").append(CR);
        sb.append("    ").append("public String[] getAppctxids() {").append(CR);
        sb.append("        ").append("return appctxids;").append(CR);
        sb.append("    ").append("}").append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gInstance() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("private String[] modelnames = {");
        sb.append(CR);
        Iterator it1 = modelnamelist.iterator();
        while (it1.hasNext()) {
            sb.append("        ");
            sb.append("\"");
            sb.append((String)it1.next());
            sb.append("\"");
            if (it1.hasNext()) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("private String[] appctxids = {");
        sb.append(CR);
        Iterator it = idlist.iterator();
        while (it.hasNext()) {
            sb.append("        ");
            sb.append("\"");
            sb.append((String)it.next());
            sb.append("\"");
            if (it.hasNext()) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("public JFCDataAccessManagerImpl() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (int i=0; i<modelnames.length; i++) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("appctxidsMap.put(modelnames[i], appctxids[i]);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    public static void reset() {
        modelnamelist = new LinkedHashSet();
        idlist = new LinkedHashSet();
    }

    static {
        JFCDataAccessManagerGenerator.reset();
    }
}

