/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_operation;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_parser;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.TargetitemGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Modelitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Page;
import jp.jasminesoft.jfc.gen.appschema.Permission;
import jp.jasminesoft.jfc.gen.appschema.Print;
import jp.jasminesoft.jfc.gen.appschema.Printlayout;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Sendmail;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JavaSourceGenerator
extends SourceGenerator {
    protected static Logger logger = LogManager.getLogger((String)JavaSourceGenerator.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    protected String[] defaultImportStatement = null;
    protected static final String[] wrapperClass = new String[]{"Integer", "Float", "Double", "Long", "Boolean", "Short", "Byte", "Character"};
    protected static String[] hibernate_query_set_method = new String[]{"setInteger", "setFloat", "setDouble", "setLong", "setBoolean", "setShort", "setByte", "setCharacter"};
    protected static String[] wagbyOperator = new String[]{"count", "sum", "avg", "max", "min", "first", "last", "slice", "join"};
    private static String invalidMark = null;

    public JavaSourceGenerator(Project project) {
        super(project);
    }

    @Override
    public boolean isDebug() {
        return false;
    }

    public abstract String getClassname();

    @Override
    public String getFileSuffix() {
        return ".java";
    }

    public abstract String getSubpackageName();

    public abstract String getSubpackageNameAsJavaRule();

    @Override
    public void process() {
        Object content = this.process0();
        String filename = this.getClassname();
        String subpackagename = this.getSubpackageName();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            content = this.getGeneratorClassName() + (String)content;
            this.createSource((String)content, filename, subpackagename);
        }
    }

    public abstract String process0();

    public String[] getDefaultImport() {
        return new String[0];
    }

    public String gGetPermissionMethod(Action action) {
        Permission permission = AppSchemaUtil.getActionPermission(action);
        return this.gGetPermissionMethod(permission);
    }

    public String gGetPermissionMethod(Permission permission) {
        StringBuilder sb = new StringBuilder();
        if (permission == null) {
            return "";
        }
        String name = permission.getName();
        String perm = permission.getAction();
        if (perm != null && perm.equals("JFCJOKER")) {
            name = null;
            perm = null;
        }
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.permission"), null, "Permission"));
        JavaSourceGenerator.putAnnotation(sb, "@Override", "    ");
        sb.append("    ");
        sb.append("public Permission getPermission() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return new JFCAppPermission(");
        if (name == null || name.length() == 0) {
            sb.append("JFCAppPermission.JOKER");
        } else {
            sb.append("\"" + name + "\"");
        }
        sb.append(", ");
        if (perm == null || perm.length() == 0) {
            sb.append("JFCAppPermission.JOKER");
        } else {
            sb.append("\"" + perm + "\"");
        }
        sb.append(");");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    public static String setterMethod(String s) {
        return SourceGeneratorUtil.setterMethod((String)s);
    }

    public static String setterFullMethod(String s) {
        return SourceGeneratorUtil.setterFullMethod((String)s);
    }

    public static String getterMethod(String s) {
        return SourceGeneratorUtil.getterMethod((String)s);
    }

    public static String getterFullMethod(String s) {
        return SourceGeneratorUtil.getterFullMethod((String)s);
    }

    public static String clearMethod(String s) {
        return SourceGeneratorUtil.clearMethod((String)s);
    }

    public static String getterFullMethodAsObject(String id, String s, String type) {
        return SourceGeneratorUtil.getterFullMethodAsObject((String)id, (String)s, (String)type);
    }

    public static String getterFullMethod(String id, String s) {
        return SourceGeneratorUtil.getterFullMethod((String)id, (String)s);
    }

    public static String adderMethod(String s) {
        return SourceGeneratorUtil.adderMethod((String)s);
    }

    public static String adderFullMethod(String s) {
        return SourceGeneratorUtil.adderFullMethod((String)s);
    }

    public static String checkFullMethod(String s) {
        return SourceGeneratorUtil.checkFullMethod((String)s);
    }

    public static String sizeMethod(String s) {
        return SourceGeneratorUtil.sizeMethod((String)s);
    }

    public static String sizeFullMethod(String s) {
        return SourceGeneratorUtil.sizeFullMethod((String)s);
    }

    public static String createMethod(String s, String method) {
        return SourceGeneratorUtil.createMethod((String)s, (String)method);
    }

    public static String createFullMethod(String s, String method, String[] params) {
        return SourceGeneratorUtil.createFullMethod((String)s, (String)method, (String[])params);
    }

    public static String removeMethod(String s) {
        return SourceGeneratorUtil.removeMethod((String)s);
    }

    public static String parseMethod(String name, String type) {
        return SourceGeneratorUtil.parseMethod((String)name, (String)type);
    }

    public static String convPackage2FilePath(String s) {
        return SourceGeneratorUtil.convPackage2FilePath((String)s);
    }

    public static boolean isBasicType(String str) {
        return SourceGeneratorUtil.isBasicType((String)str);
    }

    public static boolean isDateOrTimeType(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        String str0 = str.toLowerCase();
        boolean ret = false;
        if ("date".equalsIgnoreCase(str0) || "time".equalsIgnoreCase(str0) || "dateTime".equalsIgnoreCase(str)) {
            ret = true;
        }
        return ret;
    }

    public static String getDateOrTimeJavaType(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String str0 = str.toLowerCase();
        if ("date".equalsIgnoreCase(str0)) {
            return "Date";
        }
        if ("time".equalsIgnoreCase(str0)) {
            return "Time";
        }
        if ("dateTime".equalsIgnoreCase(str0)) {
            return "Timestamp";
        }
        return null;
    }

    public static boolean isStringType(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return "username".equalsIgnoreCase(str.toLowerCase()) || "zipcode".equalsIgnoreCase(str.toLowerCase()) || "string".equalsIgnoreCase(str.toLowerCase());
    }

    public static boolean isWrapperClass(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        boolean ret = false;
        for (int i = 0; i < wrapperClass.length; ++i) {
            if (!wrapperClass[i].equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static String b2wc(String type) {
        return SourceGeneratorUtil.b2wc((String)type);
    }

    public static String wc2b(String type) {
        return SourceGeneratorUtil.wc2b((String)type);
    }

    public static String getWc2b_method(String type) {
        return SourceGeneratorUtil.getWc2b_method((String)type);
    }

    public static String getB2wc_method(String type) {
        return SourceGeneratorUtil.getB2wc_method((String)type);
    }

    public static String getValidValue(String type) {
        return SourceGeneratorUtil.getProperValidValue((String)type, (String[])SourceGeneratorUtil.btypeValidValue);
    }

    public static String getNanValue(String type) {
        return SourceGeneratorUtil.getProperValidValue((String)type, (String[])SourceGeneratorUtil.byteNaNValidValue);
    }

    public static String getMinimumValue(String type) {
        return SourceGeneratorUtil.getMinimumValue((String)type);
    }

    public static String getJavaClassType(String type) {
        return SourceGeneratorUtil.getJavaClassType((String)type);
    }

    public static String getProperWrapperType(String type) {
        String type0 = JavaSourceGenerator.getProperType(type);
        if (JavaSourceGenerator.isBasicType(type0.toLowerCase())) {
            type0 = JavaSourceGenerator.b2wc(type0);
        }
        return type0;
    }

    public static String getProperType(String type) {
        String type0 = null;
        if (type == null || type.length() == 0) {
            type = "String";
        } else {
            type0 = JavaSourceGenerator.isBasicType(type) ? type : ("date".equals(type) || "Date".equals(type) ? "java.sql.Date" : ("time".equals(type) || "Time".equals(type) ? "java.sql.Time" : ("dateTime".equals(type) || "DateTime".equals(type) ? "java.sql.Timestamp" : (JavaSourceGenerator.isStringType(type) ? "String" : ("masterref".equals(type) ? "int" : type)))));
        }
        return type0;
    }

    public static String gProperSQLCondition(String src) {
        String ret;
        String string = ret = src != null ? src.toUpperCase() : "=";
        if ("GE".equals(ret)) {
            ret = ">=";
        } else if ("LE".equals(ret)) {
            ret = "<=";
        } else if ("GT".equals(ret)) {
            ret = ">";
        } else if ("LT".equals(ret)) {
            ret = "<";
        } else if ("EQ".equals(ret)) {
            ret = "=";
        } else if ("NEQ".equals(ret) || "NE".equals(ret)) {
            ret = "!=";
        }
        return ret;
    }

    public static String gProperJavaGrammarCondition(String src) {
        String ret;
        String string = ret = src != null ? src.toUpperCase() : "==";
        if ("GE".equals(ret)) {
            ret = ">=";
        } else if ("LE".equals(ret)) {
            ret = "<=";
        } else if ("GT".equals(ret)) {
            ret = ">";
        } else if ("LT".equals(ret)) {
            ret = "<";
        } else if ("EQ".equals(ret)) {
            ret = "==";
        } else if ("NEQ".equals(ret) || "NE".equals(ret)) {
            ret = "!=";
        }
        return ret;
    }

    public static void setImportStatement(Model model, Project project, List<String> importList) {
        if (model == null || importList == null) {
            return;
        }
        Object packagename = AppSchemaUtil.getPackagename(model, project);
        if (((String)packagename).length() > 0) {
            packagename = (String)packagename + "*";
        }
        if (!importList.contains(packagename)) {
            importList.add((String)packagename);
        }
        if (!"presentation".equals(model.getType())) {
            JavaSourceGenerator.setImportStatement_relation(model, project, importList);
        }
        if (!"presentation".equals(model.getType())) {
            JavaSourceGenerator.setImportStatement_foreignKey(model, project, importList);
        }
        JavaSourceGenerator.setImportStatement_itemgroup(model, project, importList);
        IRNode node = model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            return;
        }
        Model rmodel = (Model)node;
        if ("store".equals(rmodel.getType()) && "presentation".equals(model.getType())) {
            Object spackagename = AppSchemaUtil.getPackagename(rmodel, project);
            if (((String)spackagename).length() > 0) {
                spackagename = (String)spackagename + "*";
            }
            if (!importList.contains(spackagename)) {
                importList.add((String)spackagename);
            }
        } else if (!"store".equals(rmodel.getType()) || !"store".equals(model.getType())) {
            JavaSourceGenerator.setImportStatement(rmodel, project, importList);
        }
        if ("jfcworkflow_setting_c".equals(model.getId())) {
            int ptr = -1;
            for (int i = 0; i < importList.size(); ++i) {
                String s = importList.get(i);
                if (!s.endsWith(".jfcparticipant_setting.*")) continue;
                ptr = i;
                break;
            }
            if (ptr >= 0) {
                importList.remove(ptr);
            }
        }
    }

    public static void setImportStatement_relation(Model model, Project project, List<String> importList) {
        if (model == null || importList == null) {
            return;
        }
        IModelChoice[] imc = model.getContent();
        if (imc == null) {
            return;
        }
        for (int i = 0; i < imc.length; ++i) {
            Modelitem item;
            if (!(imc[i] instanceof Modelitem) || "masterref".equals((item = (Modelitem)imc[i]).getType())) continue;
            Relation rel = AppSchemaUtil.getRelationTypeExceptRef(item);
            if (rel != null) {
                JavaSourceGenerator.addImportList(project, importList, rel);
            }
            if ((rel = AppSchemaUtil.getRelationTypeIsRef(item)) == null) continue;
            JavaSourceGenerator.addImportList(project, importList, rel);
            Modelitem ritem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(project, model.getId(), item);
            if (!"storeref".equals(ritem.getType())) continue;
            JavaSourceGenerator.addImportList(project, importList, AppSchemaUtil.getRelationTypeExceptRef(ritem));
        }
    }

    public static void addImportList(Project project, List<String> importList, Relation rel) {
        IRNode node00 = rel.getIdrefAsIRNode();
        if (node00 != null && node00 instanceof Model) {
            Model rmodel00 = (Model)node00;
            JavaSourceGenerator.addImportList(project, importList, rmodel00);
        }
    }

    public static void addImportList(Project project, List<String> importList, Model tmodel) {
        Object _rpackagename = AppSchemaUtil.getPackagename(tmodel, project);
        if (_rpackagename != null && ((String)_rpackagename).length() > 0 && !importList.contains(_rpackagename = (String)_rpackagename + "*")) {
            importList.add((String)_rpackagename);
        }
    }

    public static void setImportStatement_foreignKey(Model model, Project project, List<String> importList) {
        if (model == null || importList == null) {
            return;
        }
        IModelChoice[] imc = model.getContent();
        if (imc == null) {
            return;
        }
        HashSet<String> processedModelIdSet = new HashSet<String>();
        for (int i = 0; i < imc.length; ++i) {
            ForeignKey fkey;
            Model fmodel;
            if (!(imc[i] instanceof ForeignKey) || processedModelIdSet.contains((fmodel = (Model)(fkey = (ForeignKey)imc[i]).getIdrefAsIRNode()).getId())) continue;
            JavaSourceGenerator.addImportList(project, importList, fmodel);
            processedModelIdSet.add(fmodel.getId());
        }
    }

    public static void setImportStatement_itemgroup(Model model, Project project, List<String> importList) {
        if (model == null || importList == null) {
            return;
        }
        IModelChoice[] imc = model.getContent();
        if (imc == null) {
            return;
        }
        for (int i = 0; i < imc.length; ++i) {
            Model gmodel;
            Object gpkgname;
            Modelitemgroup itemg;
            IRNode node;
            if (!(imc[i] instanceof Modelitemgroup) || (node = (itemg = (Modelitemgroup)imc[i]).getIdrefAsIRNode()) == null || !(node instanceof Model) || (gpkgname = AppSchemaUtil.getPackagename(gmodel = (Model)node, project)) == null || ((String)gpkgname).length() <= 0 || importList.contains(gpkgname = (String)gpkgname + "*")) continue;
            importList.add((String)gpkgname);
        }
    }

    public void setImportStatement_dataitem(Action action, List<String> importList) {
        Model[] rmodels = AppSchemaUtil.getDataitemAsModel(action);
        if (rmodels != null) {
            for (int i = 0; i < rmodels.length; ++i) {
                Model rmodel = rmodels[i];
                this.setImportStatement_model(rmodel, importList);
            }
        }
    }

    public void setImportStatement_model(Model model, List<String> importList) {
        String s = null;
        String _pkgname = AppSchemaUtil.getPackagename(model, this.project);
        if (_pkgname != null && _pkgname.length() > 0 && !importList.contains(s = _pkgname + "*")) {
            importList.add(s);
        }
    }

    public void setImportStatement_dataitem_with_refmodel(Action action, List<String> importList) {
        Model[] rmodels = AppSchemaUtil.getDataitemAsModel(action);
        if (rmodels != null) {
            for (int i = 0; i < rmodels.length; ++i) {
                Model rmodel = rmodels[i];
                this.setImportStatement_model(rmodel, importList);
                IRNode node = rmodel.getIdrefAsIRNode();
                if (node == null || !(node instanceof Model)) continue;
                Model rmodel0 = (Model)node;
                this.setImportStatement_model(rmodel0, importList);
            }
        }
    }

    public void setImportStatement_condition(Action action, List<String> importList) {
        Model[] rmodels = this.getConditionlistModel(action);
        if (rmodels != null) {
            for (int i = 0; i < rmodels.length; ++i) {
                if (rmodels[i] == null) continue;
                this.setImportStatement_model(rmodels[i], importList);
            }
        }
    }

    private Model[] getConditionlistModel(Action action) {
        ArrayList<Model> rmodelList = new ArrayList<Model>();
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, action);
        Model cpmodel = AppSchemaUtil.getConditionPModel(this.project, action, true);
        if (cmodel != null) {
            rmodelList.add(cmodel);
        }
        if (cpmodel != null) {
            rmodelList.add(cpmodel);
        }
        if (rmodelList.size() == 0) {
            rmodelList.add((Model)action.getIdrefAsIRNode());
        }
        return rmodelList.toArray(new Model[0]);
    }

    public void setImportStatement_sendmail(Action action, List<String> importList) {
        Sendmail[] sendmails = AppSchemaUtil.getSendmailAll(action);
        if (sendmails == null) {
            return;
        }
        String s = null;
        String _pkgname = null;
        Model model = null;
        for (int i = 0; i < sendmails.length; ++i) {
            Sendmail sendmail = sendmails[i];
            IRNode node = sendmail.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                model = (Model)node;
            }
            if (model == null || (_pkgname = AppSchemaUtil.getPackagename(model, this.project)) == null || _pkgname.length() <= 0 || importList.contains(s = _pkgname + "*")) continue;
            importList.add(s);
        }
    }

    public void setImportStatement_initdb_package(Action action, List<String> importList) {
        String s = this.project.getPackage() + ".initdb.*";
        importList.add(s);
    }

    public void setImportStatement_jasperreports(Action action, List<String> importList) {
        ArrayList<Print> prints = new ArrayList<Print>();
        Print[] printAssociateWithAction = AppSchemaUtil.getPrint(action);
        if (printAssociateWithAction != null && printAssociateWithAction.length > 0) {
            prints.addAll(Arrays.asList(printAssociateWithAction));
        }
        if ("showList".equals(action.getType()) && AppSchemaUtil.hasCommand(this.project, action, "PrintAll")) {
            Action showAction;
            Model smodel = null;
            IRNode node = action.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                smodel = (Model)node;
            }
            if (smodel != null && (showAction = AppSchemaUtil.getActionByModelIdAndType(this.project, smodel.getId(), "show")) != null && (printAssociateWithAction = AppSchemaUtil.getPrint(showAction)) != null && printAssociateWithAction.length > 0) {
                prints.addAll(Arrays.asList(printAssociateWithAction));
            }
        }
        if (prints.size() == 0) {
            return;
        }
        for (Print print : prints) {
            Printlayout printlayout;
            IRNode node = print.getIdrefAsIRNode();
            if (node == null || !(node instanceof Printlayout) || !"jasperreports".equals((printlayout = (Printlayout)node).getUselibrary())) continue;
            importList.add("net.sf.jasperreports.engine.*");
            importList.add("net.sf.jasperreports.engine.data.JRXmlDataSource");
            importList.add("net.sf.jasperreports.engine.query.JRXPathQueryExecuterFactory");
            importList.add("net.sf.jasperreports.engine.util.JRLoader");
            importList.add("net.sf.jasperreports.engine.export.*");
            break;
        }
    }

    public String getPackage() {
        if (this.project.getPackage() == null) {
            return null;
        }
        return this.project.getPackage() + "." + this.getSubpackageNameAsJavaRule();
    }

    public static String createProperId(Action action) {
        if (action == null) {
            return null;
        }
        String id = action.getId();
        String type = action.getType();
        if (type.endsWith("-master")) {
            if (type.startsWith("showList")) {
                id = StringUtil.replace((String)id, (String)"showList", (String)"Master");
            } else {
                return null;
            }
        }
        return id;
    }

    public static String createActionClassname(String id, Action action, Project project) {
        String packagename = project.getPackage();
        Object modelname = "";
        IRNode node = action.getIdrefAsIRNode();
        if (node != null && node instanceof Model) {
            Model model = (Model)node;
            Model smodel = AppSchemaUtil.getStoreModel(model);
            if (smodel == null) {
                smodel = model;
            }
            modelname = smodel != null ? smodel.getId() : "";
            modelname = (String)modelname + ".";
        }
        StringBuilder classname = new StringBuilder(packagename);
        classname.append(".struts.");
        classname.append((String)modelname);
        String _classtype = action.getStrutsclasstype();
        if (_classtype != null && _classtype.length() > 0) {
            if (_classtype.indexOf(".") > 0) {
                classname = new StringBuilder(_classtype);
            } else {
                classname.append(_classtype);
            }
        } else {
            if (action.getType().endsWith("-master")) {
                classname.append(JavaSourceGenerator.capFirst(id));
            } else {
                classname.append(JavaSourceGenerator.capFirst(action.getId()));
            }
            classname.append("Action");
        }
        return classname.toString();
    }

    public static String createControllerClassname(String id, Action action, Project project) {
        String packagename = project.getPackage();
        Object modelname = "";
        IRNode node = action.getIdrefAsIRNode();
        if (node != null && node instanceof Model) {
            Model model = (Model)node;
            Model smodel = AppSchemaUtil.getStoreModel(model);
            if (smodel == null) {
                smodel = model;
            }
            modelname = smodel != null ? smodel.getId() : "";
            modelname = (String)modelname + ".";
        }
        StringBuilder classname = new StringBuilder(packagename);
        classname.append(".controller.");
        classname.append((String)modelname);
        String _classtype = action.getStrutsclasstype();
        if (_classtype != null && _classtype.length() > 0) {
            if (_classtype.indexOf(".") > 0) {
                classname = new StringBuilder(_classtype);
            } else {
                classname.append(_classtype);
            }
        } else {
            if (action.getType().endsWith("-master")) {
                classname.append(JavaSourceGenerator.capFirst(id));
            } else {
                classname.append(JavaSourceGenerator.capFirst(action.getId()));
            }
            classname.append("Controller");
        }
        return classname.toString();
    }

    public static String createPkeyname(Map<String, Map<String, String>> compositeKeyMap) {
        if (compositeKeyMap == null || compositeKeyMap.size() == 0) {
            return "id";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = compositeKeyMap.keySet().iterator();
        int countOfModel = 0;
        while (it.hasNext()) {
            String modelId;
            Map<String, String> _map;
            Set<String> nameSet;
            if (countOfModel > 0) {
                sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
            }
            if ((nameSet = (_map = compositeKeyMap.get(modelId = it.next())).keySet()) != null && nameSet.size() > 0) {
                String[] pkeys = nameSet.toArray(new String[0]);
                for (int i = 0; i < pkeys.length - 1; ++i) {
                    sb.append(pkeys[i]);
                    sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
                }
                sb.append(pkeys[pkeys.length - 1]);
            }
            ++countOfModel;
        }
        return sb.toString();
    }

    public static boolean isGraphicData(String s) {
        boolean ret = false;
        if (s != null && (s.endsWith(".gif") || s.endsWith(".png") || s.endsWith(".jpg") || s.endsWith(".jpeg"))) {
            ret = true;
        }
        return ret;
    }

    public static String getEncoding(Project project) {
        String enc = project.getEncoding();
        if (enc == null || enc.length() == 0) {
            enc = System.getProperty("file.encoding");
        }
        return enc;
    }

    public static String getWebEncoding(Project project) {
        String enc = project.getWebencoding();
        if (enc == null || enc.length() == 0) {
            enc = project.getEncoding();
        }
        if (enc == null || enc.length() == 0) {
            enc = "UTF-8";
        }
        return enc;
    }

    public String gLoggerReady(String classname) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("/");
        sb.append("** " + rman.getValue("comment.logger") + " *");
        sb.append("/");
        sb.append(CR);
        sb.append("    ");
        sb.append("private final static Logger logger = ");
        sb.append("LogManager.getLogger(");
        sb.append(classname);
        sb.append(".class.getName());");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    public static String getSimpleDateFormatDefinition(Project project, String type) {
        return JavaSourceGenerator.getSimpleDateFormatDefinition(project, JavaSourceGenerator.getSimpleDateFormatStandardVariableName(type), type);
    }

    public static String getSimpleDateFormatDefinition(Project project, String var, String type) {
        Environment environment = project.getEnvironment();
        if (var == null) {
            var = JavaSourceGenerator.getSimpleDateFormatStandardVariableName(type);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleDateFormat ");
        sb.append(var);
        sb.append(" = ");
        sb.append("new SimpleDateFormat(\"");
        sb.append(DbTypeManager.getSimpleDateFormatString(environment, type));
        sb.append("\"");
        sb.append(", JFCUtils.createLocale(p.locale)");
        sb.append(");");
        return sb.toString();
    }

    public static String getSimpleDateFormatStandardVariableName(String type) {
        String var = null;
        var = "date".equals(type) ? "fmt_d" : ("time".equals(type) ? "fmt_t" : ("dateTime".equals(type) ? "fmt_dt" : ""));
        return var;
    }

    public static String getProperSQLDateTimeConv(String type) {
        String ret = null;
        ret = "date".equals(type) ? "DateTimeUtil.getSQLDate" : ("time".equals(type) ? "DateTimeUtil.getSQLTime" : ("dateTime".equals(type) ? "DateTimeUtil.getSQLTimestamp" : ""));
        return ret;
    }

    public static String getProperStr2DateTimeConvMethodname(String type) {
        String ret = null;
        ret = "date".equals(type) ? "DateTimeUtil.getDate" : ("time".equals(type) ? "DateTimeUtil.getTimeWithFormat" : ("dateTime".equals(type) ? "DateTimeUtil.getDateTimeWithFormat" : ""));
        return ret;
    }

    public static String getInvalidMark(Project project) {
        if (invalidMark == null) {
            CompatibilityManager man = CompatibilityManager.getInstance();
            if (man.isExistResourceKey("jp.jasminesoft.jfc.gen.JavaSourceGenerator.invalidMark")) {
                String s;
                invalidMark = s = man.getStringValue("jp.jasminesoft.jfc.gen.JavaSourceGenerator.invalidMark");
            } else {
                Environment env = project.getEnvironment();
                invalidMark = env.getInvalidMark();
            }
        }
        return invalidMark;
    }

    public static int getVersionAsInt(Project project) {
        String version = project.getVersion();
        int ret = 0;
        try {
            ret = (int)Double.parseDouble(version);
        }
        catch (NumberFormatException e) {
            ret = -1;
        }
        return ret;
    }

    public static String getHibernateQuerySetMethod(String type) {
        if (type == null || type.length() == 0) {
            return "";
        }
        if (type.endsWith("[]")) {
            type = type.substring(0, type.length() - 2);
        }
        for (int i = 0; i < SourceGeneratorUtil.basicType.length; ++i) {
            if (!SourceGeneratorUtil.basicType[i].equals(type)) continue;
            return hibernate_query_set_method[i];
        }
        if (type.equals("date")) {
            return "setDate";
        }
        if (type.equals("time")) {
            return "setTime";
        }
        if (type.equals("dateTime")) {
            return "setTimestamp";
        }
        return "setString";
    }

    public static void putAnnotation(StringBuilder sb, String anot, String basetab) {
        sb.append(basetab);
        sb.append(anot);
        sb.append(CR);
    }

    protected Set<String> gSetTargetItem(Model model) {
        Model lmodel = this.getTargetModel4gSetTargetItem(model);
        TargetitemGenerator tgen = new TargetitemGenerator();
        return tgen.createListTargetitems(this.project, model, lmodel);
    }

    protected Model getTargetModel4gSetTargetItem(Model model) {
        return AppSchemaUtil.getModel(this.project, model.getId(), "list");
    }

    protected void gSetTargetItem4pbean(Set<String> targetItemSet, StringBuilder sb, String basetab) {
        this.gCreateTargetItemSet(targetItemSet, sb, basetab);
        sb.append(basetab);
        sb.append("pbean.setParameter(");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("ProcessBean.TargetItemSetParamName, _targetItemSet);");
        sb.append(CR);
    }

    protected void gCreateTargetItemSet(Set<String> targetItemSet, StringBuilder sb, String basetab) {
        this.gCreateTargetItemSet(targetItemSet, sb, basetab, "_targetItem", "_targetItemSet", false);
    }

    protected void gCreateTargetItemSet(Set<String> targetItemSet, StringBuilder sb, String basetab, String array_varname, String set_varname, boolean is_copy) {
        sb.append(basetab);
        sb.append("// " + rman.getValue("struts.comment.settargetitem.pbean"));
        sb.append(CR);
        sb.append(basetab);
        sb.append("final String[] " + array_varname + " = {");
        sb.append(CR);
        Iterator<String> it = targetItemSet.iterator();
        while (it.hasNext()) {
            sb.append(basetab + "    ");
            sb.append("\"");
            if (!is_copy) {
                sb.append(AppSchemaUtil.getChildPart(it.next()));
            } else {
                sb.append(it.next());
            }
            sb.append("\"");
            if (it.hasNext()) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append(basetab);
        sb.append("};");
        sb.append(CR);
        sb.append(basetab);
        sb.append("HashSet<String> " + set_varname + " = new HashSet<String>(Arrays.asList(" + array_varname + "));");
        sb.append(CR);
    }

    public static String getServiceObjectName(Action action) {
        String id = action.getIdref();
        if (id == null) {
            id = "";
        }
        return id + "Service";
    }

    public static String getServiceClassName(Action action) {
        String id = action.getIdref();
        if (id == null) {
            id = "";
        }
        return JavaSourceGenerator.capFirst(id) + "Service";
    }

    public static String getGetterServiceClassName(Action action) {
        String id = action.getIdref();
        if (id == null) {
            id = "";
        }
        return "get" + JavaSourceGenerator.capFirst(id) + "Service()";
    }

    public static int getCacheSize(Action action) {
        int cachesize = -1;
        return cachesize;
    }

    protected static int getMaxOption(Page page) {
        int maxsize = 10;
        if (page == null) {
            return maxsize;
        }
        String _option = page.getOption();
        if (_option != null && _option.length() > 0) {
            StringTokenizer st = new StringTokenizer(_option, ", ");
            while (st.hasMoreTokens()) {
                int t = StringUtil.intValue((String)st.nextToken());
                maxsize = Math.max(t, maxsize);
            }
        } else {
            maxsize = page.getSize();
        }
        return maxsize;
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "// genclassname:" + this.getClass().getName() + CR;
        }
        return "";
    }

    protected static String getSQLObjectMethodname(String type) {
        if ("time".equalsIgnoreCase(type)) {
            return "DateTimeUtil.getSQLTime";
        }
        if ("dateTime".equalsIgnoreCase(type)) {
            return "DateTimeUtil.getSQLTimestamp";
        }
        if ("date".equalsIgnoreCase(type)) {
            return "DateTimeUtil.getSQLDate";
        }
        return null;
    }

    public static String getFirstModelitemNameInExpression(String expr, Model model) {
        String[] ret = JavaSourceGenerator.getModelitemNameInExpression(expr, model);
        if (ret == null || ret.length == 0) {
            return "";
        }
        return ret[0];
    }

    public static String[] getModelitemNameInExpression(String expr, Model model) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder var = null;
        boolean varMode = false;
        int length = expr.length();
        for (int i = 0; i < length; ++i) {
            char c = expr.charAt(i);
            if (c == '$') {
                if (i + 1 >= length || expr.charAt(i + 1) != '{') continue;
                varMode = true;
                ++i;
                continue;
            }
            if (c == '}' && varMode && var != null) {
                Modelitem mitem;
                String itemname = var.toString();
                String idsuffix = AppSchemaUtil.getIdSuffixPartInExpr(itemname);
                if (idsuffix != null && itemname.endsWith(idsuffix)) {
                    itemname = itemname.substring(0, itemname.length() - idsuffix.length());
                } else if (itemname.endsWith("#content")) {
                    itemname = itemname.substring(0, itemname.length() - "#content".length());
                } else if (itemname.endsWith("#array")) {
                    itemname = itemname.substring(0, itemname.length() - "#array".length());
                }
                if (JavaSourceGenerator.isIncludeWagbyOperator(itemname) || (mitem = AppSchemaUtil.getModelitem(itemname, model)) == null) continue;
                list.add(itemname);
                varMode = false;
                var = null;
                continue;
            }
            if (!varMode) continue;
            if (var == null) {
                var = new StringBuilder();
            }
            var.append(c);
        }
        return list.toArray(new String[0]);
    }

    public static String parsePlaceHolder(String cnt, Model model) throws IllegalArgumentException {
        return JavaSourceGenerator.parsePlaceHolder(cnt, model, null, null);
    }

    public static String parsePlaceHolder(String cnt, Model model, Project project) throws IllegalArgumentException {
        return JavaSourceGenerator.parsePlaceHolder(cnt, model, null, project);
    }

    public static String parsePlaceHolder(String cnt, Model model, String pi) throws IllegalArgumentException {
        return JavaSourceGenerator.parsePlaceHolder(cnt, model, pi, null);
    }

    public static String parsePlaceHolder(String cnt, Model model, String pi, Project project) throws IllegalArgumentException {
        if (cnt == null || cnt.length() == 0) {
            return "";
        }
        int length = cnt.length();
        if (StringUtils.isBlank((CharSequence)pi)) {
            pi = "";
        } else if (!((String)pi).startsWith("PI:") && !((String)pi).startsWith("_")) {
            pi = "PI:prefix=" + (String)pi;
        }
        ArrayList<String> lines = new ArrayList<String>();
        boolean ignore = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = cnt.charAt(i);
            buf.append(c);
            if (c == '\"' || c == '\'') {
                ignore = !ignore;
                continue;
            }
            if (c != ';' || i <= 0 || cnt.charAt(i - 1) == 'p' || ignore) continue;
            String _s = buf.toString();
            lines.add(_s.substring(0, _s.length() - 1));
            buf = new StringBuilder();
        }
        if (buf.toString().length() > 0) {
            lines.add(buf.toString());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            if (i > 0) {
                sb.append(";");
            }
            String line = JavaSourceGenerator.convertFunction((String)lines.get(i));
            sb.append(JavaSourceGenerator.parsePlaceHolder0(line, model, (String)pi, project));
        }
        return sb.toString();
    }

    private static String convertFunction(String s) {
        String ret = s;
        String[][] functions = new String[][]{{"SKIPUPDATETIME()", "JFCUtils.skipUpdatetime(p)"}};
        for (int i = 0; i < functions.length; ++i) {
            if (!s.equals(functions[i][0])) continue;
            ret = functions[i][1];
            break;
        }
        return ret;
    }

    private static String parsePlaceHolder0(String cnt, Model model, String pi, Project project) throws IllegalArgumentException {
        if (cnt == null || cnt.length() == 0) {
            return "";
        }
        if (cnt.indexOf("ISEMPTY") >= 0) {
            cnt = HelperGenerator_calc_operation.preprocess_conv_isempty(cnt, model);
        }
        int length = cnt.length();
        String setterExp = null;
        int separatePoint = JavaSourceGenerator.separateExpressionByEqaul(cnt);
        if (separatePoint >= 0) {
            setterExp = cnt.substring(0, separatePoint).trim();
            cnt = cnt.substring(separatePoint + 1).trim();
            length = cnt.length();
        }
        StringBuilder exp = new StringBuilder();
        StringBuilder var = null;
        boolean varMode = false;
        Model pmodel = project != null ? AppSchemaUtil.getPresentationModel(project, model) : null;
        Model targetmodel = model;
        for (int i = 0; i < length; ++i) {
            char c = cnt.charAt(i);
            if (c == '$') {
                if (i + 1 >= length) continue;
                if (cnt.charAt(i + 1) == '{') {
                    varMode = true;
                    ++i;
                    continue;
                }
                exp.append(c);
                continue;
            }
            if (c == '}' && varMode && var != null) {
                Relation rel;
                String reltype;
                Modelitem mitem;
                String itemname = var.toString();
                if (itemname.startsWith("p;")) {
                    itemname = itemname.substring("p;".length());
                    if (pmodel != null) {
                        targetmodel = pmodel;
                    }
                } else {
                    targetmodel = model;
                }
                boolean mode_content = false;
                String idsuffix = AppSchemaUtil.getIdSuffixPartInExpr(itemname);
                if (idsuffix != null && itemname.endsWith(idsuffix)) {
                    itemname = itemname.substring(0, itemname.length() - idsuffix.length());
                } else if (itemname.endsWith("#content")) {
                    itemname = itemname.substring(0, itemname.length() - "#content".length());
                    mode_content = true;
                } else if (itemname.endsWith("#array")) {
                    itemname = itemname.substring(0, itemname.length() - "#array".length());
                }
                if (JavaSourceGenerator.isIncludeWagbyOperator(itemname)) {
                    logger.error(rman.getValue("error.parse.cnt.wagbyoperator", cnt));
                }
                if ((mitem = AppSchemaUtil.getModelitem(itemname, model)) == null && (mitem = AppSchemaUtil.withRefmodelPrimaryKeyName(itemname, model, project)) == null && model != null) {
                    Object[] o = new Object[]{cnt, itemname, model.getId()};
                    logger.error(rman.getValue("error.parse.cnt.mitem.notfound", o));
                }
                if (targetmodel == null) {
                    return "";
                }
                String m_id = targetmodel.getId();
                String pm_id = pmodel != null ? pmodel.getId() : "";
                String m_name = itemname;
                if (AppSchemaUtil.hasChildPart(itemname)) {
                    pm_id = m_id = AppSchemaUtil.getParentPart(itemname);
                    m_name = AppSchemaUtil.getChildPart(itemname);
                }
                String string = reltype = (rel = AppSchemaUtil.getRelation(mitem)) != null ? AppSchemaUtil.getRelationType(rel, project) : null;
                if (mode_content) {
                    if (reltype != null) {
                        String pm_id2 = pm_id;
                        if (pi.startsWith("PI:mid=")) {
                            String _pm_id2 = pi.substring("PI:mid=".length());
                            if (AppSchemaUtil.hasChildPart(itemname) && _pm_id2.startsWith(m_id)) {
                                pm_id2 = _pm_id2;
                            }
                        }
                        if ("check".equals(reltype)) {
                            String ppackagename = AppSchemaUtil.getPackagename(pmodel, project);
                            Modelitem pmitem = AppSchemaUtil.getModelitem(itemname, pmodel);
                            String pmitemclassname = AppSchemaUtil.getModelitemClassname(pmitem);
                            exp.append("PresentationPHelper.setMasterCodeMultipleAsString(");
                            if (pi.startsWith("PI:mid=")) {
                                exp.append("values");
                            } else {
                                exp.append(pm_id + JavaSourceGenerator.getterFullMethod(m_name));
                            }
                            exp.append(" ,").append(ppackagename).append(pmitemclassname).append(".class");
                            exp.append(")");
                        } else {
                            exp.append("((").append(pm_id2 + JavaSourceGenerator.getterFullMethod(m_name));
                            exp.append(" != null && ");
                            exp.append("PresentationPHelper.setMasterRadioCodeSingle(");
                            exp.append(pm_id2 + JavaSourceGenerator.getterFullMethod(m_name));
                            exp.append(") != null");
                            exp.append(") ? ");
                            exp.append("PresentationPHelper.setMasterRadioCodeSingle(");
                            exp.append(pm_id2 + JavaSourceGenerator.getterFullMethod(m_name));
                            exp.append(")");
                            exp.append(".getContent()");
                            exp.append(" : \"\")");
                        }
                    } else {
                        exp.append("s");
                    }
                } else if (StringUtils.isBlank((CharSequence)pi)) {
                    exp.append(m_id + JavaSourceGenerator.getterFullMethod(m_name));
                } else if (pi.startsWith("PI:prefix=")) {
                    String prefix = pi.substring("PI:prefix=".length());
                    exp.append(prefix + m_id + JavaSourceGenerator.getterFullMethod(m_name));
                } else if (pi.startsWith("PI:mid=")) {
                    if (AppSchemaUtil.hasChildPart(itemname)) {
                        m_id = pi.substring("PI:mid=".length());
                        exp.append("__" + m_id + JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(itemname)));
                    } else {
                        exp.append(m_id + JavaSourceGenerator.getterFullMethod(m_name));
                    }
                } else if (pi.startsWith("PI:var=")) {
                    String varname = pi.substring("PI:var=".length());
                    exp.append(varname);
                } else {
                    exp.append(pi + m_id + JavaSourceGenerator.getterFullMethod(m_name));
                }
                varMode = false;
                var = null;
                continue;
            }
            if (varMode) {
                if (var == null) {
                    var = new StringBuilder();
                }
                var.append(c);
                continue;
            }
            exp.append(c);
        }
        if (setterExp != null) {
            if (!setterExp.startsWith("${") || !setterExp.endsWith("}")) {
                throw new IllegalArgumentException(setterExp);
            }
            setterExp = setterExp.substring(2, setterExp.length() - 1);
            String idsuffix = AppSchemaUtil.getIdSuffixPartInExpr(setterExp);
            if (idsuffix != null && setterExp.endsWith(idsuffix)) {
                setterExp = setterExp.substring(0, setterExp.length() - idsuffix.length());
            } else if (setterExp.endsWith("#content")) {
                setterExp = setterExp.substring(0, setterExp.length() - "#content".length());
            } else if (setterExp.endsWith("#array")) {
                setterExp = setterExp.substring(0, setterExp.length() - "#array".length());
            }
            Modelitem mitem = AppSchemaUtil.getModelitem(setterExp, model);
            if (mitem == null) {
                throw new IllegalArgumentException(setterExp);
            }
            if (AppSchemaUtil.hasChildPart(mitem.getName())) {
                // empty if block
            }
            exp.insert(0, pi + model.getId() + "." + JavaSourceGenerator.setterMethod(setterExp) + "(");
            exp.append(")");
        }
        return exp.toString();
    }

    public static int separateExpressionByEqaul(String cnt) {
        int separatePoint = -1;
        int length = cnt.length();
        boolean ignore = false;
        for (int i = 0; i < length; ++i) {
            char c = cnt.charAt(i);
            if (c == '\"' || c == '\'') {
                ignore = !ignore;
                continue;
            }
            if (c != '=' || ignore || cnt.charAt(i - 1) == '!' || cnt.charAt(i - 1) == '<' || cnt.charAt(i - 1) == '>' || cnt.charAt(i - 1) == '=' || i + 1 < length && (cnt.charAt(i + 1) == '=' || cnt.charAt(i + 1) == '<' || cnt.charAt(i + 1) == '>')) continue;
            separatePoint = i;
            break;
        }
        return separatePoint;
    }

    public static boolean isIncludeWagbyOperator(String itemname) {
        boolean ret = false;
        if (itemname == null) {
            return ret;
        }
        itemname = StringUtil.removeSpace((String)itemname);
        for (int i = 0; i < wagbyOperator.length; ++i) {
            String op = wagbyOperator[i] + "(";
            if (!itemname.startsWith(op)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static final String parseNowExpression(String cnt, String kubun) {
        if (cnt == null || cnt.length() == 0) {
            return "";
        }
        int length = cnt.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = cnt.charAt(i);
            if (c == 'n') {
                char cn;
                char c3;
                char c2 = i + 1 < length ? cnt.charAt(i + 1) : (char)'\u0000';
                char c4 = c3 = i + 2 < length ? cnt.charAt(i + 2) : (char)'\u0000';
                if (c2 != 'o' || c3 != 'w') continue;
                i += 3;
                StringBuilder token = new StringBuilder("now");
                while (i < length && (cn = cnt.charAt(i)) != ')') {
                    token.append(cn);
                    ++i;
                }
                sb.append(JavaSourceGenerator.convertNowExpression(token.toString(), kubun));
                --i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final String convertNowExpression(String cnt, String kubun) {
        StringBuilder sb = new StringBuilder();
        if ("time".equals(kubun)) {
            sb.append("DateTimeUtil.getTimeWithNowFormat(");
            sb.append("DateTimeUtil.getSQLTime((java.sql.Timestamp)p.request.getAttribute(\"V_NOW\"))");
            sb.append(", \"");
            sb.append(cnt);
            sb.append("\")");
        } else {
            sb.append("DateTimeUtil.getDateWithNowFormat(");
            sb.append("(java.sql.Date)p.request.getAttribute(\"V_TODAY\")");
            sb.append(", \"");
            sb.append(cnt);
            sb.append("\")");
        }
        return sb.toString();
    }

    public static final String VARNAME(String name) {
        return "__" + name;
    }

    public static String getProperFormActionName(String formaction) {
        if (formaction == null) {
            return "";
        }
        if (!((String)formaction).endsWith(".do")) {
            formaction = (String)formaction + ".do";
        }
        return formaction;
    }

    public static String replaceSpecialVariable(String expr) {
        return JavaSourceGenerator.replaceSpecialVariable(expr, null);
    }

    public static String replaceSpecialVariable(String expr, String itemname) {
        if (StringUtils.isBlank((CharSequence)expr)) {
            return "";
        }
        expr = HelperGenerator_calc_parser.convertFunctionNames(expr, itemname);
        return expr;
    }

    public static String getContentInParentheses(String s) {
        if (s == null) {
            return null;
        }
        int beginIndex = s.indexOf("(");
        int endIndex = s.lastIndexOf(")");
        if (beginIndex >= 0 && endIndex > 0) {
            return s.substring(beginIndex + 1, endIndex).trim();
        }
        return null;
    }

    public static String getContentInPlaceHolder(String s) {
        if (s == null) {
            return null;
        }
        int beginIndex = s.indexOf("${");
        int endIndex = s.lastIndexOf("}");
        if (beginIndex >= 0 && endIndex > 0) {
            return s.substring(beginIndex + 2, endIndex).trim();
        }
        return null;
    }

    public static boolean isValidValue(String type, String value) {
        boolean ret;
        block56: {
            if (type == null) {
                return false;
            }
            if (value == null) {
                value = "";
            }
            ret = true;
            if ("int".equals(type)) {
                try {
                    if (value.indexOf(",") > 0) {
                        String[] tokens;
                        for (String s : tokens = value.split(",")) {
                            if (JavaSourceGenerator.isValidExpression(s)) {
                                return true;
                            }
                            Integer.parseInt(s);
                        }
                        break block56;
                    }
                    if (JavaSourceGenerator.isValidExpression(value)) {
                        return true;
                    }
                    Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    ret = false;
                }
            } else if ("double".equals(type)) {
                try {
                    if (value.indexOf(",") > 0) {
                        String[] tokens;
                        for (String s : tokens = value.split(",")) {
                            if (JavaSourceGenerator.isValidExpression(s)) {
                                return true;
                            }
                            Double.parseDouble(s);
                        }
                        break block56;
                    }
                    if (JavaSourceGenerator.isValidExpression(value)) {
                        return true;
                    }
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    ret = false;
                }
            } else if ("long".equals(type)) {
                try {
                    if (value.indexOf(",") > 0) {
                        String[] tokens;
                        for (String s : tokens = value.split(",")) {
                            if (JavaSourceGenerator.isValidExpression(s)) {
                                return true;
                            }
                            Long.parseLong(s);
                        }
                        break block56;
                    }
                    if (JavaSourceGenerator.isValidExpression(value)) {
                        return true;
                    }
                    Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    ret = false;
                }
            } else if ("float".equals(type)) {
                try {
                    if (value.indexOf(",") > 0) {
                        String[] tokens;
                        for (String s : tokens = value.split(",")) {
                            if (JavaSourceGenerator.isValidExpression(s)) {
                                return true;
                            }
                            Float.parseFloat(s);
                        }
                        break block56;
                    }
                    if (JavaSourceGenerator.isValidExpression(value)) {
                        return true;
                    }
                    Float.parseFloat(value);
                }
                catch (NumberFormatException e) {
                    ret = false;
                }
            } else if ("byte".equals(type)) {
                try {
                    if (value.indexOf(",") > 0) {
                        String[] tokens;
                        for (String s : tokens = value.split(",")) {
                            if (JavaSourceGenerator.isValidExpression(s)) {
                                return true;
                            }
                            Byte.parseByte(s);
                        }
                        break block56;
                    }
                    if (JavaSourceGenerator.isValidExpression(value)) {
                        return true;
                    }
                    Byte.parseByte(value);
                }
                catch (NumberFormatException e) {
                    ret = false;
                }
            } else if ("short".equals(type)) {
                try {
                    if (value.indexOf(",") > 0) {
                        String[] tokens;
                        for (String s : tokens = value.split(",")) {
                            if (JavaSourceGenerator.isValidExpression(s)) {
                                return true;
                            }
                            Short.parseShort(s);
                        }
                        break block56;
                    }
                    if (JavaSourceGenerator.isValidExpression(value)) {
                        return true;
                    }
                    Short.parseShort(value);
                }
                catch (NumberFormatException e) {
                    ret = false;
                }
            } else if ("boolean".equals(type)) {
                try {
                    if (value.indexOf(",") > 0) {
                        String[] tokens;
                        for (String s : tokens = value.split(",")) {
                            Boolean.parseBoolean(s);
                        }
                    } else {
                        Boolean.parseBoolean(value);
                    }
                }
                catch (NumberFormatException e) {
                    ret = false;
                }
            }
        }
        return ret;
    }

    private static boolean isValidExpression(String s) {
        return "PI()".equals(s) || "RAND()".equals(s);
    }

    public static String normalizeModelitemName(String o_name) {
        if (o_name == null) {
            return null;
        }
        if (o_name.endsWith("_jshfilename")) {
            o_name = o_name.substring(0, o_name.length() - "_jshfilename".length());
        }
        return o_name;
    }

    public static boolean isUseExpression(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        int p1 = s.indexOf("${");
        int p2 = s.indexOf("}");
        if (p1 >= 0 && p2 >= 0 && p2 > p1) {
            return true;
        }
        boolean quoteSingle = false;
        boolean quoteDouble = false;
        boolean illegalFlag = false;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\'' && !quoteDouble) {
                quoteSingle = !quoteSingle;
                continue;
            }
            if (c == '\"' && !quoteSingle) {
                quoteDouble = !quoteDouble;
                continue;
            }
            if (quoteSingle || quoteDouble || c == '\t' || c == '\n' || c == '\r' || ' ' <= c && c <= '~') continue;
            illegalFlag = true;
            break;
        }
        if (illegalFlag) {
            return false;
        }
        while (s.indexOf("(") >= 0) {
            int c;
            int c1 = s.indexOf("(");
            int c2 = s.indexOf(")");
            int n = c = c1 > 0 ? (int)s.charAt(c1 - 1) : -1;
            if (c1 > 0 && c2 > 0 && c2 > c1 && c >= 65 && c <= 90) {
                return true;
            }
            if (c2 > 0) {
                s = s.substring(c2 + 1);
                continue;
            }
            if (c1 <= 0) break;
            s = s.substring(c1 + 1);
        }
        return false;
    }

    public static String getValidLabelPart(String label) {
        String tmp;
        int ptr = label.indexOf("[");
        if (ptr > 0 && label.trim().endsWith("]") && (tmp = label.substring(ptr + 1)).indexOf("@list") >= 0) {
            label = label.substring(0, ptr);
        }
        return label;
    }

    public static String getMinusOne(String type) {
        return SourceGeneratorUtil.getMinusOne((String)type);
    }
}

