/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JobGeneratorUtil;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.IJobChoice;
import jp.jasminesoft.jfc.gen.appschema.Job;
import jp.jasminesoft.jfc.gen.appschema.Jobparam;
import jp.jasminesoft.jfc.gen.appschema.Jobrule;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class JobBodyGenerator
extends JavaSourceGenerator
implements IGeneratorFactory {
    public static final String SUB_PACKAGE_NAME = "app";
    protected String templateDir = "template/javasrc/job/";
    private Map<String, String> replaceSpecialExpressionMap;
    private Job job;
    private Model smodel;

    public JobBodyGenerator(Project project) {
        this(null, project);
    }

    public JobBodyGenerator(Job job, Project project) {
        super(project);
        this.job = job;
        this.smodel = AppSchemaUtil.getStoreModel(AppSchemaUtil.getModel(project, job.getModel()));
        this.replaceSpecialExpressionMap = new HashMap<String, String>();
        this.replaceSpecialExpressionMap.put("MAIL.MESSAGEID", "MailMessageManager.getMessageIdAsString(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.INREPLYTO", "MailMessageManager.getInReplyToAsString(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.SUBJECT", "MailMessageManager.getSubjectAsString(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.BODY", "MailMessageManager.getBodyAsString(_m, _multi)");
        this.replaceSpecialExpressionMap.put("MAIL.BODY_RICH", "replaceBR(MailMessageManager.getBodyAsString(_m, _multi))");
        this.replaceSpecialExpressionMap.put("MAIL.FROM", "MailMessageManager.getFromAsStringArray(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.TO", "MailMessageManager.getToAsStringArray(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.CC", "MailMessageManager.getCcAsStringArray(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.BCC", "MailMessageManager.getBccAsStringArray(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.RECEIVEDATE", "MailMessageManager.getReceivedSQLDate(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.RECEIVETIME", "MailMessageManager.getReceivedSQLTime(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.RECEIVEDATETIME", "MailMessageManager.getReceivedSQLTimestamp(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.SENTDATE", "MailMessageManager.getSentSQLDate(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.SENTTIME", "MailMessageManager.getSentSQLTime(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.SENTDATETIME", "MailMessageManager.getSentSQLTimestamp(_m)");
        this.replaceSpecialExpressionMap.put("MAIL.ATTACHMENT", "MailMessageManager.getAttachment(_multi)");
        this.replaceSpecialExpressionMap.put("MAIL.ATTACHMENTJSHFILENAME", "MailMessageManager.getAttachmentJshfilename(_multi, _files)");
        this.replaceSpecialExpressionMap.put("TWITTER.CREATED_AT", "TwitterUtil.getCreatedAt(tweet)");
        this.replaceSpecialExpressionMap.put("TWITTER.FROM_USER", "tweet.getFromUser()");
        this.replaceSpecialExpressionMap.put("TWITTER.FROM_USER_ID", "tweet.getFromUserId()");
        this.replaceSpecialExpressionMap.put("TWITTER.GEO_LOCATION", "TwitterUtil.getGeoLocationAsString(tweet)");
        this.replaceSpecialExpressionMap.put("TWITTER.ID", "tweet.getId()");
        this.replaceSpecialExpressionMap.put("TWITTER.ISO_LANGUAGE_CODE", "tweet.getIsoLanguageCode()");
        this.replaceSpecialExpressionMap.put("TWITTER.PROFILE_IMAGE_URL", "tweet.getProfileImageUrl()");
        this.replaceSpecialExpressionMap.put("TWITTER.SOURCE", "tweet.getSource()");
        this.replaceSpecialExpressionMap.put("TWITTER.TEXT", "tweet.getText()");
        this.replaceSpecialExpressionMap.put("TWITTER.TO_USER", "tweet.getToUser()");
        this.replaceSpecialExpressionMap.put("TWITTER.TO_USER_ID", "tweet.getToUserId()");
    }

    @Override
    public String getClassname() {
        return JobGeneratorUtil.getProcessorName(this.job.getName());
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, this.smodel);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, this.smodel);
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    protected String getTemplateFilePath() {
        return this.templateDir + this.getTemplateFile();
    }

    protected String getTemplateFile() {
        return JavaSourceGenerator.capFirst(this.job.getType()) + ".vm";
    }

    protected Job getJob() {
        return this.job;
    }

    protected Model getStoreModel() {
        return this.smodel;
    }

    @Override
    public String process0() {
        Set jobSet;
        String _expression;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String mtab = "        ";
        HashMap<String, LinkedHashSet<Jobrule>> jobTypeMap = new HashMap<String, LinkedHashSet<Jobrule>>();
        ArrayList<String> initList = new ArrayList<String>();
        ArrayList<String> successList = new ArrayList<String>();
        ArrayList<String> failList = new ArrayList<String>();
        IJobChoice[] ijcs = this.job.getContent();
        if (ijcs != null) {
            for (IJobChoice ijc : ijcs) {
                if (ijc instanceof Jobrule) {
                    Jobrule jobrule = (Jobrule)ijc;
                    String _type = jobrule.getType();
                    LinkedHashSet<Jobrule> jobSet2 = (LinkedHashSet<Jobrule>)jobTypeMap.get(_type);
                    if (jobSet2 == null) {
                        jobSet2 = new LinkedHashSet<Jobrule>();
                        jobTypeMap.put(_type, jobSet2);
                    }
                    jobSet2.add(jobrule);
                    continue;
                }
                if (!(ijc instanceof Jobparam)) continue;
                Jobparam jobparam = (Jobparam)ijc;
                this.createVariableMapByJobparam(map, jobparam);
            }
        }
        if ((_expression = this.createFireExpression(jobSet = (Set)jobTypeMap.get("fire"), mtab)) != null) {
            map.put("fireExpression", _expression);
        }
        jobSet = (Set)jobTypeMap.get("init");
        this.createSuccessOrFailExpression(jobSet, initList, mtab + "            ");
        jobSet = (Set)jobTypeMap.get("success");
        this.createSuccessOrFailExpression(jobSet, successList, mtab);
        jobSet = (Set)jobTypeMap.get("fail");
        this.createSuccessOrFailExpression(jobSet, failList, mtab);
        this.outputExpression("initExpression", initList, map);
        this.outputExpression("successExpression", successList, map);
        this.outputExpression("failExpression", failList, map);
        this.createVariableMap(map);
        return VelocityUtils.mergeContent((String)this.getTemplateFilePath(), map);
    }

    private void createSuccessOrFailExpression(Set<Jobrule> jobSet, List<String> list, String mtab) {
        if (jobSet == null || jobSet.size() == 0) {
            return;
        }
        LinkedHashMap<String, LinkedHashSet<Jobrule>> njobMap = new LinkedHashMap<String, LinkedHashSet<Jobrule>>();
        for (Jobrule jobrule : jobSet) {
            LinkedHashSet<Jobrule> cjobSet;
            String var;
            String _content = jobrule.getContent();
            int begin_var = _content.indexOf("${");
            int end_var = _content.indexOf("}");
            String pname = "";
            if (begin_var >= 0 && end_var > 0 && end_var > begin_var && AppSchemaUtil.hasChildPart(var = _content.substring(begin_var + 2, end_var))) {
                pname = AppSchemaUtil.getParentPart(var);
            }
            if ((cjobSet = (LinkedHashSet<Jobrule>)njobMap.get(pname)) == null) {
                cjobSet = new LinkedHashSet<Jobrule>();
                njobMap.put(pname, cjobSet);
            }
            cjobSet.add(jobrule);
        }
        for (String groupName : njobMap.keySet()) {
            Set cjobSet = (Set)njobMap.get(groupName);
            if ("".equals(groupName)) {
                this.createSuccessOrFailExpression_single(cjobSet, list, mtab);
                continue;
            }
            this.createSuccessOrFailExpression_cont(groupName, cjobSet, list, mtab);
        }
    }

    private void createSuccessOrFailExpression_cont(String groupName, Set<Jobrule> cjobSet, List<String> list, String mtab) {
        if (cjobSet == null || cjobSet.size() == 0) {
            return;
        }
        String varname_filename = null;
        String varname_jshfilename = null;
        for (Jobrule jobrule : cjobSet) {
            int lptr;
            String _content = jobrule.getContent();
            int eq_ptr = JavaSourceGenerator.separateExpressionByEqaul(_content);
            if (eq_ptr < 0) continue;
            String _itemname = _content.substring(0, eq_ptr);
            int begin_var = _itemname.indexOf("${");
            int end_var = _itemname.indexOf("}");
            String var = _itemname.substring(begin_var + 2, end_var);
            String _filter = null;
            String _specialExpression = _content.substring(eq_ptr + 1);
            if (_specialExpression.startsWith("MAIL.") && (lptr = _specialExpression.lastIndexOf("-")) > 0) {
                _filter = _specialExpression.substring(lptr + 1);
                _specialExpression = _specialExpression.substring(0, lptr);
            }
            if ("MAIL.ATTACHMENT".equals(_specialExpression)) {
                Object code = mtab;
                code = _filter != null ? (String)code + "String[][] _filenames = MailMessageManager.getAllAttachmentfilename(_multi, filterManager.getFilter(\"" + _filter + "\"), _files);" : (String)code + "String[][] _filenames = MailMessageManager.getAllAttachmentfilename(_multi, _files);";
                list.add((String)code);
                varname_filename = AppSchemaUtil.getChildPart(var);
                continue;
            }
            if (!"MAIL.ATTACHMENTJSHFILENAME".equals(_specialExpression)) continue;
            varname_jshfilename = AppSchemaUtil.getChildPart(var);
        }
        Model model = this.getStoreModel();
        Modelitem conitem = AppSchemaUtil.getModelitem(groupName, model);
        String spackagename = AppSchemaUtil.getPackagename(model, this.project);
        String conclassname = AppSchemaUtil.getModelitemClassname(conitem);
        StringBuilder sb = new StringBuilder(mtab);
        sb.append("List<");
        sb.append(spackagename);
        sb.append(conclassname);
        sb.append(">");
        sb.append(" ");
        sb.append("_" + groupName + "List");
        sb.append(" =");
        list.add(sb.toString());
        sb = new StringBuilder(mtab);
        sb.append("    ");
        sb.append("new ArrayList<");
        sb.append(spackagename);
        sb.append(conclassname);
        sb.append(">();");
        list.add(sb.toString());
        list.add(mtab + "if (_filenames != null && _filenames.length > 0) {");
        list.add(mtab + "    for (int j=0; j<_filenames.length; j++) {");
        list.add(mtab + "        String _filename = _filenames[j][0];");
        list.add(mtab + "        String _jshfilename = _filenames[j][1];");
        sb = new StringBuilder(mtab);
        sb.append("        ");
        sb.append(spackagename);
        sb.append(conclassname);
        sb.append(" ");
        sb.append("_" + groupName);
        sb.append(" =");
        list.add(sb.toString());
        sb = new StringBuilder(mtab);
        sb.append("            ");
        sb.append("new ");
        sb.append(spackagename);
        sb.append(conclassname);
        sb.append("();");
        list.add(sb.toString());
        sb = new StringBuilder(mtab);
        sb.append("        ");
        sb.append("_" + groupName);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(varname_filename));
        sb.append("(");
        sb.append("_filename");
        sb.append(");");
        list.add(sb.toString());
        sb = new StringBuilder(mtab);
        sb.append("        ");
        sb.append("_" + groupName);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(varname_jshfilename));
        sb.append("(");
        sb.append("_jshfilename");
        sb.append(");");
        list.add(sb.toString());
        sb = new StringBuilder(mtab);
        sb.append("        ");
        sb.append("_" + groupName + "List.add(");
        sb.append("_" + groupName);
        sb.append(");");
        list.add(sb.toString());
        list.add(mtab + "    }");
        sb = new StringBuilder(mtab);
        sb.append("    ");
        sb.append("if (_" + groupName + "List.size() > 0) {");
        list.add(sb.toString());
        sb = new StringBuilder(mtab);
        sb.append("        ");
        sb.append("_" + model.getId());
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(groupName));
        sb.append("(");
        sb.append("_" + groupName + "List.toArray(new ");
        sb.append(spackagename);
        sb.append(conclassname);
        sb.append("[0]));");
        list.add(sb.toString());
        sb = new StringBuilder(mtab);
        sb.append("    ");
        sb.append("}");
        list.add(sb.toString());
        list.add(mtab + "}");
    }

    private void createSuccessOrFailExpression_single(Set<Jobrule> cjobSet, List<String> list, String mtab) {
        if (cjobSet == null || cjobSet.size() == 0) {
            return;
        }
        for (Jobrule jobrule : cjobSet) {
            Object _content = jobrule.getContent();
            try {
                int lptr;
                int eq_ptr = JavaSourceGenerator.separateExpressionByEqaul((String)_content);
                if (eq_ptr < 0) continue;
                String _filter = null;
                String _specialExpression = ((String)_content).substring(eq_ptr + 1);
                if (_specialExpression.startsWith("MAIL.") && (lptr = _specialExpression.lastIndexOf("-")) > 0) {
                    _filter = _specialExpression.substring(lptr + 1);
                }
                if (_filter != null) {
                    _content = ((String)_content).substring(0, eq_ptr) + ((String)_content).substring(eq_ptr).replace("-" + _filter, "");
                }
                _content = JavaSourceGenerator.replaceSpecialVariable((String)_content);
                Object _expression = JavaSourceGenerator.parsePlaceHolder((String)_content, this.smodel, "_");
                if (StringUtils.isNotBlank((CharSequence)(_expression = StringUtil.replace((String)_expression, this.replaceSpecialExpressionMap)))) {
                    if (_filter != null) {
                        String tmp;
                        int beginp = ((String)_expression).indexOf("(");
                        String string = tmp = beginp > 0 ? ((String)_expression).substring(beginp + 1) : null;
                        if (tmp != null) {
                            if (tmp.indexOf("_multi") > 0) {
                                tmp = tmp.replace("_multi", "_multi, filterManager.getFilter(\"" + _filter + "\")");
                            } else if (tmp.indexOf("_m") > 0) {
                                tmp = tmp.replace("_m", "_m, filterManager.getFilter(\"" + _filter + "\")");
                            }
                            _expression = ((String)_expression).substring(0, beginp + 1) + tmp;
                        }
                    }
                    _expression = mtab + (String)_expression + ";";
                } else {
                    _expression = "";
                }
                list.add((String)_expression);
            }
            catch (IllegalArgumentException e) {
                if (this.smodel == null) continue;
                Object[] o = new Object[]{this.smodel.getId(), e.getMessage(), _content};
                String itemname = e.getMessage();
                if (JavaSourceGenerator.isIncludeWagbyOperator(itemname)) {
                    logger.warn(rman.getValue("placeholder.itemname.wagbyoperator", o));
                    continue;
                }
                logger.warn(rman.getValue("placeholder.itemname.notfound", o));
            }
        }
    }

    private String createFireExpression(Set<Jobrule> jobSet, String mtab) {
        if (jobSet == null || jobSet.size() == 0) {
            return null;
        }
        Iterator<Jobrule> it = jobSet.iterator();
        Jobrule jobrule = it.next();
        String _content = jobrule.getContent();
        _content = JavaSourceGenerator.replaceSpecialVariable(_content);
        Object _expression = JavaSourceGenerator.parsePlaceHolder(_content, this.smodel, "_");
        _expression = StringUtils.isNotBlank((CharSequence)(_expression = StringUtil.replace((String)_expression, this.replaceSpecialExpressionMap))) ? mtab + "return (" + (String)_expression + ");" : mtab + "return true;";
        return _expression;
    }

    private void outputExpression(String type, List<String> expressionList, Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        int size = expressionList.size();
        for (int i = 0; i < size; ++i) {
            String s = expressionList.get(i);
            sb.append(s);
            if (size <= 1 || i >= size - 1) continue;
            sb.append(StringUtil.CR);
        }
        map.put(type, sb.toString());
    }

    protected abstract void createVariableMap(Map<String, Object> var1);

    protected void createVariableMapByJobparam(Map<String, Object> map, Jobparam jobparam) {
    }
}

