/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceWriter;
import jp.jasminesoft.jfc.gen.appschema.Acl;
import jp.jasminesoft.jfc.gen.appschema.Category;
import jp.jasminesoft.jfc.gen.appschema.Principal;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JprincipalGenerator
implements ISourceVariable {
    protected Project project;
    protected ResourceManager rman;
    protected static Logger logger = LogManager.getLogger((String)JprincipalGenerator.class.getName());
    private JFCAppResourceGenerator resgen;

    public JprincipalGenerator(Project project, JFCAppResourceGenerator resgen) {
        this.project = project;
        this.resgen = resgen;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public void process() {
        Acl acl = this.project.getAcl();
        if (acl == null) {
            return;
        }
        Principal[] principals = acl.getPrincipal();
        if (principals == null) {
            return;
        }
        Category[] categories = acl.getCategory();
        if (categories == null) {
            return;
        }
        String enc = this.project.getEncoding();
        for (int i = 0; i < principals.length; ++i) {
            Principal principal = principals[i];
            int no = principal.getNo();
            String id = principal.getPrincipalId();
            String content = principal.getContent();
            if (no < 0) {
                logger.warn(this.rman.getValue("jprincipal.skip", id));
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"");
            sb.append(enc);
            sb.append("\"?>");
            sb.append(CR);
            sb.append("<jprincipal id=\"");
            sb.append(principal.getId());
            sb.append("\"");
            if (principal.checkOrder()) {
                sb.append(" priority=\"").append(principal.getOrder()).append("\"");
            }
            sb.append(">");
            sb.append(CR);
            sb.append("  ");
            sb.append("<principalId>");
            sb.append(principal.getPrincipalId());
            sb.append("</principalId>");
            sb.append(CR);
            sb.append("  ");
            sb.append("<content>");
            sb.append(content);
            sb.append("</content>");
            sb.append(CR);
            if (principal.checkCategory()) {
                sb.append("  ");
                sb.append("<category>");
                sb.append(principal.getCategory());
                sb.append("</category>");
                sb.append(CR);
            }
            if (principal.checkOrder()) {
                sb.append("  ");
                sb.append("<order>");
                sb.append(principal.getOrder());
                sb.append("</order>");
                sb.append(CR);
            }
            if (principal.getIsShowInSelect()) {
                sb.append("  ");
                sb.append("<isShowInSelect>");
                sb.append(principal.getIsShowInSelect());
                sb.append("</isShowInSelect>");
                sb.append(CR);
            }
            if (principal.getIsEditable()) {
                sb.append("  ");
                sb.append("<isEditable>");
                sb.append(principal.getIsEditable());
                sb.append("</isEditable>");
                sb.append(CR);
            }
            sb.append("</jprincipal>");
            sb.append(CR);
            this.output(id, "jprincipal", sb.toString());
        }
        this.outputCategory(categories);
    }

    protected void output(String id, String modelId, String content) {
        String basedir = this.project.getBasedir();
        String enc = JavaSourceGenerator.getEncoding(this.project);
        try {
            SourceWriter.write(basedir, "init", modelId, id, ".xml", content, enc);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected void outputCategory(Category[] categories) {
        String enc = JavaSourceGenerator.getEncoding(this.project);
        for (Category category : categories) {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"");
            sb.append(enc);
            sb.append("\"?>").append(CR);
            sb.append("<jcategory>").append(CR);
            sb.append("  ").append("<id>").append(category.getId()).append("</id>").append(CR);
            sb.append("  ").append("<no>").append(category.getId()).append("</no>").append(CR);
            sb.append("  ").append("<order>").append(category.getOrder()).append("</order>").append(CR);
            sb.append("  ").append("<categoryId>").append(category.getCategoryId()).append("</categoryId>").append(CR);
            sb.append("  ").append("<content>").append(category.getContent()).append("</content>").append(CR);
            sb.append("</jcategory>").append(CR);
            this.output(category.getCategoryId(), "jcategory", sb.toString());
        }
    }
}

