/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JspGenerator;
import jp.jasminesoft.jfc.gen.JspGenerator_copy;
import jp.jasminesoft.jfc.gen.JspGenerator_download;
import jp.jasminesoft.jfc.gen.JspGenerator_free;
import jp.jasminesoft.jfc.gen.JspGenerator_insert;
import jp.jasminesoft.jfc.gen.JspGenerator_jobentry;
import jp.jasminesoft.jfc.gen.JspGenerator_master;
import jp.jasminesoft.jfc.gen.JspGenerator_printAll;
import jp.jasminesoft.jfc.gen.JspGenerator_show;
import jp.jasminesoft.jfc.gen.JspGenerator_showList;
import jp.jasminesoft.jfc.gen.JspGenerator_update;
import jp.jasminesoft.jfc.gen.JspGenerator_uploadUpdate;
import jp.jasminesoft.jfc.gen.MobileGeneratorManager;
import jp.jasminesoft.jfc.gen.MobileJspGenerator_copy;
import jp.jasminesoft.jfc.gen.MobileJspGenerator_insert;
import jp.jasminesoft.jfc.gen.MobileJspGenerator_show;
import jp.jasminesoft.jfc.gen.MobileJspGenerator_showList;
import jp.jasminesoft.jfc.gen.MobileJspGenerator_update;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JspGeneratorFactory
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)JspGeneratorFactory.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");

    public static JspGenerator[] create(Project project, Presentation presentation) {
        JspGenerator[] gens = new JspGenerator[]{};
        if (presentation == null) {
            return gens;
        }
        Action action = null;
        IRNode node = presentation.getIdrefAsIRNode();
        if (node != null && node instanceof Action) {
            action = (Action)node;
        }
        String type = null;
        if (action == null) {
            if (presentation.getIdref() != null) {
                logger.error(rman.getValue("jsp.comment.actiontype.null", presentation.getIdref()));
            }
            type = "show";
        } else {
            type = action.getType();
        }
        type = type == null || type.length() == 0 ? "show" : type;
        MobileGeneratorManager.getInstance();
        boolean isMobile = MobileGeneratorManager.isMobilePresentation(presentation);
        HashSet<JspGenerator> set = new HashSet<JspGenerator>();
        if ("show".equals(type) || "showArray".equals(type) || "confirm".equals(type)) {
            if (!isMobile) {
                set.add(new JspGenerator_show(project, action, presentation));
            } else {
                set.add(new MobileJspGenerator_show(project, action, presentation));
            }
        } else if ("showList".equals(type) || "jobentryList".equals(type)) {
            Link[] links;
            if (!isMobile) {
                set.add(new JspGenerator_showList(project, action, presentation));
            } else {
                set.add(new MobileJspGenerator_showList(project, action, presentation));
            }
            for (Link link : links = AppSchemaUtil.findLink(presentation)) {
                if (!"PrintAll".equals(link.getAction())) continue;
                Model model = AppSchemaUtil.getStoreModel(AppSchemaUtil.getModel(project, action.getIdref()));
                set.add(new JspGenerator_printAll(project, action, presentation, model.getId() + "_printAll", link));
            }
        } else if ("insert".equals(type)) {
            if (!isMobile) {
                set.add(new JspGenerator_insert(project, action, presentation));
            } else {
                set.add(new MobileJspGenerator_insert(project, action, presentation));
            }
        } else if ("copy".equals(type)) {
            if (!isMobile) {
                set.add(new JspGenerator_copy(project, action, presentation));
            } else {
                set.add(new MobileJspGenerator_copy(project, action, presentation));
            }
        } else if ("update".equals(type)) {
            if (!isMobile) {
                set.add(new JspGenerator_update(project, action, presentation));
            } else {
                set.add(new MobileJspGenerator_update(project, action, presentation));
            }
        } else if ("free".equals(type)) {
            set.add(new JspGenerator_free(project, action, presentation));
        } else if ("jobentry".equals(type)) {
            set.add(new JspGenerator_jobentry(project, action, presentation));
        } else if ("showList-master".equals(type)) {
            Model mmodel = (Model)action.getIdrefAsIRNode();
            if (mmodel != null && !"static".equals(mmodel.getStorage())) {
                set.add(new JspGenerator_master(project, action, presentation));
            }
        } else if ("download".equals(type)) {
            set.add(new JspGenerator_download(project, action, presentation));
        } else if ("uploadUpdate".equals(type)) {
            set.add(new JspGenerator_uploadUpdate(project, action, presentation));
        }
        if (set.size() > 0) {
            gens = set.toArray(new JspGenerator[0]);
        }
        return gens;
    }
}

