/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.appschema.KeyRule;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyRuleGenerator {
    public static Logger logger = LogManager.getLogger((String)KeyRuleGenerator.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");

    public static String createMethod(Model model, KeyRule keyRule) {
        String type = keyRule.getType();
        if ("prefix".equals(type)) {
            return KeyRuleGenerator.createMethod_prefix(keyRule);
        }
        if ("padding".equals(type)) {
            return KeyRuleGenerator.createMethod_padding(keyRule);
        }
        logger.warn("Unknown type: " + type);
        return "";
    }

    private static String createMethod_prefix(KeyRule keyRule) {
        String format = keyRule.getFormat();
        String cnt = keyRule.getContent();
        StringBuilder sb = new StringBuilder();
        sb.append("CONCAT(");
        if (cnt.startsWith("fiscalYear") || "normalYear".equals(cnt)) {
            sb.append("TEXT(");
            if (cnt.startsWith("fiscalYear")) {
                int month = -1;
                int ptr = cnt.indexOf(":");
                if (ptr > 0) {
                    month = NumberUtils.toInt((String)cnt.substring(ptr + 1));
                }
                if (month < 0 || month > 12) {
                    sb.append("DATE(FISCALYEAR(TODAY()),MONTH(TODAY()),DAY(TODAY()))");
                } else {
                    sb.append("DATE(FISCALYEAR(TODAY(), ").append(month).append("),MONTH(TODAY()),DAY(TODAY()))");
                }
            } else {
                sb.append("DATE(TODAY())");
            }
            sb.append(", ");
            if (format != null && format.length() > 0) {
                sb.append("\"");
                sb.append(format);
                sb.append("\"");
            } else {
                sb.append("\"yyyy-\"");
            }
            sb.append(")");
        } else {
            sb.append("\"");
            sb.append(StringUtil.escapeString((String)cnt, (char)'\"'));
            sb.append("\"");
        }
        sb.append(", ");
        return sb.toString();
    }

    private static String createMethod_padding(KeyRule keyRule) {
        String padding_length_str;
        String content = keyRule.getContent();
        int ptr = content.indexOf(",");
        String padding_char = ptr > 0 ? content.substring(0, ptr) : "";
        String string = padding_length_str = ptr > 0 ? content.substring(ptr + 1) : "";
        if (padding_char == null || padding_char.length() == 0) {
            Object[] o = new Object[]{content};
            logger.error(rman.getValue("keyrule.padding.char.null", o));
            return "";
        }
        char c = padding_char.charAt(0);
        int len = StringUtil.intValue((String)padding_length_str);
        if (len == 0) {
            Object[] o = new Object[]{content};
            logger.error(rman.getValue("keyrule.padding.length", o));
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PADDING(");
        sb.append("'");
        sb.append(c);
        sb.append("', ");
        sb.append(len);
        sb.append(", ");
        return sb.toString();
    }
}

