/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MasterBeanGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    protected Model model;
    protected Logger logger = LogManager.getLogger((String)MasterBeanGenerator.class.getName());
    protected boolean useJFCMasterClassFlag = false;

    public MasterBeanGenerator(Project project, Model model) {
        super(project);
        this.model = model;
        this.useJFCMasterClassFlag = AppSchemaUtil.isUseJFCMasterClass(model, project);
    }

    protected boolean isUseJFCMasterClassFlag() {
        return this.useJFCMasterClassFlag;
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gVariableDefinition());
        sb.append(CR);
        sb.append(this.gConstructor());
        sb.append(CR);
        sb.append(this.gMasterBeanMethod());
        sb.append(this.gEnd());
        return sb.toString();
    }

    public String getClassExplanation() {
        return rman.getValue("master.comment.explanation", SourceGenerator.capFirst(this.model.getId()));
    }

    @Override
    public String getClassname() {
        return MasterBeanGenerator.getClassname(this.model);
    }

    public static String getClassname(Model model) {
        StringBuilder sb = new StringBuilder();
        sb.append("Master").append(SourceGenerator.capFirst(model.getId()));
        return sb.toString();
    }

    public String gClassDeclaration() {
        return "";
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, this.model);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, this.model);
    }

    @Override
    public String[] getDefaultImport() {
        return new String[0];
    }

    protected String gHeader() {
        String packagename;
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((ary = this.getDefaultImport()) != null) {
            for (int i = 0; i < ary.length; ++i) {
                sb.append("import ");
                sb.append(ary[i]);
                sb.append(";");
                sb.append(CR);
            }
        }
        if (!this.isUseJFCMasterClassFlag() && (packagename = AppSchemaUtil.getPackagename(this.model, this.project)) != null && packagename.length() > 0) {
            sb.append("import ");
            sb.append(packagename);
            sb.append("*;");
            sb.append(CR);
        }
        sb.append("import ");
        if (this.project.getPackage() != null) {
            sb.append(this.project.getPackage());
            sb.append(".");
        }
        sb.append(SUB_PACKAGE_NAME);
        sb.append(".*");
        sb.append(";");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    protected String gConstructor() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), null, null));
        sb.append("    ");
        sb.append("private ");
        sb.append(this.getClassname());
        sb.append("() {");
        if (this.isUseJFCMasterClassFlag()) {
            sb.append(CR);
            sb.append("        ");
            sb.append("super();");
            sb.append(CR);
            sb.append("    ");
        }
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    public static String getMasterClassname(Model model) {
        Object classname = "";
        if (model != null) {
            classname = "Master" + SourceGenerator.capFirst(model.getId());
        }
        return classname;
    }

    public static String getRetValueMasterClassnameArray(Model model, Project project) {
        return MasterBeanGenerator.getRetValueMasterClassname0(model, project, "code_m", true);
    }

    public static String getRetValueMasterClassnameArray(Model model, Project project, String varname) {
        return MasterBeanGenerator.getRetValueMasterClassname0(model, project, varname, true);
    }

    public static String getRetValueMasterClassname0(Model model, Project project, String varname, boolean isArray) {
        String mpackagename = AppSchemaUtil.getPackagename(model, project);
        String mclassname0 = AppSchemaUtil.getClassname(model);
        StringBuilder sb = new StringBuilder();
        sb.append(mpackagename + mclassname0);
        if (isArray) {
            sb.append("[]");
        }
        sb.append(" ").append(varname);
        return sb.toString();
    }

    public static String getGetterStatement4Masters(Model model, Project project, String p_varname, String tab) {
        String mpackagename = null;
        String declare_stmt = null;
        if ("jprincipal".equals(model.getId())) {
            mpackagename = "jp.jasminesoft.jfc.app.";
            declare_stmt = "jp.jasminesoft.jfc.model.master.Master[] code_m";
        } else {
            mpackagename = AppSchemaUtil.getPackagename_app(model, project);
            declare_stmt = MasterBeanGenerator.getRetValueMasterClassnameArray(model, project);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append(declare_stmt);
        sb.append(" =");
        sb.append(CR);
        sb.append(tab).append("    ");
        sb.append(mpackagename);
        sb.append(MasterBeanGenerator.getClassname(model));
        sb.append(".getMasters(").append(p_varname).append(");");
        sb.append(CR);
        return sb.toString();
    }

    public static String getGetterStatement4MasterCode(Model model, Project project, String code_varname, String p_varname, String tab) {
        String mpackagename = null;
        String declare_stmt = null;
        if ("jprincipal".equals(model.getId())) {
            mpackagename = "jp.jasminesoft.jfc.app.";
            declare_stmt = "jp.jasminesoft.jfc.model.master.Master code_m";
        } else {
            mpackagename = AppSchemaUtil.getPackagename_app(model, project);
            declare_stmt = MasterBeanGenerator.getRetValueMasterClassname0(model, project, "code_m", false);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append(declare_stmt);
        sb.append(" =");
        sb.append(CR);
        sb.append(tab).append("    ");
        sb.append(mpackagename);
        sb.append(MasterBeanGenerator.getClassname(model));
        sb.append(".getMaster(").append(code_varname).append(", ").append(p_varname).append(");");
        sb.append(CR);
        return sb.toString();
    }

    protected String gGetterMethod() {
        StringBuilder sb = new StringBuilder();
        String mid = this.model.getId();
        String mpackagename = AppSchemaUtil.getPackagename(this.model, this.project);
        String mclassname = AppSchemaUtil.getMasterClassname(this.model);
        String mclassname0 = AppSchemaUtil.getClassname(this.model);
        Object mtpackagename = this.project.getPackage() + ".app." + mid + ".";
        if (mclassname.indexOf(".") >= 0) {
            mtpackagename = "";
        }
        String[] msg_param = new String[]{"p ActionParameter"};
        Object[] o = new Object[]{this.model.getDescription()};
        sb.append(CommentGenerator.gComment(rman.getValue("jfcdataaccessmanager.comment.getMasterCode", o), msg_param, "An array of Master"));
        sb.append("    ");
        sb.append("public static jp.jasminesoft.jfc.model.master.Master[] getMasters");
        sb.append("(");
        sb.append("ActionParameter p");
        sb.append(") {");
        sb.append(CR);
        sb.append("        ");
        sb.append((String)mtpackagename);
        sb.append(mclassname);
        sb.append(" master = ");
        sb.append(CR);
        sb.append("            ");
        sb.append((String)mtpackagename);
        sb.append(mclassname);
        sb.append(CR);
        sb.append("                ");
        sb.append(".getInstance(p);");
        sb.append(CR);
        sb.append("        ");
        sb.append(mpackagename + mclassname0);
        sb.append("[] code_m =");
        sb.append(CR);
        sb.append("            ");
        sb.append("(");
        sb.append(mpackagename + mclassname0);
        sb.append("[])");
        sb.append(CR);
        sb.append("                ");
        sb.append("master.getData();");
        sb.append(CR);
        sb.append("        ");
        sb.append("return code_m;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        msg_param = new String[]{"code Integer", "p ActionParameter"};
        sb.append(CommentGenerator.gComment(rman.getValue("jfcdataaccessmanager.comment.getMasterCode", o), msg_param, "Master"));
        sb.append("    ");
        sb.append("public static jp.jasminesoft.jfc.model.master.Master getMaster");
        sb.append("(");
        sb.append("Integer code, ActionParameter p");
        sb.append(") {");
        sb.append(CR);
        sb.append("        ");
        sb.append((String)mtpackagename);
        sb.append(mclassname);
        sb.append(" master = ");
        sb.append(CR);
        sb.append("            ");
        sb.append((String)mtpackagename);
        sb.append(mclassname);
        sb.append(CR);
        sb.append("                ");
        sb.append(".getInstance(p);");
        sb.append(CR);
        sb.append("        ");
        sb.append(mpackagename + mclassname0);
        sb.append(" code_m =");
        sb.append(CR);
        sb.append("            ");
        sb.append("(");
        sb.append(mpackagename + mclassname0);
        sb.append(")");
        sb.append(CR);
        sb.append("                ");
        sb.append("((code != null) ? master.getData(code.intValue()) : null);");
        sb.append(CR);
        sb.append("        ");
        sb.append("return code_m;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gVariableDefinition() {
        return "";
    }

    protected String gMasterBeanMethod() {
        return "";
    }
}

