/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.TreeMap;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.MasterBeanGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Inititem;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MasterBeanGenerator_static
extends MasterBeanGenerator {
    protected Logger logger = LogManager.getLogger((String)MasterBeanGenerator_static.class.getName());

    public MasterBeanGenerator_static(Project project, Model model) {
        super(project, model);
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> ilist = new ArrayList<String>();
        ilist.add("jp.jasminesoft.jfc.ActionParameter");
        ilist.add("jp.jasminesoft.jfc.JFCUtils");
        ilist.add("jp.jasminesoft.jfc.master.app.AbstractMasterMemory");
        return ilist.toArray(new String[0]);
    }

    @Override
    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends AbstractMasterMemory");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gConstructor() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), null, null));
        sb.append("    ");
        sb.append("private ");
        sb.append(this.getClassname());
        sb.append("() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gVariableDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("/** ");
        sb.append(rman.getValue("master.comment.myinstance"));
        sb.append(" */");
        sb.append(CR);
        sb.append("    ");
        sb.append("private static ");
        sb.append(this.getClassname());
        sb.append(" instance;");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gMasterBeanMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gGetInstanceMethod());
        sb.append(CR);
        sb.append(this.gInitMethod());
        sb.append(CR);
        sb.append(this.gGetterMethod());
        return sb.toString();
    }

    protected String gGetInstanceMethod() {
        StringBuilder sb = new StringBuilder();
        String[] param = new String[]{"p ActionParameter"};
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.getinstance"), param, this.getClassname()));
        sb.append("    ");
        sb.append("public static synchronized ");
        sb.append(this.getClassname());
        sb.append(" getInstance(ActionParameter p) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (instance == null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("instance = new ");
        sb.append(this.getClassname());
        sb.append("();");
        sb.append(CR);
        sb.append("            ");
        sb.append("instance.init();");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("return instance;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gInitMethod() {
        StringBuilder sb = new StringBuilder();
        String[] param = new String[]{};
        sb.append(CommentGenerator.gComment(rman.getValue("master.comment.init"), param, null));
        sb.append("    ");
        sb.append("public void init() {");
        sb.append(CR);
        TreeMap<Integer, Inititem> iitemmap = new TreeMap<Integer, Inititem>();
        IModelChoice[] imc = this.model.getContent();
        int len = imc.length;
        for (int i = 0; i < len; ++i) {
            if (!(imc[i] instanceof Inititem)) continue;
            Inititem iitem = (Inititem)imc[i];
            iitemmap.put(iitem.getId(), iitem);
        }
        sb.append("        ");
        sb.append(AppSchemaUtil.getPackagename(this.model, this.project));
        sb.append(AppSchemaUtil.getClassname(this.model));
        sb.append("[] code_m = ");
        sb.append(CR);
        sb.append("            ");
        sb.append("new ");
        sb.append(AppSchemaUtil.getPackagename(this.model, this.project));
        sb.append(AppSchemaUtil.getClassname(this.model));
        sb.append("[" + iitemmap.size() + "];");
        sb.append(CR);
        sb.append(CR);
        int cnt = 0;
        for (Integer id : iitemmap.keySet()) {
            String rkey;
            Inititem iitem = (Inititem)iitemmap.get(id);
            sb.append("        ");
            sb.append("code_m[" + cnt + "] = ");
            sb.append("new ");
            sb.append(AppSchemaUtil.getPackagename(this.model, this.project));
            sb.append(AppSchemaUtil.getClassname(this.model));
            sb.append("();");
            sb.append(CR);
            sb.append("        ");
            sb.append("code_m[" + cnt + "].setId(");
            sb.append(iitem.getId());
            sb.append(");");
            sb.append(CR);
            if (iitem.checkPriority()) {
                sb.append("        ");
                sb.append("code_m[" + cnt + "].setPriority(");
                sb.append(iitem.getPriority());
                sb.append(");");
                sb.append(CR);
            }
            if (iitem.getValid() != null) {
                String valid = StringUtil.convertJavaString((String)iitem.getValid());
                rkey = JFCAppResourceGenerator.createMasterValidResourceKey(valid, this.model.getId());
                JFCAppResourceGenerator.put(rkey, valid);
                sb.append("        ");
                sb.append("code_m[" + cnt + "].setValid(");
                sb.append("JFCUtils.getRValue(\"" + rkey + "\", \"").append(JFCUtils.getLocaleString()).append("\")");
                sb.append(");");
                sb.append(CR);
            }
            sb.append("        ");
            sb.append("code_m[" + cnt + "].setContent(");
            String content = iitem.getContent();
            if (content != null) {
                content = StringUtil.convertJavaString((String)content);
                rkey = JFCAppResourceGenerator.createMasterContentResourceKey(content, this.model.getId());
                JFCAppResourceGenerator.put(rkey, content);
                sb.append("JFCUtils.getRValue(\"" + rkey + "\", \"").append(JFCUtils.getLocaleString()).append("\")");
            }
            sb.append(");");
            sb.append(CR);
            sb.append(CR);
            ++cnt;
        }
        sb.append("        ");
        sb.append("setData(code_m);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

