/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.util.ExtensionFilenameFilter;
import jp.jasminesoft.util.StringTemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginHtmlManager {
    private String CR = System.getProperty("line.separator");
    private String enc = "UTF-8";
    private String[] filterExtensions = new String[]{"html"};
    private Map pluginMap;
    protected Logger logger = LogManager.getLogger((String)PluginHtmlManager.class.getName());

    public PluginHtmlManager() {
        this.pluginMap = new HashMap();
        this.init();
    }

    private void init() {
        String templatedirname = "template" + File.separator + "html" + File.separator;
        File dir = new File(templatedirname);
        if (!dir.isDirectory()) {
            this.logger.error(templatedirname + " is not directory.");
            return;
        }
        String[] files = dir.list((FilenameFilter)new ExtensionFilenameFilter(this.filterExtensions, false, false));
        for (int i = 0; i < files.length; ++i) {
            String pfilename;
            String content;
            String name = files[i];
            if (!name.startsWith("__plugin") || (content = this.read(pfilename = templatedirname + File.separator + name)) == null || content.length() <= 0) continue;
            String key = name.substring("__plugin_".length(), name.length() - ".html".length());
            StringTemplateManager stman = new StringTemplateManager(content);
            this.pluginMap.put(key, stman);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(String filename) {
        BufferedReader in = null;
        StringBuilder buf = new StringBuilder();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), this.enc));
            String line = null;
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append(this.CR);
            }
        }
        catch (IOException e) {
            this.logger.warn("File read error:" + filename);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return buf.toString();
    }

    public String[] getSuffix() {
        Set set = this.pluginMap.keySet();
        return set.toArray(new String[0]);
    }

    public String getContent(String suffix, String[][] replace_str) {
        StringTemplateManager stman = (StringTemplateManager)this.pluginMap.get(suffix);
        stman.clearContents();
        if (replace_str != null) {
            for (int i = 0; i < replace_str.length; ++i) {
                String blockname = replace_str[i][0];
                String s = replace_str[i][1];
                stman.addContent(blockname, s);
            }
        }
        return stman.getResult();
    }
}

