/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.gen.AbstractDBExpressionGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.CacheType;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.ExpressionGenerator;
import jp.jasminesoft.jfc.gen.ExpressionGenerator_Hibernate;
import jp.jasminesoft.jfc.gen.ExpressionGenerator_JDBC;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_showArray;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.TablenameGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Import;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Permission;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Sort;
import jp.jasminesoft.jfc.gen.appschema.Sortkey;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class ProcessBeanGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    protected static String SortKeyParamName = "sort_key";
    protected String __id;
    protected String __type;
    protected Action action;
    protected String[] defaultImportStatement = new String[0];
    protected String storage;
    protected int storagetype;
    protected boolean useCacheManager_storeref;
    protected StringBuilder psb;
    protected boolean isSerializablePkey = false;

    public ProcessBeanGenerator(Project project, String id, String type, Action action) {
        super(project);
        this.__id = id;
        this.__type = type;
        this.action = action;
        if ((this.__id == null || this.__id.length() == 0) && action != null) {
            this.__id = action.getIdref();
        }
        if ((this.__type == null || this.__type.length() == 0) && action != null) {
            this.__type = action.getType();
        }
        Model model = this.getStoreModel();
        this.storage = model.getStorage();
        this.storagetype = AppSchemaUtil.getStorageType(this.storage);
        this.psb = new StringBuilder();
    }

    public String getStoreModelId() {
        return this.__id;
    }

    protected String getActionType() {
        return this.__type;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setStorerefCache(boolean b) {
        this.useCacheManager_storeref = b;
    }

    @Override
    public String process0() {
        String actionType;
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gLoggerReady(this.getClassname()));
        sb.append(this.gVariableDefinition());
        sb.append(this.gGetPermissionMethod4pbean(this.action));
        sb.append(this.gConstructor());
        if (this.action != null && this.action.getWaitModel()) {
            sb.append(this.gSyncObject());
        }
        sb.append(this.gOtherMethod());
        sb.append(this.gRunMethod());
        sb.append(this.gMainMethod());
        sb.append(this.gEnd());
        String string = actionType = this.action == null ? null : this.action.getType();
        if (actionType != null && !actionType.equals("showArray") && !actionType.equals("showList")) {
            ApplicationContextBean appbean = new ApplicationContextBean(this.getClassname(), ProcessBeanGenerator.getPackageNameAsJavaRule(this.project, this.getStoreModel()) + "." + this.getClassname());
            SpringApplicationContextContainer.addApplicationContextBean(appbean);
        }
        return sb.toString();
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(this.getClassDeclarationSuffix());
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return this.getClassname();
    }

    @Override
    public String getClassname() {
        return AppSchemaUtil.createProcessBeanName(this.__id, this.__type, this.action, null, true);
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, this.getStoreModel());
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return ProcessBeanGenerator.getSubpackageNameAsJavaRule(this.getStoreModel());
    }

    public static String getSubpackageNameAsJavaRule(Model model) {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, model);
    }

    public static String getPackageNameAsJavaRule(Project project, Model model) {
        return project.getPackage() + "." + ProcessBeanGenerator.getSubpackageNameAsJavaRule(model);
    }

    @Override
    public String[] getDefaultImport() {
        return this.defaultImportStatement;
    }

    public String getClassDeclarationSuffix() {
        String ret = null;
        if (this.action != null && this.action.getSingleModel()) {
            ret = " extends DbSingleProcessBean";
        } else if (this.action != null && this.action.getWaitModel()) {
            ret = " extends DbWaitProcessBean";
        } else {
            Model smodel;
            IRNode node;
            ret = " extends DbProcessBean";
            if (this.action != null && (node = this.action.getIdrefAsIRNode()) != null && node instanceof Model && (smodel = (Model)node).getTextsearch() && "showList".equals(this.getActionType()) && StringUtils.isBlank((CharSequence)this.action.getView()) && !AppSchemaUtil.isActionIdRestrictedList(this.action)) {
                ret = " extends TextSearchableProcessBean";
            }
        }
        return ret;
    }

    protected String gHeader() {
        Conditionlist conditionlist;
        int i;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(ProcessBeanGenerator.getPackageNameAsJavaRule(this.project, this.getStoreModel()));
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        String excelFunctionImportStatement = AppSchemaUtil.getMyExcelFunctionStaticImport(this.project);
        String[] ary = this.getDefaultImport();
        if (ary != null) {
            for (int i2 = 0; i2 < ary.length; ++i2) {
                sb.append("import ");
                sb.append(ary[i2]);
                sb.append(";");
                sb.append(CR);
                if (excelFunctionImportStatement == null || !ary[i2].equals(excelFunctionImportStatement)) continue;
                excelFunctionImportStatement = null;
            }
        }
        if (excelFunctionImportStatement != null) {
            sb.append("import ");
            sb.append(excelFunctionImportStatement);
            sb.append(";");
            sb.append(CR);
        }
        sb.append("import ");
        if (this.project.getPackage() != null) {
            sb.append(this.project.getPackage());
            sb.append(".");
        }
        sb.append(SUB_PACKAGE_NAME);
        sb.append(".*");
        sb.append(";");
        sb.append(CR);
        HashSet<String> importSet = new HashSet<String>();
        Model model = this.getStoreModel();
        if (model != null) {
            IModelChoice[] imc;
            Object s = AppSchemaUtil.getPackagename(model, this.project);
            if (s != null && ((String)s).length() > 0) {
                s = (String)s + "*";
                importSet.add((String)s);
            }
            if ((imc = model.getContent()) != null) {
                for (i = 0; i < imc.length; ++i) {
                    if (!(imc[i] instanceof Import)) continue;
                    Import _import = (Import)imc[i];
                    importSet.add(_import.getContent());
                }
            }
        }
        if (this.action != null && (conditionlist = AppSchemaUtil.getConditionlist(this.action)) != null) {
            Model _model;
            Object s;
            String cond_id = conditionlist.getIdref();
            IRNode node = conditionlist.getIdrefAsIRNode();
            if (cond_id != null && node != null && node instanceof Model && (s = AppSchemaUtil.getPackagename(_model = (Model)node, this.project)) != null && ((String)s).length() > 0) {
                s = (String)s + "*";
                importSet.add((String)s);
            }
        }
        this.additionalImportSet(importSet);
        this.textSearchImportSet(importSet);
        for (String stmt : importSet) {
            sb.append("import ");
            sb.append(stmt);
            sb.append(";");
            sb.append(CR);
        }
        sb.append("");
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    protected void additionalImportSet(Set<String> importSet) {
    }

    protected void textSearchImportSet(Set<String> importSet) {
    }

    protected boolean isTextSearch() {
        if (!JFCAppGenerator.getIsTextSearch()) {
            return false;
        }
        return this.getStoreModel().getTextsearch();
    }

    protected Model getStoreModel() {
        Model model = null;
        if (this.action != null) {
            IRNode node = this.action.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                model = (Model)node;
            } else if (this.action.getIdref() != null) {
                Object[] o = new Object[]{this.action.getId(), this.action.getIdref()};
                logger.error(rman.getValue("value.null.model", o));
            }
        } else {
            model = AppSchemaUtil.getModel(this.project, this.__id);
        }
        return model;
    }

    protected String gVariableDefinition() {
        return "";
    }

    protected String gGetPermissionMethod4pbean(Action action) {
        Permission permission = AppSchemaUtil.getProcessBeanPermission(action, this.project, this.getStoreModelId(), this.getActionType());
        if (action != null) {
            return this.gGetPermissionMethod(permission);
        }
        if ("jholiday".equals(this.getStoreModelId()) && "showArray".equals(this.getActionType())) {
            return "";
        }
        return this.gGetPermissionMethod(permission);
    }

    protected String gConstructor() {
        StringBuilder sb = new StringBuilder();
        String _init = this.getInitializeCodeInConstructor();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), null, null));
        sb.append("    ");
        sb.append("public ");
        sb.append(this.getClassname());
        sb.append("() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super();");
        sb.append(CR);
        if (_init != null) {
            sb.append(_init);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        String[] param = new String[]{"p ActionParameter"};
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), param, null));
        sb.append("    ");
        sb.append("public ");
        sb.append(this.getClassname());
        sb.append("(ActionParameter p) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super(p);");
        sb.append(CR);
        if (_init != null) {
            sb.append(_init);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String getInitializeCodeInConstructor() {
        return null;
    }

    protected String gSyncObject() {
        StringBuilder sb = new StringBuilder();
        if (this.action == null) {
            return sb.toString();
        }
        Model model = this.getStoreModel();
        if (model == null) {
            return sb.toString();
        }
        sb.append(CommentGenerator.gComment(rman.getValue("pbean.comment.syncobj"), null, null));
        JavaSourceGenerator.putAnnotation(sb, "@Override", "    ");
        sb.append("    ");
        sb.append("public Object getSynchronizedObject() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("Object o = getParameter(\"");
        sb.append(StringUtil.convertJavaString((String)model.getId()));
        sb.append("\");");
        sb.append(CR);
        sb.append("        ");
        sb.append("return (o != null) ? o : super.getSynchronizedObject();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gOtherMethod() {
        return "";
    }

    protected String gRunMethod() {
        StringBuilder sb = new StringBuilder();
        if ("free".equals(this.__type) || "empty".equals(this.__type)) {
            sb.append(this.gRunMethod0(null));
            sb.append(CR);
            return sb.toString();
        }
        Model model = this.getStoreModel();
        if (model != null) {
            sb.append(this.gRunMethod0(model));
            sb.append(CR);
        }
        if (this.psb.length() > 0) {
            this.gPrepareParamMethod();
            sb.append(this.psb.toString());
        }
        return sb.toString();
    }

    private void gPrepareParamMethod() {
        IRNode node;
        StringBuilder sb = new StringBuilder();
        Conditionlist conditionlist = AppSchemaUtil.getConditionlist(this.action);
        Model _model = null;
        if (conditionlist != null && (node = conditionlist.getIdrefAsIRNode()) != null && node instanceof Model) {
            _model = (Model)node;
        }
        String cond_classname = null;
        if (_model != null) {
            cond_classname = AppSchemaUtil.getClassname(_model);
        }
        if (StringUtils.isBlank(cond_classname)) {
            return;
        }
        String[] params = new String[]{"paramMap", "cond"};
        sb.append(CommentGenerator.gComment(rman.getValue("pbean.comment.setcond2parammap"), params, null));
        sb.append("    ");
        sb.append("public void setConditionToParamMap(Map paramMap, ");
        sb.append(cond_classname);
        sb.append(" cond) {");
        sb.append(CR);
        if (this.isTextSearch()) {
            sb.append("        ");
            sb.append("if (cond != null && cond.getTextsearchjshparam() != null)");
            sb.append(CR);
            sb.append("            ");
            sb.append("paramMap.put(\"");
            sb.append("textsearchjshparam");
            sb.append("\", cond.getTextsearchjshparam());");
            sb.append(CR);
            sb.append(CR);
        }
        this.psb.insert(0, sb.toString());
        this.psb.append("    ");
        this.psb.append("}");
        this.psb.append(CR);
        this.psb.append(CR);
    }

    protected String gRunMethod0(Model model) {
        return "    }" + CR;
    }

    protected ExpressionGenerator getExpressionGenerator() {
        AbstractDBExpressionGenerator generator;
        if (this.storagetype == 5) {
            generator = new ExpressionGenerator_Hibernate(this.project);
        } else {
            if (this.storagetype != 0 && this.storagetype != 5) {
                logger.error("Unknown storage " + this.storage + " in " + this.__type + " model " + this.__id);
            }
            generator = new ExpressionGenerator_JDBC();
        }
        return generator;
    }

    protected String gCreateExpressionMethod(Conditionlist conditionlist, Sort sort, Model model) {
        IRNode node;
        Model _model = null;
        Model _rmodel = null;
        if (conditionlist != null && (node = conditionlist.getIdrefAsIRNode()) != null && node instanceof Model) {
            _model = (Model)node;
        }
        if (_model != null) {
            IRNode _node;
            String _idref = _model.getIdref();
            if (_idref != null && _idref.length() > 0 && (_node = _model.getIdrefAsIRNode()) != null) {
                _rmodel = (Model)_node;
            }
            if (_rmodel == null) {
                String sid = _model.getId();
                sid = sid.substring(0, sid.indexOf("_"));
                _rmodel = AppSchemaUtil.getModel(this.project, sid);
            }
        }
        if (_rmodel == null) {
            _rmodel = model;
        } else if (_rmodel != null && !_rmodel.getId().equals(model.getId()) && !"download".equals(this.action.getType())) {
            Object[] o = new Object[]{this.action != null ? this.action.getId() : "", model != null ? model.getId() : "", _model != null ? _model.getId() : "", _rmodel != null ? _rmodel.getId() : ""};
            logger.error(rman.getValue("pbean.errmsg.different_storemodelid_conditionmodelidref", o));
        }
        return this.gCreateExpressionMethod(conditionlist, sort, _rmodel, _model);
    }

    protected String gCreateExpressionMethod(Conditionlist conditionlist, Sort sort, Model _rmodel, Model _model) {
        String tableclassname = this.getTableclassname(_rmodel, this.project);
        StringBuilder sb = new StringBuilder();
        if (conditionlist == null && sort == null) {
            return "";
        }
        ExpressionGenerator generator = this.getExpressionGenerator();
        generator.setProject(this.project);
        generator.setId(this.__id);
        generator.setStoreModel(_rmodel);
        boolean needsConditionModel = true;
        if (this.action != null && !this.action.getStrutsclassgen() && conditionlist != null && conditionlist.getIdref() == null) {
            needsConditionModel = false;
        }
        if (_model == null && needsConditionModel) {
            _model = this.action != null ? AppSchemaUtil.getConditionModel(this.project, this.action) : AppSchemaUtil.getModel(this.project, _rmodel.getId(), "condition");
        }
        generator.setConditionModel(_model);
        generator.setAction(this.action);
        if (tableclassname.equals("MasterTable")) {
            String packagename = AppSchemaUtil.getPackagename(_rmodel, this.project);
            generator.setTableclassname(packagename + tableclassname);
        } else {
            generator.setTableclassname(tableclassname);
        }
        generator.setConditionlist(conditionlist);
        generator.setSort(sort);
        this.gCreateExpressionMethod(sb, generator);
        return sb.toString();
    }

    protected void gCreateExpressionMethod(StringBuilder sb, ExpressionGenerator generator) {
        sb.append(generator.gCreateExpressionMethod());
    }

    protected String getTableclassname(Model model, Project project) {
        String tableclassname = AppSchemaUtil.getRelaxerTableclassname(model, project);
        return tableclassname;
    }

    protected String gSetparam4pbean(Conditionlist conditionlist) {
        return this.gSetparam4pbean(conditionlist, "");
    }

    protected String gSetparam4pbean(Conditionlist conditionlist, String basetab) {
        return this.gSetparam4pbean(conditionlist, false, basetab);
    }

    protected String gSetparam4pbean(Conditionlist conditionlist, boolean preparedConditionOnly, String basetab) {
        IRNode node;
        StringBuilder sb = new StringBuilder();
        Model _model = null;
        Model _rmodel = null;
        if (conditionlist != null && (node = conditionlist.getIdrefAsIRNode()) != null && node instanceof Model) {
            _model = (Model)node;
        }
        if (_model != null) {
            IRNode _node;
            String _idref = _model.getIdref();
            if (_idref != null && _idref.length() > 0 && (_node = _model.getIdrefAsIRNode()) != null) {
                _rmodel = (Model)_node;
            }
            if (_rmodel == null) {
                String sid = _model.getId();
                sid = sid.substring(0, sid.indexOf("_"));
                _rmodel = AppSchemaUtil.getModel(this.project, sid);
            }
        }
        if (_rmodel == null) {
            _rmodel = this.getStoreModel();
        }
        String cond_classname = null;
        if (_model != null) {
            cond_classname = AppSchemaUtil.getClassname(_model);
        }
        if (cond_classname != null) {
            sb.append("        " + (String)basetab);
            sb.append("// " + rman.getValue("pbean.comment.createexpression.readparam"));
            sb.append(CR);
            sb.append("        " + (String)basetab);
            sb.append(cond_classname);
            sb.append(" cond = null;");
            sb.append(CR);
            sb.append("        " + (String)basetab);
            sb.append(cond_classname);
            sb.append(" cond_o = ");
            sb.append("(");
            sb.append(cond_classname);
            sb.append(")");
            sb.append("getParameter(ProcessBean.ConditionParamName);");
            sb.append(CR);
            sb.append("        " + (String)basetab);
            sb.append("if (cond_o != null) {");
            sb.append(CR);
            sb.append("            " + (String)basetab);
            sb.append("cond = new ");
            sb.append(cond_classname);
            sb.append("(cond_o);");
            sb.append(CR);
            sb.append("        " + (String)basetab);
            sb.append("}");
            sb.append(CR);
            this.gSetParam4pbean_createConditionObject("        " + (String)basetab, sb, _model, _rmodel);
        }
        if (preparedConditionOnly) {
            basetab = (String)basetab + "    ";
            sb.append("    " + (String)basetab);
            sb.append("if (beforeSearch) {");
            sb.append(CR);
        }
        if (cond_classname != null) {
            sb.append("        " + (String)basetab);
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(_model, this.project));
            sb.append(".beforeSearch(cond ,p);");
            sb.append(CR);
        }
        if (preparedConditionOnly) {
            sb.append("    " + (String)basetab);
            sb.append("}");
            sb.append(CR);
            return sb.toString();
        }
        int countOfOutputCondition = 0;
        Condition[] conditions = AppSchemaUtil.getAllInnerCondition(conditionlist);
        if (conditions != null) {
            for (int i = 0; i < conditions.length; ++i) {
                Condition condition = conditions[i];
                if (this.isIgnoreCondition(condition, _model) || condition.getImplicit()) continue;
                if (cond_classname == null) {
                    this.gSetparam4pbeanItem_NoCondClassname(sb, condition, (String)basetab, _rmodel);
                    continue;
                }
                this.gSetparam4pbeanItem_HasCondClassname(this.psb, condition, (String)basetab, _model, _rmodel);
                ++countOfOutputCondition;
            }
        }
        if (cond_classname != null && _model != null && _model.getContent() != null && _model.getContent().length != 0) {
            this.psb.append("        " + (String)basetab);
            this.psb.append("if (cond != null && cond");
            this.psb.append(ProcessBeanGenerator.getterFullMethod("noselection_jshparam"));
            this.psb.append(" != null) {");
            this.psb.append(CR);
            this.psb.append("            " + (String)basetab);
            this.psb.append("paramMap.put(\"");
            this.psb.append("noselection_jshparam");
            this.psb.append("\", cond");
            this.psb.append(ProcessBeanGenerator.getterFullMethod("noselection_jshparam"));
            this.psb.append(");");
            this.psb.append(CR);
            this.psb.append("        " + (String)basetab);
            this.psb.append("}");
            this.psb.append(CR);
            this.psb.append(CR);
            ++countOfOutputCondition;
        }
        if (cond_classname != null && countOfOutputCondition > 0) {
            sb.append("        " + (String)basetab);
            sb.append("setConditionToParamMap(paramMap, cond);");
            sb.append(CR);
        }
        sb.append(CR);
        return sb.toString();
    }

    protected void gSetParam4pbean_createConditionObject(String tab, StringBuilder sb, Model _model, Model _rmodel) {
    }

    protected boolean isIgnoreCondition(Condition condition, Model cmodel) {
        return false;
    }

    private void gSetparam4pbeanItem_NoCondClassname(StringBuilder sb, Condition condition, String basetab, Model _rmodel) {
        String name = condition.getName();
        if (name == null) {
            return;
        }
        String type = this.getConditionType(condition, null, _rmodel);
        if (type == null) {
            return;
        }
        if ("BETWEEN".equals(condition.getCond())) {
            condition.setName(name + condition.getStartPrefix());
            condition.setCond("GE");
            this.gSetparam4pbeanItem_NoCondClassname(sb, condition, basetab, _rmodel, type);
            condition.setName(name + condition.getEndPrefix());
            condition.setCond("LE");
            this.gSetparam4pbeanItem_NoCondClassname(sb, condition, basetab, _rmodel, type);
            condition.setName(name);
            condition.setCond("BETWEEN");
            return;
        }
        this.gSetparam4pbeanItem_NoCondClassname(sb, condition, basetab, _rmodel, type);
    }

    private void gSetparam4pbeanItem_NoCondClassname(StringBuilder sb, Condition condition, String basetab, Model _rmodel, String type) {
        String name = AppSchemaUtil.getChildPart(condition.getName());
        Modelitem mitem = AppSchemaUtil.getModelitem(name, _rmodel);
        String javatype = this.getJavaType(type, mitem);
        if ("constraintparticipant".equals(javatype)) {
            return;
        }
        if (javatype.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR()) > 0) {
            String[] tokens = javatype.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP());
            if (mitem.getType().equals("storeref")) {
                Relation relation = AppSchemaUtil.getRelation(mitem);
                _rmodel = (Model)relation.getIdrefAsIRNode();
            }
            PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(_rmodel, this.project);
            for (int i = 0; i < tokens.length; ++i) {
                String javatype0 = this.getJavaType(tokens[i], mitem);
                String name0 = name + "_" + pkeys[i].getName();
                this.gSetparam4pbeanItem_NoCondClassname0(sb, condition, basetab, _rmodel, name0, javatype0);
            }
        } else {
            this.gSetparam4pbeanItem_NoCondClassname0(sb, condition, basetab, _rmodel, name, javatype);
        }
        sb.append(CR);
    }

    private void gSetparam4pbeanItem_NoCondClassname0(StringBuilder sb, Condition condition, String basetab, Model rmodel, String name, String javatype) {
        if (AppSchemaUtil.isGenerationModelitem(name, rmodel)) {
            return;
        }
        this.isSerializablePkey = true;
        sb.append("        " + basetab);
        sb.append("java.io.Serializable _" + name + " = (java.io.Serializable)getParameterMap().get(\"");
        sb.append(StringUtil.convertJavaString((String)name));
        sb.append("\");");
        sb.append(CR);
        sb.append("        " + basetab);
        sb.append("if (_" + name + " != null) {");
        sb.append(CR);
        if ("java.lang.String".equals(javatype)) {
            sb.append("            " + basetab);
            sb.append("if (_" + name + " instanceof String) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", _" + name + ");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("logger.warn(\"parameter ");
            sb.append(StringUtil.convertJavaString((String)name));
            sb.append(" is illegal object. skip.\");");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("return null;");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
        } else if ("java.sql.Date".equals(javatype) || "java.sql.Time".equals(javatype) || "java.sql.Timestamp".equals(javatype)) {
            String classname = javatype;
            sb.append("            " + basetab);
            sb.append("if (_" + name + " instanceof String) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", ");
            if ("java.sql.Date".equals(javatype)) {
                sb.append("DateTimeUtil.getSQLDate(DateTimeUtil.getDate(");
                sb.append("(String)_" + name + ")));");
            } else if ("java.sql.Time".equals(javatype)) {
                sb.append("DateTimeUtil.getSQLTime(DateTimeUtil.getDateWithFormat(");
                sb.append("(String)_" + name);
                sb.append(", DateTimeUtil.DEFAULT_TIMEFORMAT_PATTERNS)));");
            } else if ("java.sql.Timestamp".equals(javatype)) {
                sb.append("DateTimeUtil.getSQLTime(DateTimeUtil.getDateWithFormat(");
                sb.append("(String)_" + name);
                sb.append(", DateTimeUtil.DEFAULT_DATETIMEFORMAT_PATTERNS)));");
            }
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else if (_" + name + " instanceof " + classname + ") {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", _" + name + ");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("logger.warn(\"parameter ");
            sb.append(StringUtil.convertJavaString((String)name));
            sb.append(" is illegal object. skip.\");");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("return null;");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
        } else if ("boolean".equals(javatype)) {
            String classname = "Boolean";
            sb.append("            " + basetab);
            sb.append("if (_" + name + " instanceof String) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", " + classname + ".valueOf((String)_" + name + "));");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else if (_" + name + " instanceof " + classname + ") {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", _" + name + ");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("logger.warn(\"parameter ");
            sb.append(StringUtil.convertJavaString((String)name));
            sb.append(" is illegal object. skip.\");");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("return null;");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
        } else if ("int".equals(javatype) || "byte".equals(javatype) || "short".equals(javatype) || "long".equals(javatype) || "float".equals(javatype) || "double".equals(javatype) || "combo".equals(javatype) || "radio".equals(javatype)) {
            String classname = "int".equals(javatype) ? "Integer" : ("byte".equals(javatype) ? "Byte" : ("short".equals(javatype) ? "Short" : ("long".equals(javatype) ? "Long" : ("float".equals(javatype) ? "Float" : ("double".equals(javatype) ? "Double" : ("combo".equals(javatype) ? "Integer" : ("radio".equals(javatype) ? "Integer" : null)))))));
            sb.append("            " + basetab);
            sb.append("if (_" + name + " instanceof String) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("try {");
            sb.append(CR);
            sb.append("                  " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", " + classname + ".valueOf((String)_" + name + "));");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("} catch (NumberFormatException e) {");
            sb.append(CR);
            sb.append("                  " + basetab);
            sb.append("logger.warn(\"parameter ");
            sb.append(StringUtil.convertJavaString((String)name));
            sb.append(" is illegal value \"+_" + name + ", e);");
            sb.append(CR);
            sb.append("                  " + basetab);
            sb.append("return null;");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("}");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else if (_" + name + " instanceof " + classname + ") {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", _" + name + ");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("logger.warn(\"parameter ");
            sb.append(StringUtil.convertJavaString((String)name));
            sb.append(" is illegal object. skip.\");");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("return null;");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
        } else if ("int[]".equals(javatype) || "byte[]".equals(javatype) || "short[]".equals(javatype) || "long[]".equals(javatype) || "float[]".equals(javatype) || "double[]".equals(javatype) || "check".equals(javatype) || "java.lang.String[]".equals(javatype) || "java.sql.Date[]".equals(javatype) || "java.sql.Time[]".equals(javatype) || "java.sql.Timestamp[]".equals(javatype)) {
            String classname = "check".equals(javatype) ? "int[]" : javatype;
            String not_array_classname = classname;
            if (not_array_classname.endsWith("[]")) {
                not_array_classname = not_array_classname.substring(0, not_array_classname.lastIndexOf("[]"));
            }
            if ("int".equals(not_array_classname)) {
                not_array_classname = "Integer";
            } else if ("byte".equals(not_array_classname)) {
                not_array_classname = "Byte";
            } else if ("short".equals(not_array_classname)) {
                not_array_classname = "Short";
            } else if ("long".equals(not_array_classname)) {
                not_array_classname = "Long";
            } else if ("float".equals(not_array_classname)) {
                not_array_classname = "Float";
            } else if ("double".equals(not_array_classname)) {
                not_array_classname = "Double";
            }
            sb.append("            " + basetab);
            sb.append("if (_" + name + " instanceof " + classname + ") {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", _" + name + ");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else if (_" + name + " instanceof " + not_array_classname + ") {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", ");
            sb.append("new " + classname + " {");
            sb.append("(" + not_array_classname + ")");
            sb.append("_" + name);
            sb.append("});");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else if (_" + name + " instanceof String) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, name)));
            sb.append("\", ");
            sb.append("new " + classname + " {");
            sb.append(not_array_classname);
            sb.append(".valueOf((String)");
            sb.append("_" + name);
            sb.append(")");
            sb.append("});");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("} else {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("logger.warn(\"parameter ");
            sb.append(StringUtil.convertJavaString((String)name));
            sb.append(" is illegal object. skip.\");");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("return null;");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
        } else {
            logger.error("unknown type " + javatype);
        }
        sb.append("        " + basetab);
        sb.append("}");
        sb.append(CR);
    }

    private void gSetparam4pbeanItem_HasCondClassname(StringBuilder sb, Condition condition, String basetab, Model _model, Model _rmodel) {
        String[] types;
        String name = condition.getName();
        if (name == null) {
            return;
        }
        String type = this.getConditionType(condition, _model, _rmodel);
        if (type == null) {
            return;
        }
        boolean isCheckbox = false;
        Modelitem citem = AppSchemaUtil.getModelitem(name, _model);
        if (citem != null && "storeref".equals(citem.getType())) {
            Relation c_relation = AppSchemaUtil.getRelationTypeExceptRef(citem);
            if (c_relation == null) {
                c_relation = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(_model, citem);
            }
            if (c_relation != null && "check".equals(c_relation.getType())) {
                isCheckbox = true;
            }
        }
        Modelitem smitem = AppSchemaUtil.getModelitem(name, _rmodel);
        boolean isStoreref = false;
        if (smitem != null && "storeref".equals(smitem.getType())) {
            isStoreref = true;
        }
        if ((types = AppSchemaUtil.decompositePrimaryKey(type)).length == 1) {
            sb.append(this.outputSetParameterStatement(type, name, condition, basetab, isStoreref, false, _model));
            sb.append(CR);
            sb.append(CR);
            return;
        }
        PrimaryKey[] __r_pkeys = null;
        String[][] _params = null;
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(smitem);
        if (relation == null) {
            relation = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(_rmodel, smitem);
        }
        if (relation != null) {
            Model __rmodel = (Model)relation.getIdrefAsIRNode();
            __r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(__rmodel, this.project);
            _params = AppSchemaUtil.getAllCompositeKeyNameAndTypeAsStringArray(this.project, __rmodel);
            if ("check".equals(relation.getType()) || isCheckbox) {
                sb.append(this.outputSetParameterStatement4CompositeKeyCheckbox(name, condition, basetab, smitem, _model, __r_pkeys));
                sb.append(CR);
                sb.append(CR);
                return;
            }
        }
        if (_params == null || _params.length == 0) {
            logger.error("[Internal Error] _params is null or zero, smitem=" + smitem);
            return;
        }
        int size = __r_pkeys.length;
        for (int i = 0; i < size; ++i) {
            String _type = __r_pkeys[i].getType();
            String _name = name + "_" + __r_pkeys[i].getName();
            sb.append(this.outputSetParameterStatement(_type, _name, condition, basetab, isStoreref, true, _model));
            sb.append(CR);
            sb.append(CR);
        }
    }

    private String getConditionType(Condition condition, Model _model, Model _rmodel) {
        Modelitem cmitem = null;
        String name = condition.getName();
        String type = null;
        if (_model == null && "showArray".equals(this.__type)) {
            _model = AppSchemaUtil.getModel(this.project, _rmodel.getId(), "condition");
        }
        if (_model == null) {
            type = condition.getType();
        } else if (condition.getCond().equals("BETWEEN")) {
            type = null;
        } else {
            cmitem = AppSchemaUtil.getModelitem(name, _model);
            if (cmitem != null) {
                type = cmitem.getType();
            }
        }
        Modelitem target = null;
        String id = null;
        if ((type == null || type.equalsIgnoreCase("string")) && _rmodel != null) {
            target = AppSchemaUtil.getModelitem(name, _rmodel);
            if (target == null) {
                return type;
            }
            type = target.getType();
            id = _rmodel.getId();
        } else {
            target = cmitem;
            String string = id = _model != null ? _model.getId() : _rmodel.getId();
            if (target == null) {
                return type;
            }
        }
        if ("masterref".equals(type)) {
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(target);
            if (relation == null) {
                Object[] o = new Object[]{id, name};
                logger.error(rman.getValue("value.null.relation", o));
                return null;
            }
            return relation.getType();
        }
        if ("storeref".equals(type)) {
            type = this.getConditionType_storeref(target, id, name);
        }
        return type;
    }

    private String getConditionType_storeref(Modelitem target, String id, String name) {
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(target);
        if (relation != null) {
            return this.getConditionType_storeref_TypeExceptRef(relation, id, name);
        }
        Relation refrelation = AppSchemaUtil.getRelationTypeIsRef(target);
        if (refrelation == null) {
            Object[] o = new Object[]{id, name};
            logger.error(rman.getValue("value.null.relation.condition", o));
            return null;
        }
        String rtype = this.getConditionType_storeref_TypeIsRef(refrelation);
        if (rtype == null) {
            Object[] o = new Object[]{id, name};
            logger.error(rman.getValue("value.null.relation.condition", o));
            return null;
        }
        return rtype;
    }

    private String getConditionType_storeref_TypeExceptRef(Relation relation, String id, String name) {
        Modelitem _ritem;
        IRNode rnode = relation.getIdrefAsIRNode();
        if (rnode == null || !(rnode instanceof Model)) {
            Object[] o = new Object[]{id, name, relation.getIdref()};
            logger.error(rman.getValue("value.null.relation.idref", o));
            return null;
        }
        Model rmodel = (Model)rnode;
        if (relation.getRoleid() != null && relation.getRoleid().equals(relation.getRolecontent()) && (_ritem = AppSchemaUtil.getModelitem(relation.getRoleid(), rmodel)) != null) {
            Object type = AppSchemaUtil.getModelitemType(this.project, rmodel.getId(), _ritem, "roleid");
            if ("check".equals(relation.getType())) {
                type = (String)type + "[]";
            }
            return type;
        }
        String[] types = AppSchemaUtil.getAllCompositeKeyTypeAsStringArray(this.project, rmodel);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            sb.append(types[i]);
            if ("check".equals(relation.getType())) {
                sb.append("[]");
            }
            if (i >= types.length - 1) continue;
            sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
        }
        return sb.toString();
    }

    private String getConditionType_storeref_TypeIsRef(Relation refrelation) {
        Model refmodel = (Model)refrelation.getIdrefAsIRNode();
        String refname = refrelation.getName();
        if (refmodel == null || refname == null) {
            return null;
        }
        Modelitem refmitem = AppSchemaUtil.getModelitem(refname, refmodel);
        if (refmitem == null) {
            return null;
        }
        String type = refmitem.getType();
        if ("masterref".equals(type)) {
            Relation refmitem_relation = AppSchemaUtil.getRelationTypeExceptRef(refmitem);
            if (refmitem_relation == null) {
                return null;
            }
            return refmitem_relation.getType();
        }
        if ("storeref".equals(type)) {
            Relation refmitem_relation = AppSchemaUtil.getRelationTypeExceptRef(refmitem);
            if (refmitem_relation != null) {
                return this.getConditionType_storeref_TypeExceptRef(refmitem_relation, refmodel.getId(), refmitem.getName());
            }
            Relation refmitem_refrelation = AppSchemaUtil.getRelationTypeIsRef(refmitem);
            if (refmitem_refrelation == null) {
                return null;
            }
            return this.getConditionType_storeref_TypeIsRef(refmitem_refrelation);
        }
        return type;
    }

    protected String gSetSortparam4pbean(Conditionlist conditionlist, Sort sort) {
        return this.gSetSortparam4pbean(conditionlist, sort, "");
    }

    protected String gSetSortparam4pbean(Conditionlist conditionlist, Sort sort, String basetab) {
        StringBuilder sb = new StringBuilder();
        sb.append("        " + basetab);
        sb.append("paramMap.put(\"");
        sb.append(SortKeyParamName);
        sb.append("\", createSortKey());");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String outputSetParameterStatement(String type, String name, Condition condition, String basetab, boolean isStoreref, boolean isCompositeKey, Model _model) {
        StringBuilder sb = new StringBuilder();
        if (AppSchemaUtil.isGenerationModelitem(name, _model)) {
            return sb.toString();
        }
        int _idx = name.indexOf("/");
        String cname = _idx > 0 ? name.substring(_idx + 1) : name;
        boolean isCheckBoxFlag = false;
        if (type != null && type.endsWith("[]")) {
            isCheckBoxFlag = true;
            type = type.substring(0, type.length() - "[]".length());
        }
        if ("combo".equals(type) || "radio".equals(type)) {
            sb.append("        " + basetab);
            sb.append("if (cond != null && cond");
            sb.append(ProcessBeanGenerator.checkFullMethod(cname));
            sb.append(")");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, cname)));
            sb.append("\", ");
            sb.append("Integer.valueOf(");
            sb.append("cond");
            sb.append(ProcessBeanGenerator.getterFullMethod(cname));
            sb.append("));");
        } else if (isCheckBoxFlag || "check".equals(type)) {
            String _type = type;
            if ("check".equals(type)) {
                _type = "int";
            }
            sb.append("        " + basetab);
            sb.append("if (cond != null && cond");
            sb.append(ProcessBeanGenerator.getterFullMethod(cname));
            sb.append(" != null) {");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append(JavaSourceGenerator.getProperType(_type));
            sb.append("[] codes = cond");
            sb.append(ProcessBeanGenerator.getterFullMethod(cname));
            sb.append(";");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, cname)));
            sb.append("\", ");
            sb.append("codes);");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("}");
        } else if (JavaSourceGenerator.isBasicType(type)) {
            String cond;
            String string = cond = condition != null ? condition.getCond() : "";
            if ("BETWEEN".equals(cond)) {
                String sp = condition.getStartPrefix();
                String ep = condition.getEndPrefix();
                sb.append(this.getBasicCondition(name + sp, cname + sp, type, condition, AppSchemaUtil.getModelitem(name + sp, _model), isStoreref, isCompositeKey, basetab));
                sb.append(CR);
                sb.append(CR);
                sb.append(this.getBasicCondition(name + ep, cname + ep, type, condition, AppSchemaUtil.getModelitem(name + ep, _model), isStoreref, isCompositeKey, basetab));
            } else {
                sb.append(this.getBasicCondition(name, cname, type, condition, AppSchemaUtil.getModelitem(name, _model), isStoreref, isCompositeKey, basetab));
            }
        } else {
            String cond;
            String string = cond = condition != null ? condition.getCond() : "";
            if ("BETWEEN".equals(cond)) {
                String sp = condition.getStartPrefix();
                String ep = condition.getEndPrefix();
                sb.append(this.getCondition(name + sp, cname + sp, condition, basetab));
                sb.append(CR);
                sb.append(CR);
                sb.append(this.getCondition(name + ep, cname + ep, condition, basetab));
            } else {
                sb.append(this.getCondition(name, cname, condition, basetab));
            }
        }
        return sb.toString();
    }

    private String outputSetParameterStatement4CompositeKeyCheckbox(String name, Condition condition, String basetab, Modelitem mitem, Model model, PrimaryKey[] pkeys) {
        String type;
        int i;
        StringBuilder sb = new StringBuilder();
        int _idx = name.indexOf("/");
        String cname = _idx > 0 ? name.substring(_idx + 1) : name;
        String id = AppSchemaUtil.getChildPart(mitem.getName());
        String packagename = AppSchemaUtil.getPackagename(model, this.project);
        String classname = AppSchemaUtil.getModelitemClassname(mitem);
        String mid = "_" + id;
        sb.append("        " + basetab);
        sb.append("if (cond != null && cond");
        sb.append(ProcessBeanGenerator.getterFullMethod(cname));
        sb.append(" != null) {");
        sb.append(CR);
        sb.append("            " + basetab);
        sb.append(packagename);
        sb.append(classname);
        sb.append("[] ");
        sb.append(mid);
        sb.append(" = cond");
        sb.append(ProcessBeanGenerator.getterFullMethod(cname));
        sb.append(";");
        sb.append(CR);
        sb.append("            " + basetab);
        sb.append("if (");
        sb.append(mid);
        sb.append(" != null && ");
        sb.append("_" + id);
        sb.append(".length > 0) {");
        sb.append(CR);
        sb.append("                " + basetab);
        sb.append("int size = ");
        sb.append(mid);
        sb.append(".length;");
        sb.append(CR);
        for (i = 0; i < pkeys.length; ++i) {
            type = pkeys[i].getType();
            if (type.endsWith("[]")) {
                type = type.substring(0, type.length() - "[]".length());
            }
            String _type = JavaSourceGenerator.getProperType(type);
            String arrayname = "_" + cname + "_" + pkeys[i].getName() + "_array";
            sb.append("                " + basetab);
            sb.append(_type);
            sb.append("[] ");
            sb.append(arrayname);
            sb.append(" = new ");
            sb.append(_type);
            sb.append("[size];");
            sb.append(CR);
        }
        sb.append("                " + basetab);
        sb.append("for (int i=0; i<size; i++) {");
        sb.append(CR);
        for (i = 0; i < pkeys.length; ++i) {
            String arrayname = "_" + cname + "_" + pkeys[i].getName() + "_array";
            sb.append("                    " + basetab);
            sb.append(arrayname);
            sb.append("[i] = ");
            sb.append(mid);
            sb.append("[i]");
            sb.append(JavaSourceGenerator.getterFullMethod(pkeys[i].getName()));
            sb.append(";");
            sb.append(CR);
        }
        sb.append("                " + basetab);
        sb.append("}");
        sb.append(CR);
        for (i = 0; i < pkeys.length; ++i) {
            type = pkeys[i].getType();
            if (type.endsWith("[]")) {
                type = type.substring(0, type.length() - 2);
            }
            String arrayname = "_" + cname + "_" + pkeys[i].getName() + "_array";
            String varname = cname + "_" + pkeys[i].getName();
            sb.append("                " + basetab);
            sb.append("paramMap.put(\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, varname)));
            sb.append("\", ");
            sb.append(arrayname);
            sb.append(");");
            sb.append(CR);
        }
        sb.append("            " + basetab);
        sb.append("}");
        sb.append(CR);
        sb.append("        " + basetab);
        sb.append("}");
        return sb.toString();
    }

    private String getBasicCondition(String name, String cname, String type, Condition condition, Modelitem item, boolean isStoreref, boolean isCompositeKey, String basetab) {
        StringBuilder sb = new StringBuilder();
        if (!"boolean".equals(type)) {
            sb.append("        " + basetab);
            sb.append("if (cond != null");
            if (item != null && !item.getMust() || isCompositeKey) {
                sb.append(" && cond");
                sb.append(ProcessBeanGenerator.checkFullMethod(cname));
            }
            sb.append(") {");
            sb.append(CR);
        }
        sb.append("            " + basetab);
        sb.append("paramMap.put(\"");
        sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, cname)));
        sb.append("\", ");
        sb.append(JavaSourceGenerator.b2wc(type));
        sb.append(".valueOf");
        sb.append("(");
        sb.append("cond");
        sb.append(ProcessBeanGenerator.getterFullMethod(cname));
        sb.append("));");
        if (!"boolean".equals(type)) {
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("}");
        }
        return sb.toString();
    }

    private String getCondition(String name, String cname, Condition condition, String basetab) {
        StringBuilder sb = new StringBuilder();
        sb.append("        " + basetab);
        sb.append("if (cond != null && cond");
        sb.append(ProcessBeanGenerator.getterFullMethod(cname));
        sb.append(" != null)");
        sb.append(CR);
        sb.append("            " + basetab);
        sb.append("paramMap.put(\"");
        sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getParameterMapKey(condition, cname)));
        sb.append("\", ");
        sb.append("cond");
        sb.append(ProcessBeanGenerator.getterFullMethod(cname));
        sb.append(");");
        return sb.toString();
    }

    protected String gUseCacheManager() {
        return this.gUseCacheManager("        ");
    }

    protected String gUseCacheManager(String basetab) {
        CacheType cacheType = AppSchemaUtil.getCacheType(this.project);
        if (cacheType != CacheType.Classic && cacheType != CacheType.Slim) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(basetab);
        sb.append("// " + rman.getValue("pbean.comment.usecache"));
        sb.append(CR);
        sb.append(basetab);
        sb.append(this.project.getPackage());
        sb.append(".app.");
        sb.append("CacheManager cman = ");
        sb.append(this.project.getPackage());
        sb.append(".app.");
        sb.append("CacheManager.getInstance(p);");
        sb.append(CR);
        return sb.toString();
    }

    protected static String gCacheManagerClearUpdateChoiceObj(Model model, String instance, Project project, String basetab) {
        List<String> list = ProcessBeanGenerator.getKeyCacheManagerClearUpdateChoiceObj(model, project);
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(basetab);
            sb.append(instance);
            sb.append("clearUpdateChoiceObj(");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append(s);
            sb.append(");");
            sb.append(CR);
        }
        return sb.toString();
    }

    protected static List<String> getKeyCacheManagerClearUpdateChoiceObj(Model model, Project project) {
        List<ModelAndItemPair> nlist;
        CacheType cacheType = AppSchemaUtil.getCacheType(project);
        if (cacheType != CacheType.Classic && cacheType != CacheType.Slim) {
            List<String> list = Collections.emptyList();
            return list;
        }
        ArrayList<String> list = new ArrayList<String>();
        HashSet<Model> targetModelSet = new HashSet<Model>();
        targetModelSet.add(model);
        if (StringUtils.isNotBlank((CharSequence)model.getMainmodelidref())) {
            targetModelSet.add(model);
            ProcessBeanGenerator.addSubModelWithSameParent(model.getMainmodelidref(), model, targetModelSet, project);
        }
        ProcessBeanGenerator.addSubModelWithSameParent(model.getId(), model, targetModelSet, project);
        HashSet<String> targetModelIdSet = new HashSet<String>();
        for (Model _m : targetModelSet) {
            targetModelIdSet.add(_m.getId());
        }
        ArrayList<ModelAndItemPair> clist = new ArrayList<ModelAndItemPair>();
        HashSet<CallSite> distinctSet = null;
        IProjectChoice[] ipc = project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Model smodel;
                IModelChoice[] imc;
                Model model1;
                if (!(ipc[i] instanceof Model) || !"store".equals((model1 = (Model)ipc[i]).getType()) && !"condition".equals(model1.getType()) || (imc = model1.getContent()) == null || imc.length == 0 || !(smodel = AppSchemaUtil.getStoreModel(model1)).getCache()) continue;
                for (int j = 0; j < imc.length; ++j) {
                    if (!(imc[j] instanceof Modelitem)) continue;
                    boolean useClearUpdateChoiceObjMethod = false;
                    boolean isSelfSearch = false;
                    Modelitem mitem1 = (Modelitem)imc[j];
                    if (mitem1.getGeneration()) continue;
                    Relation mitem1_rel = AppSchemaUtil.getRelationTypeExceptRef(mitem1);
                    if ("combo".equals(mitem1.getDualinputmethod()) && targetModelIdSet.contains(model1.getId())) {
                        useClearUpdateChoiceObjMethod = true;
                    } else if (mitem1.getAlloption() != null && mitem1_rel != null && mitem1_rel.getSelfsearch() && targetModelIdSet.contains(smodel.getId())) {
                        useClearUpdateChoiceObjMethod = true;
                        isSelfSearch = true;
                    } else if (mitem1_rel != null && targetModelIdSet.contains(mitem1_rel.getIdref())) {
                        useClearUpdateChoiceObjMethod = true;
                    }
                    if (useClearUpdateChoiceObjMethod && "condition".equals(model1.getType())) {
                        Model __smodel = AppSchemaUtil.getIdrefModel(model1);
                        Modelitem __s_mitem = AppSchemaUtil.getModelitem(mitem1.getName(), __smodel);
                        if (!(__s_mitem != null && AppSchemaUtil.getRelationTypeExceptRef(__s_mitem) == null || isSelfSearch)) {
                            useClearUpdateChoiceObjMethod = false;
                        } else {
                            model1 = smodel;
                        }
                    }
                    if (!useClearUpdateChoiceObjMethod) continue;
                    ModelAndItemPair pair = new ModelAndItemPair(model1, mitem1);
                    clist.add(pair);
                    if (!isSelfSearch) continue;
                    if (distinctSet == null) {
                        distinctSet = new HashSet<CallSite>();
                    }
                    distinctSet.add((CallSite)((Object)(model1.getId() + "$$$" + mitem1.getName())));
                }
            }
        }
        if (clist.size() > 0 && (nlist = ProcessBeanGenerator.chaseRef(clist, project)) != null) {
            clist.addAll(nlist);
        }
        if (clist.size() > 0) {
            for (ModelAndItemPair pair : clist) {
                Model pmodel = AppSchemaUtil.getModel(project, pair.model.getId(), "presentation");
                if (pmodel == null) continue;
                String packagename = AppSchemaUtil.getPackagename(pmodel, project);
                String targetclassname = AppSchemaUtil.getModelitemClassname(pair.mitem);
                StringBuilder sb = new StringBuilder();
                sb.append(packagename);
                sb.append(targetclassname);
                sb.append(".class.getName()");
                if ("combo".equals(pair.mitem.getDualinputmethod()) || distinctSet != null && distinctSet.contains(pair.model.getId() + "$$$" + pair.mitem.getName())) {
                    sb.append("+\"_distinct\"");
                }
                list.add(sb.toString());
            }
        }
        return list;
    }

    private static List<ModelAndItemPair> chaseRef(List<ModelAndItemPair> clist, Project project) {
        List<ModelAndItemPair> nlist2;
        ArrayList<ModelAndItemPair> nlist = null;
        for (IProjectChoice ipc : project.getContent()) {
            IModelChoice[] imc;
            Model model1;
            if (!(ipc instanceof Model) || !"store".equals((model1 = (Model)ipc).getType()) && !"condition".equals(model1.getType()) || (imc = model1.getContent()) == null || imc.length == 0) continue;
            block1: for (int i = 0; i < imc.length; ++i) {
                Relation refrel;
                Modelitem mitem1;
                if (!(imc[i] instanceof Modelitem) || !(mitem1 = (Modelitem)imc[i]).getType().equals("storeref") || (refrel = AppSchemaUtil.getRelationTypeIsRef(mitem1)) == null) continue;
                for (ModelAndItemPair pair : clist) {
                    if (!refrel.getIdref().equals(pair.model.getId()) || !refrel.getName().equals(pair.mitem.getName())) continue;
                    if (nlist == null) {
                        nlist = new ArrayList<ModelAndItemPair>();
                    }
                    nlist.add(new ModelAndItemPair(model1, mitem1));
                    continue block1;
                }
            }
        }
        if (nlist != null && (nlist2 = ProcessBeanGenerator.chaseRef(nlist, project)) != null) {
            nlist.addAll(nlist2);
        }
        return nlist;
    }

    protected static void addSubModelWithSameParent(String pid, Model parent, Set<Model> targetModelSet, Project project) {
        IProjectChoice[] ipc = project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Model model1;
                if (!(ipc[i] instanceof Model) || !"store".equals((model1 = (Model)ipc[i]).getType())) continue;
                String tablename = parent.getTablename();
                if (!pid.equals(model1.getMainmodelidref()) && (!StringUtils.isNotBlank((CharSequence)tablename) || !tablename.equals(model1.getTablename()))) continue;
                targetModelSet.add(model1);
            }
        }
    }

    protected String gEhcacheManager_remove(Model model, String instancename, String basetab) {
        CacheType cacheType = AppSchemaUtil.getCacheType(this.project);
        if (cacheType != CacheType.Classic && cacheType != CacheType.Slim) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String classname = AppSchemaUtil.getClassname(model);
        sb.append(basetab);
        sb.append("cman.remove");
        sb.append(classname);
        sb.append("(");
        sb.append(instancename);
        sb.append(");");
        sb.append(CR);
        return sb.toString();
    }

    protected static String gEhcacheManager_clear(Model model, String instance, Project project, String basetab) {
        CacheType cacheType = AppSchemaUtil.getCacheType(project);
        if (cacheType != CacheType.Classic && cacheType != CacheType.Slim) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String classname = AppSchemaUtil.getClassname(model);
        sb.append(basetab);
        sb.append(instance);
        sb.append("clear");
        sb.append(classname);
        sb.append("();");
        sb.append(CR);
        return sb.toString();
    }

    protected static String gEhcacheManager_clearCount(Model model, String instance, Project project, String basetab) {
        CacheType cacheType = AppSchemaUtil.getCacheType(project);
        if (cacheType != CacheType.Classic && cacheType != CacheType.Slim) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HashSet<Model> targetModelSet = new HashSet<Model>();
        if (model.getCache()) {
            targetModelSet.add(model);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getMainmodelidref())) {
            targetModelSet.add((Model)model.getMainmodelidrefAsIRNode());
            ProcessBeanGenerator.addSubModelWithSameParent(model.getMainmodelidref(), model, targetModelSet, project);
        }
        ProcessBeanGenerator.addSubModelWithSameParent(model.getId(), model, targetModelSet, project);
        TreeSet<String> classnameSet = new TreeSet<String>();
        for (Model m : targetModelSet) {
            if (!m.getCache()) continue;
            String classname = AppSchemaUtil.getClassname(m);
            classnameSet.add(classname);
        }
        for (String classname : classnameSet) {
            sb.append(basetab);
            sb.append(instance);
            sb.append("clear");
            sb.append(classname);
            sb.append("Count();");
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gCreateTableObjectCode(Model model, String variablename) {
        return this.gCreateTableObjectCode("            ", model, variablename);
    }

    protected String gCreateTableObjectCode(String tab, Model model, String variablename) {
        StringBuilder sb = new StringBuilder();
        String packagename = AppSchemaUtil.getPackagename(model, this.project);
        String tableclassname = this.getTableclassname(model, this.project);
        sb.append(tab);
        sb.append(packagename);
        sb.append(tableclassname);
        sb.append(" " + variablename + " =");
        sb.append(CR);
        sb.append(tab);
        sb.append("    ");
        sb.append("new ");
        sb.append(packagename);
        sb.append(tableclassname);
        sb.append("(");
        sb.append(CR);
        sb.append(tab);
        sb.append("        ");
        sb.append("con, ");
        sb.append("JFCAppTablename.");
        String tablename = TablenameGenerator.createTableVariableName(model);
        sb.append(tablename);
        sb.append(");");
        sb.append(CR);
        return sb.toString();
    }

    protected String gCreateTableObjectCode1(Model model) {
        StringBuilder sb = new StringBuilder();
        String tableclassname = this.getTableclassname(model, this.project);
        if (tableclassname.equals("MasterTable")) {
            String packagename = AppSchemaUtil.getPackagename(model, this.project);
            sb.append(packagename);
        }
        sb.append(tableclassname);
        sb.append(" table = null;");
        return sb.toString();
    }

    protected String gCreateTableObjectCode2(Model model) {
        return this.gCreateTableObjectCode2("            ", model);
    }

    protected String gCreateTableObjectCode2(String tab, Model model) {
        StringBuilder sb = new StringBuilder();
        String tableclassname = this.getTableclassname(model, this.project);
        sb.append(tab);
        sb.append("table = new ");
        if (tableclassname.equals("MasterTable")) {
            String packagename = AppSchemaUtil.getPackagename(model, this.project);
            sb.append(packagename);
        }
        sb.append(tableclassname);
        sb.append("(");
        sb.append(CR);
        sb.append(tab);
        sb.append("    ");
        sb.append("con, ");
        String tablename = TablenameGenerator.createTableVariableName(model);
        sb.append("JFCAppTablename.");
        sb.append(tablename);
        sb.append(");");
        sb.append(CR);
        return sb.toString();
    }

    protected boolean isOutputSortResultsMethod(Sort sort) {
        if (!(this instanceof ProcessBeanGenerator_showArray)) {
            return false;
        }
        if (sort == null) {
            return false;
        }
        Sortkey[] keys = sort.getSortkey();
        return keys != null && keys.length != 0;
    }

    protected boolean isCorrectOneTimeSearchResults() {
        return false;
    }

    protected boolean isCloseConintConnectionObjectForUnmodified() {
        return false;
    }

    protected String gSortResultsMethod(Sort sort, String classname) {
        StringBuilder sb = new StringBuilder();
        String[] param = new String[]{"ary"};
        sb.append(CommentGenerator.gComment(rman.getValue("pbean.comment.sortresults"), param, null));
        sb.append("    ");
        sb.append("protected static void sortResults(");
        sb.append(classname);
        sb.append("[] ary)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("java.util.Arrays.sort(ary, new java.util.Comparator() {");
        sb.append(CR);
        sb.append("            ");
        sb.append("/** " + rman.getValue("pbean.comment.compare4sort") + " */");
        sb.append(CR);
        sb.append("            ");
        sb.append("public int compare(Object o1, Object o2) {");
        sb.append(CR);
        sb.append("                ");
        sb.append(classname);
        sb.append(" obj1 = (");
        sb.append(classname);
        sb.append(")o1;");
        sb.append(CR);
        sb.append("                ");
        sb.append(classname);
        sb.append(" obj2 = (");
        sb.append(classname);
        sb.append(")o2;");
        sb.append(CR);
        sb.append("                ");
        sb.append("int value;");
        sb.append(CR);
        sb.append(CR);
        Model _model = this.getStoreModel();
        Sortkey[] keys = sort.getSortkey();
        if (keys != null) {
            for (int j = 0; j < keys.length; ++j) {
                String content = keys[j].getContent();
                boolean reverse = keys[j].getReverse() || sort.getReverse();
                String GetValueObj1 = "obj1.get" + SourceGenerator.capFirst(content) + "()";
                String GetValueObj2 = "obj2.get" + SourceGenerator.capFirst(content) + "()";
                Modelitem modelitem = this.getModelitem(_model, content);
                String javatype = "[unknown modelitem]";
                boolean isMultiple = false;
                if (modelitem != null) {
                    javatype = this.getJavaType(null, modelitem);
                    if (javatype == null) {
                        javatype = "[unknown java type]";
                    }
                    isMultiple = this.isMultiple(modelitem);
                }
                sb.append("                ");
                sb.append("// ");
                sb.append(content);
                sb.append(" : ");
                sb.append(javatype);
                if (isMultiple) {
                    sb.append("[]");
                }
                sb.append(CR);
                sb.append("                ");
                sb.append("value = CompareUtil.compare(");
                sb.append(GetValueObj1);
                sb.append(", ");
                sb.append(GetValueObj2);
                sb.append(");");
                sb.append(CR);
                sb.append("                ");
                sb.append("if (value != 0) return ");
                if (reverse) {
                    sb.append("-");
                }
                sb.append("value;");
                sb.append(CR);
                sb.append(CR);
            }
        }
        sb.append("                ");
        sb.append("return 0;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("});");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected Modelitem getModelitem(Model _model, String name) {
        if (_model == null) {
            return null;
        }
        IModelChoice[] imc = _model.getContent();
        if (imc == null) {
            return null;
        }
        for (int j = 0; j < imc.length; ++j) {
            Modelitem _mitem;
            if (imc[j] == null || !(imc[j] instanceof Modelitem) || !(_mitem = (Modelitem)imc[j]).getName().equals(name)) continue;
            return _mitem;
        }
        return null;
    }

    protected String getJavaType(String type, Modelitem _mitem) {
        if (type == null) {
            type = _mitem.getType();
        }
        if ("storeref".equals(type)) {
            type = AppSchemaUtil.getModelitemType(this.project, this.getStoreModelId(), _mitem, "roleid");
        }
        if (type != null && type.trim().endsWith("[]")) {
            String _type = type.trim();
            int index = _type.lastIndexOf("[]");
            return this.getJavaType0(_type.substring(0, index)) + "[]";
        }
        return this.getJavaType0(type);
    }

    protected String getJavaType0(String type) {
        if ("string".equalsIgnoreCase(type)) {
            return "java.lang.String";
        }
        if ("date".equals(type)) {
            return "java.sql.Date";
        }
        if ("time".equals(type)) {
            return "java.sql.Time";
        }
        if ("dateTime".equals(type)) {
            return "java.sql.Timestamp";
        }
        if ("masterref".equals(type)) {
            return "int";
        }
        if ("zipcode".equals(type)) {
            return "java.lang.String";
        }
        return type;
    }

    protected boolean isMultiple(Modelitem _mitem) {
        return _mitem.getMultiple();
    }

    protected String gMainMethod() {
        StringBuilder sb = new StringBuilder();
        String[] param = new String[]{"args"};
        sb.append(CommentGenerator.gComment(rman.getValue("pbean.comment.main"), param, null));
        sb.append("    ");
        sb.append("public static void main(String[] args) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p = null;");
        sb.append(CR);
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        sb.append("            ");
        sb.append("p = DbProcessBean.createActionParameter(");
        sb.append("args[0], args[1]);");
        sb.append(CR);
        sb.append("        ");
        sb.append("} catch (ArrayIndexOutOfBoundsException e) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("System.err.println(\"");
        sb.append(StringUtil.convertJavaString((String)rman.getValue("pbean.comment.main.usage")));
        sb.append("\");");
        sb.append(CR);
        sb.append("            ");
        sb.append("System.exit(1);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (p == null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("System.err.println(\"");
        sb.append(StringUtil.convertJavaString((String)rman.getValue("pbean.comment.main.paramerror")));
        sb.append("\");");
        sb.append(CR);
        sb.append("            ");
        sb.append("System.exit(1);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("// ");
        sb.append(rman.getValue("pbean.comment.main.newpbean"));
        sb.append(CR);
        sb.append("        ");
        sb.append("DbProcessBean pbean = new ");
        sb.append(this.getClassname());
        sb.append("(p);");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("// ");
        sb.append(rman.getValue("pbean.comment.main.setparam"));
        sb.append(CR);
        sb.append("        ");
        sb.append("pbean.prepare_test();");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("// ");
        sb.append(rman.getValue("pbean.comment.main.do_test"));
        sb.append(CR);
        sb.append("        ");
        sb.append("Object o = pbean.run();");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("// ");
        sb.append(rman.getValue("pbean.comment.main.release"));
        sb.append(CR);
        sb.append("        ");
        sb.append("pbean.release();");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("System.out.println(o);");
        sb.append(CR);
        sb.append("        ");
        sb.append("System.out.println(\"");
        sb.append(StringUtil.convertJavaString((String)rman.getValue("pbean.comment.main.finish")));
        sb.append("\");");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String getPrimaryKeyVariableName(PrimaryKey pkey) {
        return "_" + AppSchemaUtil.createFullPrimaryKeyName(pkey);
    }

    protected String gLogParam4InternalControl() {
        StringBuilder sb = new StringBuilder();
        sb.append("        ").append("outputConditionToLog(paramMap, logger);").append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String getModelVariableName(Model model) {
        String id = model.getId();
        return "_" + id;
    }

    protected String getRefModelVariableName(Model model) {
        String id = model.getId();
        return "__" + id;
    }

    protected void gRunMethod0_getIndexer(Model model, StringBuilder sb) {
        sb.append(CommentGenerator.gComment(rman.getValue("pbean.comment.textsearch.getindexdir"), null, null));
        sb.append("    ");
        sb.append("public Indexer getIndexer() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
        sb.append(".getIndexer(p);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("public String getIndexModelId() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
        sb.append(".getIndexModelId();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private static class ModelAndItemPair {
        Model model;
        Modelitem mitem;

        public ModelAndItemPair(Model model, Modelitem mitem) {
            this.model = model;
            this.mitem = mitem;
        }
    }
}

