/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGeneratorDownloadHibernate;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_aggregate_getCount;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_aggregate_getCountUpdateList;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_aggregate_updateList;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_delete;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_download;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_empty;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_free;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getAvg;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getAvgUpdateList;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getBranchNumber;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getCount;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getMax;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getMaxUpdateList;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getMin;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getMinUpdateList;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getSum;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_getSumUpdateList;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_insert;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_show;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_showArray;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_showList;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_showListCalendarview;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_showListFull;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_showListMaster;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_update;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_uploadUpdate;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Aggregatelist;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessBeanGeneratorFactory
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)ProcessBeanGeneratorFactory.class.getName());
    protected static ResourceManager rman;

    public static ProcessBeanGenerator create(Project project, Action action) {
        String type = action != null ? action.getType() : null;
        String id = action != null ? action.getIdref() : null;
        return ProcessBeanGeneratorFactory.create(project, action, id, type);
    }

    public static ProcessBeanGenerator create(Project project, String id, String type) {
        return ProcessBeanGeneratorFactory.create(project, null, id, type);
    }

    public static ProcessBeanGenerator create(Project project, Action action, String id, String type) {
        if (action == null && id != null && type != null) {
            action = AppSchemaUtil.getActionByModelIdAndType(project, id, type);
        }
        if (type == null && action != null) {
            type = action.getType();
        }
        if (id == null && action != null) {
            id = action.getIdref();
        }
        if (type == null || type.length() == 0) {
            logger.warn(rman.getValue("value.null.action.type", action != null ? action.getId() : "null"));
            logger.warn(rman.getValue("pbean.comment.skip"));
            return null;
        }
        if (id == null || id.length() == 0) {
            logger.warn(rman.getValue("pbean.factory.null.id"));
            logger.warn(rman.getValue("pbean.comment.skip"));
            return null;
        }
        Model smodel = null;
        if (action != null && ((smodel = (Model)action.getIdrefAsIRNode()) == null || smodel != null && "static".equals(smodel.getStorage()))) {
            return null;
        }
        ProcessBeanGenerator gen = null;
        if (type.endsWith("-master")) {
            type = type.substring(0, type.length() - "-master".length());
        }
        if ("show".equals(type)) {
            gen = new ProcessBeanGenerator_show(project, id, type, action);
        } else if ("showArray".equals(type)) {
            gen = new ProcessBeanGenerator_showArray(project, id, type, action);
        } else if ("showList".equals(type)) {
            if (smodel != null && smodel.getType().equals("master")) {
                gen = new ProcessBeanGenerator_showListMaster(project, id, type, action);
            } else if (action != null && "calendar".equals(action.getView())) {
                gen = new ProcessBeanGenerator_showListCalendarview(project, id, type, action);
            } else if (action != null && action.getId().startsWith("restrictedList")) {
                if (AppSchemaUtil.hasRestrictedListProcessBean(project, action.getId())) {
                    gen = new ProcessBeanGenerator_showList(project, id, type, action);
                }
            } else {
                gen = new ProcessBeanGenerator_showList(project, id, type, action);
            }
        } else if ("showListFull".equals(type)) {
            gen = new ProcessBeanGenerator_showListFull(project, id, "showList", action);
        } else if ("insert".equals(type) || "copy".equals(type)) {
            gen = new ProcessBeanGenerator_insert(project, id, type, action);
        } else if ("update".equals(type)) {
            gen = new ProcessBeanGenerator_update(project, id, type, action);
        } else if ("delete".equals(type)) {
            gen = new ProcessBeanGenerator_delete(project, id, type, action);
        } else if ("free".equals(type)) {
            gen = new ProcessBeanGenerator_free(project, id, type, action);
        } else if ("jobentry".equals(type) || "jobentryList".equals(type)) {
            gen = new ProcessBeanGenerator_empty(project, id, type, action);
        } else if ("download".equals(type)) {
            String storage = smodel.getStorage();
            int storagetype = AppSchemaUtil.getStorageType(storage);
            gen = storagetype == 5 ? new ProcessBeanGeneratorDownloadHibernate(project, id, type, action) : new ProcessBeanGenerator_download(project, id, type, action);
        } else if ("empty".equals(type)) {
            gen = new ProcessBeanGenerator_empty(project, id, type, action);
        } else if ("uploadUpdate".equals(type)) {
            gen = new ProcessBeanGenerator_uploadUpdate(project, id, type, action);
        } else if ("getCount".equals(type)) {
            gen = new ProcessBeanGenerator_getCount(project, id, type, action);
        } else if ("getAvg".equals(type)) {
            gen = action.getUpdatelist() ? new ProcessBeanGenerator_getAvgUpdateList(project, id, type, action) : new ProcessBeanGenerator_getAvg(project, id, type, action);
        } else if ("getMax".equals(type)) {
            gen = action.getUpdatelist() ? new ProcessBeanGenerator_getMaxUpdateList(project, id, type, action) : new ProcessBeanGenerator_getMax(project, id, type, action);
        } else if ("getMin".equals(type)) {
            gen = action.getUpdatelist() ? new ProcessBeanGenerator_getMinUpdateList(project, id, type, action) : new ProcessBeanGenerator_getMin(project, id, type, action);
        } else if ("getSum".equals(type)) {
            gen = action.getUpdatelist() ? new ProcessBeanGenerator_getSumUpdateList(project, id, type, action) : new ProcessBeanGenerator_getSum(project, id, type, action);
        } else if ("aggregate_getCount".equals(type)) {
            gen = action.getUpdatelist() ? new ProcessBeanGenerator_aggregate_getCountUpdateList(project, id, type, action) : new ProcessBeanGenerator_aggregate_getCount(project, id, type, action);
        } else if ("getBranch".equals(type)) {
            gen = new ProcessBeanGenerator_getBranchNumber(project, id, type, action);
        }
        return gen;
    }

    public static ProcessBeanGenerator_aggregate_updateList createAggreagteUpdateListProcessBean(Project project, Action action, String id, Aggregatelist alist) {
        String type;
        String atype = alist.getType();
        if (atype.equals("avg")) {
            type = "getAvg";
        } else if (atype.equals("max")) {
            type = "getMax";
        } else if (atype.equals("min")) {
            type = "getMin";
        } else if (atype.equals("sum")) {
            type = "getSum";
        } else if (atype.equals("count")) {
            type = "aggregate_getCount";
        } else {
            return null;
        }
        ProcessBeanGenerator_showList gen = null;
        if ("getAvg".equals(type)) {
            gen = new ProcessBeanGenerator_getAvgUpdateList(project, id, type, action);
        } else if ("getMax".equals(type)) {
            gen = new ProcessBeanGenerator_getMaxUpdateList(project, id, type, action);
        } else if ("getMin".equals(type)) {
            gen = new ProcessBeanGenerator_getMinUpdateList(project, id, type, action);
        } else if ("getSum".equals(type)) {
            gen = new ProcessBeanGenerator_getSumUpdateList(project, id, type, action);
        } else if ("aggregate_getCount".equals(type)) {
            gen = new ProcessBeanGenerator_aggregate_getCountUpdateList(project, id, type, action);
        }
        return gen;
    }
}

