/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.Arrays;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ExpressionGenerator;
import jp.jasminesoft.jfc.gen.ExpressionGenerator_Hibernate;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_showList;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Aggregateitem;
import jp.jasminesoft.jfc.gen.appschema.Aggregatelist;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Sort;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ProcessBeanGenerator_aggregate
extends ProcessBeanGenerator_showList {
    protected static Logger logger = LogManager.getLogger((String)ProcessBeanGenerator_aggregate.class.getName());
    protected static final String ResultsType_Number = "Number";
    protected static final String ResultsType_Object = "Object";

    public ProcessBeanGenerator_aggregate(Project project, String id, String type, Action action) {
        super(project, id, type, action);
    }

    protected abstract String getAggregateType();

    protected String getResultsType() {
        return ResultsType_Number;
    }

    protected String[] getAggregateTypes() {
        String[] types = new String[]{this.getAggregateType()};
        return types;
    }

    protected String[] getResultsTypes() {
        String[] types = new String[]{this.getResultsType()};
        return types;
    }

    @Override
    public String getClassname() {
        return ProcessBeanGenerator_aggregate.getClassname(this.action, this.getAggregateType());
    }

    public static String getClassname(Action action, String aggregate_type) {
        if (!Arrays.asList(AppSchemaUtil.getAggregateTypeList()).contains(aggregate_type)) {
            return null;
        }
        return "Get" + JavaSourceGenerator.capFirst(aggregate_type) + AppSchemaUtil.createProcessBeanName(action, null);
    }

    @Override
    protected String gSuccessReturnCode() {
        StringBuilder sb = new StringBuilder();
        if (this.storagetype == 5) {
            String[] types = this.getAggregateTypes();
            if (types.length == 1) {
                sb.append("        ");
                sb.append("return results_" + types[0] + ";");
                sb.append(CR);
            } else {
                sb.append("        ");
                sb.append("Map<String,Map<String,Object>> results = new Map<String,Map<String,Object>>();");
                sb.append(CR);
                for (String type : types) {
                    sb.append("        ");
                    sb.append("results.put(\"" + type + "\", results_" + type + ");");
                    sb.append(CR);
                }
                sb.append("        ");
                sb.append("return results;");
                sb.append(CR);
            }
        } else {
            logger.error("non support");
        }
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected boolean isSort(Sort sort) {
        return false;
    }

    @Override
    protected String gCreateListInstanceCodeForHibernate(Model model, boolean isCorrectOneTimeSearchResults, boolean isOutputSortResultsMethod) {
        StringBuilder sb = new StringBuilder();
        String[] types = this.getAggregateTypes();
        String[] resultstypes = this.getResultsTypes();
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            String resultstype = resultstypes[i];
            sb.append("        ");
            sb.append("Map<String," + resultstype + "> results_" + type + " = null;");
            sb.append(CR);
        }
        return sb.toString();
    }

    protected Aggregatelist getAggregatelist(String type) {
        Aggregatelist aggregatelist = AppSchemaUtil.getAggregatelist(this.action, type);
        return aggregatelist;
    }

    @Override
    protected String gSearchTryCodeForHibernate(Model model, Sort sort, boolean isCorrectOneTimeSearchResults, boolean isOutputSortResultsMethod, boolean isExistsCreateExpressionMethod, boolean isFirstFlag, String basetab) {
        StringBuilder sb = new StringBuilder();
        String sessionFactoryBeanId = new StoreModel(model).sessionFactoryBeanId();
        if (isFirstFlag) {
            sb.append(basetab);
            sb.append("String expression = null;");
            sb.append(CR);
            sb.append(basetab);
            if (!"sessionFactory".equals(sessionFactoryBeanId)) {
                sb.append("org.hibernate.Session session");
                sb.append(CR);
                sb.append(basetab + "        ");
                sb.append("= HibernateUtil.openSession(\"");
                sb.append(sessionFactoryBeanId);
                sb.append("\", p);");
            } else {
                sb.append("org.hibernate.Session session = HibernateUtil.openSession();");
            }
            sb.append(CR);
        } else {
            sb.append(basetab);
            sb.append("expression = null;");
            sb.append(CR);
            sb.append(basetab);
            if (!"sessionFactory".equals(sessionFactoryBeanId)) {
                sb.append("session = HibernateUtil.openSession(\"");
                sb.append(sessionFactoryBeanId);
                sb.append("\", p);");
            } else {
                sb.append("session = HibernateUtil.openSession();");
            }
            sb.append(CR);
        }
        sb.append(basetab);
        sb.append("try {");
        sb.append(CR);
        if (isExistsCreateExpressionMethod) {
            sb.append(this.gCallCreateExpressionMethod(basetab));
            sb.append(CR);
        } else {
            sb.append(basetab + "    ");
            sb.append("expression = \"");
            sb.append(this.createExpressionHeader());
            sb.append("\";");
            sb.append(CR);
        }
        sb.append(basetab + "    ");
        sb.append("Query query = createQuery(session, expression");
        if (isExistsCreateExpressionMethod) {
            sb.append(", paramMap");
        }
        sb.append(");");
        sb.append(CR);
        String[] types = this.getAggregateTypes();
        String[] resultstypes = this.getResultsTypes();
        if (types.length == 1) {
            String type = types[0];
            Aggregatelist aggregatelist = this.getAggregatelist(type);
            if (aggregatelist == null || aggregatelist.getAggregateitem() == null || aggregatelist.getAggregateitem().length == 0) {
                Object[] o = new Object[]{this.action.getId(), type, this.getClassname()};
                logger.error(rman.getValue("pbean.errmsg.action.aggregateitem.null", o));
                return null;
            }
            Aggregateitem[] aggregateitems = aggregatelist.getAggregateitem();
            if (aggregateitems.length == 1) {
                sb.append(basetab + "    ");
                sb.append("Object result0 = (Object)query.uniqueResult();");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("results_" + type + " = new HashMap<String," + resultstypes[0] + ">();");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("if (result0 != null");
                if (!resultstypes[0].equals(ResultsType_Object)) {
                    sb.append(" && result0 instanceof " + resultstypes[0]);
                }
                sb.append(") {");
                sb.append(CR);
                sb.append(basetab + "        ");
                sb.append("results_" + type + ".put(\"" + aggregateitems[0].getName() + "\", ");
                if (!resultstypes[0].equals(ResultsType_Object)) {
                    sb.append("(" + resultstypes[0] + ")");
                }
                sb.append("result0);");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("}");
                sb.append(CR);
                sb.append(CR);
                return sb.toString();
            }
        }
        sb.append(basetab + "    ");
        sb.append("Object[] result0 = (Object[])query.uniqueResult();");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("int cnt = 0;");
        sb.append(CR);
        sb.append(CR);
        for (int j = 0; j < types.length; ++j) {
            String type = types[j];
            String resultstype = resultstypes[j];
            Aggregatelist aggregatelist = this.getAggregatelist(type);
            if (aggregatelist == null || aggregatelist.getAggregateitem() == null || aggregatelist.getAggregateitem().length == 0) {
                Object[] o = new Object[]{this.action.getId(), type, this.getClassname()};
                logger.error(rman.getValue("pbean.errmsg.action.aggregateitem.null", o));
                return null;
            }
            Aggregateitem[] aggregateitems = aggregatelist.getAggregateitem();
            sb.append(basetab + "    ");
            sb.append("results_" + type + " = new HashMap<String," + resultstype + ">();");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("if (result0 != null) {");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("final String[] names_" + type + " = {");
            for (int i = 0; i < aggregateitems.length; ++i) {
                sb.append("\"");
                sb.append(aggregateitems[i].getName());
                sb.append("\"");
                if (i == aggregateitems.length - 1) continue;
                sb.append(", ");
            }
            sb.append("};");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("for (int i=0; i<names_" + type + ".length; i++) {");
            sb.append(CR);
            if (!resultstype.equals(ResultsType_Object)) {
                sb.append(basetab + "            ");
                sb.append("if (result0[cnt] instanceof " + resultstype + ") {");
                sb.append(CR);
                sb.append(basetab + "                ");
                sb.append("results_" + type + ".put(names_" + type + "[i], (" + resultstype + ")result0[cnt]);");
                sb.append(CR);
                sb.append(basetab + "            ");
                sb.append("}");
                sb.append(CR);
            } else {
                sb.append(basetab + "            ");
                sb.append("results_" + type + ".put(names_" + type + "[i], result0[cnt]);");
                sb.append(CR);
            }
            sb.append(basetab + "            ");
            sb.append("cnt++;");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    @Override
    protected String gSearchCatchCodeForHibernate(boolean isCorrectOneTimeSearchResults, boolean isOutputSortResultsMethod, boolean isExistsCreateExpressionMethod, String basetab) {
        StringBuilder sb = new StringBuilder();
        sb.append(basetab);
        sb.append("} catch (Exception e) {");
        sb.append(CR);
        sb.append(this.gSearchCatchCode_ErrorMessage(isCorrectOneTimeSearchResults, isOutputSortResultsMethod, isExistsCreateExpressionMethod, basetab));
        return sb.toString();
    }

    @Override
    protected String gSearchFinallyCode_end(boolean isCorrectOneTimeSearchResults, boolean isOutputSortResultsMethod, boolean isExistsCreateExpressionMethod, String basetab) {
        StringBuilder sb = new StringBuilder();
        if (this.storagetype == 5) {
            sb.append(basetab);
            sb.append("session.close();");
            sb.append(CR);
        }
        return sb.toString();
    }

    @Override
    protected void gCreateExpressionMethod(StringBuilder sb, ExpressionGenerator generator) {
        if (generator instanceof ExpressionGenerator_Hibernate) {
            ExpressionGenerator_Hibernate generator_hibernate = (ExpressionGenerator_Hibernate)generator;
            generator_hibernate.setExpressionHeaderType(3);
            generator_hibernate.setExpressionHeader(this.createExpressionHeader());
        }
        super.gCreateExpressionMethod(sb, generator);
    }

    protected String createExpressionHeader() {
        String[] types;
        if (this.action == null) {
            Object[] o = new Object[]{this.getClassname()};
            logger.error(rman.getValue("pbean.errmsg.action.null", o));
            return null;
        }
        Model smodel = this.getStoreModel();
        String id_alias = AppSchemaUtil.createHqlAliasName(smodel.getId());
        String classname = AppSchemaUtil.getClassname(smodel);
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        boolean isfirst = true;
        for (String type : types = this.getAggregateTypes()) {
            Aggregatelist aggregatelist = this.getAggregatelist(type);
            if (aggregatelist == null || aggregatelist.getAggregateitem() == null || aggregatelist.getAggregateitem().length == 0) {
                Object[] o = new Object[]{this.action.getId(), this.getAggregateType(), this.getClassname()};
                logger.error(rman.getValue("pbean.errmsg.action.aggregateitem.null", o));
                return null;
            }
            Aggregateitem[] aggregateitems = aggregatelist.getAggregateitem();
            for (int i = 0; i < aggregateitems.length; ++i) {
                if (isfirst) {
                    isfirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(type);
                sb.append("(");
                sb.append(AppSchemaUtil.getProperColumnName(aggregateitems[i].getName(), smodel, this.project));
                sb.append(")");
            }
        }
        sb.append(" from ");
        sb.append(classname);
        sb.append(" as ");
        sb.append(id_alias);
        return sb.toString();
    }

    @Override
    protected boolean isShowListReturnType_ResultListWrapper() {
        return false;
    }
}

