/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.LinkedHashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.appschema.Model;

public class RelatedModelNode {
    private Model model;
    private Map<String, RelatedModelNode> parentMap;

    public RelatedModelNode(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public void addParent(Model parent) {
        if (this.parentMap == null) {
            this.parentMap = new LinkedHashMap<String, RelatedModelNode>();
        }
        if (!this.parentMap.containsKey(parent.getId())) {
            this.parentMap.put(parent.getId(), new RelatedModelNode(parent));
        }
    }

    public int size() {
        return this.parentMap != null ? this.parentMap.size() : 0;
    }

    public RelatedModelNode[] getParentNode() {
        if (this.parentMap == null) {
            return new RelatedModelNode[0];
        }
        return this.parentMap.values().toArray(new RelatedModelNode[0]);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RelatedModelNode)) {
            return false;
        }
        RelatedModelNode node = (RelatedModelNode)o;
        return this.model.getId().equals(node.model.getId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append(this.model.getId()).append(" ");
        if (this.parentMap != null) {
            for (RelatedModelNode parent_node : this.parentMap.values()) {
                sb.append(parent_node);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

