/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RelaxSchemaBaseGenerator
extends RelaxSchemaGenerator {
    protected Model model;
    protected Set elementSet;
    protected StringBuilder esb;
    protected String dbtype;
    protected Logger logger = LogManager.getLogger((String)RelaxSchemaBaseGenerator.class.getName());

    public RelaxSchemaBaseGenerator(Project project, Model model) {
        super(project);
        this.model = model;
        this.elementSet = new HashSet();
        this.esb = new StringBuilder();
        this.dbtype = DbTypeManager.getType(project.getEnvironment());
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gStartRootElement());
        sb.append(this.gRelaxSchemaMethod());
        sb.append(this.gFinishRootElement());
        return sb.toString();
    }

    @Override
    public String getFilename() {
        return this.model.getId();
    }

    @Override
    public String getSubpackageName() {
        return "model" + File.separator + this.getFilename();
    }

    protected String gHeader() {
        StringBuilder sb = new StringBuilder();
        String enc = JavaSourceGenerator.getEncoding(this.project);
        sb.append("<?xml version=\"1.0\" encoding=\"" + enc + "\" ?>");
        sb.append(CR);
        sb.append(this.rsman.gHeader());
        return sb.toString();
    }

    public String gStartRootElement() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rsman.gStartRootElement(this.model));
        return sb.toString();
    }

    public String gFinishRootElement() {
        return this.rsman.gFinishRootElement();
    }

    public void registName(String refname) {
        this.elementSet.add(refname);
    }

    public boolean isUsedName(String refname) {
        boolean b = this.elementSet.contains(refname);
        if (b) {
            this.esb.append("  ");
            this.esb.append("<!-- ");
            this.esb.append(refname);
            this.esb.append(" has already been declared. -->");
            this.esb.append(CR);
        }
        this.elementSet.add(refname);
        return b;
    }

    public String listSkippedElementName() {
        return this.esb.toString();
    }

    public boolean isPrimaryKeyByModelitemName(String modelitemname, PrimaryKey[] pkeys) {
        boolean ret = false;
        if (modelitemname == null || modelitemname.length() == 0 || pkeys == null || pkeys.length == 0) {
            return ret;
        }
        for (int i = 0; i < pkeys.length; ++i) {
            if (!modelitemname.equals(pkeys[i].getName())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean isChildElementByModelitemName(String modelitemname) {
        int index = modelitemname.indexOf("/");
        return index >= 0;
    }

    public String getRefnameByModelitemName(String modelitemname) {
        return this.getElemnameByModelitemName(modelitemname);
    }

    public String getElemnameByModelitemName(String modelitemname) {
        int index = modelitemname.lastIndexOf("/");
        if (index < 0) {
            return modelitemname;
        }
        return modelitemname.substring(index + 1);
    }

    public String getParentModelitemNameByModelitemName(String modelitemname) {
        int index = modelitemname.lastIndexOf("/");
        if (index < 0) {
            return null;
        }
        return modelitemname.substring(0, index);
    }

    public String getParentRefnameByModelitemName(String modelitemname) {
        return this.getParentElemnameByModelitemName(modelitemname);
    }

    public String getParentElemnameByModelitemName(String modelitemname) {
        String pmodelitemname = this.getParentModelitemNameByModelitemName(modelitemname);
        if (pmodelitemname == null) {
            return null;
        }
        return this.getElemnameByModelitemName(pmodelitemname);
    }

    protected String gSqlDataType(String type) {
        String ret = null;
        return ret;
    }

    protected boolean setUnderCondition(String type, Modelitem item, boolean origValue) {
        return origValue;
    }

    @Override
    public String getModelPackageName() {
        return this.model.getPackage();
    }

    protected abstract String gRelaxSchemaMethod();
}

