/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaListGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaTotalGeneratorUtil;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.View;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelaxSchemaTotalGenerator
extends RelaxSchemaListGenerator {
    protected Logger logger = LogManager.getLogger((String)RelaxSchemaTotalGenerator.class.getName());
    protected View view = null;

    public RelaxSchemaTotalGenerator(Project project, Model model) {
        super(project, model);
        this.view = RelaxSchemaTotalGeneratorUtil.getTotalView(project, model);
        if (this.view == null) {
            this.logger.error(this.rman.getValue("relax.notfound.totalaction", model.getId()));
        }
    }

    @Override
    protected boolean setUnderCondition(String type, Modelitem sitem, boolean origValue) {
        if (type == null || type.length() == 0 || !"multiple".equals(type)) {
            return origValue;
        }
        return RelaxSchemaTotalGeneratorUtil.isMajorAndMasterrefItem(this.view, sitem);
    }

    @Override
    protected String createChildSchema(String refname, String elemname, String classname, String type, boolean isPrimarykeyFlag, boolean isMasterFlag, boolean isStorerefFlag, boolean isAutodefaultFlag, boolean isMultipleFlag, boolean isUniqueFlag, String defaultValue, String sqlDataType, String option, boolean isDimension, boolean isMajor) {
        StringBuilder sb = new StringBuilder();
        if (this.isUsedName(refname)) {
            return sb.toString();
        }
        if (isMasterFlag && isMajor) {
            sb.append(this.rsman.gTotal_refElement("  ", refname, elemname, "int", defaultValue, classname, option));
        } else if (isStorerefFlag && isMajor) {
            sb.append(this.rsman.gTotal_refElement("  ", refname, elemname, type, defaultValue, classname, option));
        } else {
            if (isMajor && JavaSourceGenerator.isBasicType(type)) {
                if ("byte".equals(type) || "short".equals(type) || "char".equals(type) || "int".equals(type) || "long".equals(type)) {
                    type = "long";
                } else if ("float".equals(type) || "double".equals(type)) {
                    type = "double";
                }
            }
            sb.append(this.rsman.gStoreElement("  ", refname, elemname, classname, type, defaultValue, isMasterFlag, isPrimarykeyFlag, isUniqueFlag, isAutodefaultFlag, isMultipleFlag, this.gSqlDataType(sqlDataType), option));
        }
        return sb.toString();
    }

    @Override
    protected boolean checkDimension(String name) {
        if (this.view == null || name == null) {
            return false;
        }
        Item[] items = this.view.getItem();
        if (items == null || items.length == 0) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if (!"dimension".equals(item.getName()) || !name.equals(item.getContent())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkMajor(String name) {
        if (this.view == null || name == null) {
            return false;
        }
        Item[] items = this.view.getItem();
        if (items == null || items.length == 0) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if (!"major".equals(item.getName()) || !name.equals(item.getContent())) continue;
            return true;
        }
        return false;
    }
}

