/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.ReportListServiceImplGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Datalist;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Print;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportListServiceGenerator {
    protected static Logger logger = LogManager.getLogger((String)ReportListServiceGenerator.class.getName());
    protected Project project;
    protected Map<String, List<Action>> actionMap;

    public ReportListServiceGenerator(Project project) {
        this.project = project;
        this.actionMap = this.checkAction(project);
    }

    private Map<String, List<Action>> checkAction(Project project) {
        LinkedHashMap<String, List<Action>> map = new LinkedHashMap<String, List<Action>>();
        if (project == null) {
            return map;
        }
        IProjectChoice[] ipc = project.getContent();
        if (ipc == null) {
            return map;
        }
        for (int i = 0; i < ipc.length; ++i) {
            Model model;
            Print[] prints;
            Action action;
            if (!(ipc[i] instanceof Action) || !"showList".equals((action = (Action)ipc[i]).getType()) || (prints = AppSchemaUtil.getPrint(action)) == null || prints.length == 0 || (model = ReportListServiceGenerator.getDataitemIdrefModel(action)) == null || ReportListServiceImplGenerator.getScreentype(action) == null) continue;
            ArrayList<Action> actions = (ArrayList<Action>)map.get(action.getIdref());
            if (actions == null) {
                actions = new ArrayList<Action>();
                map.put(action.getIdref(), actions);
            }
            actions.add(action);
        }
        return map;
    }

    public static Model getDataitemIdrefModel(Action action) {
        Datalist datalist = AppSchemaUtil.getDatalist(action);
        if (datalist == null) {
            return null;
        }
        Dataitem[] dataitems = datalist.getDataitem();
        if (dataitems == null || dataitems.length == 0) {
            return null;
        }
        Dataitem dataitem = dataitems[0];
        IRNode node = dataitem.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            return null;
        }
        return (Model)node;
    }

    public Map<String, List<Action>> getActionMap() {
        return Collections.unmodifiableMap(this.actionMap);
    }

    public void process() {
        for (String modelid : this.actionMap.keySet()) {
            ReportListServiceImplGenerator gen = new ReportListServiceImplGenerator(this.project, modelid, this.actionMap.get(modelid));
            gen.process();
        }
    }

    public ApplicationContextBean getApplicationContextBean(String modelid) {
        List<Action> list = this.actionMap.get(modelid);
        if (list == null) {
            return null;
        }
        ReportListServiceImplGenerator gen = new ReportListServiceImplGenerator(this.project, modelid, list);
        return gen.getApplicationContextBean();
    }
}

