/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.appschema.ConnectionInterface;
import jp.jasminesoft.jfc.gen.appschema.ConnectionInterfaceParam;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerXmlGenerator
extends ConfigGenerator {
    private static final Logger logger = LogManager.getLogger(ServerXmlGenerator.class);
    public static final String TOMCAT_DEFAULT_HTTPPORT = "8080";
    public static final String TOMCAT_DEFAULT_AJP13PORT = "8009";
    public static final String TOMCAT_DEFAULT_SERVERPORT = "8005";
    public static final String TOMCAT_DEFAULT_REDIRECTPORT = "8443";
    public static final String TOMCAT_DEFAULT_MAXHTTPHEADERSIZE = "8192";
    public static final String TOMCAT_DEFAULT_MAXPARAMETERCOUNT = "20000";
    private static final String AJP13_DISABLE_SECRET_REQUIRED = "secretRequired=\"false\"";
    private static final String COMMENTOUT_BEGIN = "<!--";
    private static final String COMMENTOUT_END = "-->";

    public ServerXmlGenerator(String tmplatefilename, Project project) {
        super(tmplatefilename, project);
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "server";
    }

    @Override
    public String getSubpackageName() {
        return "conf";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        ServerXmlGenerator.addContent(this.project, tplman);
        return tplman.getResult();
    }

    static void addContent(Project project, FileTemplateManager tplman) {
        tplman.addContent("jfcappname", project.getName());
        String httpport = TOMCAT_DEFAULT_HTTPPORT;
        String httpportCommentoutBegin = "";
        String httpportCommentoutEnd = "";
        String ajp13port = TOMCAT_DEFAULT_AJP13PORT;
        String ajp13portCommentoutBegin = "";
        String ajp13portCommentoutEnd = "";
        Object ajp13attr = AJP13_DISABLE_SECRET_REQUIRED;
        String serverport = TOMCAT_DEFAULT_SERVERPORT;
        Object servershutdown = null;
        String redirectport = TOMCAT_DEFAULT_REDIRECTPORT;
        String maxHttpHeaderSize = null;
        String maxParameterCount = null;
        Object maxPostSizeAttr = "";
        String driver = "org.hsqldb.jdbcDriver";
        String url = "jdbc:hsqldb:sampledb";
        String user = "sa";
        String pwd = "";
        int maxActive = 30;
        int maxIdle = 10;
        int maxWait = 5000;
        String validationQuery = null;
        String connectionInitSqls = null;
        String path = AppSchemaUtil.getWebappUrl(project);
        String docBase = AppSchemaUtil.getWebappName(project);
        Object logfilename = AppSchemaUtil.isRootDeployment(project) ? "" : project.getName() + "_";
        Environment env = project.getEnvironment();
        if (env != null) {
            String maxPostSize;
            String ajp13secret;
            int port;
            Database db = AppSchemaUtil.getDatabase(env);
            if (db != null) {
                driver = db.getDriver();
                url = db.getUrl();
                user = db.getUser();
                pwd = db.getPassword();
                maxActive = db.getMaxActive();
                maxIdle = db.getMaxIdle();
                maxWait = db.getMaxWait();
                validationQuery = ServerXmlGenerator.createValidationQuery(db);
                connectionInitSqls = db.getConnectionInitSqls();
            }
            httpport = null;
            String portstr = env.getTomcatHttpPort();
            if (StringUtils.isNotBlank((CharSequence)portstr)) {
                try {
                    port = Integer.parseInt(portstr);
                    if (port > 0) {
                        httpport = portstr;
                    }
                }
                catch (NumberFormatException e) {
                    logger.error("Illegal number environment/@tomcatHttpPort " + httpport + ". disabled http port", (Throwable)e);
                }
            }
            if (httpport == null) {
                httpport = TOMCAT_DEFAULT_HTTPPORT;
                httpportCommentoutBegin = COMMENTOUT_BEGIN;
                httpportCommentoutEnd = COMMENTOUT_END;
            }
            ajp13port = null;
            portstr = env.getTomcatAJP13Port();
            if (StringUtils.isNotBlank((CharSequence)portstr)) {
                try {
                    port = Integer.parseInt(portstr);
                    if (port > 0) {
                        ajp13port = portstr;
                    }
                }
                catch (NumberFormatException e) {
                    logger.error("Illegal number environment/@tomcatAJP13Port " + ajp13port + ". disabled ajp13 port", (Throwable)e);
                }
            }
            if (ajp13port == null) {
                ajp13port = TOMCAT_DEFAULT_AJP13PORT;
                ajp13portCommentoutBegin = COMMENTOUT_BEGIN;
                ajp13portCommentoutEnd = COMMENTOUT_END;
            }
            ajp13attr = StringUtils.isBlank((CharSequence)(ajp13secret = env.getTomcatAJP13Secret())) ? AJP13_DISABLE_SECRET_REQUIRED : "secret=\"" + StringUtil.escapeStringForXML((String)ajp13secret) + "\"";
            serverport = "-1";
            portstr = env.getTomcatServerPort();
            if (StringUtils.isNotBlank((CharSequence)portstr)) {
                try {
                    Integer.parseInt(portstr);
                    serverport = portstr;
                }
                catch (NumberFormatException e) {
                    logger.error("Illegal number environment/@tomcatServerPort " + serverport + ". disabled server port", (Throwable)e);
                }
            }
            servershutdown = env.getTomcatServerShutdown();
            redirectport = env.getTomcatRedirectPort();
            if (redirectport == null || redirectport.length() == 0) {
                redirectport = TOMCAT_DEFAULT_REDIRECTPORT;
            } else {
                try {
                    Integer.parseInt(redirectport);
                }
                catch (NumberFormatException e) {
                    logger.error("Illegal number environment/@tomcatRedirectport " + redirectport + ". use default setting 8443", (Throwable)e);
                    redirectport = TOMCAT_DEFAULT_REDIRECTPORT;
                }
            }
            maxHttpHeaderSize = env.getTomcatMaxHttpHeaderSize();
            if (!NumberUtils.isParsable((String)maxHttpHeaderSize)) {
                logger.error("Illegal number environment/@maxHttpHeaderSize" + maxHttpHeaderSize + ". use default setting 8192");
                maxHttpHeaderSize = TOMCAT_DEFAULT_MAXHTTPHEADERSIZE;
            }
            if (!NumberUtils.isParsable((String)(maxParameterCount = env.getTomcatMaxParameterCount()))) {
                logger.error("Illegal number environment/@maxHttpHeaderSize" + maxParameterCount + ". use default setting 20000");
                maxParameterCount = TOMCAT_DEFAULT_MAXPARAMETERCOUNT;
            }
            if (StringUtils.isNotBlank((CharSequence)(maxPostSize = env.getTomcatMaxPostSize()))) {
                if (NumberUtils.isParsable((String)maxPostSize)) {
                    maxPostSizeAttr = "maxPostSize=\"" + maxPostSize + "\"";
                } else {
                    logger.error("Illegal number environment/@maxPostSize" + maxPostSize);
                }
            }
        }
        if (StringUtils.isBlank(servershutdown)) {
            servershutdown = "SHUTDOWN" + project.getName().toUpperCase();
        }
        StringBuilder resourceAttributes = new StringBuilder();
        if (StringUtils.isNotBlank(validationQuery)) {
            resourceAttributes.append(CR).append("            ").append(validationQuery);
        }
        if (StringUtils.isNotBlank(connectionInitSqls)) {
            resourceAttributes.append(CR).append("            ").append("connectionInitSqls=\"").append(WebStringEncodeUtilities.replaceCharEntity(connectionInitSqls)).append("\"");
        }
        tplman.addContent("httpport", httpport);
        tplman.addContent("httpportcommentoutbegin", httpportCommentoutBegin);
        tplman.addContent("httpportcommentoutend", httpportCommentoutEnd);
        tplman.addContent("ajp13port", ajp13port);
        tplman.addContent("ajp13portcommentoutbegin", ajp13portCommentoutBegin);
        tplman.addContent("ajp13portcommentoutend", ajp13portCommentoutEnd);
        tplman.addContent("ajp13attr", (String)ajp13attr);
        tplman.addContent("serverport", serverport);
        tplman.addContent("servershutdown", (String)servershutdown);
        tplman.addContent("redirectport", redirectport);
        tplman.addContent("maxHttpHeaderSize", maxHttpHeaderSize);
        tplman.addContent("maxParameterCount", maxParameterCount);
        tplman.addContent("maxPostSizeAttr", (String)maxPostSizeAttr);
        tplman.addContent("driver", driver);
        tplman.addContent("url", StringUtil.escapeStringForXML((String)url));
        tplman.addContent("user", user);
        tplman.addContent("password", StringUtil.escapeStringForXML((String)pwd));
        tplman.addContent("maxActive", Integer.toString(maxActive));
        tplman.addContent("maxIdle", Integer.toString(maxIdle));
        tplman.addContent("maxWait", Integer.toString(maxWait));
        tplman.addContent("resourceAttributes", resourceAttributes.toString());
        tplman.addContent("path", path);
        tplman.addContent("docBase", docBase);
        tplman.addContent("logfilename", (String)logfilename);
        ConnectionInterface conintcfg = AppSchemaUtil.getConnectionInterface(env);
        if (conintcfg != null) {
            tplman.addContent("conint_comment_begin", "");
            tplman.addContent("conint_comment_end", "");
            StringBuilder buf = new StringBuilder();
            String factory = conintcfg.getFactory();
            buf.append("       <parameter>\n");
            buf.append("         <name>factory</name>\n");
            buf.append("         <value>");
            buf.append(factory);
            buf.append("</value>\n");
            buf.append("       </parameter>\n");
            for (ConnectionInterfaceParam param : conintcfg.getConnectionInterfaceParam()) {
                String key = param.getKey();
                String content = param.getContent();
                buf.append("       <parameter>\n");
                buf.append("         <name>");
                buf.append(key);
                buf.append("</name>\n");
                buf.append("         <value>");
                buf.append(content);
                buf.append("</value>\n");
                buf.append("       </parameter>\n");
            }
            tplman.addContent("conint_parameter", buf.toString());
        } else {
            tplman.addContent("conint_comment_begin", COMMENTOUT_BEGIN);
            tplman.addContent("conint_comment_end", COMMENTOUT_END);
            tplman.addContent("conint_parameter", "");
        }
    }

    protected static String createValidationQuery(Database db) {
        if (!db.getAutoReconnect()) {
            return null;
        }
        if (DbTypeManager.isHSQLDB(db)) {
            return null;
        }
        String validationQuery = db.getValidationQuery();
        if (StringUtils.isBlank((CharSequence)validationQuery)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("validationQuery=\"");
        sb.append(validationQuery);
        sb.append("\"");
        return sb.toString();
    }
}

