/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.converter.DatabaseAdapterConverter;
import jp.jasminesoft.jfc.core.support.velocity.VelocityUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.GoogleMapScriptManager;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.JobGeneratorUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.TextSearchUtil;
import jp.jasminesoft.jfc.gen.appschema.ApplicationContextConfig;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Job;
import jp.jasminesoft.jfc.gen.appschema.Jobparam;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.QuartzJDBCJobstore;
import jp.jasminesoft.jfc.gen.appschema.Usebean;
import jp.jasminesoft.util.ExtensionFilenameFilter;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpringApplicationContextGenerator
extends SourceGenerator {
    private static final Logger logger = LogManager.getLogger(SpringApplicationContextGenerator.class);
    protected ResourceManager rman;
    private Set<String> targetModelIdSet;
    private boolean isFullBuild;
    private List<String> availableTextExtractors = new ArrayList<String>();

    public SpringApplicationContextGenerator(Project project, boolean isFullBuild) {
        super(project);
        this.availableTextExtractors.add("TextPorterTextExtractor");
        this.availableTextExtractors.add("Xdoc2txtTextExtractor");
        this.availableTextExtractors.add("TikaTextExtractor");
        this.availableTextExtractors.add("SampleTextExtractor");
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.isFullBuild = isFullBuild;
    }

    @Override
    public String getFileSuffix() {
        return "";
    }

    public String getSubpackageName() {
        return "webpage" + File.separator;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    protected String getCustomizeDirectory() {
        return "applicationContext";
    }

    public void setTargetModelIdSet(Set<String> targetModelIdSet) {
        this.targetModelIdSet = targetModelIdSet;
    }

    @Override
    public void process() {
        String smodelid = "jholiday";
        Model smodel = AppSchemaUtil.getModel(this.project, smodelid);
        if (smodel != null) {
            String beanId = "ShowArrayJholidayProcessBean";
            String packagename = AppSchemaUtil.getPackagename_app(smodel, this.project);
            String beanClass = packagename + beanId;
            ApplicationContextBean bean = new ApplicationContextBean(beanId, beanClass);
            SpringApplicationContextContainer.addApplicationContextBean(bean);
        }
        this.addApplicationContextBeanForService();
        String[] files = SpringApplicationContextContainer.getApplicationContextPaths();
        for (int i = 0; i < files.length; ++i) {
            this.createApplicationContext(SpringApplicationContextContainer.getApplicationContextBeans(files[i]), files[i]);
        }
    }

    private void addApplicationContextBeanForService() {
        ApplicationContextBean bean = new ApplicationContextBean("logonService", "jp.jasminesoft.jfc.service.LogonService", true);
        SpringApplicationContextContainer.addApplicationContextBean(bean);
        bean = new ApplicationContextBean("menuService", "jp.jasminesoft.jfc.service.MenuService", true);
        SpringApplicationContextContainer.addApplicationContextBean(bean);
        bean = new ApplicationContextBean("jfcConfig", "jp.jasminesoft.jfc.service.JfcConfig", true);
        bean.setDependsOn("LogonStatusManager");
        SpringApplicationContextContainer.addApplicationContextBean(bean);
        bean = new ApplicationContextBean("LogonStatusManager", "jp.jasminesoft.jfc.LogonStatusManager", true);
        SpringApplicationContextContainer.addApplicationContextBean(bean);
        bean = new ApplicationContextBean("TableConfigManager", "jp.jasminesoft.jfc.TableConfigManager", true);
        bean.setLazyInit(false);
        SpringApplicationContextContainer.addApplicationContextBean(bean);
        bean = new ApplicationContextBean("errorManager", "jp.jasminesoft.jfc.JFCErrorManager", true);
        SpringApplicationContextContainer.addApplicationContextBean(bean);
        String appModeManagerType = this.project.getEnvironment().getAppModeManagerType();
        String appModeManagerClassname = appModeManagerType.equals("single") ? "jp.jasminesoft.jfc.JFCAppModeManager" : (appModeManagerType.equals("autoscale") ? "jp.jasminesoft.jfc.JFCAppModeManagerAutoScaleImpl" : "jp.jasminesoft.jfc.JFCAppModeManager");
        bean = new ApplicationContextBean("JFCAppModeManager", appModeManagerClassname, true);
        SpringApplicationContextContainer.addApplicationContextBean(bean);
    }

    protected void createApplicationContext(ApplicationContextBean[] beans, String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gContent(beans));
        sb.append(this.gFooter());
        sb.append(this.getGeneratorClassName());
        this.createSource(sb.toString(), filename, this.getSubpackageName(), false);
    }

    protected String gHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append(CR);
        sb.append("<beans ");
        if (CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.SpringApplicationContextGenerator.lazy-initialization") && !this.isFullBuild) {
            sb.append("default-lazy-init=\"true\"").append(CR).append("       ");
        }
        sb.append("xmlns=\"http://www.springframework.org/schema/beans\"").append(CR);
        sb.append("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + CR);
        sb.append("       xmlns:context=\"http://www.springframework.org/schema/context\"" + CR);
        sb.append("       xmlns:aop=\"http://www.springframework.org/schema/aop\"" + CR);
        sb.append("       xmlns:util=\"http://www.springframework.org/schema/util\"" + CR);
        sb.append("       xmlns:tx=\"http://www.springframework.org/schema/tx\"" + CR);
        sb.append("       xsi:schemaLocation=\"http://www.springframework.org/schema/beans" + CR);
        sb.append("                           http://www.springframework.org/schema/beans/spring-beans.xsd" + CR);
        sb.append("                           http://www.springframework.org/schema/context" + CR);
        sb.append("                           http://www.springframework.org/schema/context/spring-context.xsd" + CR);
        sb.append("                           http://www.springframework.org/schema/aop" + CR);
        sb.append("                           http://www.springframework.org/schema/aop/spring-aop.xsd" + CR);
        sb.append("                           http://www.springframework.org/schema/util" + CR);
        sb.append("                           http://www.springframework.org/schema/util/spring-util.xsd" + CR);
        sb.append("                           http://www.springframework.org/schema/tx" + CR);
        sb.append("                           http://www.springframework.org/schema/tx/spring-tx.xsd\">" + CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gContent(ApplicationContextBean[] beans) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, LinkedHashSet<ApplicationContextBean>> modelMap = new TreeMap<String, LinkedHashSet<ApplicationContextBean>>();
        for (int i = 0; i < beans.length; ++i) {
            ApplicationContextBean bean = beans[i];
            if (bean == null) continue;
            String beanClass = bean.getBeanClass();
            String modelid = bean.getModelId();
            if (StringUtils.isBlank((CharSequence)modelid)) {
                modelid = this.suggestModelId(beanClass);
            }
            if (StringUtils.isBlank((CharSequence)modelid)) continue;
            LinkedHashSet<ApplicationContextBean> beanSet = (LinkedHashSet<ApplicationContextBean>)modelMap.get(modelid);
            if (beanSet == null) {
                beanSet = new LinkedHashSet<ApplicationContextBean>();
                modelMap.put(modelid, beanSet);
            }
            beanSet.add(bean);
        }
        for (String modelid : modelMap.keySet()) {
            sb.append("<import resource=\"");
            sb.append(this.getCustomizeDirectory());
            sb.append("/");
            sb.append(modelid);
            sb.append(".xml\"/>");
            sb.append(CR);
        }
        sb.append(CR);
        HashSet<String> importSet = new HashSet<String>(modelMap.keySet());
        sb.append("<!-- for common -->");
        sb.append(CR);
        sb.append("<import resource=\"");
        sb.append(this.getCustomizeDirectory());
        sb.append("/");
        String __modelid = "__common";
        importSet.add(__modelid);
        sb.append(__modelid);
        sb.append(".xml\"/>");
        sb.append(CR);
        sb.append(CR);
        sb.append("<!-- for Job Controll -->");
        sb.append(CR);
        sb.append("<import resource=\"");
        sb.append(this.getCustomizeDirectory());
        sb.append("/");
        __modelid = "__jobcontrol";
        importSet.add(__modelid);
        sb.append(__modelid);
        sb.append(".xml\"/>");
        sb.append(CR);
        sb.append(CR);
        if (JFCAppGenerator.getIsTextSearch() && AppSchemaUtil.hasTextSearchModel(this.project)) {
            sb.append("<!-- for Text Search -->");
            sb.append(CR);
            sb.append("<import resource=\"");
            sb.append(this.getCustomizeDirectory());
            sb.append("/");
            __modelid = "__textsearch";
            importSet.add(__modelid);
            sb.append(__modelid);
            sb.append(".xml\"/>");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append("<!-- for workflow -->");
        sb.append(CR);
        sb.append("<import resource=\"");
        sb.append(this.getCustomizeDirectory());
        sb.append("/");
        __modelid = "__workflow";
        importSet.add(__modelid);
        sb.append(__modelid);
        sb.append(".xml\"/>");
        sb.append(CR);
        sb.append(CR);
        if (StringUtils.isNotBlank((CharSequence)this.getGooglemapKey())) {
            sb.append("<!-- for mapview -->");
            sb.append(CR);
            sb.append("<import resource=\"");
            sb.append(this.getCustomizeDirectory());
            sb.append("/");
            __modelid = "__mapview";
            importSet.add(__modelid);
            sb.append(__modelid);
            sb.append(".xml\"/>");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append("<!-- for master -->");
        sb.append(CR);
        sb.append("<import resource=\"");
        sb.append(this.getCustomizeDirectory());
        sb.append("/");
        __modelid = "__master";
        importSet.add(__modelid);
        sb.append(__modelid);
        sb.append(".xml\"/>");
        sb.append(CR);
        sb.append(CR);
        Database database = AppSchemaUtil.getDatabase(this.project.getEnvironment());
        String batchddlfilename = database.getSpringBatchDDL();
        if (!StringUtils.isBlank((CharSequence)batchddlfilename)) {
            sb.append("<!-- for Batch process -->");
            sb.append(CR);
            sb.append("<import resource=\"");
            sb.append(this.getCustomizeDirectory());
            sb.append("/");
            __modelid = "__batch";
            importSet.add(__modelid);
            sb.append(__modelid);
            sb.append(".xml\"/>");
            sb.append(CR);
            sb.append(CR);
        }
        Object[] subdatabases = AppSchemaUtil.getSubdatabases(this.project.getEnvironment());
        if (ArrayUtils.isNotEmpty((Object[])subdatabases)) {
            sb.append("<!-- for sub-databases  -->");
            sb.append(CR);
            sb.append("<import resource=\"");
            sb.append(this.getCustomizeDirectory());
            sb.append("/");
            __modelid = "__subdatabase";
            importSet.add(__modelid);
            sb.append(__modelid);
            sb.append(".xml\"/>");
            sb.append(CR);
            sb.append(CR);
            ApplicationContextBlockGenerator acbg = new ApplicationContextBlockGenerator("__subdatabase", this.createSubdatabasesContent((Database[])subdatabases), this.project);
            acbg.process();
        }
        sb.append(this.importUserCustomizeFile(importSet));
        Environment env = null;
        if (this.project != null) {
            env = this.project.getEnvironment();
        }
        ApplicationContextConfig appCtxCfg = AppSchemaUtil.getApplicationContextConfig(env);
        Boolean lazyinit = null;
        if (appCtxCfg != null) {
            lazyinit = appCtxCfg.getLazyinitAsBoolean();
        }
        for (String modelid : modelMap.keySet()) {
            if (this.targetModelIdSet != null && this.targetModelIdSet.size() > 0 && !this.targetModelIdSet.contains(modelid) && !modelid.equals("__others") && !modelid.equals("jfc") || "seq".equals(modelid)) continue;
            StringBuilder sbc = new StringBuilder();
            sbc.append(this.gHeader());
            Set beanSet = (Set)modelMap.get(modelid);
            for (ApplicationContextBean bean : beanSet) {
                if (bean.getLazyInit() == null && BooleanUtils.isTrue((Boolean)lazyinit)) {
                    bean.setLazyInit(true);
                }
                sbc.append(bean.makeTextDocument());
                sbc.append(CR);
            }
            sbc.append(this.gFooter());
            ApplicationContextBlockGenerator acbg = new ApplicationContextBlockGenerator(modelid, sbc.toString(), this.project);
            acbg.process();
        }
        ApplicationContextBlockGenerator acbg = new ApplicationContextBlockGenerator("__jobcontrol", this.createJobContent(this.project), this.project);
        acbg.process();
        if (JFCAppGenerator.getIsTextSearch()) {
            acbg = new ApplicationContextBlockGenerator("__textsearch", this.createTextSearchContent(this.project), this.project);
            acbg.process();
        }
        acbg = new ApplicationContextBlockGenerator("__workflow", this.createWorkflowContent(this.project), this.project);
        acbg.process();
        String googlemapKey = this.getGooglemapKey();
        if (StringUtils.isNotBlank((CharSequence)googlemapKey)) {
            acbg = new ApplicationContextBlockGenerator("__mapview", this.createMapviewContent(this.project, googlemapKey), this.project);
            acbg.process();
        }
        acbg = new ApplicationContextBlockGenerator("__master", this.createMasterContent(this.project), this.project);
        acbg.process();
        return sb.toString();
    }

    protected String importUserCustomizeFile(Set<String> importSet) {
        String[] basedirs;
        StringBuilder sb = new StringBuilder();
        for (String basedir : basedirs = this.rman.getValueStrArray("CustomizeXmlBasedirs")) {
            File targetdir = new File(basedir, this.getCustomizeDirectory());
            if (!targetdir.exists() || !targetdir.isDirectory()) {
                logger.debug("customize basedir " + targetdir + " is not found.");
                continue;
            }
            sb.append(this.importUserCustomizeFile(importSet, targetdir));
        }
        return sb.toString();
    }

    protected String importUserCustomizeFile(Set<String> importSet, File targetdir) {
        StringBuilder sb = new StringBuilder();
        String ext = ".xml";
        String[] lists = targetdir.list((FilenameFilter)new ExtensionFilenameFilter(new String[]{ext}, false));
        if (lists == null) {
            return sb.toString();
        }
        for (int i = 0; i < lists.length; ++i) {
            String filename = StringUtils.removeEnd((String)lists[i], (String)ext);
            if (importSet.contains(filename)) continue;
            sb.append("<!-- for " + filename + " (user customize file) -->");
            sb.append(CR);
            sb.append("<import resource=\"");
            sb.append(this.getCustomizeDirectory());
            sb.append("/");
            sb.append(filename);
            sb.append(".xml\"/>");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    private String suggestModelId(String beanClass) {
        String mid = StringUtil.getClassName((String)StringUtil.getPackageName((String)beanClass));
        if (beanClass.startsWith("jp.jasminesoft.jfc.app.")) {
            System.out.println("beanClass=" + beanClass);
            System.out.println("mid=" + mid);
        }
        if (mid == null || "".equals(mid) || "app".equals(mid)) {
            mid = "__others";
        } else if ("null".equals(mid)) {
            mid = null;
        }
        return mid;
    }

    protected String gFooter() {
        StringBuilder sb = new StringBuilder();
        sb.append("</beans>");
        sb.append(CR);
        return sb.toString();
    }

    private String createJobContent(Project project) {
        String jobname;
        IProjectChoice[] ipcs;
        String packagename = project.getPackage();
        HashSet<String> processedNameSet = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        ApplicationContextBean jutil = new ApplicationContextBean("JFCQuartzJobManagerJobscheduleUtil", packagename + ".app.jfcjobschedule.JFCQuartzJobManagerJobscheduleUtilImpl", true);
        sb.append(jutil);
        sb.append(CR);
        processedNameSet.add(jutil.getBeanId());
        ApplicationContextBean jman = this.getJFCQuartzJobManagerBean(project);
        sb.append(jman);
        sb.append(CR);
        processedNameSet.add(jman.getBeanId());
        ApplicationContextBean pbean = new ApplicationContextBean("ShowArrayJfcjobscheduleProcessBean", packagename + ".app.jfcjobschedule.ShowArrayJfcjobscheduleProcessBean");
        sb.append(pbean);
        sb.append(CR);
        processedNameSet.add(pbean.getBeanId());
        for (IProjectChoice ipc : ipcs = project.getContent()) {
            if (!(ipc instanceof Job)) continue;
            Job job = (Job)ipc;
            jobname = job.getName();
            String jobtype = job.getType();
            if (this.isThreadJobtype(jobtype)) continue;
            String jobclassname = JobGeneratorUtil.getClassnameByJobType(jobtype);
            if (StringUtils.isBlank((CharSequence)jobclassname)) {
                jobclassname = job.getClassname();
                logger.warn("job " + jobname + "'s classname is not set, use appschema spec:" + jobclassname);
            }
            String propname = JobGeneratorUtil.getProcessorNameByJobType(jobtype);
            String refid = JobGeneratorUtil.getProcessorName(jobname);
            ApplicationContextBean jbean = new ApplicationContextBean(jobname, "org.springframework.scheduling.quartz.JobDetailFactoryBean", true);
            jbean.addProperty("jobClass", jobclassname);
            jbean.setSingleton(false);
            Jobparam[] jobparams = AppSchemaUtil.getJobparam(job);
            Map<String, Object> jpmap = this.createJobParameterMap(jobtype, propname, refid, jobparams);
            if (jpmap.size() > 0) {
                jbean.addPropertyMap("jobDataAsMap", jpmap);
            }
            sb.append(CR);
            sb.append(jbean);
            sb.append(CR);
            processedNameSet.add(jobname);
            sb.append(this.createJobProcessor(job, processedNameSet));
            Usebean[] ubeans = AppSchemaUtil.getUsebean(job);
            ApplicationContextBean bean = null;
            if (ubeans == null || ubeans.length <= 0) continue;
            for (Usebean ubean : ubeans) {
                bean = new ApplicationContextBean(ubean.getId(), ubean.getClassname(), true);
                sb.append(bean);
                sb.append(CR);
                processedNameSet.add(bean.getBeanId());
            }
        }
        Object[] exjobs = this.readCustomizeFolder();
        if (ArrayUtils.isNotEmpty((Object[])exjobs)) {
            sb.append(CR).append("  <!-- extension -->");
            for (Object exjob : exjobs) {
                jobname = ((Job)exjob).getName();
                if (processedNameSet.contains(jobname)) continue;
                processedNameSet.add(jobname);
                String jobclassname = ((Job)exjob).getClassname();
                ApplicationContextBean jbean = new ApplicationContextBean(jobname, "org.springframework.scheduling.quartz.JobDetailFactoryBean", true);
                jbean.addProperty("jobClass", jobclassname);
                jbean.setSingleton(false);
                sb.append(CR);
                sb.append(jbean);
                sb.append(CR);
            }
        }
        sb.append(this.gFooter());
        return sb.toString();
    }

    private boolean isThreadJobtype(String jobtype) {
        return jobtype.equals("uploadUpdateThread");
    }

    protected ApplicationContextBean getJFCQuartzJobManagerBean(Project project) {
        String classname = this.getJFCQuartzJobManagerClassname(project);
        ApplicationContextBean jman = new ApplicationContextBean("JFCQuartzJobManager", classname, true);
        if (this.isScheduleQueueName(classname)) {
            jman.addProperty("scheduleRAMJobTopicName", "JFCQuartzJobManagerScheduleRAMJobCommandTopic");
            jman.addProperty("scheduleJobNowTopicName", "JFCQuartzJobManagerCommandTopic");
        }
        if (this.isScheduleDomainQueueName(classname)) {
            jman.addProperty("domainidScheduleDomainJobQueueNameHeader", "JFCQuartzJobManagerScheduleDomainJobCommandQueue_");
            jman.addProperty("domainidScheduleJobNowQueueNameHeader", "JFCQuartzJobManagerDomainCommandQueue_");
        }
        return jman;
    }

    protected boolean isScheduleQueueName(String classname) {
        return SpringApplicationContextGenerator.isUseJDBCJobstore(classname);
    }

    protected boolean isScheduleDomainQueueName(String classname) {
        return SpringApplicationContextGenerator.isUseDomainScheduler(classname);
    }

    protected static boolean isUseJDBCJobstore(String classname) {
        JFCQuartzJobManagerClass c = JFCQuartzJobManagerClass.valueOfClassname(classname);
        if (c == null) {
            return false;
        }
        return c.isUseJDBCJobstore();
    }

    protected static boolean isUseDomainScheduler(String classname) {
        JFCQuartzJobManagerClass c = JFCQuartzJobManagerClass.valueOfClassname(classname);
        if (c == null) {
            return false;
        }
        return c.isUseDomainScheduler();
    }

    protected static boolean isUseV2JDBCScheduler(String classname) {
        JFCQuartzJobManagerClass c = JFCQuartzJobManagerClass.valueOfClassname(classname);
        if (c == null) {
            return false;
        }
        return c.isUseV2JDBCScheduler();
    }

    public String getJFCQuartzJobManagerClassname(Project project) {
        Database database = AppSchemaUtil.getDatabase(project.getEnvironment());
        QuartzJDBCJobstore qjj = database.getQuartzJDBCJobstore();
        return SpringApplicationContextGenerator._getJFCQuartzJobManagerClassname(qjj);
    }

    public static String getJFCQuartzJobManagerClassname(QuartzJDBCJobstore qjj) {
        return SpringApplicationContextGenerator._getJFCQuartzJobManagerClassname(qjj);
    }

    public static String _getJFCQuartzJobManagerClassname(QuartzJDBCJobstore qjj) {
        if (qjj == null) {
            return JFCQuartzJobManagerClass.V2RAM.getClassname();
        }
        String type = qjj.getJFCQuartzJobManagerType();
        String manclass = null;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            manclass = type;
        }
        if (manclass == null) {
            manclass = JFCQuartzJobManagerClass.V1.getClassname();
        }
        return manclass;
    }

    private String createJobProcessor(Job job, Set<String> processedNameSet) {
        ApplicationContextBean bean;
        StringBuilder sb;
        block5: {
            String propname = JobGeneratorUtil.getProcessorNameByJobType(job.getType());
            if (StringUtils.isBlank((CharSequence)propname)) {
                return "";
            }
            sb = new StringBuilder();
            String refid = JobGeneratorUtil.getProcessorName(job.getName());
            String refclassname = job.getClassname();
            bean = new ApplicationContextBean(refid, refclassname, true);
            if ("sendMail".equals(job.getType())) {
                bean.setSingleton(false);
                sb.append(bean);
                sb.append(CR);
                processedNameSet.add(bean.getBeanId());
                bean = new ApplicationContextBean(refid + "Factory", "org.springframework.beans.factory.config.ObjectFactoryCreatingFactoryBean", true);
                ApplicationContextBean.XmlString xmlString = new ApplicationContextBean.XmlString("<idref bean=\"" + refid + "\"/>");
                bean.addProperty("targetBeanName", xmlString);
                sb.append(bean);
                sb.append(CR);
                processedNameSet.add(bean.getBeanId());
                try {
                    StoreModel storeModel = new StoreModel(AppSchemaUtil.getModel(this.project, job.getModel()));
                    String packageName = this.project.getPackage() + ".app." + storeModel.getId();
                    String className = JobGeneratorUtil.getScrollerName(job.getName());
                    bean = new ApplicationContextBean(className, packageName + "." + className, true);
                    bean.setSingleton(false);
                    bean.addLookupMethod("getActionParameterContainer", "ActionParameterContainer");
                }
                catch (IllegalArgumentException e) {
                    logger.error(job + " has illegal parameter. " + e.getMessage());
                    if (!logger.isDebugEnabled()) break block5;
                    e.printStackTrace();
                }
            }
        }
        for (Jobparam jobparam : AppSchemaUtil.getJobparam(job)) {
            if (!jobparam.getUseSpringContext()) continue;
            String key = jobparam.getKey();
            String content = jobparam.getContent();
            content = StringUtil.escapeStringForXML((String)content);
            bean.addProperty(key, content);
        }
        sb.append(bean);
        sb.append(CR);
        processedNameSet.add(bean.getBeanId());
        return sb.toString();
    }

    private Map<String, Object> createJobParameterMap(String jobtype, String propname, String refid, Jobparam[] jobparams) {
        TreeMap<String, Object> jpmap = new TreeMap<String, Object>();
        if ("sendMail".equals(jobtype)) {
            propname = (String)propname + "Factory";
            refid = (String)refid + "Factory";
        }
        if (StringUtils.isNotBlank((CharSequence)propname)) {
            jpmap.put((String)propname, new ApplicationContextBean.ReferenceElement((String)refid));
        }
        if (jobparams == null || jobparams.length == 0) {
            return jpmap;
        }
        for (Jobparam jobparam : jobparams) {
            String key;
            if (!jobparam.getUseSpringContext() || !(key = jobparam.getKey()).startsWith("mail:")) continue;
            String content = jobparam.getContent();
            content = StringUtil.escapeStringForXML((String)content);
            jpmap.put(key, content);
        }
        if (jobtype != null && (jobtype.equals("uploadUpdate") || jobtype.equals("download") || jobtype.equals("reportList") || jobtype.equals("customize"))) {
            for (Jobparam jobparam : jobparams) {
                String content;
                if (jobparam.getValueRef() != null) {
                    content = jobparam.getValueRef();
                    jpmap.put(jobparam.getKey(), new ApplicationContextBean.ReferenceElement(content));
                    continue;
                }
                content = jobparam.getContent();
                jpmap.put(jobparam.getKey(), content);
            }
        }
        return jpmap;
    }

    private Job[] readCustomizeFolder() {
        String[] basedirs;
        TreeMap<String, Job> jobmap = new TreeMap<String, Job>();
        for (String basedir : basedirs = this.rman.getValueStrArray("CustomizeExportJfcJobBasedirs")) {
            File customizeFolderDir = new File(basedir);
            if (!customizeFolderDir.exists() || !customizeFolderDir.isDirectory()) continue;
            String[] lists = customizeFolderDir.list();
            TreeSet<String> fileNameSet = new TreeSet<String>();
            fileNameSet.addAll(Arrays.asList(lists));
            for (String name : fileNameSet) {
                if (!name.endsWith(".xml")) continue;
                File xmlFile = new File(basedir + File.separator + name);
                DocumentBuilderFactory factory = null;
                DocumentBuilder builder = null;
                try {
                    String name_ = null;
                    String classname_ = null;
                    boolean skipFlag = false;
                    factory = DocumentBuilderFactory.newInstance();
                    builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(xmlFile);
                    NodeList roots = doc.getChildNodes();
                    for (int i = 0; i < roots.getLength(); ++i) {
                        Node n = roots.item(i);
                        Element e = (Element)n;
                        if (!"jfcjob".equals(e.getTagName())) continue;
                        String createApplicationContextStr = e.getAttribute("createApplicationContext");
                        if (createApplicationContextStr != null && "false".equals(createApplicationContextStr)) {
                            skipFlag = true;
                            break;
                        }
                        NodeList childs = n.getChildNodes();
                        for (int j = 0; j < childs.getLength(); ++j) {
                            Node n2 = childs.item(j);
                            if ("name".equals(n2.getNodeName())) {
                                name_ = n2.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (!"classname".equals(n2.getNodeName())) continue;
                            classname_ = n2.getFirstChild().getNodeValue();
                        }
                    }
                    if (skipFlag) continue;
                    if (StringUtils.isBlank(name_)) {
                        logger.warn("Illegal format: name is null, " + xmlFile.getAbsolutePath());
                    }
                    if (StringUtils.isBlank(classname_)) {
                        logger.warn("Illegal format: classname is null, " + xmlFile.getAbsolutePath());
                    }
                    if (!StringUtils.isNotBlank(name_) || !StringUtils.isNotBlank(classname_) || jobmap.containsKey(name_)) continue;
                    Job job = new Job();
                    job.setName(name_);
                    job.setClassname(classname_);
                    jobmap.put(name_, job);
                }
                catch (IOException e) {
                    logger.warn("IOException," + e);
                }
                catch (ParserConfigurationException e) {
                    logger.warn("ParserConfigurationException," + e);
                }
                catch (SAXException e) {
                    logger.warn("SAXException," + e);
                }
            }
        }
        return jobmap.values().toArray(new Job[jobmap.size()]);
    }

    private String createTextSearchContent(Project project) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.createTextSearchContent4MakeTextIndex(project));
        sb.append(this.createTextSearchContent4TextExtractor(project));
        sb.append(this.createTextSearchContent4CharCounter(project));
        sb.append(this.gFooter());
        return sb.toString();
    }

    private String createTextSearchContent4MakeTextIndex(Project project) {
        StringBuilder sb = new StringBuilder();
        String def = TextSearchUtil.createTextSearchTargetModelDefinition(project);
        ApplicationContextBean mtidx = new ApplicationContextBean("MakeTextIndex", "jp.jasminesoft.jfc.textsearch.servlet.MakeTextIndex", true);
        mtidx.addProperty("indexInfo", def);
        sb.append(mtidx);
        sb.append(CR);
        return sb.toString();
    }

    private String createTextSearchContent4TextExtractor(Project project) {
        StringBuilder sb = new StringBuilder();
        String tExtractorClsName = "SampleTextExtractor";
        if (project.getEnvironment() != null && this.availableTextExtractors.contains(project.getEnvironment().getTextsearchTextExtractor())) {
            tExtractorClsName = project.getEnvironment().getTextsearchTextExtractor();
        }
        ApplicationContextBean mtidx = new ApplicationContextBean("TextExtractor", "jp.jasminesoft.jfc.textsearch." + tExtractorClsName, true);
        sb.append(mtidx);
        sb.append(CR);
        return sb.toString();
    }

    private String createTextSearchContent4CharCounter(Project project) {
        StringBuilder sb = new StringBuilder();
        ApplicationContextBean mtidx = new ApplicationContextBean("CharCounter", "jp.jasminesoft.jfc.textsearch.CharCounter", false);
        if (project.getEnvironment() != null) {
            mtidx.addProperty("limit", Integer.toString(project.getEnvironment().getTextsearchMaxcharPerData()));
        }
        sb.append(mtidx);
        sb.append(CR);
        return sb.toString();
    }

    private String createWorkflowContent(Project project) {
        String packagename = project.getPackage();
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        ApplicationContextBean jman = new ApplicationContextBean("JfcworkflowSettingService", packagename + ".app.jfcworkflow_setting.JfcworkflowSettingServiceImpl");
        sb.append(jman);
        sb.append(CR);
        jman = new ApplicationContextBean("JfcworkstateService", packagename + ".app.jfcworkstate.JfcworkstateServiceImpl");
        sb.append(jman);
        sb.append(CR);
        jman = new ApplicationContextBean("WorkFlowManager", packagename + ".app.WorkFlowManager", true);
        sb.append(jman);
        sb.append(CR);
        jman = new ApplicationContextBean("WorkflowRestrictions", "jp.jasminesoft.jfc.hibernate.WorkflowRestrictions", true);
        jman.setSingleton(false);
        sb.append(jman);
        sb.append(CR);
        sb.append(this.gFooter());
        return sb.toString();
    }

    private String createMapviewContent(Project project, String googlemapKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        ApplicationContextBean mapviewctx = new ApplicationContextBean("googlemap_key", "java.lang.String", true);
        ApplicationContextBean.ConstructorArgType constructorArg = new ApplicationContextBean.ConstructorArgType();
        constructorArg.setValue(googlemapKey);
        mapviewctx.addConstructorArg(constructorArg);
        sb.append(mapviewctx);
        sb.append(CR);
        sb.append(this.gFooter());
        return sb.toString();
    }

    private String createMasterContent(Project project) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        ApplicationContextBean ctx = new ApplicationContextBean("ShowListMasterProcessBean", "jp.jasminesoft.jfc.master.app.ShowListMasterProcessBean");
        sb.append(ctx);
        sb.append(CR);
        ctx = new ApplicationContextBean("InsertMasterProcessBean", "jp.jasminesoft.jfc.master.app.InsertMasterProcessBean");
        sb.append(ctx);
        sb.append(CR);
        ctx = new ApplicationContextBean("UpdateMasterProcessBean", "jp.jasminesoft.jfc.master.app.UpdateMasterProcessBean");
        sb.append(ctx);
        sb.append(CR);
        sb.append(this.gFooter());
        return sb.toString();
    }

    private String createSubdatabasesContent(Database[] subdatabases) {
        HashMap<String, Object[]> context = new HashMap<String, Object[]>();
        context.put("subdatabases", new DatabaseAdapterConverter().convert(subdatabases));
        String path = "vm/webapp/WEB-INF/applicationContext/__subdatabase.xml.vm";
        return VelocityUtils.merge((String)path, context);
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<!-- genclassname:" + this.getClass().getName() + " -->" + CR;
        }
        return "";
    }

    protected String getGooglemapKey() {
        String googlemapKey;
        GoogleMapScriptManager gmap_man = GoogleMapScriptManager.getInstance(this.project, true);
        String string = googlemapKey = gmap_man != null ? gmap_man.getGooglemapKey() : "";
        if (StringUtils.isBlank((CharSequence)googlemapKey)) {
            return "";
        }
        return googlemapKey;
    }

    class ApplicationContextBlockGenerator
    extends ConfigGenerator {
        private String id;
        private String content;

        ApplicationContextBlockGenerator(String id, String content, Project project) {
            super(null, project);
            this.id = id;
            this.content = content;
        }

        @Override
        public String getFileSuffix() {
            return ".xml";
        }

        @Override
        public String getFilename() {
            return this.id;
        }

        @Override
        public String getSubpackageName() {
            return "webpage" + File.separator + "WEB-INF" + File.separator + "applicationContext";
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public String process0() {
            return this.content;
        }
    }

    public static enum JFCQuartzJobManagerClass {
        V2RAM("jp.jasminesoft.jfc.JFCQuartzJobManagerBaseV2RAM"),
        V1("jp.jasminesoft.jfc.JFCQuartzJobManagerBaseV1"),
        V1MSA("jp.jasminesoft.jfc.JFCQuartzJobManagerBaseV1MSA"),
        V2JDBC("jp.jasminesoft.jfc.JFCQuartzJobManagerBaseV2JDBC");

        private String classname;

        public static JFCQuartzJobManagerClass valueOfClassname(String classname) {
            for (JFCQuartzJobManagerClass c : JFCQuartzJobManagerClass.values()) {
                if (!c.getClassname().equals(classname)) continue;
                return c;
            }
            return null;
        }

        private JFCQuartzJobManagerClass(String classname) {
            this.classname = classname;
        }

        public String getClassname() {
            return this.classname;
        }

        public boolean isUseJDBCJobstore() {
            return this == V1 || this == V1MSA;
        }

        public boolean isUseDomainScheduler() {
            return this == V1MSA;
        }

        public boolean isUseV2JDBCScheduler() {
            return this == V2JDBC;
        }
    }
}

