/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.CSSLayout;
import jp.jasminesoft.jfc.gen.EmptyStyleSheetManager;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.StyleSheetManager;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StyleSheetManagerFactory
implements IGeneratorFactory {
    private static Map<String, StyleSheetManager> idmap;
    private static Map<String, StyleSheetManager> filenamemap;
    private static List<StyleSheetManager> instancelist;
    protected static Logger logger;

    public static StyleSheetManager getInstance(Project project, Presentation presentation, Action action) {
        if (action != null) {
            String id = JavaSourceGenerator.createProperId(action);
            return StyleSheetManagerFactory.getInstance(project, presentation, id);
        }
        return StyleSheetManagerFactory.getInstance(project, presentation, (String)null);
    }

    public static StyleSheetManager getInstance(Project project, Presentation presentation, String id) {
        StyleSheetManager _instance;
        String filename;
        if (presentation.getFilename() != null) {
            filename = presentation.getFilename();
            _instance = filenamemap.get(filename);
            if (_instance != null) {
                return _instance;
            }
            _instance = new CSSLayout(project, presentation, id, filename);
            if (idmap.containsKey(filename)) {
                logger.warn("duplicate stylesheet filename " + filename);
                return null;
            }
            filenamemap.put(filename, _instance);
        } else if (id != null) {
            filename = id;
            _instance = idmap.get(filename);
            if (_instance != null) {
                return _instance;
            }
            _instance = new CSSLayout(project, presentation, id, filename);
            if (filenamemap.containsKey(filename)) {
                logger.warn("duplicate stylesheet filename " + filename);
                return null;
            }
            idmap.put(filename, _instance);
        } else {
            return null;
        }
        if (_instance != null) {
            instancelist.add(_instance);
        }
        if (id != null) {
            String myScreenStyleFilename = "My" + filename.substring(0, 1).toUpperCase() + filename.substring(1);
            EmptyStyleSheetManager myScreenStyleManager = new EmptyStyleSheetManager(project, presentation, id, myScreenStyleFilename);
            idmap.put(myScreenStyleFilename, myScreenStyleManager);
            instancelist.add(myScreenStyleManager);
            String myStyleFilename = "My";
            EmptyStyleSheetManager myStyleManager = new EmptyStyleSheetManager(project, presentation, id, myStyleFilename);
            idmap.put(myStyleFilename, myStyleManager);
            instancelist.add(myStyleManager);
        }
        return _instance;
    }

    public static Collection<StyleSheetManager> getAllStyleSheetManager() {
        return Collections.unmodifiableCollection(instancelist);
    }

    public static void reset() {
        idmap = Collections.synchronizedMap(new HashMap());
        filenamemap = Collections.synchronizedMap(new HashMap());
        instancelist = Collections.synchronizedList(new ArrayList());
    }

    static {
        StyleSheetManagerFactory.reset();
        logger = LogManager.getLogger((String)StyleSheetManagerFactory.class.getName());
    }
}

