/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.util.StringUtil;

public class TabBuffer
implements ISourceVariable {
    private StringBuilder sb;
    private int p;
    private int indent_size;
    private boolean tabChangeFlag;
    private boolean outputCRFlag;
    private InhibitCRFlag inhibitCRFlag;

    public TabBuffer() {
        this(0, new StringBuilder(), 4);
    }

    public TabBuffer(StringBuilder sb) {
        this(0, sb, 4);
    }

    public TabBuffer(int p, StringBuilder sb, int indent_size) {
        if (p > 0) {
            this.p = p;
        }
        this.sb = sb == null ? new StringBuilder() : sb;
        this.indent_size = indent_size >= 0 ? indent_size : 0;
        this.inhibitCRFlag = InhibitCRFlag.None;
    }

    public int getIndentSize() {
        return this.indent_size;
    }

    public void setIndentSize(int indent_size) {
        this.indent_size = indent_size;
    }

    public int getPosition() {
        return this.p;
    }

    public void setPosition(int p) {
        this.p = p;
    }

    public void setInhibitCr(boolean b) {
        this.inhibitCRFlag = b ? InhibitCRFlag.Ready : InhibitCRFlag.Close;
    }

    private void changeInhibitCRFlagStatus() {
        if (this.inhibitCRFlag == InhibitCRFlag.Ready) {
            this.inhibitCRFlag = InhibitCRFlag.Inhibit;
        } else if (this.inhibitCRFlag == InhibitCRFlag.Close) {
            this.inhibitCRFlag = InhibitCRFlag.None;
        }
    }

    public void cr() {
        if (this.outputCRFlag) {
            return;
        }
        if (this.inhibitCRFlag != InhibitCRFlag.Inhibit) {
            if (this.inhibitCRFlag != InhibitCRFlag.Close) {
                this.outputCRFlag = true;
                this.sb.append(CR);
                this.changeInhibitCRFlagStatus();
            }
        }
    }

    public void append(int i) {
        this.sb.append(i);
        this.tabChangeFlag = false;
        this.outputCRFlag = false;
    }

    public void append(char ch) {
        this.sb.append(ch);
        this.tabChangeFlag = false;
        this.outputCRFlag = false;
    }

    public void append(byte b) {
        this.sb.append(b);
        this.tabChangeFlag = false;
        this.outputCRFlag = false;
    }

    public void append(short s) {
        this.sb.append(s);
        this.tabChangeFlag = false;
        this.outputCRFlag = false;
    }

    public void append(float f) {
        this.sb.append(f);
        this.tabChangeFlag = false;
        this.outputCRFlag = false;
    }

    public void append(double d) {
        this.sb.append(d);
        this.tabChangeFlag = false;
        this.outputCRFlag = false;
    }

    public void append(long l) {
        this.sb.append(l);
        this.tabChangeFlag = false;
        this.outputCRFlag = false;
    }

    public void append(String str) {
        if (str != null && str.length() > 0 && !StringUtil.isWhitespace((String)str)) {
            this.sb.append(str);
            this.tabChangeFlag = false;
            this.outputCRFlag = false;
        }
    }

    public void append_cr(String str) {
        if (str != null && str.length() > 0 && !StringUtil.isWhitespace((String)str)) {
            this.sb.append(str);
            this.tabChangeFlag = false;
            if (this.inhibitCRFlag != InhibitCRFlag.Inhibit) {
                if (this.inhibitCRFlag != InhibitCRFlag.Close) {
                    this.sb.append(CR);
                    this.outputCRFlag = true;
                }
            }
            this.changeInhibitCRFlagStatus();
        }
    }

    public void append(Object obj) {
        if (obj == null) {
            return;
        }
        this.sb.append(obj.toString());
        this.tabChangeFlag = false;
        this.outputCRFlag = false;
    }

    public void append_cr(Object obj) {
        if (obj == null) {
            return;
        }
        this.sb.append(obj.toString());
        if (this.inhibitCRFlag != InhibitCRFlag.Inhibit) {
            if (this.inhibitCRFlag != InhibitCRFlag.Close) {
                this.sb.append(CR);
                this.outputCRFlag = true;
                this.tabChangeFlag = false;
            }
        }
        this.changeInhibitCRFlagStatus();
    }

    public void append_debug() {
        if (this.tabChangeFlag) {
            this.sb.append("t");
        } else {
            this.sb.append("f");
        }
    }

    public void forward() {
        if (this.inhibitCRFlag != InhibitCRFlag.Inhibit) {
            if (this.inhibitCRFlag != InhibitCRFlag.Close && !this.tabChangeFlag) {
                this.p += this.indent_size;
                this.sb.append(this.tab());
                this.tabChangeFlag = true;
            }
        }
        this.changeInhibitCRFlagStatus();
    }

    public void back() {
        if (this.inhibitCRFlag != InhibitCRFlag.Inhibit) {
            if (this.inhibitCRFlag != InhibitCRFlag.Close && !this.tabChangeFlag) {
                this.p -= this.indent_size;
                if (this.p < 0) {
                    this.p = 0;
                }
                this.sb.append(this.tab());
                this.tabChangeFlag = true;
            }
        }
        this.changeInhibitCRFlagStatus();
    }

    public void forceBack() {
        if (this.inhibitCRFlag != InhibitCRFlag.Inhibit) {
            if (this.inhibitCRFlag != InhibitCRFlag.Close) {
                if (this.tabChangeFlag) {
                    this.sb.delete(this.sb.length() - this.p, this.sb.length());
                    this.tabChangeFlag = false;
                }
                this.back();
            }
        }
    }

    public void indent() {
        if (this.inhibitCRFlag != InhibitCRFlag.Inhibit) {
            if (this.inhibitCRFlag != InhibitCRFlag.Close && !this.tabChangeFlag) {
                this.sb.append(this.tab());
                this.tabChangeFlag = true;
            }
        }
        this.changeInhibitCRFlagStatus();
    }

    private String tab() {
        String tab = null;
        switch (this.p) {
            case 2: {
                tab = "  ";
                break;
            }
            case 4: {
                tab = "    ";
                break;
            }
            case 6: {
                tab = "      ";
                break;
            }
            case 8: {
                tab = "        ";
                break;
            }
            case 10: {
                tab = "          ";
                break;
            }
            case 12: {
                tab = "            ";
                break;
            }
            case 14: {
                tab = "              ";
                break;
            }
            case 16: {
                tab = "                ";
                break;
            }
            case 18: {
                tab = "                  ";
                break;
            }
            case 20: {
                tab = "                    ";
                break;
            }
            case 22: {
                tab = "                      ";
                break;
            }
            case 24: {
                tab = "                        ";
                break;
            }
            case 26: {
                tab = "                          ";
                break;
            }
            case 28: {
                tab = "                            ";
                break;
            }
            case 30: {
                tab = "                              ";
                break;
            }
            case 32: {
                tab = "                                ";
                break;
            }
            case 34: {
                tab = "                                  ";
                break;
            }
            case 36: {
                tab = "                                    ";
                break;
            }
            case 38: {
                tab = "                                      ";
                break;
            }
            case 40: {
                tab = "                                        ";
                break;
            }
            case 42: {
                tab = "                                          ";
                break;
            }
            case 44: {
                tab = "                                            ";
                break;
            }
            case 46: {
                tab = "                                              ";
                break;
            }
            case 48: {
                tab = "                                                ";
                break;
            }
            case 50: {
                tab = "                                                  ";
                break;
            }
            case 52: {
                tab = "                                                    ";
                break;
            }
            case 54: {
                tab = "                                                      ";
                break;
            }
            case 56: {
                tab = "                                                        ";
                break;
            }
            case 58: {
                tab = "                                                          ";
                break;
            }
            case 60: {
                tab = "                                                            ";
                break;
            }
            default: {
                tab = "";
            }
        }
        return tab;
    }

    public int length() {
        return this.sb.length();
    }

    public void delete(int start, int end) {
        this.sb.delete(start, end);
    }

    public String toString() {
        return this.sb.toString();
    }

    public static void main(String[] args) {
        TabBuffer tb = new TabBuffer();
        tb.setIndentSize(2);
        tb.forward();
        tb.indent();
        tb.indent();
        tb.append("how are you ?");
        tb.cr();
        System.out.println(tb.toString());
    }

    private static enum InhibitCRFlag {
        Ready,
        Inhibit,
        Close,
        None;

    }
}

