/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.List;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ReplaceMapHelperGenerator_base;
import jp.jasminesoft.jfc.gen.TemplateExcelReportGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class TemplateExcelReportListFileGenerator
extends TemplateExcelReportGenerator {
    private static Logger logger = LogManager.getLogger(TemplateExcelReportListFileGenerator.class);

    public TemplateExcelReportListFileGenerator(String filename) {
        super(filename);
    }

    @Override
    protected void process0(List list, Sheet sheet, CellStyle style) {
        int size = list.size();
        int cellPosition = 0;
        for (int i = 0; i < size; ++i) {
            Object o = list.get(i);
            if (!(o instanceof ReplaceMapHelperGenerator_base.LabelPlaceHolderPair)) continue;
            Row row = null;
            row = cellPosition == 0 ? sheet.createRow(0) : sheet.getRow(0);
            ReplaceMapHelperGenerator_base.LabelPlaceHolderPair value = (ReplaceMapHelperGenerator_base.LabelPlaceHolderPair)o;
            if (value.placeholder.indexOf("#id") > 0) continue;
            if (cellPosition > 255) {
                logger.info("Output Excel Report Template is stopped. over cell index 256");
                break;
            }
            Cell cell_label = row.createCell(cellPosition);
            cell_label.setCellType(CellType.STRING);
            cell_label.setCellStyle(style);
            cell_label.setCellValue(value.label);
            row = cellPosition == 0 ? sheet.createRow(1) : sheet.getRow(1);
            Cell cell_placeholder = row.createCell(cellPosition);
            if (value.type == null) {
                cell_placeholder.setCellType(CellType.STRING);
            } else if (JavaSourceGenerator.isBasicType(value.type)) {
                cell_placeholder.setCellType(CellType.NUMERIC);
            } else {
                cell_placeholder.setCellType(CellType.STRING);
            }
            cell_placeholder.setCellType(CellType.STRING);
            cell_placeholder.setCellValue("${" + value.placeholder + "}");
            ++cellPosition;
        }
    }
}

