/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.ApplicationContextBeanByName;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.TextSearchGeneratorModule_Model2Map;
import jp.jasminesoft.jfc.gen.TextSearchUtil;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextSearchModuleGenerator {
    private Project project;
    protected static Logger logger = LogManager.getLogger(TextSearchModuleGenerator.class);
    protected static ResourceManager rman;

    public TextSearchModuleGenerator(Project project) {
        this.project = project;
        rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        if (!JFCAppGenerator.getIsTextSearch()) {
            logger.error(rman.getValue("gen.limit.textsearch"));
        }
    }

    public void process() {
        IProjectChoice[] ipcs;
        for (IProjectChoice ipc : ipcs = this.project.getContent()) {
            Model model;
            if (!(ipc instanceof Model) || !TextSearchUtil.isTextsearchNecessary4(this.project, model = (Model)ipc)) continue;
            TextSearchGeneratorModule_Model2Map generator = new TextSearchGeneratorModule_Model2Map(model, this.project);
            generator.process();
            this.addModel2Map2SpringApplicationContextContainer(model, generator);
        }
    }

    private void addModel2Map2SpringApplicationContextContainer(Model model, TextSearchGeneratorModule_Model2Map generator) {
        ApplicationContextBeanByName bean = new ApplicationContextBeanByName(generator.getClassname(), AppSchemaUtil.getPackagename_app(model, this.project) + generator.getClassname());
        bean.addProperty("textExtractor", new ApplicationContextBean.ReferenceElement("TextExtractor"));
        bean.addProperty("charCounter", new ApplicationContextBean.ReferenceElement("CharCounter"));
        SpringApplicationContextContainer.addApplicationContextBean(bean);
    }
}

