/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.XmlConfigGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displaycount;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Forward;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IResultcaseChoice;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Mapping;
import jp.jasminesoft.jfc.gen.appschema.Navigationbar;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Resultcase;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class ViewsXmlGenerator
extends XmlConfigGenerator {
    private boolean isFullBuild;
    private static final String[] reserve_action_path;
    private static final String[] reserve_forward_name;
    private static final Set<String> reserveActionPath;
    private static final Set<String> reserveForwardName;

    public ViewsXmlGenerator(String tmplatefilename, Project project, boolean isFullBuild) {
        super(tmplatefilename, project);
        this.isFullBuild = isFullBuild;
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "views";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF";
    }

    @Override
    protected String getCustomizeDirectory() {
        return "views";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.getTmplateFilename());
        if (!tplman.isValid()) {
            return "";
        }
        String menuinput = "/menu.jsp";
        String mobilemenuinput = "/mobileMenu.jsp";
        String afterLogon = "mainMenu.do";
        tplman.addContent("afterLogon", afterLogon);
        tplman.addContent("packagename", this.project.getPackage());
        LinkedHashMap<String, ActionNode> ruleMap = new LinkedHashMap<String, ActionNode>();
        TreeSet<String> menuSet = new TreeSet<String>();
        TreeSet<String> mobileMenuSet = new TreeSet<String>();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                String type;
                Layout layout;
                if (ipc[i] instanceof Action) {
                    Action action = (Action)ipc[i];
                    if (action.getWizard()) {
                        this.addWizardTask(action, ruleMap);
                    } else {
                        this.addTask(action, ruleMap);
                    }
                    if (action.getMenuref() == null) continue;
                    String pagenum = "";
                    if (action.getWizard()) {
                        pagenum = "1";
                    }
                    menuSet.add(JavaSourceGenerator.createProperId(action) + pagenum);
                    if (!AppSchemaUtil.isMobile(action, this.project)) continue;
                    mobileMenuSet.add(JavaSourceGenerator.createProperId(action) + pagenum);
                    continue;
                }
                if (!(ipc[i] instanceof Presentation)) continue;
                Presentation presentation = (Presentation)ipc[i];
                this.addTask(presentation, ruleMap);
                if ("menu".equals(presentation.getFilename())) {
                    layout = presentation.getLayout();
                    if (layout == null || (type = layout.getType()) == null || !type.startsWith("tiles:")) continue;
                    menuinput = "menu.page";
                    continue;
                }
                if (!"mobileMenu".equals(presentation.getFilename()) || (layout = presentation.getLayout()) == null || (type = layout.getType()) == null || !type.startsWith("tiles:")) continue;
                mobilemenuinput = "mobileMenu.page";
            }
        }
        this.createRuleDefinition(ruleMap);
        this.addCustomizeFile();
        tplman.addContent("rulecontent_def", this.createEntityRefDef());
        tplman.addContent("rulecontent", this.createEntityRef());
        tplman.addContent("logonlist", this.createForwardlist("logon.", ruleMap));
        tplman.addContent("menulist", this.createForwardlist("mainMenu.", menuSet));
        tplman.addContent("menuinput", menuinput);
        tplman.addContent("mobilemenulist", this.createForwardlist("mobileMenu.", mobileMenuSet));
        tplman.addContent("mobilemenuinput", mobilemenuinput);
        tplman.addContent("systemdir", "system");
        if (!this.isFullBuild && CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.SpringApplicationContextGenerator.lazy-initialization")) {
            tplman.addContent("beansattr", "default-lazy-init=\"true\"");
        } else {
            tplman.addContent("beansattr", "");
        }
        this.saveSeparateConfigFile();
        return tplman.getResult();
    }

    protected ActionNode createActionNode(String id, Action action) {
        ActionNode node = new ActionNode(action, id);
        String classname = JavaSourceGenerator.createActionClassname(id, action, this.project);
        node.setType(classname);
        return node;
    }

    private String convPathIfRedirectProcess(String path, String id, String name, Action action) {
        if ((id.startsWith("insert") || id.startsWith("copy")) && name.startsWith("show") && !name.startsWith("showList")) {
            String idref = action.getIdref();
            if (idref == null || idref.length() == 0) {
                idref = ((String)path).substring("show".length());
            }
            path = "redirect" + SourceGenerator.capFirst(idref) + ".jsp";
        }
        return path;
    }

    protected void addTask(Action action, Map<String, ActionNode> ruleMap) {
        Mapping[] mappings;
        Forward forward;
        String id = JavaSourceGenerator.createProperId(action);
        if (id == null || this.isReservedActionPath(id)) {
            return;
        }
        Presentation[] presentations = AppSchemaUtil.getPresentation(this.project, action);
        ActionNode node = null;
        if (presentations == null && (node = ruleMap.get(id)) == null) {
            node = this.createActionNode(id, action);
            if (node == null) {
                return;
            }
            ruleMap.put(id, node);
        }
        if ((forward = AppSchemaUtil.getForward(action)) != null && (mappings = forward.getMapping()) != null) {
            for (int i = 0; i < mappings.length; ++i) {
                String type;
                Mapping mapping = mappings[i];
                Object name = mapping.getName();
                Object path = mapping.getContent();
                if (name == null || ((String)name).length() == 0) {
                    name = path;
                }
                if ((type = mapping.getType()) != null && "wizard".equals(type)) {
                    int wpage = mapping.getPagenum();
                    if (wpage > 0) {
                        name = (String)name + wpage;
                        path = (String)path + wpage;
                    }
                } else if (type != null && "confirm".equals(type)) {
                    path = ((String)path).startsWith("confirmCopy") ? "confirmInsert" + ((String)path).substring("confirmCopy".length()) + ".page" : (String)path + ".page";
                } else if (type != null && "printScreen".equals(type)) {
                    if (name != null && ((String)name).endsWith(".page")) {
                        name = ((String)name).substring(0, ((String)name).length() - ".page".length());
                    }
                } else if (type != null && "printListScreen".equals(type) && name != null && ((String)name).endsWith(".page")) {
                    name = ((String)name).substring(0, ((String)name).length() - ".page".length());
                }
                if (node != null) {
                    node.addForward((String)name, (String)path, mapping);
                    continue;
                }
                for (int j = 0; j < presentations.length; ++j) {
                    String layouttype;
                    Layout layout;
                    Presentation presentation = presentations[j];
                    id = presentation.getFilename();
                    if (id == null || id.length() == 0) {
                        id = presentation.getIdref();
                    } else {
                        String idref = presentation.getIdref();
                        if (id.startsWith("confirm") && (idref.startsWith("update") || idref.startsWith("insert"))) continue;
                    }
                    if (this.isReservedActionPath(id) || (layout = presentation.getLayout()) == null || "tiles:print".equals(layouttype = layout.getType())) continue;
                    node = ruleMap.get(id);
                    if (node != null) {
                        node.addForward((String)name, (String)path, mapping);
                        continue;
                    }
                    if (action != null) {
                        Action showAction;
                        node = this.createActionNode(id, action);
                        if (node == null) continue;
                        if ("cmd".equals(type) && "Show".equals(mapping.getPattern()) && (showAction = AppSchemaUtil.getAction(this.project, (String)name)) != null && showAction.getWizard()) {
                            path = StringUtil.replace((String)path, (String)name, (String)((String)name + "1"));
                            name = (String)name + "1";
                        }
                        node.addForward((String)name, (String)path, mapping);
                        ruleMap.put(id, node);
                        continue;
                    }
                    this.logger.error(this.rman.getValue("strutsconfig.presentation.id.notfound", id));
                }
            }
        }
    }

    protected void addWizardTask(Action action, Map<String, ActionNode> ruleMap) {
        String id = JavaSourceGenerator.createProperId(action);
        if (id == null) {
            return;
        }
        ActionNode node = ruleMap.get(id);
        TreeSet<Integer> wset = new TreeSet<Integer>();
        Forward forward = AppSchemaUtil.getForward(action);
        Mapping[] mappings = null;
        if (forward != null && (mappings = forward.getMapping()) != null) {
            for (int i = 0; i < mappings.length; ++i) {
                int wpage;
                Mapping mapping = mappings[i];
                String type = mapping.getType();
                if (type == null || !"wizard".equals(type) || (wpage = mapping.getPagenum()) <= 0) continue;
                wset.add(wpage);
            }
        }
        if (node == null) {
            String classname = JavaSourceGenerator.createActionClassname(id, action, this.project);
            Integer firstpagenum = null;
            for (Integer num : wset) {
                if (firstpagenum == null) {
                    firstpagenum = num;
                }
                node = new ActionNode(action, id + num);
                node.setType(classname);
                node.setWizardFirstpagenum(firstpagenum);
                ruleMap.put(id + num, node);
                if (mappings == null) continue;
                for (int i = 0; i < mappings.length; ++i) {
                    String type;
                    Mapping mapping = mappings[i];
                    Object name = mapping.getName();
                    Object path = mapping.getContent();
                    if (name == null || ((String)name).length() == 0) {
                        name = path;
                    }
                    if ((type = mapping.getType()) != null && "wizard".equals(type)) {
                        int wpage = mapping.getPagenum();
                        if (wpage > 0) {
                            name = (String)name + wpage;
                            path = (String)path + wpage;
                        }
                        path = this.convPathIfRedirectProcess((String)path, id, (String)name, action);
                        if (id.startsWith("update") && ((String)name).startsWith("show")) {
                            path = (String)path + "1";
                        }
                    } else if (type != null && "confirm".equals(type)) {
                        path = ((String)path).startsWith("confirmCopy") ? "confirmInsert" + ((String)path).substring("confirmCopy".length()) + ".page" : (String)path + ".page";
                    }
                    if (node == null) continue;
                    node.addForward((String)name, (String)path, mapping);
                }
            }
        }
        if (wset.size() > 0) {
            ActionNode node_f = new ActionNode(action, id);
            node_f.setForwardAttribute("/" + id + "1.do");
            ruleMap.put(id, node_f);
        }
    }

    protected void addTask(Presentation presentation, Map<String, ActionNode> ruleMap) {
        String inputJspFilename;
        String pid = presentation.getIdref();
        Action action = AppSchemaUtil.getAction(this.project, pid);
        String id = presentation.getFilename();
        if (id == null || id.length() == 0) {
            if (action != null) {
                id = JavaSourceGenerator.createProperId(action);
            } else {
                id = pid;
                this.logger.warn(this.rman.getValue("strutsconfig.presentation.id.invalid", pid));
            }
        } else {
            String idref = presentation.getIdref();
            if (id.startsWith("confirm") && (idref.startsWith("update") || idref.startsWith("insert"))) {
                return;
            }
        }
        if (this.isReservedActionPath(id)) {
            return;
        }
        Layout layout = presentation.getLayout();
        if (layout == null) {
            return;
        }
        Panel[] panels = layout.getPanel();
        if (panels == null) {
            return;
        }
        String layouttype = layout.getType();
        if ("tiles:print".equals(layouttype) || StringUtils.startsWith((CharSequence)layouttype, (CharSequence)"thymeleaf")) {
            return;
        }
        ActionNode node = ruleMap.get(id);
        if (node == null) {
            if (action != null) {
                node = this.createActionNode(id, action);
                if (node == null) {
                    return;
                }
                ruleMap.put(id, node);
            } else {
                this.logger.error(this.rman.getValue("strutsconfig.presentation.id.notfound", id));
                return;
            }
        }
        if ((inputJspFilename = presentation.getFilename()) == null) {
            inputJspFilename = id;
        }
        node.setInputJsp(inputJspFilename);
        if (layouttype != null && layouttype.startsWith("tiles:")) {
            node.setTiles(true);
        }
        for (int i = 0; i < panels.length; ++i) {
            IPanelChoice[] ipnc = panels[i].getContent();
            if (ipnc == null) continue;
            for (int j = 0; j < ipnc.length; ++j) {
                IDisplaymodelChoice[] idc;
                Displaymodel dmodel;
                String forward;
                Link link;
                int k;
                if (ipnc[j] instanceof Navigationbar) {
                    Navigationbar nbar = (Navigationbar)ipnc[j];
                    Link[] links = nbar.getLink();
                    if (links == null || links.length == 0) continue;
                    for (k = 0; k < links.length; ++k) {
                        link = links[k];
                        forward = this.getForwardFromLink(link, presentation);
                        if (forward == null || forward.length() <= 0) continue;
                        node.addForward(forward);
                    }
                    continue;
                }
                if (ipnc[j] instanceof Displaycount) {
                    Displaycount dcnt = (Displaycount)ipnc[j];
                    Resultcase[] rcases = dcnt.getResultcase();
                    if (rcases == null) continue;
                    for (k = 0; k < rcases.length; ++k) {
                        Resultcase rcase = rcases[k];
                        IResultcaseChoice[] irc = rcase.getContent();
                        if (irc == null) continue;
                        for (int l = 0; l < irc.length; ++l) {
                            Link link2;
                            String forward2;
                            if (!(irc[l] instanceof Link) || (forward2 = this.getForwardFromLink(link2 = (Link)irc[l], presentation)) == null || forward2.length() <= 0) continue;
                            node.addForward(forward2);
                        }
                    }
                    continue;
                }
                if (ipnc[j] instanceof Displaycondition) {
                    Displaycondition dcond = (Displaycondition)ipnc[j];
                    node.addForward(dcond.getAction());
                    continue;
                }
                if (!(ipnc[j] instanceof Displaymodel) || (dmodel = (Displaymodel)ipnc[j]) == null || (idc = dmodel.getContent()) == null) continue;
                for (k = 0; k < idc.length; ++k) {
                    if (!(idc[k] instanceof Link) || (forward = this.getForwardFromLink(link = (Link)idc[k], presentation)) == null || forward.length() <= 0) continue;
                    node.addForward(forward);
                }
            }
        }
    }

    protected String getForwardFromLink(Link link, Presentation presentation) {
        String ret = link.getForward();
        if (ret != null) {
            return ret;
        }
        if ("button".equals(link.getType())) {
            Mapping[] mappings;
            String _action = link.getAction();
            if (_action == null) {
                return null;
            }
            String _id = presentation.getIdref();
            Action action = AppSchemaUtil.getAction(this.project, _id);
            if (action == null) {
                return null;
            }
            Forward forward = AppSchemaUtil.getForward(action);
            if (forward != null && (mappings = forward.getMapping()) != null) {
                for (int i = 0; i < mappings.length; ++i) {
                    Mapping mapping = mappings[i];
                    if (!"cmd".equals(mapping.getType()) || !_action.equals(mapping.getPattern())) continue;
                    ret = mapping.getContent();
                    break;
                }
            }
        }
        return ret;
    }

    protected void createRuleDefinition(Map<String, ActionNode> ruleMap) {
        LinkedHashMap<String, ArrayList<ActionNode>> groupMap = new LinkedHashMap<String, ArrayList<ActionNode>>();
        LinkedHashMap actionIdMap = new LinkedHashMap();
        for (String id : ruleMap.keySet()) {
            String actionId;
            ArrayList<ActionNode> list;
            ActionNode node = ruleMap.get(id);
            if (node.getModelId() != null && node.getModelId().length() > 0) {
                ArrayList<ActionNode> list2 = (ArrayList<ActionNode>)groupMap.get(node.getModelId());
                if (list2 == null) {
                    list2 = new ArrayList<ActionNode>();
                    groupMap.put(node.getModelId(), list2);
                }
                list2.add(node);
            }
            if ((list = (ArrayList<ActionNode>)actionIdMap.get(actionId = node.getAction().getId())) == null) {
                list = new ArrayList<ActionNode>();
                actionIdMap.put(actionId, list);
            }
            if (node.getInputJsp() == null) continue;
            list.add(node);
        }
        ArrayList keyList = new ArrayList(groupMap.keySet());
        Collections.sort(keyList);
        HashSet<String> beanIdSet = new HashSet<String>();
        for (int i = 0; i < keyList.size(); ++i) {
            String gid = (String)keyList.get(i);
            if (this.isReservedActionPath(gid)) continue;
            List list = (List)groupMap.get(gid);
            Collections.sort(list);
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < list.size(); ++j) {
                ActionNode node = (ActionNode)list.get(j);
                String forwardAttr = node.getForwardAttribute();
                String actionId = node.getAction().getId();
                if (forwardAttr != null) {
                    this.outputBean(sb, actionId, forwardAttr, beanIdSet);
                    continue;
                }
                List nodes = (List)actionIdMap.get(node.getAction().getId());
                if (node.getInputJsp() != null) {
                    String[] urls = new String[nodes.size()];
                    int cnt = 0;
                    for (ActionNode node1 : nodes) {
                        urls[cnt++] = this.getActionInput(node1);
                    }
                    for (cnt = 0; cnt < urls.length; ++cnt) {
                        Action _action;
                        Object footer = cnt == 0 ? ".input" : ".input" + (cnt + 1);
                        this.outputBean(sb, actionId + (String)footer, urls[cnt], beanIdSet);
                        if (!actionId.startsWith("show") || actionId.startsWith("showList") || !(_action = AppSchemaUtil.getAction(this.project, actionId)).getSubwindow() || !"show".equals(_action.getType())) continue;
                        String url = "/" + _action.getIdref() + "/subWindow" + SourceGenerator.capFirst(urls[cnt].replace(".page", ".jsp"));
                        this.outputBean(sb, actionId + ".input.sw", url, beanIdSet);
                    }
                }
                HashSet<String> existForwardnameSet = new HashSet<String>();
                this.outputForwardMap(sb, "    ", ruleMap, node, existForwardnameSet, beanIdSet);
            }
            this.putContentPart(gid, sb.toString());
        }
    }

    private void outputBean(StringBuilder sb, String id, String url, Set<String> beanIdSet) {
        this.outputBean(sb, id, url, false, beanIdSet);
    }

    private void outputBean(StringBuilder sb, String id, String url, boolean redirect, Set<String> beanIdSet) {
        if (beanIdSet.contains(id)) {
            this.logger.debug("duplicate views.xml id " + id);
            return;
        }
        beanIdSet.add(id);
        sb.append("    ");
        sb.append("<bean id=\"" + id + "\"");
        sb.append(CR);
        if (url.endsWith(".page")) {
            sb.append("        ");
            sb.append("class=\"org.springframework.web.servlet.view.tiles3.TilesView\">");
            sb.append(CR);
        } else if (url.endsWith(".jsp")) {
            sb.append("        ");
            sb.append("class=\"org.springframework.web.servlet.view.JstlView\">");
            sb.append(CR);
            sb.append("        ");
            sb.append("<property name=\"exposeContextBeansAsAttributes\" value=\"true\"/>");
            sb.append(CR);
        } else if (redirect) {
            sb.append("        ");
            sb.append("class=\"org.springframework.web.servlet.view.RedirectView\">");
            sb.append(CR);
            url = StringUtils.removeStart((String)url, (String)"/");
        } else {
            sb.append("        ");
            sb.append("class=\"org.springframework.web.servlet.view.InternalResourceView\">");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("<property name=\"url\" value=\"" + url + "\"/>");
        sb.append(CR);
        sb.append("    ");
        sb.append("</bean>");
        sb.append(CR);
    }

    private void outputForwardMap(StringBuilder sb, String tab, Map<String, ActionNode> ruleMap, ActionNode node, Set<String> existForwardnameSet, Set<String> beanIdSet) {
        Map<String, String> forwardMap = node.getForwardMap();
        for (String name : forwardMap.keySet()) {
            String path = forwardMap.get(name);
            if (ViewsXmlGenerator.isReservedForwardName(name) || existForwardnameSet.contains(name)) continue;
            String url = name.equals("wizardFirstpageInput") ? this.getActionWizardFirstpageInput(ruleMap, node) : this.getActionForwardPath(path, node);
            List<Mapping> mappings = node.getForwardMappingMap().get(name);
            if (mappings == null) continue;
            for (Mapping mapping : mappings) {
                this.outputFowardMap(sb, node, beanIdSet, mapping, url);
            }
            existForwardnameSet.add(name);
        }
    }

    private void outputFowardMap(StringBuilder sb, ActionNode node, Set<String> beanIdSet, Mapping mapping, String url) {
        Object type = mapping.getType();
        if (type == null) {
            type = mapping.getName();
        } else {
            if (((String)type).equals("cmd")) {
                type = mapping.getPattern().toLowerCase();
            }
            if (((String)type).equals("wizard")) {
                type = (String)type + mapping.getPagenumAsString();
            }
        }
        this.outputBean(sb, node.getAction().getId() + "." + (String)type, url, mapping.getRedirect(), beanIdSet);
    }

    private String getActionWizardFirstpageInput(Map<String, ActionNode> ruleMap, ActionNode node) {
        if (node.getAction().getWizard() && node.getWizardFirstpagenum() != null) {
            String id = JavaSourceGenerator.createProperId(node.getAction());
            Object firstpage_path = null;
            firstpage_path = "update".equals(node.getAction().getType()) ? node.getPath() : id + node.getWizardFirstpagenum();
            ActionNode firstpage_node = ruleMap.get(firstpage_path);
            if (firstpage_node != null && firstpage_node.getInputJsp() != null) {
                return this.getActionInput(firstpage_node);
            }
        }
        return this.getActionInput(node);
    }

    private String getActionInput(ActionNode node) {
        StringBuilder sb = new StringBuilder();
        if (node.isTiles()) {
            sb.append(node.getInputJsp());
            sb.append(".page");
        } else {
            sb.append("/");
            if (node.getModelId() != null && node.getModelId().length() > 0) {
                sb.append(node.getModelId() + "/");
            }
            sb.append(node.getInputJsp());
            sb.append(".jsp");
        }
        return sb.toString();
    }

    private String getActionForwardPath(String path, ActionNode node) {
        StringBuilder sb = new StringBuilder();
        if (!path.endsWith(".page")) {
            sb.append("/");
        }
        if (path.startsWith("redirect")) {
            sb.append(node.getModelId());
            sb.append("/");
        }
        sb.append(path);
        if (!(path.endsWith(".jsp") || path.endsWith(".html") || path.endsWith(".page"))) {
            sb.append(".do");
        }
        return sb.toString();
    }

    protected String createForwardlist(String idheader, Map<String, ActionNode> ruleMap) {
        TreeSet<String> menuSet = new TreeSet<String>();
        for (String id : ruleMap.keySet()) {
            ActionNode node = ruleMap.get(id);
            if (node.getForwardAttribute() != null) continue;
            menuSet.add(id);
        }
        return this.createForwardlist(idheader, menuSet);
    }

    protected String createForwardlist(String idheader, Set<String> menuSet) {
        StringBuilder sb = new StringBuilder();
        for (String name : menuSet) {
            if (ViewsXmlGenerator.isReservedForwardName(name)) continue;
            sb.append("    ");
            sb.append("<bean id=\"" + idheader + name + "\"");
            sb.append(CR);
            sb.append("        ");
            sb.append("class=\"org.springframework.web.servlet.view.InternalResourceView\">");
            sb.append(CR);
            sb.append("        ");
            sb.append("<property name=\"url\" value=\"/" + name + ".do\"/>");
            sb.append(CR);
            sb.append("    ");
            sb.append("</bean>");
            sb.append(CR);
        }
        return sb.toString();
    }

    protected boolean isReservedActionPath(String key) {
        return reserveActionPath.contains(key);
    }

    protected static boolean isReservedForwardName(String key) {
        return reserveForwardName.contains(key);
    }

    @Override
    protected void saveSeparateConfigFile0(String id, String content) {
        StrutsConfigBlockGenerator scbg = new StrutsConfigBlockGenerator(id, content, this.project);
        scbg.process();
    }

    @Override
    protected void createEntityRef0(String gid, StringBuilder sb) {
        sb.append("    ");
        sb.append("<import resource=\"views/");
        sb.append(gid);
        sb.append(".xml\"/>");
        sb.append(CR);
    }

    static {
        int i;
        reserve_action_path = new String[]{"logoff", "autoLogoff", "logon", "menu", "mainMenu", "mobileMenu"};
        reserve_forward_name = new String[]{"logoff", "autoLogoff", "logon", "menu", "mainMenu", "mobileMenu", "underConst", "failure", "globalerror", "securityerror", "noData", "empty"};
        reserveActionPath = new HashSet<String>();
        for (i = 0; i < reserve_action_path.length; ++i) {
            reserveActionPath.add(reserve_action_path[i]);
        }
        reserveForwardName = new HashSet<String>();
        for (i = 0; i < reserve_forward_name.length; ++i) {
            reserveForwardName.add(reserve_forward_name[i]);
        }
    }

    class ActionNode
    implements Comparable<ActionNode> {
        private Action action;
        private Integer wizardFirstpagenum;
        private String modelid;
        private String path;
        private String type;
        private String input_jsp;
        private String forwardAttr;
        private boolean tilesFlag;
        private Map<String, String> forwardMap;
        private Map<String, List<Mapping>> forwardMappingMap;
        private List<String> dataitem_updatelist_actionids;

        ActionNode(Action action, String path) {
            this.action = action;
            String modelid = action.getIdref();
            this.modelid = modelid != null && modelid.length() > 0 ? modelid : "system";
            this.path = path;
            this.forwardMap = new TreeMap<String, String>();
            this.forwardMappingMap = new TreeMap<String, List<Mapping>>();
            this.dataitem_updatelist_actionids = new ArrayList<String>();
            Dataitem[] dis = AppSchemaUtil.getDataitems(action);
            if (dis == null) {
                return;
            }
            for (Dataitem di : dis) {
                if (!"updateList".equals(di.getType())) continue;
                this.dataitem_updatelist_actionids.add(di.getActionid());
            }
        }

        String getModelId() {
            return this.modelid;
        }

        Action getAction() {
            return this.action;
        }

        void setWizardFirstpagenum(Integer wizardFirstpagenum) {
            this.wizardFirstpagenum = wizardFirstpagenum;
        }

        Integer getWizardFirstpagenum() {
            return this.wizardFirstpagenum;
        }

        String getPath() {
            return this.path;
        }

        void setType(String type) {
            this.type = type;
        }

        String getType() {
            return this.type;
        }

        void setInputJsp(String input_jsp) {
            this.input_jsp = input_jsp;
        }

        String getInputJsp() {
            return this.input_jsp;
        }

        void setTiles(boolean tilesFlag) {
            this.tilesFlag = tilesFlag;
        }

        boolean isTiles() {
            return this.tilesFlag;
        }

        void setForwardAttribute(String forwardAttr) {
            this.forwardAttr = forwardAttr;
        }

        String getForwardAttribute() {
            return this.forwardAttr;
        }

        void addForward(String path) {
            this.addForward(path, path, null);
        }

        void addForward(String name, String path, Mapping mapping) {
            if (name != null && !ViewsXmlGenerator.isReservedForwardName(name)) {
                this.forwardMap.put(name, path);
                if (mapping != null) {
                    List<Mapping> list = this.forwardMappingMap.get(name);
                    if (list == null) {
                        list = new ArrayList<Mapping>();
                        this.forwardMappingMap.put(name, list);
                    }
                    list.add(mapping);
                }
            }
        }

        Map<String, String> getForwardMap() {
            return Collections.unmodifiableMap(this.forwardMap);
        }

        Map<String, List<Mapping>> getForwardMappingMap() {
            return Collections.unmodifiableMap(this.forwardMappingMap);
        }

        List<String> getDataitemUpdatelistActionid() {
            return Collections.unmodifiableList(this.dataitem_updatelist_actionids);
        }

        @Override
        public int compareTo(ActionNode an) {
            return this.modelid.compareTo(an.modelid);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("action=" + this.action.getId() + ISourceVariable.CR);
            sb.append("wizardFirstpagenum=" + this.wizardFirstpagenum + ISourceVariable.CR);
            sb.append("modelid=" + this.modelid + ISourceVariable.CR);
            sb.append("path=" + this.path + ISourceVariable.CR);
            sb.append("type=" + this.type + ISourceVariable.CR);
            sb.append("input_jsp=" + this.input_jsp + ISourceVariable.CR);
            sb.append("forwardAttr=" + this.forwardAttr + ISourceVariable.CR);
            sb.append("tilesFlag=" + this.tilesFlag + ISourceVariable.CR);
            sb.append("forwardMap=" + this.forwardMap + ISourceVariable.CR);
            return sb.toString();
        }
    }

    class StrutsConfigBlockGenerator
    extends ConfigGenerator {
        private String id;
        private String content;

        StrutsConfigBlockGenerator(String id, String content, Project project) {
            super(null, project);
            this.id = id;
            this.content = content;
        }

        @Override
        public String getFileSuffix() {
            return ".xml";
        }

        @Override
        public String getFilename() {
            return this.id;
        }

        @Override
        public String getSubpackageName() {
            return "webpage" + File.separator + "WEB-INF" + File.separator + "views";
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public String process0() {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append(CR);
            sb.append("<beans ");
            if (CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.SpringApplicationContextGenerator.lazy-initialization") && !ViewsXmlGenerator.this.isFullBuild) {
                sb.append("default-lazy-init=\"true\"").append(CR).append("       ");
            }
            sb.append("xmlns=\"http://www.springframework.org/schema/beans\"").append(CR);
            sb.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            sb.append(CR);
            sb.append("    xmlns:context=\"http://www.springframework.org/schema/context\"");
            sb.append(CR);
            sb.append("    xmlns:util=\"http://www.springframework.org/schema/util\"");
            sb.append(CR);
            sb.append("    xmlns:mvc=\"http://www.springframework.org/schema/mvc\"");
            sb.append(CR);
            sb.append("    xsi:schemaLocation=\"");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/beans ");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/beans/spring-beans.xsd");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/context ");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/context/spring-context.xsd");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/util ");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/util/spring-util.xsd");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/mvc");
            sb.append(CR);
            sb.append("        http://www.springframework.org/schema/mvc/spring-mvc.xsd\">");
            sb.append(CR);
            sb.append(this.content);
            sb.append("</beans>");
            sb.append(CR);
            return sb.toString();
        }
    }
}

