/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.TextSearchUtil;
import jp.jasminesoft.jfc.gen.appschema.Anormlib;
import jp.jasminesoft.jfc.gen.appschema.ConnectionInterface;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Dblockmanager;
import jp.jasminesoft.jfc.gen.appschema.Defaultlogon;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Filestore;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Include;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.MessageQueue;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Param;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Redisdatabase;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebXmlUtils {
    protected static Logger logger = LogManager.getLogger(WebXmlUtils.class);
    private Project project;
    private boolean isFullBuild;

    public WebXmlUtils(Project project, boolean isFullBuild) {
        this.project = project;
        this.isFullBuild = isFullBuild;
    }

    public Map<String, Object> createTemplateMap() {
        Filestore filestore;
        Redisdatabase rdb;
        String httpsessionstoretype;
        Integer browserCacheMaxAge;
        String[] applicationContextPaths;
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        TreeMap<String, String> ctxparamMap = new TreeMap<String, String>();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        templateMap.put("contextParamMap", ctxparamMap);
        templateMap.put("paramMap", paramMap);
        templateMap.put("webencoding", JavaSourceGenerator.getWebEncoding(this.project));
        templateMap.put("contentTypeCharset", AppSchemaUtil.getContentTypeCharset(this.project));
        templateMap.put("jfcpackagename", this.project.getPackage());
        paramMap.put("application", "jp.jasminesoft.jfc.ApplicationResources");
        paramMap.put("debug", "2");
        paramMap.put("detail", "2");
        paramMap.put("validate", "true");
        paramMap.put("jsp_encoding", AppSchemaUtil.getContentTypeCharset(this.project));
        paramMap.put("encoding_convert", "true");
        paramMap.put("max_logon", "100");
        paramMap.put("session_timeout", "1800");
        paramMap.put("appmenu", "/WEB-INF/menu.xml");
        paramMap.put("download_dir", "${APPHOME}/download_dir");
        paramMap.put("cssfilemanager", "jp.jasminesoft.jfc.CssFileManagerImpl");
        paramMap.put("spring.autowire", "byName");
        paramMap.put("flowDefinitionOutputDirectory", "${DEPLOYHOME}/WEB-INF/workflow-definitions");
        paramMap.put("flowDefinitionCustomizeDirectory", "${DEPLOYHOME}/../../../customize/webpage/WEB-INF/workflow-definitions");
        paramMap.put("participantDefinitionOutputDirectory", "${DEPLOYHOME}/WEB-INF/workflow-definitions");
        Environment env = this.project.getEnvironment();
        if (env != null) {
            Param[] params;
            ConnectionInterface conintcfg;
            boolean checkClientSessionId;
            boolean forceOutputNoCache;
            Defaultlogon defaultlogon;
            paramMap.put("security_url", "file:${DEPLOYHOME}/WEB-INF/lib/jfcapp.jar");
            Database db = AppSchemaUtil.getDatabase(env);
            if (db != null) {
                String sequenceDML;
                String driver;
                String dbtype = db.getType();
                String quoteid = db.getQuoteid();
                String quotewhere = db.getQuotewhere();
                String quoteidinwhere = db.getQuoteidinwhere();
                boolean jdbc2flag = db.getJdbc2();
                paramMap.put("jdbc.quote_id", quoteid);
                paramMap.put("jdbc.quote_where", quotewhere);
                paramMap.put("jdbc.quote_id_in_where", quoteidinwhere);
                paramMap.put("jdbc.jdbc2", Boolean.valueOf(jdbc2flag).toString());
                paramMap.put("dbtype", dbtype);
                if (DbTypeManager.isDatabaseType(dbtype, "hsqldb") && (driver = db.getDriver()) != null && driver.indexOf("hsqldb") > -1) {
                    templateMap.put("hsqldbListener", Boolean.TRUE);
                }
                if (StringUtils.isNotBlank((CharSequence)(sequenceDML = db.getSequenceDML()))) {
                    paramMap.put("sequenceDML", sequenceDML);
                }
            }
            if ((defaultlogon = AppSchemaUtil.getDefaultlogon(env)) != null) {
                String userid = defaultlogon.getUserid();
                userid = userid != null ? userid : "guest";
                String pwd = defaultlogon.getPassword();
                pwd = pwd != null ? pwd : "guest";
                ctxparamMap.put("ignore_logoncheck", "true");
                ctxparamMap.put("ignore_logoncheckUsername", userid);
                ctxparamMap.put("ignore_logoncheckPassword", pwd);
            }
            if (!(forceOutputNoCache = env.getForceOutputNoCache())) {
                ctxparamMap.put("force_output_nocache", "false");
            }
            if (checkClientSessionId = env.getCheckClientSessionId()) {
                ctxparamMap.put("check_client_session_id", "true");
            }
            ctxparamMap.put("packagename", this.project.getPackage());
            Anormlib anormlib = AppSchemaUtil.getAnormlib(env);
            if (anormlib != null) {
                String anormlibtype = anormlib.getType();
                if ("horb".equals(anormlibtype)) {
                    String horburl = anormlib.getHorburl();
                    paramMap.put("anorm_horburl", horburl);
                } else if ("rmi".equals(anormlibtype) || "json".equals(anormlibtype)) {
                    String url = anormlib.getUrl();
                    paramMap.put("anorm_url", url);
                } else if ("jar".equals(anormlibtype)) {
                    paramMap.put("jmaster_dir", "${DEPLOYHOME}/WEB-INF/jmaster");
                    paramMap.put("jmaster_file", "zipcode.dat");
                }
            }
            if ((conintcfg = AppSchemaUtil.getConnectionInterface(env)) != null) {
                templateMap.put("conint_enable", Boolean.TRUE);
            }
            if ((params = AppSchemaUtil.getInitParams(env)) != null) {
                for (int i = 0; i < params.length; ++i) {
                    Param param = params[i];
                    String key = param.getKey();
                    String value = param.getValue();
                    if (key == null || value == null) continue;
                    paramMap.put(key, value);
                }
            }
            String dojo_webpage_dir = env.getDojoWebpageDir();
            templateMap.put("dojo_webpage_dir", dojo_webpage_dir);
            templateMap.put("securityParams", AppSchemaUtil.getSecurityParams(env));
            templateMap.put("miscParams", this.createMiscParams(env));
            Dblockmanager dlm = AppSchemaUtil.getDblockmanager(env);
            if (dlm != null && dlm.checkClearThismachineAtPostConstruct()) {
                templateMap.put("clearThismachineAtPostConstruct", Boolean.toString(dlm.getClearThismachineAtPostConstruct()));
            }
        }
        if ((applicationContextPaths = SpringApplicationContextContainer.getApplicationContextPaths()) != null && applicationContextPaths.length > 0) {
            StringBuilder contextConfigLocation = new StringBuilder();
            for (int i = 0; i < applicationContextPaths.length; ++i) {
                contextConfigLocation.append(applicationContextPaths[i]);
                if (i == applicationContextPaths.length - 1) continue;
                contextConfigLocation.append(" ");
            }
            ctxparamMap.put("contextConfigLocation", contextConfigLocation.toString());
            templateMap.put("contextLoaderListener", Boolean.TRUE);
        }
        ctxparamMap.put("mobileappmenu", "/WEB-INF/mobileMenu.xml");
        boolean useSubmenuFlag = this.checkUsingSubmenu();
        paramMap.put("useSubmenu", String.valueOf(useSubmenuFlag));
        boolean hasTextSearchModel = AppSchemaUtil.hasTextSearchModel(this.project);
        if (JFCAppGenerator.getIsTextSearch() && hasTextSearchModel) {
            String def = TextSearchUtil.createTextSearchTargetModelDefinition(this.project);
            templateMap.put("maketextindexservlet_enable", Boolean.TRUE);
            templateMap.put("maketextindexservlet_index_info", def);
        }
        if ((browserCacheMaxAge = env.getBrowserCacheMaxAgeAsInteger()) != null) {
            templateMap.put("browserCacheMaxAge_enable", Boolean.TRUE);
            templateMap.put("browserCacheMaxAge", browserCacheMaxAge.toString());
        }
        if ((httpsessionstoretype = env.getHttpSessionStoreType()) != null) {
            templateMap.put("httpsessionstoretype", httpsessionstoretype);
        }
        if ((rdb = AppSchemaUtil.getRedisdatabase(env)) != null) {
            templateMap.put("redisdatabase", rdb);
            templateMap.put("redisdatabaseFlushallInitializer", AppSchemaUtil.getActivemq(env) == null);
        }
        List<MessageQueue> messageQueues = AppSchemaUtil.getMessageQueue(env);
        for (MessageQueue messageQueue : messageQueues) {
            Param[] params;
            if (messageQueue.getType().equals("RabbitMQ")) {
                templateMap.put("messageQueueRabbitMQ", messageQueue);
                continue;
            }
            if (!messageQueue.getType().equals("ActiveMQ")) continue;
            templateMap.put("messageQueueActiveMQ", messageQueue);
            for (Param param : params = messageQueue.getParam()) {
                if (!param.getKey().equals("send_dest")) continue;
                templateMap.put("messageQueueActiveMQ_send_dest", param.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)env.getSessionCookieDomain())) {
            templateMap.put("sessionCookieDomain", env.getSessionCookieDomain());
        }
        if (CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.WebXmlUtils.lazy-initialization") && !this.isFullBuild) {
            templateMap.put("lazyinitialize", "true");
        }
        if ((filestore = AppSchemaUtil.getFilestore(env)) != null) {
            templateMap.put("s3bucket", filestore.getS3bucket());
            templateMap.put("s3folder", filestore.getS3folder());
        }
        return templateMap;
    }

    private boolean checkUsingSubmenu() {
        boolean ret = true;
        Presentation presentation = null;
        IProjectChoice[] ipc = this.project.getContent();
        for (int i = 0; i < ipc.length; ++i) {
            Presentation _presentation;
            if (!(ipc[i] instanceof Presentation) || !"menu".equals((_presentation = (Presentation)ipc[i]).getFilename())) continue;
            presentation = _presentation;
            break;
        }
        if (presentation == null) {
            return ret;
        }
        Layout layout = presentation.getLayout();
        Panel[] panels = layout.getPanel();
        block1: for (int i = 0; i < panels.length; ++i) {
            IPanelChoice[] ipac;
            Panel panel = panels[i];
            if (!"submenu".equals(panel.getName()) || (ipac = panel.getContent()) == null || ipac.length <= 0) continue;
            for (int j = 0; j < ipac.length; ++j) {
                Include _include;
                if (!(ipac[j] instanceof Include) || !"static".equals((_include = (Include)ipac[j]).getType()) || !"empty.html".equals(_include.getContent())) continue;
                ret = false;
                break block1;
            }
        }
        return ret;
    }

    private Map<String, String> createMiscParams(Environment env) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (env.checkDomain()) {
            map.put("wagby.domain.id", String.valueOf(env.getDomain()));
        }
        return map;
    }
}

