/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ExtensionFilenameFilter;

public abstract class XmlConfigGenerator
extends ConfigGenerator {
    private static final String[] exts = new String[]{".xml"};
    private Map<String, String> contentPartMap = new TreeMap<String, String>();
    private Set<String> customizeFileSet = new TreeSet<String>();

    public XmlConfigGenerator(Project project) {
        super(null, project);
    }

    public XmlConfigGenerator(String tmplatefilename, Project project) {
        super(tmplatefilename, project);
    }

    protected abstract String getCustomizeDirectory();

    protected void putContentPart(String id, String content) {
        this.contentPartMap.put(id, content);
    }

    protected void addCustomizeFile() {
        String[] basedirs;
        for (String basedir : basedirs = this.rman.getValueStrArray("CustomizeXmlBasedirs")) {
            File targetdir = new File(basedir, this.getCustomizeDirectory());
            if (!targetdir.exists() || !targetdir.isDirectory()) {
                this.logger.debug("customize basedir " + targetdir + " is not found.");
                return;
            }
            this.addCustomizeFile0(targetdir);
        }
    }

    private void addCustomizeFile0(File targetdir) {
        String[] lists = targetdir.list((FilenameFilter)new ExtensionFilenameFilter(exts, true));
        if (lists != null) {
            for (int i = 0; i < lists.length; ++i) {
                String filename;
                File f = new File(targetdir, lists[i]);
                if (f.isDirectory()) {
                    this.addCustomizeFile0(f);
                }
                if (!(filename = lists[i]).endsWith(".xml") || this.contentPartMap.containsKey(filename = filename.substring(0, filename.length() - ".xml".length()))) continue;
                this.customizeFileSet.add(filename);
            }
        }
    }

    protected String createEntityRefDef() {
        StringBuilder sb = new StringBuilder();
        for (String gid : this.contentPartMap.keySet()) {
            this.createEntityRefDef0(gid, sb);
        }
        for (String gid : this.customizeFileSet) {
            this.createEntityRefDef0(gid, sb);
        }
        return sb.toString();
    }

    protected void createEntityRefDef0(String gid, StringBuilder sb) {
        sb.append("<!ENTITY ");
        sb.append(gid);
        sb.append(" SYSTEM ");
        sb.append("\"");
        sb.append(this.getCustomizeDirectory());
        sb.append("/");
        sb.append(gid);
        sb.append(".xml\">");
        sb.append(CR);
    }

    protected String createEntityRef() {
        StringBuilder sb = new StringBuilder();
        for (String gid : this.contentPartMap.keySet()) {
            this.createEntityRef0(gid, sb);
        }
        for (String gid : this.customizeFileSet) {
            this.createEntityRef0(gid, sb);
        }
        return sb.toString();
    }

    protected void createEntityRef0(String gid, StringBuilder sb) {
        sb.append("    ");
        sb.append("&");
        sb.append(gid);
        sb.append(";");
        sb.append(CR);
    }

    protected void saveSeparateConfigFile() {
        for (String id : this.contentPartMap.keySet()) {
            String content = this.contentPartMap.get(id);
            this.saveSeparateConfigFile0(id, content);
        }
    }

    protected abstract void saveSeparateConfigFile0(String var1, String var2);
}

