/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClusterMachine
implements Serializable,
Cloneable,
IRNode {
    private String machinename_;
    private String ipaddr_;
    private Integer jmxPort_;
    private Integer rmiPort_;
    private Boolean thismachine_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public ClusterMachine() {
        this.machinename_ = "";
        this.ipaddr_ = "";
    }

    public ClusterMachine(ClusterMachine source) {
        this.setup(source);
    }

    public ClusterMachine(RStack stack) {
        this.setup(stack);
    }

    public ClusterMachine(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public ClusterMachine(Element element) {
        this.setup(element);
    }

    public ClusterMachine(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public ClusterMachine(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public ClusterMachine(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public ClusterMachine(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public ClusterMachine(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public ClusterMachine(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(ClusterMachine source) {
        this.setMachinename(source.getMachinename());
        this.setIpaddr(source.getIpaddr());
        this.setJmxPort(source.getJmxPort());
        this.setRmiPort(source.getRmiPort());
        this.setThismachine(source.getThismachine());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.machinename_ = URelaxer.getAttributePropertyAsString(element, "machinename");
        this.ipaddr_ = URelaxer.getAttributePropertyAsString(element, "ipaddr");
        this.jmxPort_ = URelaxer.getAttributePropertyAsIntObject(element, "jmx_port");
        this.rmiPort_ = URelaxer.getAttributePropertyAsIntObject(element, "rmi_port");
        this.thismachine_ = URelaxer.getAttributePropertyAsBooleanObject(element, "thismachine");
    }

    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createClusterMachine(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("cluster_machine");
        if (this.machinename_ != null) {
            URelaxer.setAttributePropertyByString(element, "machinename", this.machinename_);
        }
        if (this.ipaddr_ != null) {
            URelaxer.setAttributePropertyByString(element, "ipaddr", this.ipaddr_);
        }
        if (this.jmxPort_ != null) {
            URelaxer.setAttributePropertyByInt(element, "jmx_port", this.jmxPort_);
        }
        if (this.rmiPort_ != null) {
            URelaxer.setAttributePropertyByInt(element, "rmi_port", this.rmiPort_);
        }
        if (this.thismachine_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "thismachine", this.thismachine_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getMachinename() {
        return this.machinename_;
    }

    public final void setMachinename(String machinename) {
        this.machinename_ = machinename;
    }

    public final String getIpaddr() {
        return this.ipaddr_;
    }

    public final void setIpaddr(String ipaddr) {
        this.ipaddr_ = ipaddr;
    }

    public int getJmxPort() {
        if (this.jmxPort_ == null) {
            return -1;
        }
        return this.jmxPort_;
    }

    public int getJmxPort(int jmxPort) {
        if (this.jmxPort_ == null) {
            return jmxPort;
        }
        return this.jmxPort_;
    }

    public Integer getJmxPortAsInteger() {
        return this.jmxPort_;
    }

    public boolean checkJmxPort() {
        return this.jmxPort_ != null;
    }

    public void setJmxPort(int jmxPort) {
        this.jmxPort_ = new Integer(jmxPort);
    }

    public void setJmxPort(Integer jmxPort) {
        this.jmxPort_ = jmxPort;
    }

    public int getRmiPort() {
        if (this.rmiPort_ == null) {
            return -1;
        }
        return this.rmiPort_;
    }

    public int getRmiPort(int rmiPort) {
        if (this.rmiPort_ == null) {
            return rmiPort;
        }
        return this.rmiPort_;
    }

    public Integer getRmiPortAsInteger() {
        return this.rmiPort_;
    }

    public boolean checkRmiPort() {
        return this.rmiPort_ != null;
    }

    public void setRmiPort(int rmiPort) {
        this.rmiPort_ = new Integer(rmiPort);
    }

    public void setRmiPort(Integer rmiPort) {
        this.rmiPort_ = rmiPort;
    }

    public boolean getThismachine() {
        if (this.thismachine_ == null) {
            return false;
        }
        return this.thismachine_;
    }

    public boolean getThismachine(boolean thismachine) {
        if (this.thismachine_ == null) {
            return thismachine;
        }
        return this.thismachine_;
    }

    public Boolean getThismachineAsBoolean() {
        return this.thismachine_;
    }

    public boolean checkThismachine() {
        return this.thismachine_ != null;
    }

    public void setThismachine(boolean thismachine) {
        this.thismachine_ = new Boolean(thismachine);
    }

    public void setThismachine(Boolean thismachine) {
        this.thismachine_ = thismachine;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<cluster_machine");
        if (this.machinename_ != null) {
            buffer.append(" machinename=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMachinename())));
            buffer.append("\"");
        }
        if (this.ipaddr_ != null) {
            buffer.append(" ipaddr=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIpaddr())));
            buffer.append("\"");
        }
        if (this.jmxPort_ != null) {
            buffer.append(" jmx_port=\"");
            buffer.append(URelaxer.getString(this.getJmxPort()));
            buffer.append("\"");
        }
        if (this.rmiPort_ != null) {
            buffer.append(" rmi_port=\"");
            buffer.append(URelaxer.getString(this.getRmiPort()));
            buffer.append("\"");
        }
        if (this.thismachine_ != null) {
            buffer.append(" thismachine=\"");
            buffer.append(URelaxer.getString(this.getThismachine()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</cluster_machine>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<cluster_machine");
        if (this.machinename_ != null) {
            buffer.write(" machinename=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMachinename())));
            buffer.write("\"");
        }
        if (this.ipaddr_ != null) {
            buffer.write(" ipaddr=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIpaddr())));
            buffer.write("\"");
        }
        if (this.jmxPort_ != null) {
            buffer.write(" jmx_port=\"");
            buffer.write(URelaxer.getString(this.getJmxPort()));
            buffer.write("\"");
        }
        if (this.rmiPort_ != null) {
            buffer.write(" rmi_port=\"");
            buffer.write(URelaxer.getString(this.getRmiPort()));
            buffer.write("\"");
        }
        if (this.thismachine_ != null) {
            buffer.write(" thismachine=\"");
            buffer.write(URelaxer.getString(this.getThismachine()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</cluster_machine>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<cluster_machine");
        if (this.machinename_ != null) {
            buffer.print(" machinename=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMachinename())));
            buffer.print("\"");
        }
        if (this.ipaddr_ != null) {
            buffer.print(" ipaddr=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIpaddr())));
            buffer.print("\"");
        }
        if (this.jmxPort_ != null) {
            buffer.print(" jmx_port=\"");
            buffer.print(URelaxer.getString(this.getJmxPort()));
            buffer.print("\"");
        }
        if (this.rmiPort_ != null) {
            buffer.print(" rmi_port=\"");
            buffer.print(URelaxer.getString(this.getRmiPort()));
            buffer.print("\"");
        }
        if (this.thismachine_ != null) {
            buffer.print(" thismachine=\"");
            buffer.print(URelaxer.getString(this.getThismachine()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</cluster_machine>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getMachinenameAsString() {
        return URelaxer.getString(this.getMachinename());
    }

    public String getIpaddrAsString() {
        return URelaxer.getString(this.getIpaddr());
    }

    public String getJmxPortAsString() {
        return URelaxer.getString(this.getJmxPort());
    }

    public String getRmiPortAsString() {
        return URelaxer.getString(this.getRmiPort());
    }

    public String getThismachineAsString() {
        return URelaxer.getString(this.getThismachine());
    }

    public void setMachinenameByString(String string) {
        this.setMachinename(string);
    }

    public void setIpaddrByString(String string) {
        this.setIpaddr(string);
    }

    public void setJmxPortByString(String string) {
        this.setJmxPort(Integer.parseInt(string));
    }

    public void setRmiPortByString(String string) {
        this.setRmiPort(Integer.parseInt(string));
    }

    public void setThismachineByString(String string) {
        this.setThismachine((boolean)new Boolean(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "cluster_machine")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return ClusterMachine.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (ClusterMachine.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

