/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Consistency
implements Serializable,
Cloneable,
IRNode,
IModelitemChoice {
    private String target_;
    private String cond_;
    private Boolean ignoreNull_;
    private Boolean warning_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Consistency() {
    }

    public Consistency(Consistency source) {
        this.setup(source);
    }

    public Consistency(RStack stack) {
        this.setup(stack);
    }

    public Consistency(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Consistency(Element element) {
        this.setup(element);
    }

    public Consistency(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Consistency(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Consistency(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Consistency(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Consistency(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Consistency(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Consistency source) {
        this.setTarget(source.getTarget());
        this.setCond(source.getCond());
        this.setIgnoreNull(source.getIgnoreNull());
        this.setWarning(source.getWarning());
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.target_ = URelaxer.getAttributePropertyAsString(element, "target");
        this.cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        this.ignoreNull_ = URelaxer.getAttributePropertyAsBooleanObject(element, "ignore_null");
        this.warning_ = URelaxer.getAttributePropertyAsBooleanObject(element, "warning");
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createConsistency(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("consistency");
        if (this.target_ != null) {
            URelaxer.setAttributePropertyByString(element, "target", this.target_);
        }
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        if (this.ignoreNull_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "ignore_null", this.ignoreNull_);
        }
        if (this.warning_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "warning", this.warning_);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getTarget() {
        return this.target_;
    }

    public final void setTarget(String target) {
        this.target_ = target;
    }

    public final String getCond() {
        return this.cond_;
    }

    public final void setCond(String cond) {
        this.cond_ = cond;
    }

    public boolean getIgnoreNull() {
        if (this.ignoreNull_ == null) {
            return false;
        }
        return this.ignoreNull_;
    }

    public boolean getIgnoreNull(boolean ignoreNull) {
        if (this.ignoreNull_ == null) {
            return ignoreNull;
        }
        return this.ignoreNull_;
    }

    public Boolean getIgnoreNullAsBoolean() {
        return this.ignoreNull_;
    }

    public boolean checkIgnoreNull() {
        return this.ignoreNull_ != null;
    }

    public void setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull_ = new Boolean(ignoreNull);
    }

    public void setIgnoreNull(Boolean ignoreNull) {
        this.ignoreNull_ = ignoreNull;
    }

    public boolean getWarning() {
        if (this.warning_ == null) {
            return false;
        }
        return this.warning_;
    }

    public boolean getWarning(boolean warning) {
        if (this.warning_ == null) {
            return warning;
        }
        return this.warning_;
    }

    public Boolean getWarningAsBoolean() {
        return this.warning_;
    }

    public boolean checkWarning() {
        return this.warning_ != null;
    }

    public void setWarning(boolean warning) {
        this.warning_ = new Boolean(warning);
    }

    public void setWarning(Boolean warning) {
        this.warning_ = warning;
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<consistency");
        if (this.target_ != null) {
            buffer.append(" target=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTarget())));
            buffer.append("\"");
        }
        if (this.cond_ != null) {
            buffer.append(" cond=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCond())));
            buffer.append("\"");
        }
        if (this.ignoreNull_ != null) {
            buffer.append(" ignore_null=\"");
            buffer.append(URelaxer.getString(this.getIgnoreNull()));
            buffer.append("\"");
        }
        if (this.warning_ != null) {
            buffer.append(" warning=\"");
            buffer.append(URelaxer.getString(this.getWarning()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</consistency>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<consistency");
        if (this.target_ != null) {
            buffer.write(" target=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTarget())));
            buffer.write("\"");
        }
        if (this.cond_ != null) {
            buffer.write(" cond=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCond())));
            buffer.write("\"");
        }
        if (this.ignoreNull_ != null) {
            buffer.write(" ignore_null=\"");
            buffer.write(URelaxer.getString(this.getIgnoreNull()));
            buffer.write("\"");
        }
        if (this.warning_ != null) {
            buffer.write(" warning=\"");
            buffer.write(URelaxer.getString(this.getWarning()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</consistency>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<consistency");
        if (this.target_ != null) {
            buffer.print(" target=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTarget())));
            buffer.print("\"");
        }
        if (this.cond_ != null) {
            buffer.print(" cond=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCond())));
            buffer.print("\"");
        }
        if (this.ignoreNull_ != null) {
            buffer.print(" ignore_null=\"");
            buffer.print(URelaxer.getString(this.getIgnoreNull()));
            buffer.print("\"");
        }
        if (this.warning_ != null) {
            buffer.print(" warning=\"");
            buffer.print(URelaxer.getString(this.getWarning()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</consistency>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTargetAsString() {
        return URelaxer.getString(this.getTarget());
    }

    public String getCondAsString() {
        return URelaxer.getString(this.getCond());
    }

    public String getIgnoreNullAsString() {
        return URelaxer.getString(this.getIgnoreNull());
    }

    public String getWarningAsString() {
        return URelaxer.getString(this.getWarning());
    }

    public void setTargetByString(String string) {
        this.setTarget(string);
    }

    public void setCondByString(String string) {
        this.setCond(string);
    }

    public void setIgnoreNullByString(String string) {
        this.setIgnoreNull((boolean)new Boolean(string));
    }

    public void setWarningByString(String string) {
        this.setWarning((boolean)new Boolean(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "consistency")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Consistency.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Consistency.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

