/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IEnvironmentChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.QuartzJDBCJobstore;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.RdbSetting;
import jp.jasminesoft.jfc.gen.appschema.SchemaMigration;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Database
implements Serializable,
Cloneable,
IRNode,
IEnvironmentChoice {
    private String type_;
    private String name_;
    private String version_;
    private String driver_;
    private String url_;
    private String user_;
    private String password_;
    private Integer maxCount_;
    private Integer minCount_;
    private Integer maxActive_;
    private Integer maxIdle_;
    private Integer maxWait_;
    private String quoteid_;
    private String quotewhere_;
    private String quoteidinwhere_;
    private String quoteidForHibernate_;
    private String tablenameSeparatorForHibernate_;
    private Boolean jdbc2_;
    private String hibernateDialect_;
    private String charencoding_;
    private Boolean autoReconnect_;
    private Integer maxTablenameLength_;
    private Integer maxIndexnameLength_;
    private Integer maxColumnnameLength_;
    private String maxLengthStringDataType_;
    private String characterLargeObjectDataType_;
    private Boolean supportTimeDataType_;
    private String searchStringEscapeInLike_;
    private String createSequenceDDL_;
    private String sequenceDML_;
    private String dropIndexDDL_;
    private String springBatchDDL_;
    private String masterDDL_;
    private String validationQuery_;
    private String connectionInitSqls_;
    private String sessionFactory_;
    private String transactionManager_;
    private String hibernateSchema_;
    private Boolean columnDefault_;
    private Boolean encryptopassword_;
    private String dropSequenceDDL_;
    private String createIndexDDL_;
    private String jfcworkstateCreateIndexDDL_;
    private String jfcworkstateDropIndexDDL_;
    private QuartzJDBCJobstore quartzJDBCJobstore_;
    private SchemaMigration schemaMigration_;
    private RdbSetting rdbSetting_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Database() {
        this.user_ = "";
        this.password_ = "";
    }

    public Database(Database source) {
        this.setup(source);
    }

    public Database(RStack stack) {
        this.setup(stack);
    }

    public Database(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Database(Element element) {
        this.setup(element);
    }

    public Database(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Database(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Database(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Database(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Database(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Database(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Database source) {
        this.setType(source.getType());
        this.setName(source.getName());
        this.setVersion(source.getVersion());
        this.setDriver(source.getDriver());
        this.setUrl(source.getUrl());
        this.setUser(source.getUser());
        this.setPassword(source.getPassword());
        this.setMaxCount(source.getMaxCount());
        this.setMinCount(source.getMinCount());
        this.setMaxActive(source.getMaxActive());
        this.setMaxIdle(source.getMaxIdle());
        this.setMaxWait(source.getMaxWait());
        this.setQuoteid(source.getQuoteid());
        this.setQuotewhere(source.getQuotewhere());
        this.setQuoteidinwhere(source.getQuoteidinwhere());
        this.setQuoteidForHibernate(source.getQuoteidForHibernate());
        this.setTablenameSeparatorForHibernate(source.getTablenameSeparatorForHibernate());
        this.setJdbc2(source.getJdbc2());
        this.setHibernateDialect(source.getHibernateDialect());
        this.setCharencoding(source.getCharencoding());
        this.setAutoReconnect(source.getAutoReconnect());
        this.setMaxTablenameLength(source.getMaxTablenameLength());
        this.setMaxIndexnameLength(source.getMaxIndexnameLength());
        this.setMaxColumnnameLength(source.getMaxColumnnameLength());
        this.setMaxLengthStringDataType(source.getMaxLengthStringDataType());
        this.setCharacterLargeObjectDataType(source.getCharacterLargeObjectDataType());
        this.setSupportTimeDataType(source.getSupportTimeDataType());
        this.setSearchStringEscapeInLike(source.getSearchStringEscapeInLike());
        this.setCreateSequenceDDL(source.getCreateSequenceDDL());
        this.setSequenceDML(source.getSequenceDML());
        this.setDropIndexDDL(source.getDropIndexDDL());
        this.setSpringBatchDDL(source.getSpringBatchDDL());
        this.setMasterDDL(source.getMasterDDL());
        this.setValidationQuery(source.getValidationQuery());
        this.setConnectionInitSqls(source.getConnectionInitSqls());
        this.setSessionFactory(source.getSessionFactory());
        this.setTransactionManager(source.getTransactionManager());
        this.setHibernateSchema(source.getHibernateSchema());
        this.setColumnDefault(source.getColumnDefault());
        this.setEncryptopassword(source.getEncryptopassword());
        this.setDropSequenceDDL(source.getDropSequenceDDL());
        this.setCreateIndexDDL(source.getCreateIndexDDL());
        this.setJfcworkstateCreateIndexDDL(source.getJfcworkstateCreateIndexDDL());
        this.setJfcworkstateDropIndexDDL(source.getJfcworkstateDropIndexDDL());
        if (source.quartzJDBCJobstore_ != null) {
            this.setQuartzJDBCJobstore((QuartzJDBCJobstore)source.getQuartzJDBCJobstore().clone());
        }
        if (source.schemaMigration_ != null) {
            this.setSchemaMigration((SchemaMigration)source.getSchemaMigration().clone());
        }
        if (source.rdbSetting_ != null) {
            this.setRdbSetting((RdbSetting)source.getRdbSetting().clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.version_ = URelaxer.getAttributePropertyAsString(element, "version");
        this.driver_ = URelaxer.getAttributePropertyAsString(element, "driver");
        this.url_ = URelaxer.getAttributePropertyAsString(element, "url");
        this.user_ = URelaxer.getAttributePropertyAsString(element, "user");
        this.password_ = URelaxer.getAttributePropertyAsString(element, "password");
        this.maxCount_ = URelaxer.getAttributePropertyAsIntObject(element, "maxCount");
        this.minCount_ = URelaxer.getAttributePropertyAsIntObject(element, "minCount");
        this.maxActive_ = URelaxer.getAttributePropertyAsIntObject(element, "maxActive");
        this.maxIdle_ = URelaxer.getAttributePropertyAsIntObject(element, "maxIdle");
        this.maxWait_ = URelaxer.getAttributePropertyAsIntObject(element, "maxWait");
        this.quoteid_ = URelaxer.getAttributePropertyAsString(element, "quoteid");
        this.quotewhere_ = URelaxer.getAttributePropertyAsString(element, "quotewhere");
        this.quoteidinwhere_ = URelaxer.getAttributePropertyAsString(element, "quoteidinwhere");
        this.quoteidForHibernate_ = URelaxer.getAttributePropertyAsString(element, "quoteid_for_hibernate");
        this.tablenameSeparatorForHibernate_ = URelaxer.getAttributePropertyAsString(element, "tablename_separator_for_hibernate");
        this.jdbc2_ = URelaxer.getAttributePropertyAsBooleanObject(element, "jdbc2");
        this.hibernateDialect_ = URelaxer.getAttributePropertyAsString(element, "hibernate_dialect");
        this.charencoding_ = URelaxer.getAttributePropertyAsString(element, "charencoding");
        this.autoReconnect_ = URelaxer.getAttributePropertyAsBooleanObject(element, "autoReconnect");
        this.maxTablenameLength_ = URelaxer.getAttributePropertyAsIntObject(element, "maxTablenameLength");
        this.maxIndexnameLength_ = URelaxer.getAttributePropertyAsIntObject(element, "maxIndexnameLength");
        this.maxColumnnameLength_ = URelaxer.getAttributePropertyAsIntObject(element, "maxColumnnameLength");
        this.maxLengthStringDataType_ = URelaxer.getAttributePropertyAsString(element, "maxLengthStringDataType");
        this.characterLargeObjectDataType_ = URelaxer.getAttributePropertyAsString(element, "characterLargeObjectDataType");
        this.supportTimeDataType_ = URelaxer.getAttributePropertyAsBooleanObject(element, "supportTimeDataType");
        this.searchStringEscapeInLike_ = URelaxer.getAttributePropertyAsString(element, "searchStringEscapeInLike");
        this.createSequenceDDL_ = URelaxer.getAttributePropertyAsString(element, "createSequenceDDL");
        this.sequenceDML_ = URelaxer.getAttributePropertyAsString(element, "sequenceDML");
        this.dropIndexDDL_ = URelaxer.getAttributePropertyAsString(element, "dropIndexDDL");
        this.springBatchDDL_ = URelaxer.getAttributePropertyAsString(element, "springBatchDDL");
        this.masterDDL_ = URelaxer.getAttributePropertyAsString(element, "masterDDL");
        this.validationQuery_ = URelaxer.getAttributePropertyAsString(element, "validationQuery");
        this.connectionInitSqls_ = URelaxer.getAttributePropertyAsString(element, "connectionInitSqls");
        this.sessionFactory_ = URelaxer.getAttributePropertyAsString(element, "sessionFactory");
        this.transactionManager_ = URelaxer.getAttributePropertyAsString(element, "transactionManager");
        this.hibernateSchema_ = URelaxer.getAttributePropertyAsString(element, "hibernate_schema");
        this.columnDefault_ = URelaxer.getAttributePropertyAsBooleanObject(element, "columnDefault");
        this.encryptopassword_ = URelaxer.getAttributePropertyAsBooleanObject(element, "encryptopassword");
        this.dropSequenceDDL_ = URelaxer.getAttributePropertyAsString(element, "dropSequenceDDL");
        this.createIndexDDL_ = URelaxer.getAttributePropertyAsString(element, "createIndexDDL");
        this.jfcworkstateCreateIndexDDL_ = URelaxer.getAttributePropertyAsString(element, "jfcworkstateCreateIndexDDL");
        this.jfcworkstateDropIndexDDL_ = URelaxer.getAttributePropertyAsString(element, "jfcworkstateDropIndexDDL");
        if (QuartzJDBCJobstore.isMatch(stack)) {
            this.setQuartzJDBCJobstore(factory.createQuartzJDBCJobstore(stack));
        }
        if (SchemaMigration.isMatch(stack)) {
            this.setSchemaMigration(factory.createSchemaMigration(stack));
        }
        if (RdbSetting.isMatch(stack)) {
            this.setRdbSetting(factory.createRdbSetting(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createDatabase(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("database");
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.version_ != null) {
            URelaxer.setAttributePropertyByString(element, "version", this.version_);
        }
        if (this.driver_ != null) {
            URelaxer.setAttributePropertyByString(element, "driver", this.driver_);
        }
        if (this.url_ != null) {
            URelaxer.setAttributePropertyByString(element, "url", this.url_);
        }
        if (this.user_ != null) {
            URelaxer.setAttributePropertyByString(element, "user", this.user_);
        }
        if (this.password_ != null) {
            URelaxer.setAttributePropertyByString(element, "password", this.password_);
        }
        if (this.maxCount_ != null) {
            URelaxer.setAttributePropertyByInt(element, "maxCount", this.maxCount_);
        }
        if (this.minCount_ != null) {
            URelaxer.setAttributePropertyByInt(element, "minCount", this.minCount_);
        }
        if (this.maxActive_ != null) {
            URelaxer.setAttributePropertyByInt(element, "maxActive", this.maxActive_);
        }
        if (this.maxIdle_ != null) {
            URelaxer.setAttributePropertyByInt(element, "maxIdle", this.maxIdle_);
        }
        if (this.maxWait_ != null) {
            URelaxer.setAttributePropertyByInt(element, "maxWait", this.maxWait_);
        }
        if (this.quoteid_ != null) {
            URelaxer.setAttributePropertyByString(element, "quoteid", this.quoteid_);
        }
        if (this.quotewhere_ != null) {
            URelaxer.setAttributePropertyByString(element, "quotewhere", this.quotewhere_);
        }
        if (this.quoteidinwhere_ != null) {
            URelaxer.setAttributePropertyByString(element, "quoteidinwhere", this.quoteidinwhere_);
        }
        if (this.quoteidForHibernate_ != null) {
            URelaxer.setAttributePropertyByString(element, "quoteid_for_hibernate", this.quoteidForHibernate_);
        }
        if (this.tablenameSeparatorForHibernate_ != null) {
            URelaxer.setAttributePropertyByString(element, "tablename_separator_for_hibernate", this.tablenameSeparatorForHibernate_);
        }
        if (this.jdbc2_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "jdbc2", this.jdbc2_);
        }
        if (this.hibernateDialect_ != null) {
            URelaxer.setAttributePropertyByString(element, "hibernate_dialect", this.hibernateDialect_);
        }
        if (this.charencoding_ != null) {
            URelaxer.setAttributePropertyByString(element, "charencoding", this.charencoding_);
        }
        if (this.autoReconnect_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "autoReconnect", this.autoReconnect_);
        }
        if (this.maxTablenameLength_ != null) {
            URelaxer.setAttributePropertyByInt(element, "maxTablenameLength", this.maxTablenameLength_);
        }
        if (this.maxIndexnameLength_ != null) {
            URelaxer.setAttributePropertyByInt(element, "maxIndexnameLength", this.maxIndexnameLength_);
        }
        if (this.maxColumnnameLength_ != null) {
            URelaxer.setAttributePropertyByInt(element, "maxColumnnameLength", this.maxColumnnameLength_);
        }
        if (this.maxLengthStringDataType_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxLengthStringDataType", this.maxLengthStringDataType_);
        }
        if (this.characterLargeObjectDataType_ != null) {
            URelaxer.setAttributePropertyByString(element, "characterLargeObjectDataType", this.characterLargeObjectDataType_);
        }
        if (this.supportTimeDataType_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "supportTimeDataType", this.supportTimeDataType_);
        }
        if (this.searchStringEscapeInLike_ != null) {
            URelaxer.setAttributePropertyByString(element, "searchStringEscapeInLike", this.searchStringEscapeInLike_);
        }
        if (this.createSequenceDDL_ != null) {
            URelaxer.setAttributePropertyByString(element, "createSequenceDDL", this.createSequenceDDL_);
        }
        if (this.sequenceDML_ != null) {
            URelaxer.setAttributePropertyByString(element, "sequenceDML", this.sequenceDML_);
        }
        if (this.dropIndexDDL_ != null) {
            URelaxer.setAttributePropertyByString(element, "dropIndexDDL", this.dropIndexDDL_);
        }
        if (this.springBatchDDL_ != null) {
            URelaxer.setAttributePropertyByString(element, "springBatchDDL", this.springBatchDDL_);
        }
        if (this.masterDDL_ != null) {
            URelaxer.setAttributePropertyByString(element, "masterDDL", this.masterDDL_);
        }
        if (this.validationQuery_ != null) {
            URelaxer.setAttributePropertyByString(element, "validationQuery", this.validationQuery_);
        }
        if (this.connectionInitSqls_ != null) {
            URelaxer.setAttributePropertyByString(element, "connectionInitSqls", this.connectionInitSqls_);
        }
        if (this.sessionFactory_ != null) {
            URelaxer.setAttributePropertyByString(element, "sessionFactory", this.sessionFactory_);
        }
        if (this.transactionManager_ != null) {
            URelaxer.setAttributePropertyByString(element, "transactionManager", this.transactionManager_);
        }
        if (this.hibernateSchema_ != null) {
            URelaxer.setAttributePropertyByString(element, "hibernate_schema", this.hibernateSchema_);
        }
        if (this.columnDefault_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "columnDefault", this.columnDefault_);
        }
        if (this.encryptopassword_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "encryptopassword", this.encryptopassword_);
        }
        if (this.dropSequenceDDL_ != null) {
            URelaxer.setAttributePropertyByString(element, "dropSequenceDDL", this.dropSequenceDDL_);
        }
        if (this.createIndexDDL_ != null) {
            URelaxer.setAttributePropertyByString(element, "createIndexDDL", this.createIndexDDL_);
        }
        if (this.jfcworkstateCreateIndexDDL_ != null) {
            URelaxer.setAttributePropertyByString(element, "jfcworkstateCreateIndexDDL", this.jfcworkstateCreateIndexDDL_);
        }
        if (this.jfcworkstateDropIndexDDL_ != null) {
            URelaxer.setAttributePropertyByString(element, "jfcworkstateDropIndexDDL", this.jfcworkstateDropIndexDDL_);
        }
        if (this.quartzJDBCJobstore_ != null) {
            this.quartzJDBCJobstore_.makeElement(element);
        }
        if (this.schemaMigration_ != null) {
            this.schemaMigration_.makeElement(element);
        }
        if (this.rdbSetting_ != null) {
            this.rdbSetting_.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getType() {
        if (this.type_ == null) {
            return "hsqldb";
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getName() {
        if (this.name_ == null) {
            return "jdbc/jfc";
        }
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getVersion() {
        return this.version_;
    }

    public final void setVersion(String version) {
        this.version_ = version;
    }

    public final String getDriver() {
        if (this.driver_ == null) {
            return "org.hsqldb.jdbcDriver";
        }
        return this.driver_;
    }

    public final void setDriver(String driver) {
        this.driver_ = driver;
    }

    public final String getUrl() {
        if (this.url_ == null) {
            return "jdbc:hsqldb:sampledb";
        }
        return this.url_;
    }

    public final void setUrl(String url) {
        this.url_ = url;
    }

    public final String getUser() {
        return this.user_;
    }

    public final void setUser(String user) {
        this.user_ = user;
    }

    public final String getPassword() {
        return this.password_;
    }

    public final void setPassword(String password) {
        this.password_ = password;
    }

    public int getMaxCount() {
        if (this.maxCount_ == null) {
            return 20;
        }
        return this.maxCount_;
    }

    public int getMaxCount(int maxCount) {
        if (this.maxCount_ == null) {
            return maxCount;
        }
        return this.maxCount_;
    }

    public Integer getMaxCountAsInteger() {
        return this.maxCount_;
    }

    public boolean checkMaxCount() {
        return this.maxCount_ != null;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount_ = new Integer(maxCount);
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount_ = maxCount;
    }

    public int getMinCount() {
        if (this.minCount_ == null) {
            return 2;
        }
        return this.minCount_;
    }

    public int getMinCount(int minCount) {
        if (this.minCount_ == null) {
            return minCount;
        }
        return this.minCount_;
    }

    public Integer getMinCountAsInteger() {
        return this.minCount_;
    }

    public boolean checkMinCount() {
        return this.minCount_ != null;
    }

    public void setMinCount(int minCount) {
        this.minCount_ = new Integer(minCount);
    }

    public void setMinCount(Integer minCount) {
        this.minCount_ = minCount;
    }

    public int getMaxActive() {
        if (this.maxActive_ == null) {
            return 30;
        }
        return this.maxActive_;
    }

    public int getMaxActive(int maxActive) {
        if (this.maxActive_ == null) {
            return maxActive;
        }
        return this.maxActive_;
    }

    public Integer getMaxActiveAsInteger() {
        return this.maxActive_;
    }

    public boolean checkMaxActive() {
        return this.maxActive_ != null;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive_ = new Integer(maxActive);
    }

    public void setMaxActive(Integer maxActive) {
        this.maxActive_ = maxActive;
    }

    public int getMaxIdle() {
        if (this.maxIdle_ == null) {
            return 10;
        }
        return this.maxIdle_;
    }

    public int getMaxIdle(int maxIdle) {
        if (this.maxIdle_ == null) {
            return maxIdle;
        }
        return this.maxIdle_;
    }

    public Integer getMaxIdleAsInteger() {
        return this.maxIdle_;
    }

    public boolean checkMaxIdle() {
        return this.maxIdle_ != null;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle_ = new Integer(maxIdle);
    }

    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle_ = maxIdle;
    }

    public int getMaxWait() {
        if (this.maxWait_ == null) {
            return 5000;
        }
        return this.maxWait_;
    }

    public int getMaxWait(int maxWait) {
        if (this.maxWait_ == null) {
            return maxWait;
        }
        return this.maxWait_;
    }

    public Integer getMaxWaitAsInteger() {
        return this.maxWait_;
    }

    public boolean checkMaxWait() {
        return this.maxWait_ != null;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait_ = new Integer(maxWait);
    }

    public void setMaxWait(Integer maxWait) {
        this.maxWait_ = maxWait;
    }

    public final String getQuoteid() {
        return this.quoteid_;
    }

    public final void setQuoteid(String quoteid) {
        this.quoteid_ = quoteid;
    }

    public final String getQuotewhere() {
        return this.quotewhere_;
    }

    public final void setQuotewhere(String quotewhere) {
        this.quotewhere_ = quotewhere;
    }

    public final String getQuoteidinwhere() {
        return this.quoteidinwhere_;
    }

    public final void setQuoteidinwhere(String quoteidinwhere) {
        this.quoteidinwhere_ = quoteidinwhere;
    }

    public final String getQuoteidForHibernate() {
        return this.quoteidForHibernate_;
    }

    public final void setQuoteidForHibernate(String quoteidForHibernate) {
        this.quoteidForHibernate_ = quoteidForHibernate;
    }

    public final String getTablenameSeparatorForHibernate() {
        return this.tablenameSeparatorForHibernate_;
    }

    public final void setTablenameSeparatorForHibernate(String tablenameSeparatorForHibernate) {
        this.tablenameSeparatorForHibernate_ = tablenameSeparatorForHibernate;
    }

    public boolean getJdbc2() {
        if (this.jdbc2_ == null) {
            return true;
        }
        return this.jdbc2_;
    }

    public boolean getJdbc2(boolean jdbc2) {
        if (this.jdbc2_ == null) {
            return jdbc2;
        }
        return this.jdbc2_;
    }

    public Boolean getJdbc2AsBoolean() {
        return this.jdbc2_;
    }

    public boolean checkJdbc2() {
        return this.jdbc2_ != null;
    }

    public void setJdbc2(boolean jdbc2) {
        this.jdbc2_ = new Boolean(jdbc2);
    }

    public void setJdbc2(Boolean jdbc2) {
        this.jdbc2_ = jdbc2;
    }

    public final String getHibernateDialect() {
        return this.hibernateDialect_;
    }

    public final void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect_ = hibernateDialect;
    }

    public final String getCharencoding() {
        return this.charencoding_;
    }

    public final void setCharencoding(String charencoding) {
        this.charencoding_ = charencoding;
    }

    public boolean getAutoReconnect() {
        if (this.autoReconnect_ == null) {
            return false;
        }
        return this.autoReconnect_;
    }

    public boolean getAutoReconnect(boolean autoReconnect) {
        if (this.autoReconnect_ == null) {
            return autoReconnect;
        }
        return this.autoReconnect_;
    }

    public Boolean getAutoReconnectAsBoolean() {
        return this.autoReconnect_;
    }

    public boolean checkAutoReconnect() {
        return this.autoReconnect_ != null;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect_ = new Boolean(autoReconnect);
    }

    public void setAutoReconnect(Boolean autoReconnect) {
        this.autoReconnect_ = autoReconnect;
    }

    public int getMaxTablenameLength() {
        if (this.maxTablenameLength_ == null) {
            return -1;
        }
        return this.maxTablenameLength_;
    }

    public int getMaxTablenameLength(int maxTablenameLength) {
        if (this.maxTablenameLength_ == null) {
            return maxTablenameLength;
        }
        return this.maxTablenameLength_;
    }

    public Integer getMaxTablenameLengthAsInteger() {
        return this.maxTablenameLength_;
    }

    public boolean checkMaxTablenameLength() {
        return this.maxTablenameLength_ != null;
    }

    public void setMaxTablenameLength(int maxTablenameLength) {
        this.maxTablenameLength_ = new Integer(maxTablenameLength);
    }

    public void setMaxTablenameLength(Integer maxTablenameLength) {
        this.maxTablenameLength_ = maxTablenameLength;
    }

    public int getMaxIndexnameLength() {
        if (this.maxIndexnameLength_ == null) {
            return -1;
        }
        return this.maxIndexnameLength_;
    }

    public int getMaxIndexnameLength(int maxIndexnameLength) {
        if (this.maxIndexnameLength_ == null) {
            return maxIndexnameLength;
        }
        return this.maxIndexnameLength_;
    }

    public Integer getMaxIndexnameLengthAsInteger() {
        return this.maxIndexnameLength_;
    }

    public boolean checkMaxIndexnameLength() {
        return this.maxIndexnameLength_ != null;
    }

    public void setMaxIndexnameLength(int maxIndexnameLength) {
        this.maxIndexnameLength_ = new Integer(maxIndexnameLength);
    }

    public void setMaxIndexnameLength(Integer maxIndexnameLength) {
        this.maxIndexnameLength_ = maxIndexnameLength;
    }

    public int getMaxColumnnameLength() {
        if (this.maxColumnnameLength_ == null) {
            return -1;
        }
        return this.maxColumnnameLength_;
    }

    public int getMaxColumnnameLength(int maxColumnnameLength) {
        if (this.maxColumnnameLength_ == null) {
            return maxColumnnameLength;
        }
        return this.maxColumnnameLength_;
    }

    public Integer getMaxColumnnameLengthAsInteger() {
        return this.maxColumnnameLength_;
    }

    public boolean checkMaxColumnnameLength() {
        return this.maxColumnnameLength_ != null;
    }

    public void setMaxColumnnameLength(int maxColumnnameLength) {
        this.maxColumnnameLength_ = new Integer(maxColumnnameLength);
    }

    public void setMaxColumnnameLength(Integer maxColumnnameLength) {
        this.maxColumnnameLength_ = maxColumnnameLength;
    }

    public final String getMaxLengthStringDataType() {
        return this.maxLengthStringDataType_;
    }

    public final void setMaxLengthStringDataType(String maxLengthStringDataType) {
        this.maxLengthStringDataType_ = maxLengthStringDataType;
    }

    public final String getCharacterLargeObjectDataType() {
        return this.characterLargeObjectDataType_;
    }

    public final void setCharacterLargeObjectDataType(String characterLargeObjectDataType) {
        this.characterLargeObjectDataType_ = characterLargeObjectDataType;
    }

    public boolean getSupportTimeDataType() {
        if (this.supportTimeDataType_ == null) {
            return true;
        }
        return this.supportTimeDataType_;
    }

    public boolean getSupportTimeDataType(boolean supportTimeDataType) {
        if (this.supportTimeDataType_ == null) {
            return supportTimeDataType;
        }
        return this.supportTimeDataType_;
    }

    public Boolean getSupportTimeDataTypeAsBoolean() {
        return this.supportTimeDataType_;
    }

    public boolean checkSupportTimeDataType() {
        return this.supportTimeDataType_ != null;
    }

    public void setSupportTimeDataType(boolean supportTimeDataType) {
        this.supportTimeDataType_ = new Boolean(supportTimeDataType);
    }

    public void setSupportTimeDataType(Boolean supportTimeDataType) {
        this.supportTimeDataType_ = supportTimeDataType;
    }

    public final String getSearchStringEscapeInLike() {
        return this.searchStringEscapeInLike_;
    }

    public final void setSearchStringEscapeInLike(String searchStringEscapeInLike) {
        this.searchStringEscapeInLike_ = searchStringEscapeInLike;
    }

    public final String getCreateSequenceDDL() {
        return this.createSequenceDDL_;
    }

    public final void setCreateSequenceDDL(String createSequenceDDL) {
        this.createSequenceDDL_ = createSequenceDDL;
    }

    public final String getSequenceDML() {
        return this.sequenceDML_;
    }

    public final void setSequenceDML(String sequenceDML) {
        this.sequenceDML_ = sequenceDML;
    }

    public final String getDropIndexDDL() {
        return this.dropIndexDDL_;
    }

    public final void setDropIndexDDL(String dropIndexDDL) {
        this.dropIndexDDL_ = dropIndexDDL;
    }

    public final String getSpringBatchDDL() {
        return this.springBatchDDL_;
    }

    public final void setSpringBatchDDL(String springBatchDDL) {
        this.springBatchDDL_ = springBatchDDL;
    }

    public final String getMasterDDL() {
        return this.masterDDL_;
    }

    public final void setMasterDDL(String masterDDL) {
        this.masterDDL_ = masterDDL;
    }

    public final String getValidationQuery() {
        return this.validationQuery_;
    }

    public final void setValidationQuery(String validationQuery) {
        this.validationQuery_ = validationQuery;
    }

    public final String getConnectionInitSqls() {
        return this.connectionInitSqls_;
    }

    public final void setConnectionInitSqls(String connectionInitSqls) {
        this.connectionInitSqls_ = connectionInitSqls;
    }

    public final String getSessionFactory() {
        return this.sessionFactory_;
    }

    public final void setSessionFactory(String sessionFactory) {
        this.sessionFactory_ = sessionFactory;
    }

    public final String getTransactionManager() {
        return this.transactionManager_;
    }

    public final void setTransactionManager(String transactionManager) {
        this.transactionManager_ = transactionManager;
    }

    public final String getHibernateSchema() {
        return this.hibernateSchema_;
    }

    public final void setHibernateSchema(String hibernateSchema) {
        this.hibernateSchema_ = hibernateSchema;
    }

    public boolean getColumnDefault() {
        if (this.columnDefault_ == null) {
            return false;
        }
        return this.columnDefault_;
    }

    public boolean getColumnDefault(boolean columnDefault) {
        if (this.columnDefault_ == null) {
            return columnDefault;
        }
        return this.columnDefault_;
    }

    public Boolean getColumnDefaultAsBoolean() {
        return this.columnDefault_;
    }

    public boolean checkColumnDefault() {
        return this.columnDefault_ != null;
    }

    public void setColumnDefault(boolean columnDefault) {
        this.columnDefault_ = new Boolean(columnDefault);
    }

    public void setColumnDefault(Boolean columnDefault) {
        this.columnDefault_ = columnDefault;
    }

    public boolean getEncryptopassword() {
        if (this.encryptopassword_ == null) {
            return false;
        }
        return this.encryptopassword_;
    }

    public boolean getEncryptopassword(boolean encryptopassword) {
        if (this.encryptopassword_ == null) {
            return encryptopassword;
        }
        return this.encryptopassword_;
    }

    public Boolean getEncryptopasswordAsBoolean() {
        return this.encryptopassword_;
    }

    public boolean checkEncryptopassword() {
        return this.encryptopassword_ != null;
    }

    public void setEncryptopassword(boolean encryptopassword) {
        this.encryptopassword_ = new Boolean(encryptopassword);
    }

    public void setEncryptopassword(Boolean encryptopassword) {
        this.encryptopassword_ = encryptopassword;
    }

    public final String getDropSequenceDDL() {
        return this.dropSequenceDDL_;
    }

    public final void setDropSequenceDDL(String dropSequenceDDL) {
        this.dropSequenceDDL_ = dropSequenceDDL;
    }

    public final String getCreateIndexDDL() {
        return this.createIndexDDL_;
    }

    public final void setCreateIndexDDL(String createIndexDDL) {
        this.createIndexDDL_ = createIndexDDL;
    }

    public final String getJfcworkstateCreateIndexDDL() {
        return this.jfcworkstateCreateIndexDDL_;
    }

    public final void setJfcworkstateCreateIndexDDL(String jfcworkstateCreateIndexDDL) {
        this.jfcworkstateCreateIndexDDL_ = jfcworkstateCreateIndexDDL;
    }

    public final String getJfcworkstateDropIndexDDL() {
        return this.jfcworkstateDropIndexDDL_;
    }

    public final void setJfcworkstateDropIndexDDL(String jfcworkstateDropIndexDDL) {
        this.jfcworkstateDropIndexDDL_ = jfcworkstateDropIndexDDL;
    }

    public final QuartzJDBCJobstore getQuartzJDBCJobstore() {
        return this.quartzJDBCJobstore_;
    }

    public final void setQuartzJDBCJobstore(QuartzJDBCJobstore quartzJDBCJobstore) {
        this.quartzJDBCJobstore_ = quartzJDBCJobstore;
        if (quartzJDBCJobstore != null) {
            quartzJDBCJobstore.rSetParentRNode(this);
        }
        if (quartzJDBCJobstore != null) {
            quartzJDBCJobstore.rSetRContext(this.rGetRContext());
        }
    }

    public final SchemaMigration getSchemaMigration() {
        return this.schemaMigration_;
    }

    public final void setSchemaMigration(SchemaMigration schemaMigration) {
        this.schemaMigration_ = schemaMigration;
        if (schemaMigration != null) {
            schemaMigration.rSetParentRNode(this);
        }
        if (schemaMigration != null) {
            schemaMigration.rSetRContext(this.rGetRContext());
        }
    }

    public final RdbSetting getRdbSetting() {
        return this.rdbSetting_;
    }

    public final void setRdbSetting(RdbSetting rdbSetting) {
        this.rdbSetting_ = rdbSetting;
        if (rdbSetting != null) {
            rdbSetting.rSetParentRNode(this);
        }
        if (rdbSetting != null) {
            rdbSetting.rSetRContext(this.rGetRContext());
        }
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<database");
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.version_ != null) {
            buffer.append(" version=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getVersion())));
            buffer.append("\"");
        }
        if (this.driver_ != null) {
            buffer.append(" driver=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDriver())));
            buffer.append("\"");
        }
        if (this.url_ != null) {
            buffer.append(" url=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUrl())));
            buffer.append("\"");
        }
        if (this.user_ != null) {
            buffer.append(" user=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUser())));
            buffer.append("\"");
        }
        if (this.password_ != null) {
            buffer.append(" password=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPassword())));
            buffer.append("\"");
        }
        if (this.maxCount_ != null) {
            buffer.append(" maxCount=\"");
            buffer.append(URelaxer.getString(this.getMaxCount()));
            buffer.append("\"");
        }
        if (this.minCount_ != null) {
            buffer.append(" minCount=\"");
            buffer.append(URelaxer.getString(this.getMinCount()));
            buffer.append("\"");
        }
        if (this.maxActive_ != null) {
            buffer.append(" maxActive=\"");
            buffer.append(URelaxer.getString(this.getMaxActive()));
            buffer.append("\"");
        }
        if (this.maxIdle_ != null) {
            buffer.append(" maxIdle=\"");
            buffer.append(URelaxer.getString(this.getMaxIdle()));
            buffer.append("\"");
        }
        if (this.maxWait_ != null) {
            buffer.append(" maxWait=\"");
            buffer.append(URelaxer.getString(this.getMaxWait()));
            buffer.append("\"");
        }
        if (this.quoteid_ != null) {
            buffer.append(" quoteid=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteid())));
            buffer.append("\"");
        }
        if (this.quotewhere_ != null) {
            buffer.append(" quotewhere=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuotewhere())));
            buffer.append("\"");
        }
        if (this.quoteidinwhere_ != null) {
            buffer.append(" quoteidinwhere=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteidinwhere())));
            buffer.append("\"");
        }
        if (this.quoteidForHibernate_ != null) {
            buffer.append(" quoteid_for_hibernate=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteidForHibernate())));
            buffer.append("\"");
        }
        if (this.tablenameSeparatorForHibernate_ != null) {
            buffer.append(" tablename_separator_for_hibernate=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTablenameSeparatorForHibernate())));
            buffer.append("\"");
        }
        if (this.jdbc2_ != null) {
            buffer.append(" jdbc2=\"");
            buffer.append(URelaxer.getString(this.getJdbc2()));
            buffer.append("\"");
        }
        if (this.hibernateDialect_ != null) {
            buffer.append(" hibernate_dialect=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHibernateDialect())));
            buffer.append("\"");
        }
        if (this.charencoding_ != null) {
            buffer.append(" charencoding=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCharencoding())));
            buffer.append("\"");
        }
        if (this.autoReconnect_ != null) {
            buffer.append(" autoReconnect=\"");
            buffer.append(URelaxer.getString(this.getAutoReconnect()));
            buffer.append("\"");
        }
        if (this.maxTablenameLength_ != null) {
            buffer.append(" maxTablenameLength=\"");
            buffer.append(URelaxer.getString(this.getMaxTablenameLength()));
            buffer.append("\"");
        }
        if (this.maxIndexnameLength_ != null) {
            buffer.append(" maxIndexnameLength=\"");
            buffer.append(URelaxer.getString(this.getMaxIndexnameLength()));
            buffer.append("\"");
        }
        if (this.maxColumnnameLength_ != null) {
            buffer.append(" maxColumnnameLength=\"");
            buffer.append(URelaxer.getString(this.getMaxColumnnameLength()));
            buffer.append("\"");
        }
        if (this.maxLengthStringDataType_ != null) {
            buffer.append(" maxLengthStringDataType=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMaxLengthStringDataType())));
            buffer.append("\"");
        }
        if (this.characterLargeObjectDataType_ != null) {
            buffer.append(" characterLargeObjectDataType=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCharacterLargeObjectDataType())));
            buffer.append("\"");
        }
        if (this.supportTimeDataType_ != null) {
            buffer.append(" supportTimeDataType=\"");
            buffer.append(URelaxer.getString(this.getSupportTimeDataType()));
            buffer.append("\"");
        }
        if (this.searchStringEscapeInLike_ != null) {
            buffer.append(" searchStringEscapeInLike=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSearchStringEscapeInLike())));
            buffer.append("\"");
        }
        if (this.createSequenceDDL_ != null) {
            buffer.append(" createSequenceDDL=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateSequenceDDL())));
            buffer.append("\"");
        }
        if (this.sequenceDML_ != null) {
            buffer.append(" sequenceDML=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSequenceDML())));
            buffer.append("\"");
        }
        if (this.dropIndexDDL_ != null) {
            buffer.append(" dropIndexDDL=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDropIndexDDL())));
            buffer.append("\"");
        }
        if (this.springBatchDDL_ != null) {
            buffer.append(" springBatchDDL=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSpringBatchDDL())));
            buffer.append("\"");
        }
        if (this.masterDDL_ != null) {
            buffer.append(" masterDDL=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMasterDDL())));
            buffer.append("\"");
        }
        if (this.validationQuery_ != null) {
            buffer.append(" validationQuery=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getValidationQuery())));
            buffer.append("\"");
        }
        if (this.connectionInitSqls_ != null) {
            buffer.append(" connectionInitSqls=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getConnectionInitSqls())));
            buffer.append("\"");
        }
        if (this.sessionFactory_ != null) {
            buffer.append(" sessionFactory=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSessionFactory())));
            buffer.append("\"");
        }
        if (this.transactionManager_ != null) {
            buffer.append(" transactionManager=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTransactionManager())));
            buffer.append("\"");
        }
        if (this.hibernateSchema_ != null) {
            buffer.append(" hibernate_schema=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHibernateSchema())));
            buffer.append("\"");
        }
        if (this.columnDefault_ != null) {
            buffer.append(" columnDefault=\"");
            buffer.append(URelaxer.getString(this.getColumnDefault()));
            buffer.append("\"");
        }
        if (this.encryptopassword_ != null) {
            buffer.append(" encryptopassword=\"");
            buffer.append(URelaxer.getString(this.getEncryptopassword()));
            buffer.append("\"");
        }
        if (this.dropSequenceDDL_ != null) {
            buffer.append(" dropSequenceDDL=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDropSequenceDDL())));
            buffer.append("\"");
        }
        if (this.createIndexDDL_ != null) {
            buffer.append(" createIndexDDL=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateIndexDDL())));
            buffer.append("\"");
        }
        if (this.jfcworkstateCreateIndexDDL_ != null) {
            buffer.append(" jfcworkstateCreateIndexDDL=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJfcworkstateCreateIndexDDL())));
            buffer.append("\"");
        }
        if (this.jfcworkstateDropIndexDDL_ != null) {
            buffer.append(" jfcworkstateDropIndexDDL=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJfcworkstateDropIndexDDL())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.quartzJDBCJobstore_ != null) {
            this.quartzJDBCJobstore_.makeTextElement(buffer);
        }
        if (this.schemaMigration_ != null) {
            this.schemaMigration_.makeTextElement(buffer);
        }
        if (this.rdbSetting_ != null) {
            this.rdbSetting_.makeTextElement(buffer);
        }
        buffer.append("</database>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<database");
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.version_ != null) {
            buffer.write(" version=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getVersion())));
            buffer.write("\"");
        }
        if (this.driver_ != null) {
            buffer.write(" driver=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDriver())));
            buffer.write("\"");
        }
        if (this.url_ != null) {
            buffer.write(" url=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUrl())));
            buffer.write("\"");
        }
        if (this.user_ != null) {
            buffer.write(" user=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUser())));
            buffer.write("\"");
        }
        if (this.password_ != null) {
            buffer.write(" password=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPassword())));
            buffer.write("\"");
        }
        if (this.maxCount_ != null) {
            buffer.write(" maxCount=\"");
            buffer.write(URelaxer.getString(this.getMaxCount()));
            buffer.write("\"");
        }
        if (this.minCount_ != null) {
            buffer.write(" minCount=\"");
            buffer.write(URelaxer.getString(this.getMinCount()));
            buffer.write("\"");
        }
        if (this.maxActive_ != null) {
            buffer.write(" maxActive=\"");
            buffer.write(URelaxer.getString(this.getMaxActive()));
            buffer.write("\"");
        }
        if (this.maxIdle_ != null) {
            buffer.write(" maxIdle=\"");
            buffer.write(URelaxer.getString(this.getMaxIdle()));
            buffer.write("\"");
        }
        if (this.maxWait_ != null) {
            buffer.write(" maxWait=\"");
            buffer.write(URelaxer.getString(this.getMaxWait()));
            buffer.write("\"");
        }
        if (this.quoteid_ != null) {
            buffer.write(" quoteid=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteid())));
            buffer.write("\"");
        }
        if (this.quotewhere_ != null) {
            buffer.write(" quotewhere=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuotewhere())));
            buffer.write("\"");
        }
        if (this.quoteidinwhere_ != null) {
            buffer.write(" quoteidinwhere=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteidinwhere())));
            buffer.write("\"");
        }
        if (this.quoteidForHibernate_ != null) {
            buffer.write(" quoteid_for_hibernate=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteidForHibernate())));
            buffer.write("\"");
        }
        if (this.tablenameSeparatorForHibernate_ != null) {
            buffer.write(" tablename_separator_for_hibernate=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTablenameSeparatorForHibernate())));
            buffer.write("\"");
        }
        if (this.jdbc2_ != null) {
            buffer.write(" jdbc2=\"");
            buffer.write(URelaxer.getString(this.getJdbc2()));
            buffer.write("\"");
        }
        if (this.hibernateDialect_ != null) {
            buffer.write(" hibernate_dialect=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHibernateDialect())));
            buffer.write("\"");
        }
        if (this.charencoding_ != null) {
            buffer.write(" charencoding=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCharencoding())));
            buffer.write("\"");
        }
        if (this.autoReconnect_ != null) {
            buffer.write(" autoReconnect=\"");
            buffer.write(URelaxer.getString(this.getAutoReconnect()));
            buffer.write("\"");
        }
        if (this.maxTablenameLength_ != null) {
            buffer.write(" maxTablenameLength=\"");
            buffer.write(URelaxer.getString(this.getMaxTablenameLength()));
            buffer.write("\"");
        }
        if (this.maxIndexnameLength_ != null) {
            buffer.write(" maxIndexnameLength=\"");
            buffer.write(URelaxer.getString(this.getMaxIndexnameLength()));
            buffer.write("\"");
        }
        if (this.maxColumnnameLength_ != null) {
            buffer.write(" maxColumnnameLength=\"");
            buffer.write(URelaxer.getString(this.getMaxColumnnameLength()));
            buffer.write("\"");
        }
        if (this.maxLengthStringDataType_ != null) {
            buffer.write(" maxLengthStringDataType=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMaxLengthStringDataType())));
            buffer.write("\"");
        }
        if (this.characterLargeObjectDataType_ != null) {
            buffer.write(" characterLargeObjectDataType=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCharacterLargeObjectDataType())));
            buffer.write("\"");
        }
        if (this.supportTimeDataType_ != null) {
            buffer.write(" supportTimeDataType=\"");
            buffer.write(URelaxer.getString(this.getSupportTimeDataType()));
            buffer.write("\"");
        }
        if (this.searchStringEscapeInLike_ != null) {
            buffer.write(" searchStringEscapeInLike=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSearchStringEscapeInLike())));
            buffer.write("\"");
        }
        if (this.createSequenceDDL_ != null) {
            buffer.write(" createSequenceDDL=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateSequenceDDL())));
            buffer.write("\"");
        }
        if (this.sequenceDML_ != null) {
            buffer.write(" sequenceDML=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSequenceDML())));
            buffer.write("\"");
        }
        if (this.dropIndexDDL_ != null) {
            buffer.write(" dropIndexDDL=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDropIndexDDL())));
            buffer.write("\"");
        }
        if (this.springBatchDDL_ != null) {
            buffer.write(" springBatchDDL=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSpringBatchDDL())));
            buffer.write("\"");
        }
        if (this.masterDDL_ != null) {
            buffer.write(" masterDDL=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMasterDDL())));
            buffer.write("\"");
        }
        if (this.validationQuery_ != null) {
            buffer.write(" validationQuery=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getValidationQuery())));
            buffer.write("\"");
        }
        if (this.connectionInitSqls_ != null) {
            buffer.write(" connectionInitSqls=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getConnectionInitSqls())));
            buffer.write("\"");
        }
        if (this.sessionFactory_ != null) {
            buffer.write(" sessionFactory=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSessionFactory())));
            buffer.write("\"");
        }
        if (this.transactionManager_ != null) {
            buffer.write(" transactionManager=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTransactionManager())));
            buffer.write("\"");
        }
        if (this.hibernateSchema_ != null) {
            buffer.write(" hibernate_schema=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHibernateSchema())));
            buffer.write("\"");
        }
        if (this.columnDefault_ != null) {
            buffer.write(" columnDefault=\"");
            buffer.write(URelaxer.getString(this.getColumnDefault()));
            buffer.write("\"");
        }
        if (this.encryptopassword_ != null) {
            buffer.write(" encryptopassword=\"");
            buffer.write(URelaxer.getString(this.getEncryptopassword()));
            buffer.write("\"");
        }
        if (this.dropSequenceDDL_ != null) {
            buffer.write(" dropSequenceDDL=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDropSequenceDDL())));
            buffer.write("\"");
        }
        if (this.createIndexDDL_ != null) {
            buffer.write(" createIndexDDL=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateIndexDDL())));
            buffer.write("\"");
        }
        if (this.jfcworkstateCreateIndexDDL_ != null) {
            buffer.write(" jfcworkstateCreateIndexDDL=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJfcworkstateCreateIndexDDL())));
            buffer.write("\"");
        }
        if (this.jfcworkstateDropIndexDDL_ != null) {
            buffer.write(" jfcworkstateDropIndexDDL=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJfcworkstateDropIndexDDL())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.quartzJDBCJobstore_ != null) {
            this.quartzJDBCJobstore_.makeTextElement(buffer);
        }
        if (this.schemaMigration_ != null) {
            this.schemaMigration_.makeTextElement(buffer);
        }
        if (this.rdbSetting_ != null) {
            this.rdbSetting_.makeTextElement(buffer);
        }
        buffer.write("</database>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<database");
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.version_ != null) {
            buffer.print(" version=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getVersion())));
            buffer.print("\"");
        }
        if (this.driver_ != null) {
            buffer.print(" driver=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDriver())));
            buffer.print("\"");
        }
        if (this.url_ != null) {
            buffer.print(" url=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUrl())));
            buffer.print("\"");
        }
        if (this.user_ != null) {
            buffer.print(" user=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUser())));
            buffer.print("\"");
        }
        if (this.password_ != null) {
            buffer.print(" password=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPassword())));
            buffer.print("\"");
        }
        if (this.maxCount_ != null) {
            buffer.print(" maxCount=\"");
            buffer.print(URelaxer.getString(this.getMaxCount()));
            buffer.print("\"");
        }
        if (this.minCount_ != null) {
            buffer.print(" minCount=\"");
            buffer.print(URelaxer.getString(this.getMinCount()));
            buffer.print("\"");
        }
        if (this.maxActive_ != null) {
            buffer.print(" maxActive=\"");
            buffer.print(URelaxer.getString(this.getMaxActive()));
            buffer.print("\"");
        }
        if (this.maxIdle_ != null) {
            buffer.print(" maxIdle=\"");
            buffer.print(URelaxer.getString(this.getMaxIdle()));
            buffer.print("\"");
        }
        if (this.maxWait_ != null) {
            buffer.print(" maxWait=\"");
            buffer.print(URelaxer.getString(this.getMaxWait()));
            buffer.print("\"");
        }
        if (this.quoteid_ != null) {
            buffer.print(" quoteid=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteid())));
            buffer.print("\"");
        }
        if (this.quotewhere_ != null) {
            buffer.print(" quotewhere=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuotewhere())));
            buffer.print("\"");
        }
        if (this.quoteidinwhere_ != null) {
            buffer.print(" quoteidinwhere=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteidinwhere())));
            buffer.print("\"");
        }
        if (this.quoteidForHibernate_ != null) {
            buffer.print(" quoteid_for_hibernate=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getQuoteidForHibernate())));
            buffer.print("\"");
        }
        if (this.tablenameSeparatorForHibernate_ != null) {
            buffer.print(" tablename_separator_for_hibernate=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTablenameSeparatorForHibernate())));
            buffer.print("\"");
        }
        if (this.jdbc2_ != null) {
            buffer.print(" jdbc2=\"");
            buffer.print(URelaxer.getString(this.getJdbc2()));
            buffer.print("\"");
        }
        if (this.hibernateDialect_ != null) {
            buffer.print(" hibernate_dialect=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHibernateDialect())));
            buffer.print("\"");
        }
        if (this.charencoding_ != null) {
            buffer.print(" charencoding=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCharencoding())));
            buffer.print("\"");
        }
        if (this.autoReconnect_ != null) {
            buffer.print(" autoReconnect=\"");
            buffer.print(URelaxer.getString(this.getAutoReconnect()));
            buffer.print("\"");
        }
        if (this.maxTablenameLength_ != null) {
            buffer.print(" maxTablenameLength=\"");
            buffer.print(URelaxer.getString(this.getMaxTablenameLength()));
            buffer.print("\"");
        }
        if (this.maxIndexnameLength_ != null) {
            buffer.print(" maxIndexnameLength=\"");
            buffer.print(URelaxer.getString(this.getMaxIndexnameLength()));
            buffer.print("\"");
        }
        if (this.maxColumnnameLength_ != null) {
            buffer.print(" maxColumnnameLength=\"");
            buffer.print(URelaxer.getString(this.getMaxColumnnameLength()));
            buffer.print("\"");
        }
        if (this.maxLengthStringDataType_ != null) {
            buffer.print(" maxLengthStringDataType=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMaxLengthStringDataType())));
            buffer.print("\"");
        }
        if (this.characterLargeObjectDataType_ != null) {
            buffer.print(" characterLargeObjectDataType=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCharacterLargeObjectDataType())));
            buffer.print("\"");
        }
        if (this.supportTimeDataType_ != null) {
            buffer.print(" supportTimeDataType=\"");
            buffer.print(URelaxer.getString(this.getSupportTimeDataType()));
            buffer.print("\"");
        }
        if (this.searchStringEscapeInLike_ != null) {
            buffer.print(" searchStringEscapeInLike=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSearchStringEscapeInLike())));
            buffer.print("\"");
        }
        if (this.createSequenceDDL_ != null) {
            buffer.print(" createSequenceDDL=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateSequenceDDL())));
            buffer.print("\"");
        }
        if (this.sequenceDML_ != null) {
            buffer.print(" sequenceDML=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSequenceDML())));
            buffer.print("\"");
        }
        if (this.dropIndexDDL_ != null) {
            buffer.print(" dropIndexDDL=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDropIndexDDL())));
            buffer.print("\"");
        }
        if (this.springBatchDDL_ != null) {
            buffer.print(" springBatchDDL=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSpringBatchDDL())));
            buffer.print("\"");
        }
        if (this.masterDDL_ != null) {
            buffer.print(" masterDDL=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMasterDDL())));
            buffer.print("\"");
        }
        if (this.validationQuery_ != null) {
            buffer.print(" validationQuery=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getValidationQuery())));
            buffer.print("\"");
        }
        if (this.connectionInitSqls_ != null) {
            buffer.print(" connectionInitSqls=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getConnectionInitSqls())));
            buffer.print("\"");
        }
        if (this.sessionFactory_ != null) {
            buffer.print(" sessionFactory=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSessionFactory())));
            buffer.print("\"");
        }
        if (this.transactionManager_ != null) {
            buffer.print(" transactionManager=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTransactionManager())));
            buffer.print("\"");
        }
        if (this.hibernateSchema_ != null) {
            buffer.print(" hibernate_schema=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHibernateSchema())));
            buffer.print("\"");
        }
        if (this.columnDefault_ != null) {
            buffer.print(" columnDefault=\"");
            buffer.print(URelaxer.getString(this.getColumnDefault()));
            buffer.print("\"");
        }
        if (this.encryptopassword_ != null) {
            buffer.print(" encryptopassword=\"");
            buffer.print(URelaxer.getString(this.getEncryptopassword()));
            buffer.print("\"");
        }
        if (this.dropSequenceDDL_ != null) {
            buffer.print(" dropSequenceDDL=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDropSequenceDDL())));
            buffer.print("\"");
        }
        if (this.createIndexDDL_ != null) {
            buffer.print(" createIndexDDL=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateIndexDDL())));
            buffer.print("\"");
        }
        if (this.jfcworkstateCreateIndexDDL_ != null) {
            buffer.print(" jfcworkstateCreateIndexDDL=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJfcworkstateCreateIndexDDL())));
            buffer.print("\"");
        }
        if (this.jfcworkstateDropIndexDDL_ != null) {
            buffer.print(" jfcworkstateDropIndexDDL=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJfcworkstateDropIndexDDL())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.quartzJDBCJobstore_ != null) {
            this.quartzJDBCJobstore_.makeTextElement(buffer);
        }
        if (this.schemaMigration_ != null) {
            this.schemaMigration_.makeTextElement(buffer);
        }
        if (this.rdbSetting_ != null) {
            this.rdbSetting_.makeTextElement(buffer);
        }
        buffer.print("</database>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getVersionAsString() {
        return URelaxer.getString(this.getVersion());
    }

    public String getDriverAsString() {
        return URelaxer.getString(this.getDriver());
    }

    public String getUrlAsString() {
        return URelaxer.getString(this.getUrl());
    }

    public String getUserAsString() {
        return URelaxer.getString(this.getUser());
    }

    public String getPasswordAsString() {
        return URelaxer.getString(this.getPassword());
    }

    public String getMaxCountAsString() {
        return URelaxer.getString(this.getMaxCount());
    }

    public String getMinCountAsString() {
        return URelaxer.getString(this.getMinCount());
    }

    public String getMaxActiveAsString() {
        return URelaxer.getString(this.getMaxActive());
    }

    public String getMaxIdleAsString() {
        return URelaxer.getString(this.getMaxIdle());
    }

    public String getMaxWaitAsString() {
        return URelaxer.getString(this.getMaxWait());
    }

    public String getQuoteidAsString() {
        return URelaxer.getString(this.getQuoteid());
    }

    public String getQuotewhereAsString() {
        return URelaxer.getString(this.getQuotewhere());
    }

    public String getQuoteidinwhereAsString() {
        return URelaxer.getString(this.getQuoteidinwhere());
    }

    public String getQuoteidForHibernateAsString() {
        return URelaxer.getString(this.getQuoteidForHibernate());
    }

    public String getTablenameSeparatorForHibernateAsString() {
        return URelaxer.getString(this.getTablenameSeparatorForHibernate());
    }

    public String getJdbc2AsString() {
        return URelaxer.getString(this.getJdbc2());
    }

    public String getHibernateDialectAsString() {
        return URelaxer.getString(this.getHibernateDialect());
    }

    public String getCharencodingAsString() {
        return URelaxer.getString(this.getCharencoding());
    }

    public String getAutoReconnectAsString() {
        return URelaxer.getString(this.getAutoReconnect());
    }

    public String getMaxTablenameLengthAsString() {
        return URelaxer.getString(this.getMaxTablenameLength());
    }

    public String getMaxIndexnameLengthAsString() {
        return URelaxer.getString(this.getMaxIndexnameLength());
    }

    public String getMaxColumnnameLengthAsString() {
        return URelaxer.getString(this.getMaxColumnnameLength());
    }

    public String getMaxLengthStringDataTypeAsString() {
        return URelaxer.getString(this.getMaxLengthStringDataType());
    }

    public String getCharacterLargeObjectDataTypeAsString() {
        return URelaxer.getString(this.getCharacterLargeObjectDataType());
    }

    public String getSupportTimeDataTypeAsString() {
        return URelaxer.getString(this.getSupportTimeDataType());
    }

    public String getSearchStringEscapeInLikeAsString() {
        return URelaxer.getString(this.getSearchStringEscapeInLike());
    }

    public String getCreateSequenceDDLAsString() {
        return URelaxer.getString(this.getCreateSequenceDDL());
    }

    public String getSequenceDMLAsString() {
        return URelaxer.getString(this.getSequenceDML());
    }

    public String getDropIndexDDLAsString() {
        return URelaxer.getString(this.getDropIndexDDL());
    }

    public String getSpringBatchDDLAsString() {
        return URelaxer.getString(this.getSpringBatchDDL());
    }

    public String getMasterDDLAsString() {
        return URelaxer.getString(this.getMasterDDL());
    }

    public String getValidationQueryAsString() {
        return URelaxer.getString(this.getValidationQuery());
    }

    public String getConnectionInitSqlsAsString() {
        return URelaxer.getString(this.getConnectionInitSqls());
    }

    public String getSessionFactoryAsString() {
        return URelaxer.getString(this.getSessionFactory());
    }

    public String getTransactionManagerAsString() {
        return URelaxer.getString(this.getTransactionManager());
    }

    public String getHibernateSchemaAsString() {
        return URelaxer.getString(this.getHibernateSchema());
    }

    public String getColumnDefaultAsString() {
        return URelaxer.getString(this.getColumnDefault());
    }

    public String getEncryptopasswordAsString() {
        return URelaxer.getString(this.getEncryptopassword());
    }

    public String getDropSequenceDDLAsString() {
        return URelaxer.getString(this.getDropSequenceDDL());
    }

    public String getCreateIndexDDLAsString() {
        return URelaxer.getString(this.getCreateIndexDDL());
    }

    public String getJfcworkstateCreateIndexDDLAsString() {
        return URelaxer.getString(this.getJfcworkstateCreateIndexDDL());
    }

    public String getJfcworkstateDropIndexDDLAsString() {
        return URelaxer.getString(this.getJfcworkstateDropIndexDDL());
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setVersionByString(String string) {
        this.setVersion(string);
    }

    public void setDriverByString(String string) {
        this.setDriver(string);
    }

    public void setUrlByString(String string) {
        this.setUrl(string);
    }

    public void setUserByString(String string) {
        this.setUser(string);
    }

    public void setPasswordByString(String string) {
        this.setPassword(string);
    }

    public void setMaxCountByString(String string) {
        this.setMaxCount(Integer.parseInt(string));
    }

    public void setMinCountByString(String string) {
        this.setMinCount(Integer.parseInt(string));
    }

    public void setMaxActiveByString(String string) {
        this.setMaxActive(Integer.parseInt(string));
    }

    public void setMaxIdleByString(String string) {
        this.setMaxIdle(Integer.parseInt(string));
    }

    public void setMaxWaitByString(String string) {
        this.setMaxWait(Integer.parseInt(string));
    }

    public void setQuoteidByString(String string) {
        this.setQuoteid(string);
    }

    public void setQuotewhereByString(String string) {
        this.setQuotewhere(string);
    }

    public void setQuoteidinwhereByString(String string) {
        this.setQuoteidinwhere(string);
    }

    public void setQuoteidForHibernateByString(String string) {
        this.setQuoteidForHibernate(string);
    }

    public void setTablenameSeparatorForHibernateByString(String string) {
        this.setTablenameSeparatorForHibernate(string);
    }

    public void setJdbc2ByString(String string) {
        this.setJdbc2((boolean)new Boolean(string));
    }

    public void setHibernateDialectByString(String string) {
        this.setHibernateDialect(string);
    }

    public void setCharencodingByString(String string) {
        this.setCharencoding(string);
    }

    public void setAutoReconnectByString(String string) {
        this.setAutoReconnect((boolean)new Boolean(string));
    }

    public void setMaxTablenameLengthByString(String string) {
        this.setMaxTablenameLength(Integer.parseInt(string));
    }

    public void setMaxIndexnameLengthByString(String string) {
        this.setMaxIndexnameLength(Integer.parseInt(string));
    }

    public void setMaxColumnnameLengthByString(String string) {
        this.setMaxColumnnameLength(Integer.parseInt(string));
    }

    public void setMaxLengthStringDataTypeByString(String string) {
        this.setMaxLengthStringDataType(string);
    }

    public void setCharacterLargeObjectDataTypeByString(String string) {
        this.setCharacterLargeObjectDataType(string);
    }

    public void setSupportTimeDataTypeByString(String string) {
        this.setSupportTimeDataType((boolean)new Boolean(string));
    }

    public void setSearchStringEscapeInLikeByString(String string) {
        this.setSearchStringEscapeInLike(string);
    }

    public void setCreateSequenceDDLByString(String string) {
        this.setCreateSequenceDDL(string);
    }

    public void setSequenceDMLByString(String string) {
        this.setSequenceDML(string);
    }

    public void setDropIndexDDLByString(String string) {
        this.setDropIndexDDL(string);
    }

    public void setSpringBatchDDLByString(String string) {
        this.setSpringBatchDDL(string);
    }

    public void setMasterDDLByString(String string) {
        this.setMasterDDL(string);
    }

    public void setValidationQueryByString(String string) {
        this.setValidationQuery(string);
    }

    public void setConnectionInitSqlsByString(String string) {
        this.setConnectionInitSqls(string);
    }

    public void setSessionFactoryByString(String string) {
        this.setSessionFactory(string);
    }

    public void setTransactionManagerByString(String string) {
        this.setTransactionManager(string);
    }

    public void setHibernateSchemaByString(String string) {
        this.setHibernateSchema(string);
    }

    public void setColumnDefaultByString(String string) {
        this.setColumnDefault((boolean)new Boolean(string));
    }

    public void setEncryptopasswordByString(String string) {
        this.setEncryptopassword((boolean)new Boolean(string));
    }

    public void setDropSequenceDDLByString(String string) {
        this.setDropSequenceDDL(string);
    }

    public void setCreateIndexDDLByString(String string) {
        this.setCreateIndexDDL(string);
    }

    public void setJfcworkstateCreateIndexDDLByString(String string) {
        this.setJfcworkstateCreateIndexDDL(string);
    }

    public void setJfcworkstateDropIndexDDLByString(String string) {
        this.setJfcworkstateDropIndexDDL(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<Cloneable> classNodes = new ArrayList<Cloneable>();
        if (this.quartzJDBCJobstore_ != null) {
            classNodes.add(this.quartzJDBCJobstore_);
        }
        if (this.schemaMigration_ != null) {
            classNodes.add(this.schemaMigration_);
        }
        if (this.rdbSetting_ != null) {
            classNodes.add(this.rdbSetting_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "database")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (QuartzJDBCJobstore.isMatchHungry(target)) {
            // empty if block
        }
        if (SchemaMigration.isMatchHungry(target)) {
            // empty if block
        }
        if (RdbSetting.isMatchHungry(target)) {
            // empty if block
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Database.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Database.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

