/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultValue
implements Serializable,
Cloneable,
IRNode,
IModelChoice {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_INT = "int";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_DATETIME = "dateTime";
    public static final String TYPE_USERID = "userid";
    public static final String TYPE_JGROUPID = "jgroupid";
    public static final String TYPE_SUM = "sum";
    public static final String TYPE_RANDOM_STRING = "random:string";
    public static final String TYPE_JAVACODE = "javacode";
    public static final String TYPE_OPERATION = "operation";
    public static final String TYPE_ITEMNAME = "itemname";
    public static final String ACTION_INSERT = "insert";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_SHOW = "show";
    public static final String ACTION_SHOWLIST = "showlist";
    public static final String ACTION_INIT = "init";
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_SEARCH = "search";
    public static final String ACTION_READUPDATE = "readUpdate";
    private String content_;
    private String name_;
    private String type_;
    private String action_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public DefaultValue() {
    }

    public DefaultValue(DefaultValue source) {
        this.setup(source);
    }

    public DefaultValue(RStack stack) {
        this.setup(stack);
    }

    public DefaultValue(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public DefaultValue(Element element) {
        this.setup(element);
    }

    public DefaultValue(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public DefaultValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public DefaultValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public DefaultValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public DefaultValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public DefaultValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(DefaultValue source) {
        this.setContent(source.getContent());
        this.setName(source.getName());
        this.setType(source.getType());
        this.setAction(source.getAction());
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.action_ = URelaxer.getAttributePropertyAsString(element, "action");
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createDefaultValue(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("defaultValue");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.action_ != null) {
            URelaxer.setAttributePropertyByString(element, "action", this.action_);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String content) {
        this.content_ = content;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getType() {
        if (this.type_ == null) {
            return TYPE_STRING;
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getAction() {
        if (this.action_ == null) {
            return ACTION_INSERT;
        }
        return this.action_;
    }

    public final void setAction(String action) {
        this.action_ = action;
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<defaultValue");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.action_ != null) {
            buffer.append(" action=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</defaultValue>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<defaultValue");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.action_ != null) {
            buffer.write(" action=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</defaultValue>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<defaultValue");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.action_ != null) {
            buffer.print(" action=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</defaultValue>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getActionAsString() {
        return URelaxer.getString(this.getAction());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setActionByString(String string) {
        this.setAction(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "defaultValue")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return DefaultValue.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (DefaultValue.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

