/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Mapping;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Forward
implements Serializable,
Cloneable,
IRNode,
IActionChoice {
    private List mapping_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Forward() {
    }

    public Forward(Forward source) {
        this.setup(source);
    }

    public Forward(RStack stack) {
        this.setup(stack);
    }

    public Forward(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Forward(Element element) {
        this.setup(element);
    }

    public Forward(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Forward(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Forward(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Forward(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Forward(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Forward(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Forward source) {
        this.mapping_.clear();
        int size = source.mapping_.size();
        for (int i = 0; i < size; ++i) {
            this.addMapping((Mapping)source.getMapping(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.mapping_.clear();
        while (Mapping.isMatch(stack)) {
            this.addMapping(factory.createMapping(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createForward(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("forward");
        int size = this.mapping_.size();
        for (int i = 0; i < size; ++i) {
            Mapping value = (Mapping)this.mapping_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final Mapping[] getMapping() {
        Mapping[] array = new Mapping[this.mapping_.size()];
        return this.mapping_.toArray(array);
    }

    public final void setMapping(Mapping[] mapping) {
        int i;
        this.mapping_.clear();
        if (mapping != null) {
            for (i = 0; i < mapping.length; ++i) {
                this.addMapping(mapping[i]);
            }
        }
        for (i = 0; i < mapping.length; ++i) {
            mapping[i].rSetParentRNode(this);
        }
        for (i = 0; i < mapping.length; ++i) {
            mapping[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setMapping(Mapping mapping) {
        this.mapping_.clear();
        this.addMapping(mapping);
        if (mapping != null) {
            mapping.rSetParentRNode(this);
        }
        if (mapping != null) {
            mapping.rSetRContext(this.rGetRContext());
        }
    }

    public final void addMapping(Mapping mapping) {
        this.mapping_.add(mapping);
        if (mapping != null) {
            mapping.rSetParentRNode(this);
        }
        if (mapping != null) {
            mapping.rSetRContext(this.rGetRContext());
        }
    }

    public final void addMapping(Mapping[] mapping) {
        int i;
        for (i = 0; i < mapping.length; ++i) {
            this.addMapping(mapping[i]);
        }
        for (i = 0; i < mapping.length; ++i) {
            mapping[i].rSetParentRNode(this);
        }
        for (i = 0; i < mapping.length; ++i) {
            mapping[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeMapping() {
        return this.mapping_.size();
    }

    public final Mapping getMapping(int index) {
        return (Mapping)this.mapping_.get(index);
    }

    public final void setMapping(int index, Mapping mapping) {
        this.mapping_.set(index, mapping);
        if (mapping != null) {
            mapping.rSetParentRNode(this);
        }
    }

    public final void addMapping(int index, Mapping mapping) {
        this.mapping_.add(index, mapping);
        if (mapping != null) {
            mapping.rSetParentRNode(this);
        }
    }

    public final void removeMapping(int index) {
        this.mapping_.remove(index);
    }

    public final void removeMapping(Mapping mapping) {
        this.mapping_.remove(mapping);
    }

    public final void clearMapping() {
        this.mapping_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<forward");
        buffer.append(">");
        int size = this.mapping_.size();
        for (int i = 0; i < size; ++i) {
            Mapping value = (Mapping)this.mapping_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</forward>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<forward");
        buffer.write(">");
        int size = this.mapping_.size();
        for (int i = 0; i < size; ++i) {
            Mapping value = (Mapping)this.mapping_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</forward>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<forward");
        buffer.print(">");
        int size = this.mapping_.size();
        for (int i = 0; i < size; ++i) {
            Mapping value = (Mapping)this.mapping_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</forward>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.mapping_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "forward")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!Mapping.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        while (Mapping.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Forward.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Forward.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

