/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Op
implements Serializable,
Cloneable,
IRNode {
    public static final String TYPE_AND = "and";
    public static final String TYPE_OR = "or";
    public static final String METHOD_DEFAULT = "default";
    public static final String METHOD_INSERT = "insert";
    public static final String METHOD_UPDATE = "update";
    public static final String METHOD_DELETE = "delete";
    private String content_;
    private String action_;
    private String referrer_;
    private String type_;
    private String method_;
    private String forward_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Op() {
    }

    public Op(Op source) {
        this.setup(source);
    }

    public Op(RStack stack) {
        this.setup(stack);
    }

    public Op(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Op(Element element) {
        this.setup(element);
    }

    public Op(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Op(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Op(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Op(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Op(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Op(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Op source) {
        this.setContent(source.getContent());
        this.setAction(source.getAction());
        this.setReferrer(source.getReferrer());
        this.setType(source.getType());
        this.setMethod(source.getMethod());
        this.setForward(source.getForward());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.action_ = URelaxer.getAttributePropertyAsString(element, "action");
        this.referrer_ = URelaxer.getAttributePropertyAsString(element, "referrer");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.method_ = URelaxer.getAttributePropertyAsString(element, "method");
        this.forward_ = URelaxer.getAttributePropertyAsString(element, "forward");
    }

    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createOp(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("op");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.action_ != null) {
            URelaxer.setAttributePropertyByString(element, "action", this.action_);
        }
        if (this.referrer_ != null) {
            URelaxer.setAttributePropertyByString(element, "referrer", this.referrer_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.method_ != null) {
            URelaxer.setAttributePropertyByString(element, "method", this.method_);
        }
        if (this.forward_ != null) {
            URelaxer.setAttributePropertyByString(element, "forward", this.forward_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String content) {
        this.content_ = content;
    }

    public final String getAction() {
        return this.action_;
    }

    public final void setAction(String action) {
        this.action_ = action;
    }

    public final String getReferrer() {
        return this.referrer_;
    }

    public final void setReferrer(String referrer) {
        this.referrer_ = referrer;
    }

    public final String getType() {
        if (this.type_ == null) {
            return TYPE_AND;
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getMethod() {
        if (this.method_ == null) {
            return METHOD_DEFAULT;
        }
        return this.method_;
    }

    public final void setMethod(String method) {
        this.method_ = method;
    }

    public final String getForward() {
        return this.forward_;
    }

    public final void setForward(String forward) {
        this.forward_ = forward;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<op");
        if (this.action_ != null) {
            buffer.append(" action=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.append("\"");
        }
        if (this.referrer_ != null) {
            buffer.append(" referrer=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getReferrer())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.method_ != null) {
            buffer.append(" method=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMethod())));
            buffer.append("\"");
        }
        if (this.forward_ != null) {
            buffer.append(" forward=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getForward())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</op>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<op");
        if (this.action_ != null) {
            buffer.write(" action=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.write("\"");
        }
        if (this.referrer_ != null) {
            buffer.write(" referrer=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getReferrer())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.method_ != null) {
            buffer.write(" method=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMethod())));
            buffer.write("\"");
        }
        if (this.forward_ != null) {
            buffer.write(" forward=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getForward())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</op>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<op");
        if (this.action_ != null) {
            buffer.print(" action=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.print("\"");
        }
        if (this.referrer_ != null) {
            buffer.print(" referrer=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getReferrer())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.method_ != null) {
            buffer.print(" method=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMethod())));
            buffer.print("\"");
        }
        if (this.forward_ != null) {
            buffer.print(" forward=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getForward())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</op>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getActionAsString() {
        return URelaxer.getString(this.getAction());
    }

    public String getReferrerAsString() {
        return URelaxer.getString(this.getReferrer());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getMethodAsString() {
        return URelaxer.getString(this.getMethod());
    }

    public String getForwardAsString() {
        return URelaxer.getString(this.getForward());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setActionByString(String string) {
        this.setAction(string);
    }

    public void setReferrerByString(String string) {
        this.setReferrer(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setMethodByString(String string) {
        this.setMethod(string);
    }

    public void setForwardByString(String string) {
        this.setForward(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "op")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Op.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Op.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

