/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Page
implements Serializable,
Cloneable,
IRNode,
IActionChoice {
    private Integer size_;
    private Integer cache_;
    private Boolean closeConnection_;
    private String option_;
    private Boolean pagingFkey_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Page() {
    }

    public Page(Page source) {
        this.setup(source);
    }

    public Page(RStack stack) {
        this.setup(stack);
    }

    public Page(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Page(Element element) {
        this.setup(element);
    }

    public Page(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Page(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Page(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Page(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Page(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Page(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Page source) {
        this.setSize(source.getSize());
        this.setCache(source.getCache());
        this.setCloseConnection(source.getCloseConnection());
        this.setOption(source.getOption());
        this.setPagingFkey(source.getPagingFkey());
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.size_ = URelaxer.getAttributePropertyAsIntObject(element, "size");
        this.cache_ = URelaxer.getAttributePropertyAsIntObject(element, "cache");
        this.closeConnection_ = URelaxer.getAttributePropertyAsBooleanObject(element, "closeConnection");
        this.option_ = URelaxer.getAttributePropertyAsString(element, "option");
        this.pagingFkey_ = URelaxer.getAttributePropertyAsBooleanObject(element, "pagingFkey");
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createPage(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("page");
        if (this.size_ != null) {
            URelaxer.setAttributePropertyByInt(element, "size", this.size_);
        }
        if (this.cache_ != null) {
            URelaxer.setAttributePropertyByInt(element, "cache", this.cache_);
        }
        if (this.closeConnection_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "closeConnection", this.closeConnection_);
        }
        if (this.option_ != null) {
            URelaxer.setAttributePropertyByString(element, "option", this.option_);
        }
        if (this.pagingFkey_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "pagingFkey", this.pagingFkey_);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public int getSize() {
        if (this.size_ == null) {
            return 10;
        }
        return this.size_;
    }

    public int getSize(int sizeValue) {
        if (this.size_ == null) {
            return sizeValue;
        }
        return this.size_;
    }

    public Integer getSizeAsInteger() {
        return this.size_;
    }

    public boolean checkSize() {
        return this.size_ != null;
    }

    public void setSize(int sizeValue) {
        this.size_ = new Integer(sizeValue);
    }

    public void setSize(Integer sizeValue) {
        this.size_ = sizeValue;
    }

    public int getCache() {
        if (this.cache_ == null) {
            return 100;
        }
        return this.cache_;
    }

    public int getCache(int cache) {
        if (this.cache_ == null) {
            return cache;
        }
        return this.cache_;
    }

    public Integer getCacheAsInteger() {
        return this.cache_;
    }

    public boolean checkCache() {
        return this.cache_ != null;
    }

    public void setCache(int cache) {
        this.cache_ = new Integer(cache);
    }

    public void setCache(Integer cache) {
        this.cache_ = cache;
    }

    public boolean getCloseConnection() {
        if (this.closeConnection_ == null) {
            return true;
        }
        return this.closeConnection_;
    }

    public boolean getCloseConnection(boolean closeConnection) {
        if (this.closeConnection_ == null) {
            return closeConnection;
        }
        return this.closeConnection_;
    }

    public Boolean getCloseConnectionAsBoolean() {
        return this.closeConnection_;
    }

    public boolean checkCloseConnection() {
        return this.closeConnection_ != null;
    }

    public void setCloseConnection(boolean closeConnection) {
        this.closeConnection_ = new Boolean(closeConnection);
    }

    public void setCloseConnection(Boolean closeConnection) {
        this.closeConnection_ = closeConnection;
    }

    public final String getOption() {
        return this.option_;
    }

    public final void setOption(String option) {
        this.option_ = option;
    }

    public boolean getPagingFkey() {
        if (this.pagingFkey_ == null) {
            return false;
        }
        return this.pagingFkey_;
    }

    public boolean getPagingFkey(boolean pagingFkey) {
        if (this.pagingFkey_ == null) {
            return pagingFkey;
        }
        return this.pagingFkey_;
    }

    public Boolean getPagingFkeyAsBoolean() {
        return this.pagingFkey_;
    }

    public boolean checkPagingFkey() {
        return this.pagingFkey_ != null;
    }

    public void setPagingFkey(boolean pagingFkey) {
        this.pagingFkey_ = new Boolean(pagingFkey);
    }

    public void setPagingFkey(Boolean pagingFkey) {
        this.pagingFkey_ = pagingFkey;
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<page");
        if (this.size_ != null) {
            buffer.append(" size=\"");
            buffer.append(URelaxer.getString(this.getSize()));
            buffer.append("\"");
        }
        if (this.cache_ != null) {
            buffer.append(" cache=\"");
            buffer.append(URelaxer.getString(this.getCache()));
            buffer.append("\"");
        }
        if (this.closeConnection_ != null) {
            buffer.append(" closeConnection=\"");
            buffer.append(URelaxer.getString(this.getCloseConnection()));
            buffer.append("\"");
        }
        if (this.option_ != null) {
            buffer.append(" option=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getOption())));
            buffer.append("\"");
        }
        if (this.pagingFkey_ != null) {
            buffer.append(" pagingFkey=\"");
            buffer.append(URelaxer.getString(this.getPagingFkey()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</page>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<page");
        if (this.size_ != null) {
            buffer.write(" size=\"");
            buffer.write(URelaxer.getString(this.getSize()));
            buffer.write("\"");
        }
        if (this.cache_ != null) {
            buffer.write(" cache=\"");
            buffer.write(URelaxer.getString(this.getCache()));
            buffer.write("\"");
        }
        if (this.closeConnection_ != null) {
            buffer.write(" closeConnection=\"");
            buffer.write(URelaxer.getString(this.getCloseConnection()));
            buffer.write("\"");
        }
        if (this.option_ != null) {
            buffer.write(" option=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getOption())));
            buffer.write("\"");
        }
        if (this.pagingFkey_ != null) {
            buffer.write(" pagingFkey=\"");
            buffer.write(URelaxer.getString(this.getPagingFkey()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</page>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<page");
        if (this.size_ != null) {
            buffer.print(" size=\"");
            buffer.print(URelaxer.getString(this.getSize()));
            buffer.print("\"");
        }
        if (this.cache_ != null) {
            buffer.print(" cache=\"");
            buffer.print(URelaxer.getString(this.getCache()));
            buffer.print("\"");
        }
        if (this.closeConnection_ != null) {
            buffer.print(" closeConnection=\"");
            buffer.print(URelaxer.getString(this.getCloseConnection()));
            buffer.print("\"");
        }
        if (this.option_ != null) {
            buffer.print(" option=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getOption())));
            buffer.print("\"");
        }
        if (this.pagingFkey_ != null) {
            buffer.print(" pagingFkey=\"");
            buffer.print(URelaxer.getString(this.getPagingFkey()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</page>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getSizeAsString() {
        return URelaxer.getString(this.getSize());
    }

    public String getCacheAsString() {
        return URelaxer.getString(this.getCache());
    }

    public String getCloseConnectionAsString() {
        return URelaxer.getString(this.getCloseConnection());
    }

    public String getOptionAsString() {
        return URelaxer.getString(this.getOption());
    }

    public String getPagingFkeyAsString() {
        return URelaxer.getString(this.getPagingFkey());
    }

    public void setSizeByString(String string) {
        this.setSize(Integer.parseInt(string));
    }

    public void setCacheByString(String string) {
        this.setCache(Integer.parseInt(string));
    }

    public void setCloseConnectionByString(String string) {
        this.setCloseConnection((boolean)new Boolean(string));
    }

    public void setOptionByString(String string) {
        this.setOption(string);
    }

    public void setPagingFkeyByString(String string) {
        this.setPagingFkey((boolean)new Boolean(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "page")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Page.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Page.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

