/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.Csslist;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Javascriptlist;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Presentation
implements Serializable,
Cloneable,
IRNode,
IProjectChoice {
    private String idref_;
    private Boolean checkLogon_;
    private String filename_;
    private String css_;
    private String errorpage_;
    private String description_;
    private String locale_;
    private Boolean enableFocusFirstElement_;
    private String mobile_;
    private Layout layout_;
    private Javascriptlist javascriptlist_;
    private Csslist csslist_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Presentation() {
    }

    public Presentation(Presentation source) {
        this.setup(source);
    }

    public Presentation(RStack stack) {
        this.setup(stack);
    }

    public Presentation(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Presentation(Element element) {
        this.setup(element);
    }

    public Presentation(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Presentation(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Presentation(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Presentation(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Presentation(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Presentation(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Presentation source) {
        this.setIdref(source.getIdref());
        this.setCheckLogon(source.getCheckLogon());
        this.setFilename(source.getFilename());
        this.setCss(source.getCss());
        this.setErrorpage(source.getErrorpage());
        this.setDescription(source.getDescription());
        this.setLocale(source.getLocale());
        this.setEnableFocusFirstElement(source.getEnableFocusFirstElement());
        this.setMobile(source.getMobile());
        if (source.layout_ != null) {
            this.setLayout((Layout)source.getLayout().clone());
        }
        if (source.javascriptlist_ != null) {
            this.setJavascriptlist((Javascriptlist)source.getJavascriptlist().clone());
        }
        if (source.csslist_ != null) {
            this.setCsslist((Csslist)source.getCsslist().clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.idref_ = URelaxer.getAttributePropertyAsString(element, "idref");
        this.checkLogon_ = URelaxer.getAttributePropertyAsBooleanObject(element, "checkLogon");
        this.filename_ = URelaxer.getAttributePropertyAsString(element, "filename");
        this.css_ = URelaxer.getAttributePropertyAsString(element, "css");
        this.errorpage_ = URelaxer.getAttributePropertyAsString(element, "errorpage");
        this.description_ = URelaxer.getAttributePropertyAsString(element, "description");
        this.locale_ = URelaxer.getAttributePropertyAsString(element, "locale");
        this.enableFocusFirstElement_ = URelaxer.getAttributePropertyAsBooleanObject(element, "enableFocusFirstElement");
        this.mobile_ = URelaxer.getAttributePropertyAsString(element, "mobile");
        if (Layout.isMatch(stack)) {
            this.setLayout(factory.createLayout(stack));
        }
        if (Javascriptlist.isMatch(stack)) {
            this.setJavascriptlist(factory.createJavascriptlist(stack));
        }
        if (Csslist.isMatch(stack)) {
            this.setCsslist(factory.createCsslist(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createPresentation(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("presentation");
        if (this.idref_ != null) {
            URelaxer.setAttributePropertyByString(element, "idref", this.idref_);
        }
        if (this.checkLogon_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "checkLogon", this.checkLogon_);
        }
        if (this.filename_ != null) {
            URelaxer.setAttributePropertyByString(element, "filename", this.filename_);
        }
        if (this.css_ != null) {
            URelaxer.setAttributePropertyByString(element, "css", this.css_);
        }
        if (this.errorpage_ != null) {
            URelaxer.setAttributePropertyByString(element, "errorpage", this.errorpage_);
        }
        if (this.description_ != null) {
            URelaxer.setAttributePropertyByString(element, "description", this.description_);
        }
        if (this.locale_ != null) {
            URelaxer.setAttributePropertyByString(element, "locale", this.locale_);
        }
        if (this.enableFocusFirstElement_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "enableFocusFirstElement", this.enableFocusFirstElement_);
        }
        if (this.mobile_ != null) {
            URelaxer.setAttributePropertyByString(element, "mobile", this.mobile_);
        }
        if (this.layout_ != null) {
            this.layout_.makeElement(element);
        }
        if (this.javascriptlist_ != null) {
            this.javascriptlist_.makeElement(element);
        }
        if (this.csslist_ != null) {
            this.csslist_.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getIdref() {
        return this.idref_;
    }

    public final void setIdref(String idref) {
        this.idref_ = idref;
    }

    public boolean getCheckLogon() {
        if (this.checkLogon_ == null) {
            return true;
        }
        return this.checkLogon_;
    }

    public boolean getCheckLogon(boolean checkLogon) {
        if (this.checkLogon_ == null) {
            return checkLogon;
        }
        return this.checkLogon_;
    }

    public Boolean getCheckLogonAsBoolean() {
        return this.checkLogon_;
    }

    public boolean checkCheckLogon() {
        return this.checkLogon_ != null;
    }

    public void setCheckLogon(boolean checkLogon) {
        this.checkLogon_ = new Boolean(checkLogon);
    }

    public void setCheckLogon(Boolean checkLogon) {
        this.checkLogon_ = checkLogon;
    }

    public final String getFilename() {
        return this.filename_;
    }

    public final void setFilename(String filename) {
        this.filename_ = filename;
    }

    public final String getCss() {
        return this.css_;
    }

    public final void setCss(String css) {
        this.css_ = css;
    }

    public final String getErrorpage() {
        if (this.errorpage_ == null) {
            return "../system/error.jsp";
        }
        return this.errorpage_;
    }

    public final void setErrorpage(String errorpage) {
        this.errorpage_ = errorpage;
    }

    public final String getDescription() {
        return this.description_;
    }

    public final void setDescription(String description) {
        this.description_ = description;
    }

    public final String getLocale() {
        return this.locale_;
    }

    public final void setLocale(String locale) {
        this.locale_ = locale;
    }

    public boolean getEnableFocusFirstElement() {
        if (this.enableFocusFirstElement_ == null) {
            return false;
        }
        return this.enableFocusFirstElement_;
    }

    public boolean getEnableFocusFirstElement(boolean enableFocusFirstElement) {
        if (this.enableFocusFirstElement_ == null) {
            return enableFocusFirstElement;
        }
        return this.enableFocusFirstElement_;
    }

    public Boolean getEnableFocusFirstElementAsBoolean() {
        return this.enableFocusFirstElement_;
    }

    public boolean checkEnableFocusFirstElement() {
        return this.enableFocusFirstElement_ != null;
    }

    public void setEnableFocusFirstElement(boolean enableFocusFirstElement) {
        this.enableFocusFirstElement_ = new Boolean(enableFocusFirstElement);
    }

    public void setEnableFocusFirstElement(Boolean enableFocusFirstElement) {
        this.enableFocusFirstElement_ = enableFocusFirstElement;
    }

    public final String getMobile() {
        return this.mobile_;
    }

    public final void setMobile(String mobile) {
        this.mobile_ = mobile;
    }

    public final Layout getLayout() {
        return this.layout_;
    }

    public final void setLayout(Layout layout) {
        this.layout_ = layout;
        if (layout != null) {
            layout.rSetParentRNode(this);
        }
        if (layout != null) {
            layout.rSetRContext(this.rGetRContext());
        }
    }

    public final Javascriptlist getJavascriptlist() {
        return this.javascriptlist_;
    }

    public final void setJavascriptlist(Javascriptlist javascriptlist) {
        this.javascriptlist_ = javascriptlist;
        if (javascriptlist != null) {
            javascriptlist.rSetParentRNode(this);
        }
        if (javascriptlist != null) {
            javascriptlist.rSetRContext(this.rGetRContext());
        }
    }

    public final Csslist getCsslist() {
        return this.csslist_;
    }

    public final void setCsslist(Csslist csslist) {
        this.csslist_ = csslist;
        if (csslist != null) {
            csslist.rSetParentRNode(this);
        }
        if (csslist != null) {
            csslist.rSetRContext(this.rGetRContext());
        }
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<presentation");
        if (this.idref_ != null) {
            buffer.append(" idref=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIdref())));
            buffer.append("\"");
        }
        if (this.checkLogon_ != null) {
            buffer.append(" checkLogon=\"");
            buffer.append(URelaxer.getString(this.getCheckLogon()));
            buffer.append("\"");
        }
        if (this.filename_ != null) {
            buffer.append(" filename=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.append("\"");
        }
        if (this.css_ != null) {
            buffer.append(" css=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCss())));
            buffer.append("\"");
        }
        if (this.errorpage_ != null) {
            buffer.append(" errorpage=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getErrorpage())));
            buffer.append("\"");
        }
        if (this.description_ != null) {
            buffer.append(" description=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.append("\"");
        }
        if (this.locale_ != null) {
            buffer.append(" locale=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLocale())));
            buffer.append("\"");
        }
        if (this.enableFocusFirstElement_ != null) {
            buffer.append(" enableFocusFirstElement=\"");
            buffer.append(URelaxer.getString(this.getEnableFocusFirstElement()));
            buffer.append("\"");
        }
        if (this.mobile_ != null) {
            buffer.append(" mobile=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMobile())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.layout_ != null) {
            this.layout_.makeTextElement(buffer);
        }
        if (this.javascriptlist_ != null) {
            this.javascriptlist_.makeTextElement(buffer);
        }
        if (this.csslist_ != null) {
            this.csslist_.makeTextElement(buffer);
        }
        buffer.append("</presentation>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<presentation");
        if (this.idref_ != null) {
            buffer.write(" idref=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIdref())));
            buffer.write("\"");
        }
        if (this.checkLogon_ != null) {
            buffer.write(" checkLogon=\"");
            buffer.write(URelaxer.getString(this.getCheckLogon()));
            buffer.write("\"");
        }
        if (this.filename_ != null) {
            buffer.write(" filename=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.write("\"");
        }
        if (this.css_ != null) {
            buffer.write(" css=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCss())));
            buffer.write("\"");
        }
        if (this.errorpage_ != null) {
            buffer.write(" errorpage=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getErrorpage())));
            buffer.write("\"");
        }
        if (this.description_ != null) {
            buffer.write(" description=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.write("\"");
        }
        if (this.locale_ != null) {
            buffer.write(" locale=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLocale())));
            buffer.write("\"");
        }
        if (this.enableFocusFirstElement_ != null) {
            buffer.write(" enableFocusFirstElement=\"");
            buffer.write(URelaxer.getString(this.getEnableFocusFirstElement()));
            buffer.write("\"");
        }
        if (this.mobile_ != null) {
            buffer.write(" mobile=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMobile())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.layout_ != null) {
            this.layout_.makeTextElement(buffer);
        }
        if (this.javascriptlist_ != null) {
            this.javascriptlist_.makeTextElement(buffer);
        }
        if (this.csslist_ != null) {
            this.csslist_.makeTextElement(buffer);
        }
        buffer.write("</presentation>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<presentation");
        if (this.idref_ != null) {
            buffer.print(" idref=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIdref())));
            buffer.print("\"");
        }
        if (this.checkLogon_ != null) {
            buffer.print(" checkLogon=\"");
            buffer.print(URelaxer.getString(this.getCheckLogon()));
            buffer.print("\"");
        }
        if (this.filename_ != null) {
            buffer.print(" filename=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getFilename())));
            buffer.print("\"");
        }
        if (this.css_ != null) {
            buffer.print(" css=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCss())));
            buffer.print("\"");
        }
        if (this.errorpage_ != null) {
            buffer.print(" errorpage=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getErrorpage())));
            buffer.print("\"");
        }
        if (this.description_ != null) {
            buffer.print(" description=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDescription())));
            buffer.print("\"");
        }
        if (this.locale_ != null) {
            buffer.print(" locale=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLocale())));
            buffer.print("\"");
        }
        if (this.enableFocusFirstElement_ != null) {
            buffer.print(" enableFocusFirstElement=\"");
            buffer.print(URelaxer.getString(this.getEnableFocusFirstElement()));
            buffer.print("\"");
        }
        if (this.mobile_ != null) {
            buffer.print(" mobile=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMobile())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.layout_ != null) {
            this.layout_.makeTextElement(buffer);
        }
        if (this.javascriptlist_ != null) {
            this.javascriptlist_.makeTextElement(buffer);
        }
        if (this.csslist_ != null) {
            this.csslist_.makeTextElement(buffer);
        }
        buffer.print("</presentation>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdrefAsString() {
        return URelaxer.getString(this.getIdref());
    }

    public String getCheckLogonAsString() {
        return URelaxer.getString(this.getCheckLogon());
    }

    public String getFilenameAsString() {
        return URelaxer.getString(this.getFilename());
    }

    public String getCssAsString() {
        return URelaxer.getString(this.getCss());
    }

    public String getErrorpageAsString() {
        return URelaxer.getString(this.getErrorpage());
    }

    public String getDescriptionAsString() {
        return URelaxer.getString(this.getDescription());
    }

    public String getLocaleAsString() {
        return URelaxer.getString(this.getLocale());
    }

    public String getEnableFocusFirstElementAsString() {
        return URelaxer.getString(this.getEnableFocusFirstElement());
    }

    public String getMobileAsString() {
        return URelaxer.getString(this.getMobile());
    }

    public void setIdrefByString(String string) {
        this.setIdref(string);
    }

    public void setCheckLogonByString(String string) {
        this.setCheckLogon((boolean)new Boolean(string));
    }

    public void setFilenameByString(String string) {
        this.setFilename(string);
    }

    public void setCssByString(String string) {
        this.setCss(string);
    }

    public void setErrorpageByString(String string) {
        this.setErrorpage(string);
    }

    public void setDescriptionByString(String string) {
        this.setDescription(string);
    }

    public void setLocaleByString(String string) {
        this.setLocale(string);
    }

    public void setEnableFocusFirstElementByString(String string) {
        this.setEnableFocusFirstElement((boolean)new Boolean(string));
    }

    public void setMobileByString(String string) {
        this.setMobile(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<Cloneable> classNodes = new ArrayList<Cloneable>();
        if (this.layout_ != null) {
            classNodes.add(this.layout_);
        }
        if (this.javascriptlist_ != null) {
            classNodes.add(this.javascriptlist_);
        }
        if (this.csslist_ != null) {
            classNodes.add(this.csslist_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public IRNode getIdrefAsIRNode() {
        if (this.rContext_ == null) {
            return null;
        }
        return this.rContext_.getIRNode(this.getIdref());
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "presentation")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (Layout.isMatchHungry(target)) {
            // empty if block
        }
        if (Javascriptlist.isMatchHungry(target)) {
            // empty if block
        }
        if (Csslist.isMatchHungry(target)) {
            // empty if block
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Presentation.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Presentation.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

