/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.KeyRule;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PrimaryKey
implements Serializable,
Cloneable,
IRNode,
IModelChoice {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_INT = "int";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_DATETIME = "dateTime";
    private String name_;
    private String refname_;
    private String type_;
    private String useseq_;
    private Boolean autoid_;
    private Integer start_;
    private Boolean branch_;
    private Boolean useAutoidAtCopy_;
    private List keyRule_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public PrimaryKey() {
        this.name_ = "";
    }

    public PrimaryKey(PrimaryKey source) {
        this.setup(source);
    }

    public PrimaryKey(RStack stack) {
        this.setup(stack);
    }

    public PrimaryKey(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PrimaryKey(Element element) {
        this.setup(element);
    }

    public PrimaryKey(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PrimaryKey(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PrimaryKey(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PrimaryKey(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PrimaryKey(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PrimaryKey(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PrimaryKey source) {
        this.setName(source.getName());
        this.setRefname(source.getRefname());
        this.setType(source.getType());
        this.setUseseq(source.getUseseq());
        this.setAutoid(source.getAutoid());
        this.setStart(source.getStart());
        this.setBranch(source.getBranch());
        this.setUseAutoidAtCopy(source.getUseAutoidAtCopy());
        this.keyRule_.clear();
        int size = source.keyRule_.size();
        for (int i = 0; i < size; ++i) {
            this.addKeyRule((KeyRule)source.getKeyRule(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.refname_ = URelaxer.getAttributePropertyAsString(element, "refname");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.useseq_ = URelaxer.getAttributePropertyAsString(element, "useseq");
        this.autoid_ = URelaxer.getAttributePropertyAsBooleanObject(element, "autoid");
        this.start_ = URelaxer.getAttributePropertyAsIntObject(element, "start");
        this.branch_ = URelaxer.getAttributePropertyAsBooleanObject(element, "branch");
        this.useAutoidAtCopy_ = URelaxer.getAttributePropertyAsBooleanObject(element, "useAutoidAtCopy");
        this.keyRule_.clear();
        while (KeyRule.isMatch(stack)) {
            this.addKeyRule(factory.createKeyRule(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createPrimaryKey(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("primaryKey");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.refname_ != null) {
            URelaxer.setAttributePropertyByString(element, "refname", this.refname_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.useseq_ != null) {
            URelaxer.setAttributePropertyByString(element, "useseq", this.useseq_);
        }
        if (this.autoid_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "autoid", this.autoid_);
        }
        if (this.start_ != null) {
            URelaxer.setAttributePropertyByInt(element, "start", this.start_);
        }
        if (this.branch_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "branch", this.branch_);
        }
        if (this.useAutoidAtCopy_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "useAutoidAtCopy", this.useAutoidAtCopy_);
        }
        int size = this.keyRule_.size();
        for (int i = 0; i < size; ++i) {
            KeyRule value = (KeyRule)this.keyRule_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getRefname() {
        return this.refname_;
    }

    public final void setRefname(String refname) {
        this.refname_ = refname;
    }

    public final String getType() {
        if (this.type_ == null) {
            return TYPE_STRING;
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getUseseq() {
        return this.useseq_;
    }

    public final void setUseseq(String useseq) {
        this.useseq_ = useseq;
    }

    public boolean getAutoid() {
        if (this.autoid_ == null) {
            return false;
        }
        return this.autoid_;
    }

    public boolean getAutoid(boolean autoid) {
        if (this.autoid_ == null) {
            return autoid;
        }
        return this.autoid_;
    }

    public Boolean getAutoidAsBoolean() {
        return this.autoid_;
    }

    public boolean checkAutoid() {
        return this.autoid_ != null;
    }

    public void setAutoid(boolean autoid) {
        this.autoid_ = new Boolean(autoid);
    }

    public void setAutoid(Boolean autoid) {
        this.autoid_ = autoid;
    }

    public int getStart() {
        if (this.start_ == null) {
            return 1;
        }
        return this.start_;
    }

    public int getStart(int start) {
        if (this.start_ == null) {
            return start;
        }
        return this.start_;
    }

    public Integer getStartAsInteger() {
        return this.start_;
    }

    public boolean checkStart() {
        return this.start_ != null;
    }

    public void setStart(int start) {
        this.start_ = new Integer(start);
    }

    public void setStart(Integer start) {
        this.start_ = start;
    }

    public boolean getBranch() {
        if (this.branch_ == null) {
            return false;
        }
        return this.branch_;
    }

    public boolean getBranch(boolean branch) {
        if (this.branch_ == null) {
            return branch;
        }
        return this.branch_;
    }

    public Boolean getBranchAsBoolean() {
        return this.branch_;
    }

    public boolean checkBranch() {
        return this.branch_ != null;
    }

    public void setBranch(boolean branch) {
        this.branch_ = new Boolean(branch);
    }

    public void setBranch(Boolean branch) {
        this.branch_ = branch;
    }

    public boolean getUseAutoidAtCopy() {
        if (this.useAutoidAtCopy_ == null) {
            return true;
        }
        return this.useAutoidAtCopy_;
    }

    public boolean getUseAutoidAtCopy(boolean useAutoidAtCopy) {
        if (this.useAutoidAtCopy_ == null) {
            return useAutoidAtCopy;
        }
        return this.useAutoidAtCopy_;
    }

    public Boolean getUseAutoidAtCopyAsBoolean() {
        return this.useAutoidAtCopy_;
    }

    public boolean checkUseAutoidAtCopy() {
        return this.useAutoidAtCopy_ != null;
    }

    public void setUseAutoidAtCopy(boolean useAutoidAtCopy) {
        this.useAutoidAtCopy_ = new Boolean(useAutoidAtCopy);
    }

    public void setUseAutoidAtCopy(Boolean useAutoidAtCopy) {
        this.useAutoidAtCopy_ = useAutoidAtCopy;
    }

    public final KeyRule[] getKeyRule() {
        KeyRule[] array = new KeyRule[this.keyRule_.size()];
        return this.keyRule_.toArray(array);
    }

    public final void setKeyRule(KeyRule[] keyRule) {
        int i;
        this.keyRule_.clear();
        if (keyRule != null) {
            for (i = 0; i < keyRule.length; ++i) {
                this.addKeyRule(keyRule[i]);
            }
        }
        for (i = 0; i < keyRule.length; ++i) {
            keyRule[i].rSetParentRNode(this);
        }
        for (i = 0; i < keyRule.length; ++i) {
            keyRule[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setKeyRule(KeyRule keyRule) {
        this.keyRule_.clear();
        this.addKeyRule(keyRule);
        if (keyRule != null) {
            keyRule.rSetParentRNode(this);
        }
        if (keyRule != null) {
            keyRule.rSetRContext(this.rGetRContext());
        }
    }

    public final void addKeyRule(KeyRule keyRule) {
        this.keyRule_.add(keyRule);
        if (keyRule != null) {
            keyRule.rSetParentRNode(this);
        }
        if (keyRule != null) {
            keyRule.rSetRContext(this.rGetRContext());
        }
    }

    public final void addKeyRule(KeyRule[] keyRule) {
        int i;
        for (i = 0; i < keyRule.length; ++i) {
            this.addKeyRule(keyRule[i]);
        }
        for (i = 0; i < keyRule.length; ++i) {
            keyRule[i].rSetParentRNode(this);
        }
        for (i = 0; i < keyRule.length; ++i) {
            keyRule[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeKeyRule() {
        return this.keyRule_.size();
    }

    public final KeyRule getKeyRule(int index) {
        return (KeyRule)this.keyRule_.get(index);
    }

    public final void setKeyRule(int index, KeyRule keyRule) {
        this.keyRule_.set(index, keyRule);
        if (keyRule != null) {
            keyRule.rSetParentRNode(this);
        }
    }

    public final void addKeyRule(int index, KeyRule keyRule) {
        this.keyRule_.add(index, keyRule);
        if (keyRule != null) {
            keyRule.rSetParentRNode(this);
        }
    }

    public final void removeKeyRule(int index) {
        this.keyRule_.remove(index);
    }

    public final void removeKeyRule(KeyRule keyRule) {
        this.keyRule_.remove(keyRule);
    }

    public final void clearKeyRule() {
        this.keyRule_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<primaryKey");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.refname_ != null) {
            buffer.append(" refname=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRefname())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.useseq_ != null) {
            buffer.append(" useseq=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUseseq())));
            buffer.append("\"");
        }
        if (this.autoid_ != null) {
            buffer.append(" autoid=\"");
            buffer.append(URelaxer.getString(this.getAutoid()));
            buffer.append("\"");
        }
        if (this.start_ != null) {
            buffer.append(" start=\"");
            buffer.append(URelaxer.getString(this.getStart()));
            buffer.append("\"");
        }
        if (this.branch_ != null) {
            buffer.append(" branch=\"");
            buffer.append(URelaxer.getString(this.getBranch()));
            buffer.append("\"");
        }
        if (this.useAutoidAtCopy_ != null) {
            buffer.append(" useAutoidAtCopy=\"");
            buffer.append(URelaxer.getString(this.getUseAutoidAtCopy()));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.keyRule_.size();
        for (int i = 0; i < size; ++i) {
            KeyRule value = (KeyRule)this.keyRule_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</primaryKey>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<primaryKey");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.refname_ != null) {
            buffer.write(" refname=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRefname())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.useseq_ != null) {
            buffer.write(" useseq=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUseseq())));
            buffer.write("\"");
        }
        if (this.autoid_ != null) {
            buffer.write(" autoid=\"");
            buffer.write(URelaxer.getString(this.getAutoid()));
            buffer.write("\"");
        }
        if (this.start_ != null) {
            buffer.write(" start=\"");
            buffer.write(URelaxer.getString(this.getStart()));
            buffer.write("\"");
        }
        if (this.branch_ != null) {
            buffer.write(" branch=\"");
            buffer.write(URelaxer.getString(this.getBranch()));
            buffer.write("\"");
        }
        if (this.useAutoidAtCopy_ != null) {
            buffer.write(" useAutoidAtCopy=\"");
            buffer.write(URelaxer.getString(this.getUseAutoidAtCopy()));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.keyRule_.size();
        for (int i = 0; i < size; ++i) {
            KeyRule value = (KeyRule)this.keyRule_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</primaryKey>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<primaryKey");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.refname_ != null) {
            buffer.print(" refname=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRefname())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.useseq_ != null) {
            buffer.print(" useseq=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUseseq())));
            buffer.print("\"");
        }
        if (this.autoid_ != null) {
            buffer.print(" autoid=\"");
            buffer.print(URelaxer.getString(this.getAutoid()));
            buffer.print("\"");
        }
        if (this.start_ != null) {
            buffer.print(" start=\"");
            buffer.print(URelaxer.getString(this.getStart()));
            buffer.print("\"");
        }
        if (this.branch_ != null) {
            buffer.print(" branch=\"");
            buffer.print(URelaxer.getString(this.getBranch()));
            buffer.print("\"");
        }
        if (this.useAutoidAtCopy_ != null) {
            buffer.print(" useAutoidAtCopy=\"");
            buffer.print(URelaxer.getString(this.getUseAutoidAtCopy()));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.keyRule_.size();
        for (int i = 0; i < size; ++i) {
            KeyRule value = (KeyRule)this.keyRule_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</primaryKey>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getRefnameAsString() {
        return URelaxer.getString(this.getRefname());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getUseseqAsString() {
        return URelaxer.getString(this.getUseseq());
    }

    public String getAutoidAsString() {
        return URelaxer.getString(this.getAutoid());
    }

    public String getStartAsString() {
        return URelaxer.getString(this.getStart());
    }

    public String getBranchAsString() {
        return URelaxer.getString(this.getBranch());
    }

    public String getUseAutoidAtCopyAsString() {
        return URelaxer.getString(this.getUseAutoidAtCopy());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setRefnameByString(String string) {
        this.setRefname(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setUseseqByString(String string) {
        this.setUseseq(string);
    }

    public void setAutoidByString(String string) {
        this.setAutoid((boolean)new Boolean(string));
    }

    public void setStartByString(String string) {
        this.setStart(Integer.parseInt(string));
    }

    public void setBranchByString(String string) {
        this.setBranch((boolean)new Boolean(string));
    }

    public void setUseAutoidAtCopyByString(String string) {
        this.setUseAutoidAtCopy((boolean)new Boolean(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.keyRule_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "primaryKey")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (KeyRule.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PrimaryKey.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PrimaryKey.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

